/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.OEPrescriptionControllerCallback;
import ca.infodata.ofys.ui.dsq.controller.QueryContinuationController;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class OEPrescriptionController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE = Messages.getString((String)"GetPrescriptionsNeverDispensedAction.OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_EN_ATTENTE", (String[])new String[0]);
    private static final String OBTENTION_DE_L_ORDONNANCE_DETAILLEE = Messages.getString((String)"GetPrescriptionDispensedDetailsAction.OBTENTION_DE_L_ORDONNANCE_DETAILLEE", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(OEPrescriptionController.class.getName());
    private final OEPrescriptionControllerCallback callback;
    private IPatient patient;
    private LocalDate start = LocalDate.today().plusYear(-1);
    private LocalDate end = LocalDate.today();
    private boolean onlyActive = false;
    private int limit = 20;
    private List<IPrescriptionSummary> list;
    private QueryContinuationResult lastQCR;
    private Map<NIU_PRESCRIPTION, PrescriptionDrugDetails> drugMapDetail;
    private Map<NIU_PRESCRIPTION, PrescriptionDeviceDetails> deviceMapDetail;
    private Job listSummaryJob;
    private JobDeviceExtension getDeviceDetailJob;
    private JobDrugExtension getDrugDetailJob;
    private FindCandidateAction findCandidateAction;

    public OEPrescriptionController(OEPrescriptionControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        super(dsq);
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
        this.drugMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDrugDetails>();
        this.deviceMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDeviceDetails>();
    }

    public void listSummary() {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire des ordonnances en attente"){

                protected IStatus run(IProgressMonitor monitor) {
                    OEPrescriptionController.this.listSummary2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.listSummaryJob.getState() == 4) {
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    protected void listSummary2(IProgressMonitor monitor) {
        if (this.list == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.lastQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.list = new ArrayList<IPrescriptionSummary>(((QueryContinuationResult)r.result).prescriptions);
            }
            this.callback.listSummary(r);
        } else if (this.lastQCR != null && this.lastQCR.originalTotalQuantity < this.list.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.patient, this.lastQCR, this.limit, monitor);
            if (r.result != null) {
                this.lastQCR = (QueryContinuationResult)r.result;
                this.list.addAll(((QueryContinuationResult)r.result).prescriptions);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
                r2.prescriptions = this.list;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.prescriptions.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
            r2.prescriptions = this.list;
            r2.queryId = this.lastQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.prescriptions.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IPrescriptionSummary get(NIU_PRESCRIPTION id) {
        if (id == null) {
            return null;
        }
        if (this.list == null) {
            return null;
        }
        for (IPrescriptionSummary s : this.list) {
            if (!s.getId().equals(id.value()) || !s.getVersion().equals(id.version())) continue;
            return s;
        }
        return null;
    }

    public void getDrugDetail(NIU_PRESCRIPTION id) {
        if (this.getDrugDetailJob == null) {
            this.getDrugDetailJob = new JobDrugExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDrugDetailJob.getState() == 4) {
            this.callback.getDeviceDetail(id, (DsqCallback<PrescriptionDeviceDetails>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDrugDetailJob.setId(id);
            this.getDrugDetailJob.schedule();
        }
    }

    protected void getDrugDetail2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.drugMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getDrugDetail3(id, monitor);
            if (c.result != null) {
                this.drugMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getDrugDetail(id, c);
        } else {
            this.callback.getDrugDetail(id, (DsqCallback<PrescriptionDrugDetails>)new DsqCallback((Object)d));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<PrescriptionDrugDetails> getDrugDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getDeviceDetail(NIU_PRESCRIPTION id) {
        if (this.getDeviceDetailJob == null) {
            this.getDeviceDetailJob = new JobDeviceExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDeviceDetailJob.getState() == 4) {
            this.callback.getDeviceDetail(id, (DsqCallback<PrescriptionDeviceDetails>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDeviceDetailJob.setId(id);
            this.getDeviceDetailJob.schedule();
        }
    }

    protected void getDeviceDetail2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        PrescriptionDeviceDetails d = this.deviceMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDeviceDetails> c = this.getDeviceDetail3(id, monitor);
            if (c.result != null) {
                this.deviceMapDetail.put(id, (PrescriptionDeviceDetails)c.result);
            }
            this.callback.getDeviceDetail(id, c);
        } else {
            this.callback.getDeviceDetail(id, (DsqCallback<PrescriptionDeviceDetails>)new DsqCallback((Object)d));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<PrescriptionDeviceDetails> getDeviceDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.list = null;
        this.lastQCR = null;
        this.drugMapDetail.clear();
        this.deviceMapDetail.clear();
    }

    public void clear() {
        this.list = null;
        this.lastQCR = null;
        this.drugMapDetail.clear();
        this.deviceMapDetail.clear();
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.list = null;
        this.lastQCR = null;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isOnlyActive() {
        return this.onlyActive;
    }

    public void setOnlyActive(boolean onlyActive) {
        this.onlyActive = onlyActive;
        this.list = null;
        this.lastQCR = null;
    }

    final class JobDeviceExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobDeviceExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OEPrescriptionController.this.getDeviceDetail2(this.id, monitor);
            return Status.OK_STATUS;
        }
    }

    final class JobDrugExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobDrugExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OEPrescriptionController.this.getDrugDetail2(this.id, monitor);
            return Status.OK_STATUS;
        }
    }
}

