/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.ILocation;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IControlFactory;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.dsq.ChooseLocationDialog;
import ca.infodata.ofys.ui.dsq.DsqFormatter;
import ca.infodata.ofys.ui.dsq.FindLocationAction;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class ResolveSiteControlFactory
implements IControlFactory {
    private static final Logger logger = Logger.getLogger(ResolveSiteControlFactory.class.getName());

    public Control newControl(final BaseEditor parentEditor, Composite parent, IConfigurationElement e) {
        MyButton btnResolveSite = new MyButton(parent, "Rechercher le site au DSQ", 8, parentEditor.getToolkit());
        btnResolveSite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final XSite site = ResolveSiteControlFactory.getSite(parentEditor);
                if (site != null) {
                    final ArrayList<ILocation> locations = new ArrayList<ILocation>();
                    MyProgressMonitorDialog dialog2 = new MyProgressMonitorDialog(parentEditor.getSite().getShell());
                    dialog2.setInterruptOnCancel(true);
                    try {
                        dialog2.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    List<ILocation> list = new FindLocationAction().find(site, monitor);
                                    if (list != null) {
                                        locations.addAll(list);
                                    }
                                }
                                catch (Exception e) {
                                    MessageUtil.show((Shell)parentEditor.getSite().getShell(), (Exception)e);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        logger.log(Level.SEVERE, "", e1);
                        MessageUtil.unexpectedExceptionMsg((Shell)parentEditor.getSite().getShell());
                    }
                    catch (InterruptedException interruptedException) {}
                    ILocation location = null;
                    if (locations.size() == 1) {
                        location = (ILocation)locations.get(0);
                        MessageUtil.infoMsg((Shell)parentEditor.getSite().getShell(), (String)("La recherche \u00e0 retourn\u00e9 un seul r\u00e9sultat \n " + DsqFormatter.formatLocation(location)));
                    } else if (locations.size() > 0) {
                        ChooseLocationDialog dialog = new ChooseLocationDialog(parentEditor.getSite().getShell(), locations);
                        dialog.open();
                        if (dialog.isOk() && dialog.getSelection() != null) {
                            location = dialog.getSelection();
                        }
                    }
                    if (location != null) {
                        site.setDsqNiu(location.getNIU().value());
                        site.setCode(location.getCode());
                        site.setNameOfficial(location.getName());
                        site.setNameCommon(location.getName());
                        site.setPhonenumber1(location.getAddress().telecom);
                        site.setCity(new XCity(location.getAddress().city));
                        site.setCountry(new XCountry(location.getAddress().country));
                        site.setProvince(new XProvince(location.getAddress().state));
                        site.setPostalCode(location.getAddress().postalCode);
                        site.setStreet(location.getAddress().street);
                        site.setUpdated();
                        parentEditor.checkDirty();
                        parentEditor.showAllDataObject();
                    }
                }
            }
        });
        return btnResolveSite.getControl();
    }

    private static XSite getSite(BaseEditor parentEditor) {
        EditableDataObject completeDataObject;
        IEditorInput editorInput = parentEditor.getEditorInput();
        if (editorInput instanceof EditorInput && (completeDataObject = ((EditorInput)editorInput).getCompleteDataObject()) instanceof XSite) {
            return (XSite)completeDataObject;
        }
        return null;
    }
}

