/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.College;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.service.ri.FindProviderCriteria;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindProviderAction
extends BaseDSQAction
implements IWorkbenchWindowActionDelegate {
    private static final String RESOLUTION_DE_LINTERVENANT = Messages.getString("FindProviderAction.RESOLUTION_DE_LINTERVENANT");
    private static final Logger logger = Logger.getLogger(FindProviderAction.class.getName());
    private static IAction action;
    private static boolean tempEnable;
    private Image disable;

    static {
        tempEnable = true;
    }

    public void dispose() {
        if (this.disable != null && !this.disable.isDisposed()) {
            this.disable.dispose();
        }
    }

    public void run(IAction action) {
        IWorkbenchPage page = ControlsPlugin.getActivePage();
        if (page != null && page.getActiveEditor() instanceof ProfessionnalMultiEditor) {
            ProfessionnalMultiEditor professionnalMultiEditor = (ProfessionnalMultiEditor)page.getActiveEditor();
            final XProfessionnal professionnal = professionnalMultiEditor.getProfessionnal();
            if (professionnal == null) {
                MessageUtil.warningMsg((Shell)this.getShell(), (String)"Action non disponible");
            } else {
                MyProgressMonitorDialog dialog2 = new MyProgressMonitorDialog(this.getShell());
                try {
                    dialog2.setInterruptOnCancel(true);
                    dialog2.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IWorkbenchPage page = ControlsPlugin.getActivePage();
                            if (page != null && page.getActiveEditor() instanceof ProfessionnalMultiEditor) {
                                final ProfessionnalMultiEditor activeEditor = (ProfessionnalMultiEditor)page.getActiveEditor();
                                final IProvider provider = FindProviderAction.this.find(professionnal, monitor);
                                if (provider != null) {
                                    MessageUtil.infoMsg((Shell)FindProviderAction.this.getShell(), (String)"La r\u00e9solution a r\u00e9ussi.");
                                    if (MessageUtil.askQuestion((Shell)FindProviderAction.this.getShell(), (String)("Voulez-vous importer les donn\u00e9es DSQ de l'intervenant : \n" + FindProviderAction.this.formatProvider(provider) + "\ndans le dossier local?"), (boolean)false)) {
                                        FindProviderAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                FindProviderAction.this.importDsqProviderToLocalProvider(activeEditor, provider);
                                            }
                                        });
                                    }
                                }
                            } else {
                                IProvider provider = FindProviderAction.this.find(professionnal, monitor);
                                if (provider != null) {
                                    MessageUtil.infoMsg((Shell)FindProviderAction.this.getShell(), (String)"La r\u00e9solution a r\u00e9ussi.");
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error", ex);
                }
            }
        }
    }

    private IProvider find(XProfessionnal professionnal, IProgressMonitor monitor) {
        IProvider provider = null;
        try {
            if (monitor != null) {
                monitor.beginTask(RESOLUTION_DE_LINTERVENANT, 3);
            }
            XmlSignatureI signature = null;
            if (!this.hasSignatures(null)) {
                if (!UI.OS_WINDOWS) {
                    throw new AbortException(ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.getAlias(monitor);
                signature = this.getSignatureI(monitor, alias, null);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            XSession session = Application.get().getGlobalInstances().getSession();
            try {
                ReturnObject r;
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                FindProviderCriteria criteria = new FindProviderCriteria("qc");
                if (StringUtils.isNotBlank((String)professionnal.getFirstName())) {
                    criteria.setFirstName(professionnal.getFirstName());
                }
                if (StringUtils.isNotBlank((String)professionnal.getLastName())) {
                    criteria.setLastName(professionnal.getLastName());
                }
                if (StringUtils.isNotBlank((String)professionnal.getGender())) {
                    criteria.setGender(FindProviderAction.getDsqGender(professionnal.getGender()));
                }
                if (professionnal.getBirthDate() != null) {
                    criteria.setBirthdateUTC(Long.valueOf(professionnal.getBirthDate().toTimeInMillisUTC()));
                }
                if (StringUtils.isNotBlank((String)professionnal.getCode())) {
                    String oid = FindProviderAction.getCollegeFromProfessionnalType(professionnal);
                    String code = professionnal.getCode();
                    if (College.College_de_medecins_du_Quebec.codeOID.equals(oid)) {
                        criteria = new FindProviderCriteria("qc");
                        criteria.setNiuCollege(new NIU_COLLEGE(oid, code));
                    } else {
                        criteria = new FindProviderCriteria("qc");
                        criteria.setNiuCollege(new NIU_COLLEGE(oid, code));
                    }
                }
                if ((r = DSQAccessorClient.getInstance().findProvider(session, professionnal.getIdPerson(), criteria, (Signature)signature)) == null) {
                    throw new AbortException("Erreur lors de la r\u00e9solution l'intervenant au registre");
                }
                if (!r.getStatus().isOkToProceed()) {
                    throw new AbortException(FindProviderAction.getReadTimeoutMessage(r.getStatus().getMessage()));
                }
                provider = (IProvider)r.getObj();
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
            }
        }
        catch (CancelException cancelException) {
        }
        catch (AbortException e) {
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find provider to dsq " + StringUtils.safeToString((Logger)logger, (Object)professionnal), e);
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        if (monitor != null) {
            monitor.done();
        }
        return provider;
    }

    private static String getCollegeFromProfessionnalType(XProfessionnal prof) {
        XProfessionnalType type = prof.type;
        if (type == null) {
            throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type non-d\u00e9fini ne peut acc\u00e9der au dsq"));
        }
        switch (type) {
            case NONDEFINI: {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type non-d\u00e9fini ne peut acc\u00e9der au dsq"));
            }
            case MD_OMNIPRATICIEN: 
            case MD_SPECIALISTE: 
            case RESIDENT: {
                return College.College_de_medecins_du_Quebec.codeOID;
            }
            case PHARMACIEN: {
                return College.Ordre_des_pharmaciens_du_Quebec.codeOID;
            }
            case DENTISTE: {
                return College.Ordre_des_dentistes_du_Quebec.codeOID;
            }
            case OPTOMETRISTE: {
                return College.Ordre_des_optometristes_du_Quebec.codeOID;
            }
            case SAGE_FEMME: {
                return College.Ordre_des_sages_femmes_du_Quebec.codeOID;
            }
            case INFIRMIERE: 
            case INFIRMIERE_PRATICIENNE: {
                return College.Ordre_des_infirmieres_du_Quebec.codeOID;
            }
            case AUTRES: {
                throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type autre ne peut acc\u00e9der au dsq"));
            }
        }
        throw new StatusException((IStatus)new Status(IStatus.Severity.ERROR, "Un professionnel de type " + type + " ne peut acc\u00e9der au dsq"));
    }

    protected String formatProvider(IProvider provider) {
        String firstName = provider.getFirstName();
        String lastName = provider.getLastName();
        NIU niu = provider.getNIU_COLLEGE();
        return new JoinList(", ", new Object[]{firstName, lastName, niu.value()}).toString();
    }

    protected void importDsqProviderToLocalProvider(ProfessionnalMultiEditor activeEditor, IProvider provider) {
        XProfessionnal professionnal = activeEditor.getProfessionnal();
        professionnal.setFirstName(provider.getFirstName());
        professionnal.setLastName(provider.getLastName());
        professionnal.setCode(provider.getNIU_COLLEGE().value());
        activeEditor.showAllDataObject();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        FindProviderAction.action = action;
        action.setEnabled(tempEnable);
        Image icon = ResourceGetter.getImage((String)"images/enc-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)icon));
        this.disable = new Image((Device)Display.getDefault(), icon, 2);
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.disable));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        } else {
            tempEnable = value;
        }
    }
}

