/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.client.dataaccess.LogAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ILoginAccessor;
import ca.infodata.ofys.data.dataaccess.IUserAccessor;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.SessionLock;
import ca.infodata.ofys.data.dataaccess.util.SessionLockException;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPasswordUpdate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.log.XLogType1;
import ca.infodata.ofys.data.middle.dataobjects.log.XNewLog;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.controls.util.MyDialogSettings;
import ca.infodata.ofys.ui.dashboard.models.CLogin;
import ca.infodata.ofys.ui.dashboard.models.CLoginInfo;
import ca.infodata.ofys.ui.dashboard.models.CTwoFactorConfigSave;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.Util;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.encryption.DesEncrypter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.mutable.MutableObject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class LoginController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(LoginController.class.getName());
    private ILoginAccessor accessor = Application.get().getDataAccessors().getLoginAccessor();
    private IUserAccessor userAccessor = Application.get().getDataAccessors().getUserAccessor();
    private MyDialogSettings loginInfo = new MyDialogSettings(".login.xml", "login"){

        public void setDefaultValues() {
            this.put("USER", "");
            this.put("PSWD", "");
            this.put("OPEN_LAST", "");
            this.put("KEEP", "");
            super.setDefaultValues();
        }
    };

    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes((RouterFunction[])new RouterFunction[]{RouterFunctions.routeReturnObject((String)"/j_security_check/login", this::login), RouterFunctions.routeReturnObject((String)"/j_security_check/respAcceptance", this::responsibilityAcceptance), RouterFunctions.routeReturnObject((String)"/j_security_check/aiRespAcceptance", this::aiResponsibilityAcceptance), RouterFunctions.routeReturnObject((String)"/j_security_check/worksiteSelection", this::login), RouterFunctions.routeReturnObject((String)"/j_security_check/loginfo", this::getLoginfo), RouterFunctions.routeAction((String)"/login.html", this::index), RouterFunctions.routeAction((String)"/dashboard", this::notLoggedIn), RouterFunctions.routes((String)"/dashboard", (RouterFunction[])new RouterFunction[]{RouterFunctions.routes((String)"/Login/ws", (RouterFunction[])new RouterFunction[]{RouterFunctions.routeReturnObject((String)"/changePassword", this::changePassword), RouterFunctions.routeAction((String)"/logout", this::logOut), RouterFunctions.routeReturnObject((String)"/isWeb", this::isWeb), RouterFunctions.routeAction((String)"/openAdmin", this::openAdmin), RouterFunctions.routeAction((String)"/openInternal", this::openInternal), RouterFunctions.routeAction((String)"/openExternal", this::openExternal), RouterFunctions.routeAction((String)"/assist", this::assist), RouterFunctions.routeReturnObject((String)"/configureTwoFactor", this::configureTwoFactor), RouterFunctions.routeReturnObject((String)"/saveTwoFactorConfig", this::saveTwoFactorConfig), RouterFunctions.routeReturnObject((String)"/saveTwoFactorConfigEmail", this::saveTwoFactorConfigEmail), RouterFunctions.routeReturnObject((String)"/saveConfigEmail", this::saveTwoFactorConfigEmail), RouterFunctions.routeReturnObject((String)"/sendTwoFactorCodeToEmail", this::sendTwoFactorCodeToEmail), RouterFunctions.routeReturnObject((String)"/sendCodeToEmail", this::sendTwoFactorCodeToEmail), RouterFunctions.routeReturnObject((String)"/deleteTwoFactor", this::deleteTwoFactor), RouterFunctions.routeReturnObject((String)"/suspendTwoFactor", this::suspendTwoFactor), RouterFunctions.routeReturnObject((String)"/restoreTwoFactorAuth", this::restoreTwoFactorAuth)})})});
    }

    public ReturnObject configureTwoFactor(IServerRequest req) {
        try {
            ReturnObject res = Application.get().getDataAccessors().getUserAccessor().configureTwoFactor();
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Echec de configuration 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    private boolean isUserManager(XUser user) {
        return user.hasOneOfRoles(new XUserRole[]{XUserRole.USER_MANAGEMENT}) || user.hasOneOfRoles(new XUserRole[]{XUserRole.INFODATA});
    }

    public ReturnObject saveTwoFactorConfig(IServerRequest req) {
        try {
            CTwoFactorConfigSave p = (CTwoFactorConfigSave)req.getPostBody(CTwoFactorConfigSave.class);
            XUser currentUser = Application.get().getGlobalInstances().getSession().getUser();
            if (p.userId != null && !this.isUserManager(currentUser) && p.userId != currentUser.getId()) {
                return ServerResponses.ErrorReturnObject((String)"Vous n'avez pas les droits n\u00e9cessaires pour modifier la configuration 2FA pour l'utilisateur");
            }
            if (p.userId == null) {
                p.userId = Application.get().getGlobalInstances().getSession().getUser().getId();
            }
            ReturnObject res = Application.get().getDataAccessors().getUserAccessor().saveTwoFactorConfig(p.userId.intValue(), p.code, p.sec);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec de configuration de l'acc\u00e8s 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    public ReturnObject saveTwoFactorConfigEmail(IServerRequest req) {
        try {
            ReturnObject res;
            CTwoFactorConfigSave p = (CTwoFactorConfigSave)req.getPostBody(CTwoFactorConfigSave.class);
            if (Application.get().getGlobalInstances().getSession() != null) {
                XUser currentUser = Application.get().getGlobalInstances().getSession().getUser();
                if (p.userId != null && !this.isUserManager(currentUser) && p.userId != currentUser.getId()) {
                    return ServerResponses.ErrorReturnObject((String)"Vous n'avez pas les droits n\u00e9cessaires pour modifier la configuration 2FA pour l'utilisateur");
                }
                if (p.userId == null) {
                    p.userId = Application.get().getGlobalInstances().getSession().getUser().getId();
                }
                res = Application.get().getDataAccessors().getUserAccessor().saveTwoFactorConfigEmail(p.userId.intValue(), p.code, p.email);
            } else {
                res = Application.get().getDataAccessors().getLoginAccessor().saveTwoFactorConfigEmail(p.userName, DesEncrypter.encryptMe((String)p.password), p.clientCode, p.code, p.email);
            }
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec de sauvegarde du courriel d'acc\u00e8s 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    public ReturnObject sendTwoFactorCodeToEmail(IServerRequest req) {
        try {
            ReturnObject res;
            CTwoFactorConfigSave p = (CTwoFactorConfigSave)req.getPostBody(CTwoFactorConfigSave.class);
            if (Application.get().getGlobalInstances().getSession() != null) {
                XUser currentUser = Application.get().getGlobalInstances().getSession().getUser();
                if (p.userId != null && !this.isUserManager(currentUser) && p.userId != currentUser.getId()) {
                    return ServerResponses.ErrorReturnObject((String)"Vous n'avez pas les droits n\u00e9cessaires pour modifier la configuration 2FA pour l'utilisateur ");
                }
                if (p.userId == null) {
                    p.userId = Application.get().getGlobalInstances().getSession().getUser().getId();
                }
                if (p.email == null) {
                    p.email = Application.get().getGlobalInstances().getSession().getUser().getTwoFactorEmail();
                }
                if (p.email == null || p.email.length() < 3) {
                    return ServerResponses.ErrorReturnObject((String)"Courriel invalide");
                }
                res = Application.get().getDataAccessors().getUserAccessor().sendTwoFactorCodeToEmail(p.userId.intValue(), p.email, p.lang);
            } else {
                res = Application.get().getDataAccessors().getLoginAccessor().sendTwoFactorCodeToEmail(p.userName, DesEncrypter.encryptMe((String)p.password), p.clientCode, p.lang, p.email);
            }
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec d'envoi du courriel de code d'acc\u00e8s 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    public ReturnObject deleteTwoFactor(IServerRequest req) {
        try {
            int userId = Integer.parseInt(req.getRequiredQueryParam("userId"));
            ReturnObject res = Application.get().getDataAccessors().getUserAccessor().deleteTwoFactor(userId);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec de la suppression de la configuration 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    public ReturnObject suspendTwoFactor(IServerRequest req) {
        try {
            int userId = Integer.parseInt(req.getRequiredQueryParam("userId"));
            ReturnObject res = Application.get().getDataAccessors().getUserAccessor().suspendTwoFactor(userId);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec de la suspension de la configuration 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    public ReturnObject restoreTwoFactorAuth(IServerRequest req) {
        try {
            int userId = Integer.parseInt(req.getRequiredQueryParam("userId"));
            ReturnObject res = Application.get().getDataAccessors().getUserAccessor().restoreTwoFactorAuth(userId);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "\u00c9chec de la suspension de la configuration 2FA.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    private ActionResult index(IServerRequest request) {
        ActionResult res = new ActionResult("dashboard", "/login.html");
        return res;
    }

    private ActionResult notLoggedIn(IServerRequest request) {
        ActionResult res = new ActionResult("dashboard", "/notLoggedIn.html");
        return res;
    }

    private boolean isLoggedOut() {
        return Application.get().getGlobalInstances().getSession() == null;
    }

    private ReturnObject accessDeniedReturnObject() {
        return ServerResponses.ErrorReturnObject((String)"");
    }

    private ActionResult accessDeniedActionResult() {
        return ServerResponses.ERROR((String)"");
    }

    private ReturnObject responsibilityAcceptance(IServerRequest request) {
        this.logUserResponsibilities();
        return ServerResponses.OKReturnObject();
    }

    private ReturnObject aiResponsibilityAcceptance(IServerRequest request) {
        this.logUserAIResponsibilities();
        return ServerResponses.OKReturnObject();
    }

    private ReturnObject getLoginfo(IServerRequest request) {
        ReturnObject res = ServerResponses.OKReturnObject();
        CLoginInfo loggedIn = new CLoginInfo();
        loggedIn.clientcode = this.loginInfo.get("CLIENT");
        if (loggedIn.clientcode != null && !loggedIn.clientcode.equals("")) {
            loggedIn.clientcode = DesEncrypter.decryptMeOr((String)loggedIn.clientcode, (String)"");
        }
        loggedIn.isLoggedIn = Application.get().getGlobalInstances().getSession() != null;
        loggedIn.serverUrl = System.getProperty("ca.infodata.ofys.news.server");
        loggedIn.serverUrl = loggedIn.serverUrl == null ? "https://ofyspro.ca/news" : loggedIn.serverUrl;
        loggedIn.appVersion = LibPlugin.getVersion();
        res.setObj((Object)loggedIn);
        return res;
    }

    private void logUserResponsibilities() {
        XNewLog log = new XNewLog();
        log.setType1(XLogType1.RESPONSIBILITY_STATEMENT_ACCEPTED);
        try {
            LogAccessorClient.getInstance().log(Application.get().getGlobalInstances().getSession(), (ICallback)new DefaultCallback(), log);
        }
        catch (CannotConnectToServerException e) {
            e.printStackTrace();
        }
    }

    private void logUserAIResponsibilities() {
        XNewLog log = new XNewLog();
        log.setType1(XLogType1.AI_RESPONSIBILITY_STATEMENT_ACCEPTED);
        try {
            LogAccessorClient.getInstance().log(Application.get().getGlobalInstances().getSession(), (ICallback)new DefaultCallback(), log);
        }
        catch (CannotConnectToServerException e) {
            e.printStackTrace();
        }
    }

    private ReturnObject login(IServerRequest request) {
        ReturnObject res;
        CLogin login = (CLogin)request.getPostBody(CLogin.class);
        try {
            SessionLock sessionLock = new SessionLock(login.userName);
            sessionLock.tryLockAndRelease();
            res = this.accessor.logIn(login.userName, DesEncrypter.encryptMe((String)login.password), login.twoFactorCode, login.sid, login.autolog, Util.getMacAddress(), System.getProperty("user.name"), Util.getIp(), LocaleProvider.getLocale().toString(), login.clientCode, login.st);
            res = this.loginResponse(res, login);
        }
        catch (SessionLockException e) {
            if (e.getCause() != null) {
                logger.log(Level.SEVERE, "Exception on login", e);
            }
            res = ServerResponses.ErrorReturnObject((String)e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception on login", e);
            res = ServerResponses.ErrorReturnObject((String)MessageUtil.UNEXPECTED_ERROR_MESSAGE);
        }
        return res;
    }

    private ReturnObject loginResponse(ReturnObject response, CLogin login) {
        block6: {
            try {
                MultiStatus status = response.getStatus();
                if (!status.isOkToProceed()) break block6;
                try {
                    XSession session = (XSession)response.getObj();
                    Application.get().getGlobalInstances().setSession(session);
                    LibPlugin.setCodeClient((String)login.clientCode);
                    LibPlugin.setUserName((String)login.userName);
                    this.loginInfo.put("CLIENT", DesEncrypter.encryptMeOr((String)login.clientCode, (String)""));
                    this.loginInfo.save();
                }
                catch (StatusException e) {
                    if (e.getStatus().isOkToProceed()) {
                        response.getStatus().add((IStatus)ServerResponses.ErrorMultiStatus((String)e.getMessage()));
                    }
                    throw e;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IntroPlugin.setApplicationTitle();
                    }
                });
            }
            catch (StatusException statusException) {
                this.logOut();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                response.getStatus().add((IStatus)ServerResponses.ErrorMultiStatus((String)e.getMessage()));
                this.logOut();
            }
        }
        return response;
    }

    public ReturnObject isWeb(IServerRequest req) {
        return ServerResponses.OKReturnObject((Object)false);
    }

    private ActionResult logOut(IServerRequest request) {
        if (this.isLoggedOut()) {
            return this.accessDeniedActionResult();
        }
        Throwable exception = this.logOut();
        if (exception != null) {
            return ServerResponses.ERROR((String)MessageUtil.UNEXPECTED_ERROR_MESSAGE);
        }
        return ServerResponses.SUCCESS();
    }

    private Throwable logOut() {
        final MutableObject t = new MutableObject(null);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PerspectiveManager.getCurrentPerspective() != PerspectiveManager.Perspective.LOG_IN_PERSPECTIVE) {
                        PerspectiveManager.openLoginPerspective((boolean)true);
                    }
                    IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart().getSite().getService(IHandlerService.class);
                    service.executeCommand("ca.infodata.ofys.ui.intro.commands.logoutCommand", null);
                    IntroPlugin.mqScheduledFuture.cancel(true);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to execute ca.infodata.ofys.ui.intro.commands.logoutCommand", e);
                    t.setValue((Object)e);
                }
            }
        });
        return (Throwable)t.getValue();
    }

    private ReturnObject changePassword(IServerRequest req) {
        if (this.isLoggedOut()) {
            return this.accessDeniedReturnObject();
        }
        CPasswordUpdate change = (CPasswordUpdate)req.getPostBody(CPasswordUpdate.class);
        if (!change.password.equals(change.confirmPassword)) {
            return ServerResponses.ErrorReturnObject((String)"Le mot de passe et sa confirmation ne sont pas identiques.");
        }
        try {
            return this.userAccessor.changePasswordUser(DesEncrypter.encryptMe((String)change.oldPassword), DesEncrypter.encryptMe((String)change.password));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Echec de changement de mot de passe.", e);
            return ServerResponses.ErrorReturnObject();
        }
    }

    private ActionResult openAdmin(IServerRequest req) {
        if (this.isLoggedOut()) {
            return this.accessDeniedActionResult();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PerspectiveManager.open((PerspectiveManager.Perspective)PerspectiveManager.Perspective.OFYS_PERSPECTIVE, (boolean)true, (boolean)false);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error opening ofys perspective", e);
                }
            }
        });
        return ServerResponses.SUCCESS();
    }

    private ActionResult openInternal(IServerRequest req) {
        if (this.isLoggedOut()) {
            return this.accessDeniedActionResult();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (UI.OS_MAC) {
                    PerspectiveManager.open((PerspectiveManager.Perspective)PerspectiveManager.Perspective.OFYS_PERSPECTIVE, (boolean)true, (boolean)false);
                    try {
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = service.getCommand("ca.infodata.ofys.ui.dashboard.CefHandler");
                        try {
                            ExecutionEvent event = new ExecutionEvent(command, new HashMap(), null, null);
                            command.executeWithChecks(event);
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.dashboard.CefHandler", e);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Dashboard editor open error", e);
                    }
                } else {
                    LoginController.this.openOfysPerspectiveAsync(TimeUnit.SECONDS.toMillis(10L));
                    try {
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = service.getCommand("ca.infodata.ofys.ui.dashboard.CefHandler");
                        try {
                            ExecutionEvent event = new ExecutionEvent(command, new HashMap(), null, null);
                            command.executeWithChecks(event);
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.dashboard.CefHandler", e);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Dashboard editor open error", e);
                    }
                }
            }
        });
        return ServerResponses.SUCCESS();
    }

    private void openOfysPerspectiveAsync(long delay) {
        try {
            new Job("open"){

                protected org.eclipse.core.runtime.IStatus run(IProgressMonitor arg0) {
                    try {
                        if (PerspectiveManager.getCurrentPerspective() != PerspectiveManager.Perspective.OFYS_PERSPECTIVE) {
                            if (UI.OS_MAC) {
                                PerspectiveManager.openInSwtThread((PerspectiveManager.Perspective)PerspectiveManager.Perspective.OFYS_PERSPECTIVE, (boolean)true, (boolean)false);
                            } else {
                                PerspectiveManager.openInSwtThread((PerspectiveManager.Perspective)PerspectiveManager.Perspective.OFYS_PERSPECTIVE, (boolean)true, (boolean)false);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error opening ofys perspective", e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule(delay);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error opening ofys perspective", e);
        }
    }

    private ActionResult assist(IServerRequest req) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPartService().getActivePart().getSite().getService(IHandlerService.class);
        try {
            service.executeCommand("ca.infodata.ofys.ui.intro.commands.remoteDesktopHelp", null);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            e.printStackTrace();
        }
        return ServerResponses.SUCCESS();
    }

    private ActionResult openExternal(IServerRequest req) {
        if (this.isLoggedOut()) {
            return this.accessDeniedActionResult();
        }
        this.openOfysPerspectiveAsync(TimeUnit.SECONDS.toMillis(10L));
        if (UI.OS_WINDOWS) {
            Program.launch((String)(String.valueOf(HtmlBrowserTools.getJettyUrl(null)) + "/dashboard"));
        } else {
            Program.launch((String)(String.valueOf(HtmlBrowserTools.getJettyUrl(null)) + "/dashboard"));
        }
        return ServerResponses.SUCCESS();
    }
}

