/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class SkipjackEngine
implements BlockCipher {
    static final int BLOCK_SIZE = 8;
    static short[] ftable;
    private int[] key0;
    private int[] key1;
    private int[] key2;
    private int[] key3;
    private boolean encrypting;

    static {
        short[] sArray = new short[256];
        sArray[0] = 163;
        sArray[1] = 215;
        sArray[2] = 9;
        sArray[3] = 131;
        sArray[4] = 248;
        sArray[5] = 72;
        sArray[6] = 246;
        sArray[7] = 244;
        sArray[8] = 179;
        sArray[9] = 33;
        sArray[10] = 21;
        sArray[11] = 120;
        sArray[12] = 153;
        sArray[13] = 177;
        sArray[14] = 175;
        sArray[15] = 249;
        sArray[16] = 231;
        sArray[17] = 45;
        sArray[18] = 77;
        sArray[19] = 138;
        sArray[20] = 206;
        sArray[21] = 76;
        sArray[22] = 202;
        sArray[23] = 46;
        sArray[24] = 82;
        sArray[25] = 149;
        sArray[26] = 217;
        sArray[27] = 30;
        sArray[28] = 78;
        sArray[29] = 56;
        sArray[30] = 68;
        sArray[31] = 40;
        sArray[32] = 10;
        sArray[33] = 223;
        sArray[34] = 2;
        sArray[35] = 160;
        sArray[36] = 23;
        sArray[37] = 241;
        sArray[38] = 96;
        sArray[39] = 104;
        sArray[40] = 18;
        sArray[41] = 183;
        sArray[42] = 122;
        sArray[43] = 195;
        sArray[44] = 233;
        sArray[45] = 250;
        sArray[46] = 61;
        sArray[47] = 83;
        sArray[48] = 150;
        sArray[49] = 132;
        sArray[50] = 107;
        sArray[51] = 186;
        sArray[52] = 242;
        sArray[53] = 99;
        sArray[54] = 154;
        sArray[55] = 25;
        sArray[56] = 124;
        sArray[57] = 174;
        sArray[58] = 229;
        sArray[59] = 245;
        sArray[60] = 247;
        sArray[61] = 22;
        sArray[62] = 106;
        sArray[63] = 162;
        sArray[64] = 57;
        sArray[65] = 182;
        sArray[66] = 123;
        sArray[67] = 15;
        sArray[68] = 193;
        sArray[69] = 147;
        sArray[70] = 129;
        sArray[71] = 27;
        sArray[72] = 238;
        sArray[73] = 180;
        sArray[74] = 26;
        sArray[75] = 234;
        sArray[76] = 208;
        sArray[77] = 145;
        sArray[78] = 47;
        sArray[79] = 184;
        sArray[80] = 85;
        sArray[81] = 185;
        sArray[82] = 218;
        sArray[83] = 133;
        sArray[84] = 63;
        sArray[85] = 65;
        sArray[86] = 191;
        sArray[87] = 224;
        sArray[88] = 90;
        sArray[89] = 88;
        sArray[90] = 128;
        sArray[91] = 95;
        sArray[92] = 102;
        sArray[93] = 11;
        sArray[94] = 216;
        sArray[95] = 144;
        sArray[96] = 53;
        sArray[97] = 213;
        sArray[98] = 192;
        sArray[99] = 167;
        sArray[100] = 51;
        sArray[101] = 6;
        sArray[102] = 101;
        sArray[103] = 105;
        sArray[104] = 69;
        sArray[106] = 148;
        sArray[107] = 86;
        sArray[108] = 109;
        sArray[109] = 152;
        sArray[110] = 155;
        sArray[111] = 118;
        sArray[112] = 151;
        sArray[113] = 252;
        sArray[114] = 178;
        sArray[115] = 194;
        sArray[116] = 176;
        sArray[117] = 254;
        sArray[118] = 219;
        sArray[119] = 32;
        sArray[120] = 225;
        sArray[121] = 235;
        sArray[122] = 214;
        sArray[123] = 228;
        sArray[124] = 221;
        sArray[125] = 71;
        sArray[126] = 74;
        sArray[127] = 29;
        sArray[128] = 66;
        sArray[129] = 237;
        sArray[130] = 158;
        sArray[131] = 110;
        sArray[132] = 73;
        sArray[133] = 60;
        sArray[134] = 205;
        sArray[135] = 67;
        sArray[136] = 39;
        sArray[137] = 210;
        sArray[138] = 7;
        sArray[139] = 212;
        sArray[140] = 222;
        sArray[141] = 199;
        sArray[142] = 103;
        sArray[143] = 24;
        sArray[144] = 137;
        sArray[145] = 203;
        sArray[146] = 48;
        sArray[147] = 31;
        sArray[148] = 141;
        sArray[149] = 198;
        sArray[150] = 143;
        sArray[151] = 170;
        sArray[152] = 200;
        sArray[153] = 116;
        sArray[154] = 220;
        sArray[155] = 201;
        sArray[156] = 93;
        sArray[157] = 92;
        sArray[158] = 49;
        sArray[159] = 164;
        sArray[160] = 112;
        sArray[161] = 136;
        sArray[162] = 97;
        sArray[163] = 44;
        sArray[164] = 159;
        sArray[165] = 13;
        sArray[166] = 43;
        sArray[167] = 135;
        sArray[168] = 80;
        sArray[169] = 130;
        sArray[170] = 84;
        sArray[171] = 100;
        sArray[172] = 38;
        sArray[173] = 125;
        sArray[174] = 3;
        sArray[175] = 64;
        sArray[176] = 52;
        sArray[177] = 75;
        sArray[178] = 28;
        sArray[179] = 115;
        sArray[180] = 209;
        sArray[181] = 196;
        sArray[182] = 253;
        sArray[183] = 59;
        sArray[184] = 204;
        sArray[185] = 251;
        sArray[186] = 127;
        sArray[187] = 171;
        sArray[188] = 230;
        sArray[189] = 62;
        sArray[190] = 91;
        sArray[191] = 165;
        sArray[192] = 173;
        sArray[193] = 4;
        sArray[194] = 35;
        sArray[195] = 156;
        sArray[196] = 20;
        sArray[197] = 81;
        sArray[198] = 34;
        sArray[199] = 240;
        sArray[200] = 41;
        sArray[201] = 121;
        sArray[202] = 113;
        sArray[203] = 126;
        sArray[204] = 255;
        sArray[205] = 140;
        sArray[206] = 14;
        sArray[207] = 226;
        sArray[208] = 12;
        sArray[209] = 239;
        sArray[210] = 188;
        sArray[211] = 114;
        sArray[212] = 117;
        sArray[213] = 111;
        sArray[214] = 55;
        sArray[215] = 161;
        sArray[216] = 236;
        sArray[217] = 211;
        sArray[218] = 142;
        sArray[219] = 98;
        sArray[220] = 139;
        sArray[221] = 134;
        sArray[222] = 16;
        sArray[223] = 232;
        sArray[224] = 8;
        sArray[225] = 119;
        sArray[226] = 17;
        sArray[227] = 190;
        sArray[228] = 146;
        sArray[229] = 79;
        sArray[230] = 36;
        sArray[231] = 197;
        sArray[232] = 50;
        sArray[233] = 54;
        sArray[234] = 157;
        sArray[235] = 207;
        sArray[236] = 243;
        sArray[237] = 166;
        sArray[238] = 187;
        sArray[239] = 172;
        sArray[240] = 94;
        sArray[241] = 108;
        sArray[242] = 169;
        sArray[243] = 19;
        sArray[244] = 87;
        sArray[245] = 37;
        sArray[246] = 181;
        sArray[247] = 227;
        sArray[248] = 189;
        sArray[249] = 168;
        sArray[250] = 58;
        sArray[251] = 1;
        sArray[252] = 5;
        sArray[253] = 89;
        sArray[254] = 42;
        sArray[255] = 70;
        ftable = sArray;
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to SKIPJACK init - " + params.getClass().getName());
        }
        byte[] keyBytes = ((KeyParameter)params).getKey();
        this.encrypting = encrypting;
        this.key0 = new int[32];
        this.key1 = new int[32];
        this.key2 = new int[32];
        this.key3 = new int[32];
        int i = 0;
        while (i < 32) {
            this.key0[i] = keyBytes[i * 4 % 10] & 0xFF;
            this.key1[i] = keyBytes[(i * 4 + 1) % 10] & 0xFF;
            this.key2[i] = keyBytes[(i * 4 + 2) % 10] & 0xFF;
            this.key3[i] = keyBytes[(i * 4 + 3) % 10] & 0xFF;
            ++i;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SKIPJACK";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.key1 == null) {
            throw new IllegalStateException("SKIPJACK engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 8;
    }

    @Override
    public void reset() {
    }

    private int g(int k, int w) {
        int g1 = w >> 8 & 0xFF;
        int g2 = w & 0xFF;
        int g3 = ftable[g2 ^ this.key0[k]] ^ g1;
        int g4 = ftable[g3 ^ this.key1[k]] ^ g2;
        int g5 = ftable[g4 ^ this.key2[k]] ^ g3;
        int g6 = ftable[g5 ^ this.key3[k]] ^ g4;
        return (g5 << 8) + g6;
    }

    public int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int w1 = (in[inOff + 0] << 8) + (in[inOff + 1] & 0xFF);
        int w2 = (in[inOff + 2] << 8) + (in[inOff + 3] & 0xFF);
        int w3 = (in[inOff + 4] << 8) + (in[inOff + 5] & 0xFF);
        int w4 = (in[inOff + 6] << 8) + (in[inOff + 7] & 0xFF);
        int k = 0;
        int t = 0;
        while (t < 2) {
            int tmp;
            int i = 0;
            while (i < 8) {
                tmp = w4;
                w4 = w3;
                w3 = w2;
                w2 = this.g(k, w1);
                w1 = w2 ^ tmp ^ k + 1;
                ++k;
                ++i;
            }
            i = 0;
            while (i < 8) {
                tmp = w4;
                w4 = w3;
                w3 = w1 ^ w2 ^ k + 1;
                w2 = this.g(k, w1);
                w1 = tmp;
                ++k;
                ++i;
            }
            ++t;
        }
        out[outOff + 0] = (byte)(w1 >> 8);
        out[outOff + 1] = (byte)w1;
        out[outOff + 2] = (byte)(w2 >> 8);
        out[outOff + 3] = (byte)w2;
        out[outOff + 4] = (byte)(w3 >> 8);
        out[outOff + 5] = (byte)w3;
        out[outOff + 6] = (byte)(w4 >> 8);
        out[outOff + 7] = (byte)w4;
        return 8;
    }

    private int h(int k, int w) {
        int h1 = w & 0xFF;
        int h2 = w >> 8 & 0xFF;
        int h3 = ftable[h2 ^ this.key3[k]] ^ h1;
        int h4 = ftable[h3 ^ this.key2[k]] ^ h2;
        int h5 = ftable[h4 ^ this.key1[k]] ^ h3;
        int h6 = ftable[h5 ^ this.key0[k]] ^ h4;
        return (h6 << 8) + h5;
    }

    public int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int w2 = (in[inOff + 0] << 8) + (in[inOff + 1] & 0xFF);
        int w1 = (in[inOff + 2] << 8) + (in[inOff + 3] & 0xFF);
        int w4 = (in[inOff + 4] << 8) + (in[inOff + 5] & 0xFF);
        int w3 = (in[inOff + 6] << 8) + (in[inOff + 7] & 0xFF);
        int k = 31;
        int t = 0;
        while (t < 2) {
            int tmp;
            int i = 0;
            while (i < 8) {
                tmp = w4;
                w4 = w3;
                w3 = w2;
                w2 = this.h(k, w1);
                w1 = w2 ^ tmp ^ k + 1;
                --k;
                ++i;
            }
            i = 0;
            while (i < 8) {
                tmp = w4;
                w4 = w3;
                w3 = w1 ^ w2 ^ k + 1;
                w2 = this.h(k, w1);
                w1 = tmp;
                --k;
                ++i;
            }
            ++t;
        }
        out[outOff + 0] = (byte)(w2 >> 8);
        out[outOff + 1] = (byte)w2;
        out[outOff + 2] = (byte)(w1 >> 8);
        out[outOff + 3] = (byte)w1;
        out[outOff + 4] = (byte)(w4 >> 8);
        out[outOff + 5] = (byte)w4;
        out[outOff + 6] = (byte)(w3 >> 8);
        out[outOff + 7] = (byte)w3;
        return 8;
    }
}

