/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.AuthAttributesProvider;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableInputStream;
import org.bouncycastle.cms.CMSReadable;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.io.TeeInputStream;

class CMSEnvelopedHelper {
    static final CMSEnvelopedHelper INSTANCE = new CMSEnvelopedHelper();
    private static final Map KEYSIZES = new HashMap();
    private static final Map BASE_CIPHER_NAMES = new HashMap();
    private static final Map CIPHER_ALG_NAMES = new HashMap();
    private static final Map MAC_ALG_NAMES = new HashMap();

    static {
        KEYSIZES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSEnvelopedGenerator.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES256_CBC, new Integer(256));
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES/CBC/PKCS5Padding");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AESMac");
    }

    CMSEnvelopedHelper() {
    }

    String getAsymmetricEncryptionAlgName(String encryptionAlgOID) {
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(encryptionAlgOID)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return encryptionAlgOID;
    }

    Cipher createAsymmetricCipher(String encryptionOid, String provName) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        String asymName = this.getAsymmetricEncryptionAlgName(encryptionOid);
        if (!asymName.equals(encryptionOid)) {
            try {
                return Cipher.getInstance(asymName, provName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return Cipher.getInstance(encryptionOid, provName);
    }

    Cipher createAsymmetricCipher(String encryptionOid, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String asymName = this.getAsymmetricEncryptionAlgName(encryptionOid);
        if (!asymName.equals(encryptionOid)) {
            try {
                return this.getCipherInstance(asymName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return this.getCipherInstance(encryptionOid, provider);
    }

    KeyGenerator createSymmetricKeyGenerator(String encryptionOID, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                String algName = (String)BASE_CIPHER_NAMES.get(encryptionOID);
                if (algName != null) {
                    return this.createKeyGenerator(algName, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (provider != null) {
                return this.createSymmetricKeyGenerator(encryptionOID, null);
            }
            throw e;
        }
    }

    AlgorithmParameters createAlgorithmParameters(String encryptionOID, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParams(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                String algName = (String)BASE_CIPHER_NAMES.get(encryptionOID);
                if (algName != null) {
                    return this.createAlgorithmParams(algName, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            throw e;
        }
    }

    AlgorithmParameterGenerator createAlgorithmParameterGenerator(String encryptionOID, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParamsGenerator(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                String algName = (String)BASE_CIPHER_NAMES.get(encryptionOID);
                if (algName != null) {
                    return this.createAlgorithmParamsGenerator(algName, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            throw e;
        }
    }

    String getRFC3211WrapperName(String oid) {
        String alg = (String)BASE_CIPHER_NAMES.get(oid);
        if (alg == null) {
            throw new IllegalArgumentException("no name for " + oid);
        }
        return String.valueOf(alg) + "RFC3211Wrap";
    }

    int getKeySize(String oid) {
        Integer keySize = (Integer)KEYSIZES.get(oid);
        if (keySize == null) {
            throw new IllegalArgumentException("no keysize for " + oid);
        }
        return keySize;
    }

    private Cipher getCipherInstance(String algName, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            return Cipher.getInstance(algName, provider);
        }
        return Cipher.getInstance(algName);
    }

    private AlgorithmParameters createAlgorithmParams(String algName, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return AlgorithmParameters.getInstance(algName, provider);
        }
        return AlgorithmParameters.getInstance(algName);
    }

    private AlgorithmParameterGenerator createAlgorithmParamsGenerator(String algName, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return AlgorithmParameterGenerator.getInstance(algName, provider);
        }
        return AlgorithmParameterGenerator.getInstance(algName);
    }

    private KeyGenerator createKeyGenerator(String algName, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return KeyGenerator.getInstance(algName, provider);
        }
        return KeyGenerator.getInstance(algName);
    }

    Cipher createSymmetricCipher(String encryptionOID, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.getCipherInstance(encryptionOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String alternate = (String)CIPHER_ALG_NAMES.get(encryptionOID);
            try {
                return this.getCipherInstance(alternate, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (provider != null) {
                    return this.createSymmetricCipher(encryptionOID, null);
                }
                throw e;
            }
        }
    }

    private Mac createMac(String algName, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            return Mac.getInstance(algName, provider);
        }
        return Mac.getInstance(algName);
    }

    Mac getMac(String macOID, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.createMac(macOID, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String alternate = (String)MAC_ALG_NAMES.get(macOID);
            try {
                return this.createMac(alternate, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (provider != null) {
                    return this.getMac(macOID, null);
                }
                throw e;
            }
        }
    }

    AlgorithmParameters getEncryptionAlgorithmParameters(String encOID, byte[] encParams, Provider provider) throws CMSException {
        if (encParams == null) {
            return null;
        }
        try {
            AlgorithmParameters params = this.createAlgorithmParameters(encOID, provider);
            params.init(encParams, "ASN.1");
            return params;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find parameters for algorithm", e);
        }
        catch (IOException e) {
            throw new CMSException("can't find parse parameters", e);
        }
    }

    String getSymmetricCipherName(String oid) {
        String algName = (String)BASE_CIPHER_NAMES.get(oid);
        if (algName != null) {
            return algName;
        }
        return oid;
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, messageAlgorithm, secureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ArrayList infos = new ArrayList();
        int i = 0;
        while (i != recipientInfos.size()) {
            RecipientInfo info = RecipientInfo.getInstance(recipientInfos.getObjectAt(i));
            CMSEnvelopedHelper.readRecipientInfo(infos, info, messageAlgorithm, secureReadable, additionalData);
            ++i;
        }
        return new RecipientInformationStore(infos);
    }

    private static void readRecipientInfo(List infos, RecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        DEREncodable recipInfo = info.getInfo();
        if (recipInfo instanceof KeyTransRecipientInfo) {
            infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KEKRecipientInfo) {
            infos.add(new KEKRecipientInformation((KEKRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(infos, (KeyAgreeRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData);
        } else if (recipInfo instanceof PasswordRecipientInfo) {
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        }
    }

    static Object execute(JCECallback callback) throws CMSException {
        try {
            return callback.doInJCE();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new CMSException("MAC algorithm parameter spec invalid.", e);
        }
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private Mac mac;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        @Override
        public AlgorithmIdentifier getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public Object getCryptoObject() {
            return this.mac;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }

        @Override
        public CMSReadable getReadable(final SecretKey sKey, final Provider provider) throws CMSException {
            final String macAlg = this.algorithm.getObjectId().getId();
            final ASN1Object sParams = (ASN1Object)this.algorithm.getParameters();
            this.mac = (Mac)CMSEnvelopedHelper.execute(new JCECallback(){

                @Override
                public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException {
                    Mac mac = INSTANCE.getMac(macAlg, provider);
                    if (sParams != null && !(sParams instanceof ASN1Null)) {
                        AlgorithmParameters params = INSTANCE.createAlgorithmParameters(macAlg, provider);
                        try {
                            params.init(sParams.getEncoded(), "ASN.1");
                        }
                        catch (IOException e) {
                            throw new CMSException("error decoding algorithm parameters.", e);
                        }
                        mac.init(sKey, params.getParameterSpec(IvParameterSpec.class));
                    } else {
                        mac.init(sKey);
                    }
                    return mac;
                }
            });
            try {
                return new CMSProcessableInputStream(new TeeInputStream(this.readable.getInputStream(), new MacOutputStream(this.mac)));
            }
            catch (IOException e) {
                throw new CMSException("error reading content.", e);
            }
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, CMSReadable readable) {
            this.digestCalculator = digestCalculator;
            this.readable = readable;
        }

        @Override
        public AlgorithmIdentifier getAlgorithm() {
            return null;
        }

        @Override
        public Object getCryptoObject() {
            return null;
        }

        @Override
        public CMSReadable getReadable(SecretKey key, Provider provider) throws CMSException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                @Override
                public int read() throws IOException {
                    int b = this.in.read();
                    if (b >= 0) {
                        digestCalculator.getOutputStream().write(b);
                    }
                    return b;
                }

                @Override
                public int read(byte[] inBuf, int inOff, int inLen) throws IOException {
                    int n = this.in.read(inBuf, inOff, inLen);
                    if (n >= 0) {
                        digestCalculator.getOutputStream().write(inBuf, inOff, n);
                    }
                    return n;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private Cipher cipher;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        @Override
        public AlgorithmIdentifier getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }

        @Override
        public Object getCryptoObject() {
            return this.cipher;
        }

        @Override
        public CMSReadable getReadable(final SecretKey sKey, final Provider provider) throws CMSException {
            final String encAlg = this.algorithm.getObjectId().getId();
            final ASN1Object sParams = (ASN1Object)this.algorithm.getParameters();
            this.cipher = (Cipher)CMSEnvelopedHelper.execute(new JCECallback(){

                @Override
                public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException {
                    Cipher cipher = INSTANCE.createSymmetricCipher(encAlg, provider);
                    if (sParams != null && !(sParams instanceof ASN1Null)) {
                        try {
                            AlgorithmParameters params = INSTANCE.createAlgorithmParameters(encAlg, cipher.getProvider());
                            try {
                                params.init(sParams.getEncoded(), "ASN.1");
                            }
                            catch (IOException e) {
                                throw new CMSException("error decoding algorithm parameters.", e);
                            }
                            cipher.init(2, (Key)sKey, params);
                        }
                        catch (NoSuchAlgorithmException e) {
                            if (encAlg.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlg.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlg.equals(CMSEnvelopedDataGenerator.AES128_CBC) || encAlg.equals(CMSEnvelopedDataGenerator.AES192_CBC) || encAlg.equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
                                cipher.init(2, (Key)sKey, new IvParameterSpec(ASN1OctetString.getInstance(sParams).getOctets()));
                            }
                            throw e;
                        }
                    } else if (encAlg.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlg.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlg.equals("1.2.840.113533.7.66.10")) {
                        cipher.init(2, (Key)sKey, new IvParameterSpec(new byte[8]));
                    } else {
                        cipher.init(2, sKey);
                    }
                    return cipher;
                }
            });
            try {
                return new CMSProcessableInputStream(new CipherInputStream(this.readable.getInputStream(), this.cipher));
            }
            catch (IOException e) {
                throw new CMSException("error reading content.", e);
            }
        }
    }

    static interface JCECallback {
        public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException;
    }
}

