/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import org.apache.lucene.search.spell.StringDistance;

public final class LevensteinDistance
implements StringDistance {
    @Override
    public float getDistance(String target, String other) {
        char[] sa = target.toCharArray();
        int n = sa.length;
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int m = other.length();
        if (n == 0 || m == 0) {
            if (n == m) {
                return 1.0f;
            }
            return 0.0f;
        }
        int i = 0;
        while (i <= n) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= m) {
            char t_j = other.charAt(j - 1);
            d[0] = j;
            i = 1;
            while (i <= n) {
                int cost = sa[i - 1] == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                ++i;
            }
            int[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return 1.0f - (float)p[n] / (float)Math.max(other.length(), sa.length);
    }

    public int hashCode() {
        return 163 * this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public String toString() {
        return "levenstein";
    }
}

