/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.Version;

public final class TrimFilter
extends TokenFilter {
    final boolean updateOffsets;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    @Deprecated
    public TrimFilter(Version version, TokenStream in, boolean updateOffsets) {
        super(in);
        if (updateOffsets && version.onOrAfter(Version.LUCENE_44)) {
            throw new IllegalArgumentException("updateOffsets=true is not supported anymore as of Lucene 4.4");
        }
        this.updateOffsets = updateOffsets;
    }

    public TrimFilter(Version version, TokenStream in) {
        this(version, in, false);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.buffer();
        int len = this.termAtt.length();
        if (len == 0) {
            return true;
        }
        int start = 0;
        int end = 0;
        int endOff = 0;
        start = 0;
        while (start < len && Character.isWhitespace(termBuffer[start])) {
            ++start;
        }
        end = len;
        while (end >= start && Character.isWhitespace(termBuffer[end - 1])) {
            ++endOff;
            --end;
        }
        if (start > 0 || end < len) {
            if (start < end) {
                this.termAtt.copyBuffer(termBuffer, start, end - start);
            } else {
                this.termAtt.setEmpty();
            }
            if (this.updateOffsets && len == this.offsetAtt.endOffset() - this.offsetAtt.startOffset()) {
                int newStart = this.offsetAtt.startOffset() + start;
                int newEnd = this.offsetAtt.endOffset() - (start < end ? endOff : 0);
                this.offsetAtt.setOffset(newStart, newEnd);
            }
        }
        return true;
    }
}

