/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2.properties;

import ca.infodata.ofys.data.middle.dataobjects.properties.report.Orientation;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PageFormat2;
import ca.infodata.ofys.ui.controls.report2.properties.PaperWrapper;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public class PaperSizesFactory {
    private static final Logger logger = Logger.getLogger(PaperSizesFactory.class.getName());
    private static final double subInchToMM = 0.35277777777777775;
    private List<PaperWrapper> paperList;
    private Map<String, String> mediaSizePrettyNames;
    private PrintService printService;

    public PaperSizesFactory(PrintService printService) {
        this.printService = printService;
        this.populateMediaSizePrettyNamesMap();
        this.populatePagerList();
    }

    private void populateMediaSizePrettyNamesMap() {
        this.mediaSizePrettyNames = new HashMap<String, String>(100);
        this.mediaSizePrettyNames.put("iso-a0", "A0");
        this.mediaSizePrettyNames.put("iso-a1", "A1");
        this.mediaSizePrettyNames.put("iso-a2", "A2");
        this.mediaSizePrettyNames.put("iso-a3", "A3");
        this.mediaSizePrettyNames.put("iso-a4", "A4");
        this.mediaSizePrettyNames.put("iso-a5", "A5");
        this.mediaSizePrettyNames.put("iso-a6", "A6");
        this.mediaSizePrettyNames.put("iso-a7", "A7");
        this.mediaSizePrettyNames.put("iso-a8", "A8");
        this.mediaSizePrettyNames.put("iso-a9", "A9");
        this.mediaSizePrettyNames.put("iso-a10", "A10");
        this.mediaSizePrettyNames.put("iso-b0", "B0");
        this.mediaSizePrettyNames.put("iso-b1", "B1");
        this.mediaSizePrettyNames.put("iso-b2", "B2");
        this.mediaSizePrettyNames.put("iso-b3", "B3");
        this.mediaSizePrettyNames.put("iso-b4", "B4");
        this.mediaSizePrettyNames.put("iso-b5", "B5");
        this.mediaSizePrettyNames.put("iso-b6", "B6");
        this.mediaSizePrettyNames.put("iso-b7", "B7");
        this.mediaSizePrettyNames.put("iso-b8", "B8");
        this.mediaSizePrettyNames.put("iso-b9", "B9");
        this.mediaSizePrettyNames.put("iso-b10", "B10");
        this.mediaSizePrettyNames.put("na-letter", "North American Letter");
        this.mediaSizePrettyNames.put("na-legal", "North American Legal");
        this.mediaSizePrettyNames.put("na-8x10", "North American 8x10 inch");
        this.mediaSizePrettyNames.put("na-5x7", "North American 5x7 inch");
        this.mediaSizePrettyNames.put("executive", "Executive");
        this.mediaSizePrettyNames.put("folio", "Folio");
        this.mediaSizePrettyNames.put("invoice", "Invoice");
        this.mediaSizePrettyNames.put("tabloid", "Tabloid");
        this.mediaSizePrettyNames.put("ledger", "Ledger");
        this.mediaSizePrettyNames.put("quarto", "Quarto");
        this.mediaSizePrettyNames.put("iso-c0", "C0");
        this.mediaSizePrettyNames.put("iso-c1", "C1");
        this.mediaSizePrettyNames.put("iso-c2", "C2");
        this.mediaSizePrettyNames.put("iso-c3", "C3");
        this.mediaSizePrettyNames.put("iso-c4", "C4");
        this.mediaSizePrettyNames.put("iso-c5", "C5");
        this.mediaSizePrettyNames.put("iso-c6", "C6");
        this.mediaSizePrettyNames.put("iso-designated-long", "ISO Designated Long size");
        this.mediaSizePrettyNames.put("na-10x13-envelope", "North American 10x13 inch");
        this.mediaSizePrettyNames.put("na-9x12-envelope", "North American 9x12 inch");
        this.mediaSizePrettyNames.put("na-number-10-envelope", "North American number 10 business envelope");
        this.mediaSizePrettyNames.put("na-7x9-envelope", "North American 7x9 inch envelope");
        this.mediaSizePrettyNames.put("na-9x11-envelope", "North American 9x11 inch envelope");
        this.mediaSizePrettyNames.put("na-10x14-envelope", "North American 10x14 inch envelope");
        this.mediaSizePrettyNames.put("na-number-9-envelope", "North American number 9 business envelope");
        this.mediaSizePrettyNames.put("na-6x9-envelope", "North American 6x9 inch envelope");
        this.mediaSizePrettyNames.put("na-10x15-envelope", "North American 10x15 inch envelope");
        this.mediaSizePrettyNames.put("monarch-envelope", "Monarch envelope");
        this.mediaSizePrettyNames.put("jis-b0", "Japanese B0");
        this.mediaSizePrettyNames.put("jis-b1", "Japanese B1");
        this.mediaSizePrettyNames.put("jis-b2", "Japanese B2");
        this.mediaSizePrettyNames.put("jis-b3", "Japanese B3");
        this.mediaSizePrettyNames.put("jis-b4", "Japanese B4");
        this.mediaSizePrettyNames.put("jis-b5", "Japanese B5");
        this.mediaSizePrettyNames.put("jis-b6", "Japanese B6");
        this.mediaSizePrettyNames.put("jis-b7", "Japanese B7");
        this.mediaSizePrettyNames.put("jis-b8", "Japanese B8");
        this.mediaSizePrettyNames.put("jis-b9", "Japanese B9");
        this.mediaSizePrettyNames.put("jis-b10", "Japanese B10");
        this.mediaSizePrettyNames.put("a", "Engineering ANSI A");
        this.mediaSizePrettyNames.put("b", "Engineering ANSI B");
        this.mediaSizePrettyNames.put("c", "Engineering ANSI C");
        this.mediaSizePrettyNames.put("d", "Engineering ANSI D");
        this.mediaSizePrettyNames.put("e", "Engineering ANSI E");
        this.mediaSizePrettyNames.put("arch-a", "Architectural A");
        this.mediaSizePrettyNames.put("arch-b", "Architectural B");
        this.mediaSizePrettyNames.put("arch-c", "Architectural C");
        this.mediaSizePrettyNames.put("arch-d", "Architectural D");
        this.mediaSizePrettyNames.put("arch-e", "Architectural E");
        this.mediaSizePrettyNames.put("japanese-postcard", "Japanese Postcard");
        this.mediaSizePrettyNames.put("oufuko-postcard", "Oufuko Postcard");
        this.mediaSizePrettyNames.put("italian-envelope", "Italian Envelope");
        this.mediaSizePrettyNames.put("personal-envelope", "Personal Envelope");
        this.mediaSizePrettyNames.put("na-number-11-envelope", "North American Number 11 Envelope");
        this.mediaSizePrettyNames.put("na-number-12-envelope", "North American Number 12 Envelope");
        this.mediaSizePrettyNames.put("na-number-14-envelope", "North American Number 14 Envelope");
    }

    private void populatePagerList() {
        this.paperList = new ArrayList<PaperWrapper>(100);
        this.addCustomPapers();
    }

    private void addCustomPapers() {
        Media[] medias = (Media[])this.printService.getSupportedAttributeValues(Media.class, null, null);
        if (medias != null) {
            Media[] mediaArray = medias;
            int n = medias.length;
            int n2 = 0;
            while (n2 < n) {
                Media media = mediaArray[n2];
                if (media instanceof MediaSizeName) {
                    try {
                        this.checkAndAddSize((MediaSizeName)media);
                    }
                    catch (Exception exception) {
                        logger.info("Failed to add media size name " + media.getName() + " " + media.toString());
                    }
                }
                ++n2;
            }
        }
    }

    private void checkAndAddSize(MediaSizeName name) {
        float[] values;
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        if (!this.printService.isAttributeValueSupported(name, new DocFlavor.BYTE_ARRAY(DocFlavor.BYTE_ARRAY.PNG.getMimeType()), attributes)) {
            return;
        }
        String o = this.mediaSizePrettyNames.get(name.toString());
        String printDescription = o != null ? o.toString() : name.toString();
        MediaSize size = MediaSize.getMediaSizeForName(name);
        double pX = size.getX(1000);
        double pY = size.getY(1000);
        attributes.add(name);
        MediaPrintableArea[] area = (MediaPrintableArea[])this.printService.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes);
        if (area.length == 0) {
            return;
        }
        int useArea = 0;
        if (area[useArea] == null) {
            int i = 0;
            while (i != area.length && area[useArea] == null) {
                useArea = i++;
            }
        }
        if ((double)(values = area[useArea].getPrintableArea(1000))[2] > pX - 0.5 && (double)values[2] < pX + 0.5) {
            values[2] = (float)pX;
        }
        if ((double)values[3] > pY - 0.5 && (double)values[3] < pY + 0.5) {
            values[3] = (float)pY;
        }
        if ((double)values[2] > pX ^ (double)values[3] > pY) {
            double temp = pX;
            pX = pY;
            pY = temp;
        }
        Paper paper = new Paper();
        paper.setSize(pX, pY);
        paper.setImageableArea(values[0], values[1], values[2], values[3]);
        PaperWrapper paperWrapper = new PaperWrapper(name.toString(), printDescription, paper);
        this.paperList.add(paperWrapper);
    }

    public String findName(PageFormat pageFormat) {
        double h = pageFormat.getPaper().getHeight() * 0.35277777777777775;
        double w = pageFormat.getPaper().getWidth() * 0.35277777777777775;
        for (PaperWrapper paperWrapper : this.paperList) {
            if (!paperWrapper.sameAs(w, h)) continue;
            return paperWrapper.prettyName;
        }
        return String.valueOf(String.format("%.2f", pageFormat.getWidth() / 72.0)) + "\" X " + String.format("%.2f", pageFormat.getHeight() / 72.0) + "\"";
    }

    public PageFormat2 toPageFormat2(PageFormat pageFormat) {
        PageFormat2 pageFormat2 = null;
        if (pageFormat != null) {
            pageFormat2 = new PageFormat2();
            pageFormat2.name = this.findName(pageFormat);
            pageFormat2.orientation = pageFormat.getOrientation() == 1 ? Orientation.PORTRAIT : Orientation.LANDSCAPE;
            pageFormat2.width = pageFormat.getPaper().getWidth() * 0.35277777777777775;
            pageFormat2.height = pageFormat.getPaper().getHeight() * 0.35277777777777775;
            pageFormat2.imageableX = pageFormat.getPaper().getImageableX() * 0.35277777777777775;
            pageFormat2.imageableY = pageFormat.getPaper().getImageableY() * 0.35277777777777775;
            pageFormat2.imageableWidth = pageFormat.getPaper().getImageableWidth() * 0.35277777777777775;
            pageFormat2.imageableHeight = pageFormat.getPaper().getImageableHeight() * 0.35277777777777775;
        }
        return pageFormat2;
    }

    public List<PaperWrapper> getAvailablePapers() {
        return this.paperList;
    }

    public int getDefaultPageOrientation() {
        OrientationRequested or = (OrientationRequested)this.printService.getDefaultAttributeValue(OrientationRequested.class);
        int orientation = 1;
        if (or != null) {
            switch (or.getValue()) {
                case 4: {
                    orientation = 0;
                    break;
                }
                case 5: {
                    orientation = 2;
                }
            }
        }
        return orientation;
    }
}

