/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.popup;

import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ButtonListPopupFeature<E>
extends PopupFeature {
    public ButtonListPopupFeature(Control control) {
        super(control);
        this.showPopupDown = true;
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent) {
        Shell shell = new Shell(this.getControl().getShell(), 4);
        this.fillList(shell);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.wrap = false;
        layout.fill = true;
        layout.spacing = -5;
        shell.setLayout((Layout)layout);
        shell.pack();
        return shell;
    }

    private void fillList(Shell shell) {
        List<E> items = this.getItems();
        for (E e : items) {
            final Button button = new Button((Composite)shell, 8);
            button.setText(this.getTextForItem(e));
            button.setData(e);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ButtonListPopupFeature.this.selected(button.getData());
                }
            });
        }
    }

    @Override
    protected void refreshPopup() {
    }

    protected abstract String getTextForItem(E var1);

    protected abstract List<E> getItems();

    protected abstract void selected(E var1);
}

