/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.IControl;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormGroup
extends FontAwareComposite
implements IControl {
    private FormToolkit toolkit;
    private String text;

    public FormGroup(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.toolkit = toolkit;
        this.createControls(this);
    }

    public FormGroup(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.toolkit = toolkit;
        this.createControls(this);
    }

    private void createControls(final Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        if (this.toolkit != null) {
            this.toolkit.adapt((Composite)this);
        }
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawRectangle(new Rectangle(2, 7, parent.getSize().x - 4, parent.getSize().y - 10));
                if (FormGroup.this.getText() != null && FormGroup.this.getText().length() > 0) {
                    e.gc.setFont(FormGroup.this.getFont());
                    e.gc.drawText(" " + FormGroup.this.getText() + "  ", 15, 0);
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        size.x += 20;
        size.y += 20;
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return super.computeTrim(x, y, width, height);
    }

    public Rectangle getClientArea() {
        return super.getClientArea();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    @Override
    public Control getControl() {
        return this;
    }
}

