/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCell;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarCellRenderer;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarSelection;
import ca.infodata.ofys.ui.controls.calendar.grid.ICalendarGridData;
import ca.infodata.ofys.ui.controls.calendar.grid.MonthCell;
import ca.infodata.ofys.ui.controls.calendar.grid.MonthCellRenderer;
import ca.infodata.ofys.ui.controls.calendar.grid.NullCell;
import ca.infodata.ofys.ui.controls.calendar.grid.NullCellRenderer;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRendererFactory;
import ca.infodata.ofys.ui.controls.grid.Grid;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.Closure;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CalendarGrid<A extends ICalendarGridData> {
    private static final CalendarCellRenderer calendarCell = new CalendarCellRenderer();
    private static final MonthCellRenderer monthCell;
    private static final NullCellRenderer nullCell;
    private final Grid<Cell, A> grid;
    private boolean isDisposed;

    static {
        calendarCell.setFontPolicyName(ResourceGetter.P_LOCAL_FONTD);
        calendarCell.setFontSizeIncrement(0);
        calendarCell.setFontStyle(0);
        calendarCell.setColorText(ResourceGetter.getColor((int)0, (int)0, (int)0));
        calendarCell.setColorSelection(ResourceGetter.getColor((int)175, (int)175, (int)220));
        calendarCell.setColorBorder(ResourceGetter.getColor((int)0, (int)0, (int)0));
        calendarCell.setColorBackground(ResourceGetter.getColor((int)255, (int)255, (int)255));
        monthCell = new MonthCellRenderer();
        monthCell.setColorBackground(ResourceGetter.getColor((int)0, (int)0, (int)0));
        monthCell.setColorText(ResourceGetter.getColor((int)255, (int)255, (int)255));
        monthCell.setFont(ResourceGetter.getFont((String)ResourceGetter.P_LOCAL_FONTD, (int)15, (int)1, (boolean)true));
        nullCell = new NullCellRenderer();
        nullCell.setColorBackground(ResourceGetter.getColor((int)220, (int)220, (int)220));
        nullCell.setColorBorder(ResourceGetter.getColor((int)0, (int)0, (int)0));
    }

    public CalendarGrid(Canvas canvas, int drawYoffset, int drawXoffset) {
        this.grid = new Grid(canvas, drawYoffset, drawXoffset);
        CellRendererFactory cellRendererFactory = this.grid.getCellRendererFactory();
        cellRendererFactory.registerCellRenderer("calendar", calendarCell);
        cellRendererFactory.registerCellRenderer(MonthCell.TYPE, monthCell);
        cellRendererFactory.registerCellRenderer(NullCell.TYPE, nullCell);
    }

    public void selectLine(int weekLine) {
        Selection<Cell> selection = this.grid.getSelection();
        ICalendarGridData data = (ICalendarGridData)this.grid.getData();
        boolean added = false;
        int column = data.getAbsoluteStartColumn();
        while (column < this.grid.nbColumn()) {
            added = selection.add((Cell)data.getCell(column, weekLine)) || added;
            ++column;
        }
        if (added) {
            this.grid.redraw();
        }
    }

    public LocalDate getDateFromGCPoint(Point gcPoint) {
        Cell cell = this.grid.getCellFromGCPoint(gcPoint);
        if (cell instanceof CalendarCell) {
            return ((CalendarCell)cell).getDate();
        }
        return null;
    }

    public void reveal(LocalDate date, boolean atTop, boolean force) {
        if (date == null) {
            throw new IllegalArgumentException("date cant be null");
        }
        CalendarCell cell = ((ICalendarGridData)this.grid.getData()).getCell(date);
        if (cell != null) {
            if (atTop) {
                this.grid.revealAtTop(cell.column, cell.line, force);
            } else {
                this.grid.revealAtBottom(cell.column, cell.line, force);
            }
        }
    }

    public void revealMonth(LocalDate dateInTheMonth) {
        this.revealMonth(dateInTheMonth, false, null);
    }

    public void revealMonth(LocalDate dateInTheMonth, boolean force, Boolean revealAtTop) throws IllegalArgumentException, IllegalStateException {
        if (dateInTheMonth == null) {
            throw new IllegalArgumentException("dateInTheMonth cant be null");
        }
        A data = this.getData();
        MonthCell monthCell = data.getMonthCell(dateInTheMonth);
        if (monthCell != null) {
            int line = monthCell.getLine();
            MonthCell nextMonthCell = data.getMonthCell(dateInTheMonth.plusMonth(1));
            int endLine = nextMonthCell != null ? nextMonthCell.getLine() - 1 : data.getAbsoluteEndLine();
            if (force || this.isNotVisibleLine(line, true) || this.isNotVisibleLine(endLine, true)) {
                boolean showAtTop = line < this.getData().getAbsoluteStartLine();
                boolean bl = showAtTop = revealAtTop != null ? revealAtTop : showAtTop;
                if (showAtTop) {
                    this.revealAtTop(monthCell.column, monthCell.line, force);
                } else {
                    this.revealAtBottom(monthCell.column, monthCell.line, force);
                }
            }
        }
    }

    public CalendarSelection getSelection() {
        return this.getData().getCalendarSelection();
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.grid.dispose();
    }

    public Canvas getCanvas() {
        return this.grid.getCanvas();
    }

    public Cell getCellFromGCPoint(Point gcPoint) {
        return this.grid.getCellFromGCPoint(gcPoint);
    }

    public Rectangle getRectangleFromCell(Cell cell) {
        return this.grid.getRectangleFromCell(cell);
    }

    public CellRendererFactory getCellRendererFactory() {
        return this.grid.getCellRendererFactory();
    }

    public int getColumnWidth(int column) {
        return this.grid.getColumnWidth(column);
    }

    public Composite getControl() {
        return this.grid.getControl();
    }

    public A getData() throws IllegalStateException {
        return (A)((ICalendarGridData)this.grid.getData());
    }

    public int getLineHeight(int line) {
        return this.grid.getLineHeight(line);
    }

    public int lastVisibleColumn() {
        return this.grid.lastVisibleColumn(false);
    }

    public Integer lastVisibleLine() {
        return this.grid.lastVisibleLine(false);
    }

    public Integer firstVisibleLine() {
        return this.grid.firstVisibleLine(false);
    }

    public final int nbColumn() {
        return this.grid.nbColumn();
    }

    public final int nbLine() {
        return this.grid.nbLine();
    }

    public void redraw() {
        this.grid.redraw();
    }

    public void setCellRendererFactory(CellRendererFactory cellRendererFactory) {
        this.grid.setCellRendererFactory(cellRendererFactory);
    }

    public void setData(A data) {
        this.grid.setData(data);
    }

    public int getRelativeColumn(Cell cell) {
        return this.grid.getRelativeColumn(cell);
    }

    public int getRelativeLine(Cell cell) {
        return this.grid.getRelativeLine(cell);
    }

    public boolean isNotVisibleColumn(int column, boolean strict) {
        return this.grid.isNotVisibleColumn(column, strict);
    }

    public boolean isNotVisibleLine(int line, boolean strict) {
        return this.grid.isNotVisibleLine(line, strict);
    }

    public int lastVisibleColumn(boolean strict) {
        return this.grid.lastVisibleColumn(strict);
    }

    public int lastVisibleLine(boolean strict) {
        return this.grid.lastVisibleLine(strict);
    }

    public LocalDate getFirstDate() {
        ICalendarGridData data = (ICalendarGridData)this.grid.getData();
        int startColumn = data.getAbsoluteStartColumn();
        int endColumn = data.getAbsoluteEndColumn();
        Integer firstVisibleLine = this.grid.firstVisibleLine(false);
        if (firstVisibleLine != null) {
            Object cell = null;
            int line = firstVisibleLine;
            int column = startColumn;
            while (line <= firstVisibleLine + 4 && column < endColumn && !(cell instanceof CalendarCell)) {
                cell = data.getCell(column, line);
                while (column <= endColumn && !(cell instanceof CalendarCell)) {
                    cell = data.getCell(column, line);
                    ++column;
                }
                column = startColumn;
                ++line;
            }
            return cell != null && cell instanceof CalendarCell ? ((CalendarCell)cell).getDate() : null;
        }
        return null;
    }

    public LocalDate getEndDate() {
        ICalendarGridData data = (ICalendarGridData)this.grid.getData();
        int startColumn = data.getAbsoluteStartColumn();
        int endColumn = data.getAbsoluteEndColumn();
        Integer lastVisibleLine = this.grid.lastVisibleLine(false);
        if (lastVisibleLine != null) {
            Object cell = null;
            int line = lastVisibleLine;
            int column = endColumn;
            while (line >= lastVisibleLine - 3 && column >= startColumn && !(cell instanceof CalendarCell)) {
                cell = data.getCell(column, line);
                while (column >= startColumn && !(cell instanceof CalendarCell)) {
                    cell = data.getCell(column, line);
                    --column;
                }
                column = endColumn;
                --line;
            }
            return cell != null && cell instanceof CalendarCell ? ((CalendarCell)cell).getDate() : null;
        }
        return null;
    }

    public int getYoffset() {
        return this.grid.getYoffset();
    }

    public int getXoffset() {
        return this.grid.getXoffset();
    }

    public void revealAtTop(int column, int line, boolean force) {
        this.grid.revealAtTop(column, line, force);
    }

    public void revealAtBottom(int column, int line, boolean force) {
        this.grid.revealAtBottom(column, line, force);
    }

    public Point offsetPoint(int x, int y) {
        return this.grid.offsetPoint(x, y);
    }

    public boolean isFixedCellWidth() {
        return this.grid.isFixedCellWidth();
    }

    public boolean isFixedCellHeight() {
        return this.grid.isFixedCellHeight();
    }

    public void setFixedCellWidth(boolean fixedCellWidth) {
        this.grid.setFixedCellWidth(fixedCellWidth);
    }

    public void setFixedCellHeight(boolean fixedCellHeight) {
        this.grid.setFixedCellHeight(fixedCellHeight);
    }

    public void setOffsetListener(Closure offsetListener) {
        this.grid.setOffsetListener(offsetListener);
    }
}

