/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.ofys.ui.controls.calendar.grid.BufferedLocalDateParser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class AutoResetingBufferedLocalDateParser {
    private final BufferedLocalDateParser dateParser;
    private TimerTask resetTask;
    private final Timer resetTimer;
    private final long delay;

    public AutoResetingBufferedLocalDateParser(long autoResetingDelay) {
        this.delay = autoResetingDelay;
        this.dateParser = new BufferedLocalDateParser();
        this.resetTimer = new Timer("reset", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feed(char c) {
        if (StringUtils.isNumeric((char)c)) {
            BufferedLocalDateParser bufferedLocalDateParser = this.dateParser;
            synchronized (bufferedLocalDateParser) {
                this.dateParser.feed(c);
                this.scheduleNewReset();
            }
        }
    }

    private void scheduleNewReset() {
        if (this.resetTask != null) {
            this.resetTask.cancel();
            this.resetTimer.purge();
        }
        this.resetTask = new MyTimerTask();
        this.resetTimer.schedule(this.resetTask, this.delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate parseAndReset(LocalDate completionDate) {
        BufferedLocalDateParser bufferedLocalDateParser = this.dateParser;
        synchronized (bufferedLocalDateParser) {
            return this.dateParser.parseAndReset(completionDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        BufferedLocalDateParser bufferedLocalDateParser = this.dateParser;
        synchronized (bufferedLocalDateParser) {
            this.dateParser.reset();
        }
    }

    public static void main(String[] args) throws Exception {
        final AutoResetingBufferedLocalDateParser dateSelector = new AutoResetingBufferedLocalDateParser(3000L);
        final LocalDate today = LocalDate.today();
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (UI.CR((KeyEvent)e)) {
                    dateSelector.parseAndReset(today);
                } else if (UI.ESC((KeyEvent)e)) {
                    dateSelector.reset();
                } else {
                    dateSelector.feed(e.character);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private final class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            AutoResetingBufferedLocalDateParser.this.reset();
        }
    }
}

