/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.assistant;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposer;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposition;
import ca.infodata.ofys.ui.controls.assistant.LegendControl;
import ca.infodata.ofys.ui.controls.assistant.NullAssistantProposition;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.popup.PopupFeature;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AssistantPopup<P>
extends PopupFeature {
    private AssistantProposer<P> proposer;
    private MyText txtSearch;
    private MyText txtFilter;
    private MyText txtDescription;
    private Table list;
    private NullAssistantProposition<P> nullAssistantProposition;
    private NullAssistantProposition<P> nullAssistantPropsitionFilter;
    private List<AssistantProposition<P>> actualPropositionList;
    private static final Color BG_COLOR = ResourceGetter.getColor((int)201, (int)156, (int)71);
    private static final Color INNER_COLOR = ResourceGetter.getColor((int)242, (int)232, (int)187);
    private static final Color TEXT_COLOR = ResourceGetter.getColor((int)31, (int)32, (int)25);
    private static final Color SEARCH_COLOR = ResourceGetter.getColor((int)255, (int)255, (int)255);
    private static final int HEIGHT = 250;
    private static final String FILTRE_PAR_CONTENU = Messages.getString((String)"FILTRE_PAR_CONTENU", (String[])new String[0]);
    private static final String RECHERCHE_PAR_NOM = Messages.getString((String)"RECHERCHE_PAR_NOM", (String[])new String[0]);

    public AssistantPopup(Control c, AssistantProposer<P> proposer, NullAssistantProposition<P> nullAssistantPropsition, NullAssistantProposition<P> nullAssistantPropsitionFilter) {
        super(c);
        this.proposer = proposer;
        this.showPopupDown = true;
        this.setControlListner();
        this.nullAssistantProposition = nullAssistantPropsition;
        this.nullAssistantPropsitionFilter = nullAssistantPropsitionFilter;
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent) {
        final FontAwareShell shell = new FontAwareShell(this.getControl().getShell(), 2048);
        ResourceGetter.addListener((IRefreshFont)shell);
        this.list = new FontAwareTable((Composite)shell, 516);
        this.txtSearch = new MyText((Composite)shell, 0x800004);
        this.txtFilter = new MyText((Composite)shell, 0x800004);
        this.txtDescription = new MyText((Composite)shell, 8389192);
        this.txtFilter.setToolTipText(FILTRE_PAR_CONTENU);
        this.txtFilter.setMessage(FILTRE_PAR_CONTENU);
        this.txtSearch.setToolTipText(RECHERCHE_PAR_NOM);
        this.txtSearch.setMessage(RECHERCHE_PAR_NOM);
        shell.setBackground(BG_COLOR);
        this.txtSearch.setBackground(SEARCH_COLOR);
        this.txtFilter.setBackground(SEARCH_COLOR);
        this.list.setForeground(TEXT_COLOR);
        this.list.setBackground(INNER_COLOR);
        this.txtDescription.setForeground(TEXT_COLOR);
        this.txtDescription.setBackground(INNER_COLOR);
        this.txtDescription.setText("b");
        shell.setTabList(new Control[]{this.txtSearch.getControl(), this.txtFilter.getControl()});
        this.setIntialText();
        Composite legend = null;
        LegendControl[] legends = this.proposer.getLegendControl();
        if (legends != null && legends.length > 0) {
            legend = new Composite((Composite)shell, 0x800000);
            legend.setBackground(INNER_COLOR);
            legend.setBackgroundMode(2);
            FillLayout fl = new FillLayout();
            legend.setLayout((Layout)fl);
            LegendControl[] legendControlArray = legends;
            int n = legends.length;
            int n2 = 0;
            while (n2 < n) {
                LegendControl lc = legendControlArray[n2];
                lc.getControl(legend);
                ++n2;
            }
        }
        int w = this.getBaseControlWidth();
        FormLayout layout = new FormLayout();
        layout.marginBottom = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        layout.marginRight = 1;
        layout.spacing = 1;
        shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(25);
        this.txtSearch.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtSearch.getControl());
        data.right = new FormAttachment(50);
        this.txtFilter.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtFilter.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.bottom = legend != null ? new FormAttachment((Control)legend) : new FormAttachment(100);
        this.list.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.list);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.list, 0, 1024);
        this.txtDescription.setLayoutData(data);
        if (legend != null) {
            data = new FormData();
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.bottom = new FormAttachment(100);
            legend.setLayoutData((Object)data);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.removeListener((IRefreshFont)shell);
            }
        });
        final Table li = this.list;
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = li.getSelectionIndex();
                AssistantPopup.this.select(si);
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AssistantPopup.this.selectThisOne();
            }
        });
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && (e.character != '\n' && e.character != '\r' || e.stateMask != 0)) {
                    AssistantPopup.this.refreshList();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AssistantPopup.this.selectNext();
                    e.doit = false;
                } else if (e.keyCode == 0x1000001) {
                    AssistantPopup.this.selectPrev();
                    e.doit = false;
                } else if ((e.character == '\n' || e.character == '\r') && e.stateMask == 0) {
                    AssistantPopup.this.selectThisOne();
                }
            }
        });
        this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && (e.character != '\n' && e.character != '\r' || e.stateMask != 0)) {
                    AssistantPopup.this.refreshList();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AssistantPopup.this.selectNext();
                    e.doit = false;
                } else if (e.keyCode == 0x1000001) {
                    AssistantPopup.this.selectPrev();
                    e.doit = false;
                } else if ((e.character == '\n' || e.character == '\r') && e.stateMask == 0) {
                    AssistantPopup.this.selectThisOne();
                }
            }
        });
        this.setPopupSizeX(w);
        this.setPopupSizeY(250);
        shell.pack();
        this.list.setFocus();
        return shell;
    }

    private void selectNext() {
        if (this.list != null && !this.list.isDisposed()) {
            int newI;
            int index = this.list.getSelectionIndex();
            int size = this.list.getItemCount();
            if ((newI = ++index) > size - 1) {
                newI = 0;
            }
            this.select(newI);
        }
    }

    private void selectPrev() {
        if (this.list != null && !this.list.isDisposed()) {
            int newI;
            int index = this.list.getSelectionIndex();
            int size = this.list.getItemCount();
            if ((newI = --index) < 0) {
                newI = size - 1;
            }
            this.select(newI);
        }
    }

    private void select(int si) {
        this.list.select(si);
        this.list.showSelection();
        String info = "";
        if (si >= 0) {
            List o = (List)this.list.getData();
            AssistantProposition a = (AssistantProposition)o.get(si);
            info = a.getDescription().replaceAll("&nbsp;", " ");
        }
        this.txtDescription.setText(info);
    }

    private void selectThisOne() {
        List o = (List)this.list.getData();
        AssistantProposition a = (AssistantProposition)o.get(this.list.getSelectionIndex());
        this.selectElement(a);
        this.hidePopupWindow();
    }

    protected abstract void selectElement(AssistantProposition<P> var1);

    @Override
    public void openPopupWindow() {
        this.setIntialText();
        super.openPopupWindow();
    }

    @Override
    protected Control getPopupFirstFocusControl() {
        if (StringUtils.isNotBlank((String)this.txtSearch.getText())) {
            return this.txtFilter.getControl();
        }
        return this.txtSearch.getControl();
    }

    private void setIntialText() {
        String s = this.getOpenText();
        if (StringUtils.isEmpty((String)s)) {
            if (this.txtSearch != null && !this.txtSearch.isDisposed()) {
                this.txtSearch.setText("");
            }
        } else if (this.txtSearch != null && !this.txtSearch.isDisposed()) {
            this.txtSearch.setText(s);
        }
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            this.txtFilter.setText("");
        }
    }

    private void refreshList() {
        String word = "";
        String filter = "";
        if (this.txtSearch != null && !this.txtSearch.isDisposed()) {
            word = this.txtSearch.getText();
        }
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            filter = this.txtFilter.getText();
        }
        List<AssistantProposition<P>> list = this.proposer.getList(word);
        this.actualPropositionList = new ArrayList<AssistantProposition<P>>();
        this.actualPropositionList.addAll(list);
        if (StringUtils.isNotBlank((String)filter) && !this.actualPropositionList.isEmpty()) {
            list = this.filter(list, filter);
        }
        if (list.isEmpty() && this.actualPropositionList.isEmpty()) {
            list.add(this.nullAssistantProposition);
        } else if (list.isEmpty()) {
            System.out.println("SET FILTER TO " + filter);
            this.nullAssistantPropsitionFilter.setFilterText(filter);
            list.add(this.nullAssistantPropsitionFilter);
        }
        this.list.removeAll();
        this.list.setData(list);
        for (AssistantProposition<P> a : list) {
            TableItem item = new TableItem(this.list, 16384);
            item.setText(a.getName());
            if (a.getBgColor() == null) continue;
            Color color = ResourceGetter.getColor((RGB)a.getBgColor());
            item.setBackground(color);
        }
        this.select(0);
    }

    private List<AssistantProposition<P>> filter(List<AssistantProposition<P>> list, String filter) {
        ArrayList<AssistantProposition<P>> filterList = new ArrayList<AssistantProposition<P>>();
        for (AssistantProposition<P> ap : list) {
            if ((ap.getName() == null || !StringUtils.NormalizeToLowercase((String)ap.getName()).contains(StringUtils.NormalizeToLowercase((String)filter))) && (ap.getDescription() == null || !StringUtils.NormalizeToLowercase((String)ap.getDescription()).contains(StringUtils.NormalizeToLowercase((String)filter)))) continue;
            filterList.add(ap);
        }
        return filterList;
    }

    @Override
    protected void refreshPopup() {
        this.refreshList();
    }

    private void setControlListner() {
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 32 && event.stateMask == 262144) {
                    if (AssistantPopup.this.getPopup() != null && !AssistantPopup.this.getPopup().isDisposed() && AssistantPopup.this.getPopup().isVisible()) {
                        AssistantPopup.this.refreshPopup();
                    } else {
                        AssistantPopup.this.openPopupWindow();
                    }
                }
            }
        });
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (UI.rightClick((MouseEvent)e)) {
                    if (AssistantPopup.this.getPopup() != null && !AssistantPopup.this.getPopup().isDisposed() && AssistantPopup.this.getPopup().isVisible()) {
                        AssistantPopup.this.refreshPopup();
                    } else {
                        AssistantPopup.this.openPopupWindow();
                    }
                }
            }
        });
    }

    private int getBaseControlWidth() {
        int w = 0;
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            w = this.getControl().getSize().x - 6;
        }
        w = Math.max(300, w);
        w = Math.min(900, w);
        return w;
    }

    protected String getOpenText() {
        return "";
    }

    @Override
    protected Point computePopupLocation(Control control) {
        int x;
        int y;
        Display display = control.getDisplay();
        Rectangle displayBounds = display.getBounds();
        int displayX2 = displayBounds.x + displayBounds.width;
        if (this.showPopupDown) {
            int height = control.getBounds().height;
            if (control instanceof StyledText) {
                StyledText st = (StyledText)control;
                Point offset = st.getLocationAtOffset(st.getCaretOffset());
                height = offset.y + st.getLineHeight() + 5;
            }
            y = control.getBounds().y + height;
            x = control.getBounds().x;
            if (UI.OS_CARBON || UI.OS_COCOA) {
                if (control instanceof Button) {
                    x += 6;
                    y -= 7;
                } else {
                    ++x;
                    y += 0;
                }
            }
        } else {
            int popupHeight = this.popup.getBounds().height;
            y = control.getBounds().y - popupHeight;
            x = control.getBounds().x;
        }
        Point point = control.getParent().toDisplay(x, y);
        int popupWidth = this.popup.getBounds().width;
        if (point.x + popupWidth > displayX2) {
            point.x = displayX2 - popupWidth;
        }
        return point;
    }
}

