/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MaskedText
extends Canvas {
    private static final Logger logger = Logger.getLogger(MaskedText.class.getName());
    public static final int VALID_NOT = Integer.parseInt("00000000", 2);
    public static final int VALID_WITH_COLOR = Integer.parseInt("00000001", 2);
    public static final int VALID_WITH_MSGBOX = Integer.parseInt("00000010", 2);
    public static final int VALID_WITH_ALL = Integer.parseInt("00000011", 2);
    public static final int VALID_NOT_FIELD_EMPTY = Integer.parseInt("00000100", 2);
    public static final int VALID_FIELD_MUST_BE_COMPLETE = Integer.parseInt("00001000", 2);
    public static final int CASE_NORMAL = 0;
    public static final int CASE_UPPER = 1;
    public static final int CASE_UPPER_NO_PUNCTUATION = 3;
    public static final int CASE_LOWER = 4;
    private int validationType;
    private int caseType;
    protected Text myText;
    private boolean fromMe;
    public Color ennabledColor = ResourceGetter.getColor((int)224, (int)224, (int)224);
    private Color red = ResourceGetter.getColor((int)255, (int)0, (int)0);
    public int validationStatus = 0;
    private int oldposition;
    private int tempposition;
    private int positionToAdd;
    protected String mask;
    private ArrayList<String> listCharMask;
    private ArrayList<String> listPositionMask;
    private boolean keyField = false;
    private String errorValidationMsg = null;
    private String textValue = "";
    protected TextChangeListener listener;
    private boolean forLastChar;
    private PredicateA<String> predicate;

    public static String removeAccent(String s) {
        s = s.replaceAll("[\u00c0\u00c2]", "A");
        s = s.replaceAll("[\u00c9\u00c8\u00ca\u00cb]", "E");
        s = s.replaceAll("[\u00ce\u00cf]", "I");
        s = s.replaceAll("[\u00d6\u00d4]", "O");
        s = s.replaceAll("[\u00d9]", "U");
        s = s.replaceAll("[\u00c7]", "C");
        return s;
    }

    public static MaskedText getInstance(Composite parent, int style, String mask, int validType, int caseType) {
        return new MaskedText(parent, style, mask, validType, caseType);
    }

    public static String toLength(char theMaskChar, int lengthOfMask) {
        char[] s = new char[lengthOfMask];
        Arrays.fill(s, theMaskChar);
        return String.valueOf(s);
    }

    public MaskedText(Composite parent, int style, String mask) {
        this(parent, style, mask, VALID_WITH_COLOR | VALID_FIELD_MUST_BE_COMPLETE | VALID_NOT_FIELD_EMPTY, 0);
    }

    public MaskedText(Composite parent, int style, String mask, int validType, int caseType) {
        super(parent, 0);
        this.validationType = validType;
        this.caseType = caseType;
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        this.myText = new Text((Composite)this, style);
        this.myText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)MaskedText.this.ennabledColor);
                ResourceGetter.dispose((Object)MaskedText.this.red);
            }
        });
        this.myText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int textLimit = ((Text)e.widget).getTextLimit();
                if (textLimit != -1 && ((Text)e.widget).getText().length() > textLimit) {
                    ((Text)e.widget).setText(((Text)e.widget).getText().substring(0, textLimit));
                }
            }
        });
        if (!LibPlugin.ON_LINUX) {
            this.listener = new TextChangeListener();
            this.addListeners();
        } else {
            this.myText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    MaskedText.this.verifLinux(e);
                }
            });
            this.myText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MaskedText.this.modifLinux(e);
                }
            });
        }
        FillLayout layout = new FillLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        this.setLayout((Layout)layout);
        this.setMask(mask);
    }

    private String deletePunctuation(String chaine) {
        return MaskedText.removeAccent(chaine.toUpperCase());
    }

    private int getNbAfterChar(int position) {
        int nb = 0;
        int i = position;
        while (i < this.mask.length()) {
            if (this.mask.charAt(i) != '!' && this.mask.charAt(i) != '#' && this.mask.charAt(i) != 'A' && this.mask.charAt(i) != '9') {
                ++nb;
            } else {
                i = this.mask.length();
            }
            ++i;
        }
        return nb;
    }

    private int getNbBeforeChar(int position, boolean justBefore) {
        int nb = 0;
        if (--position < this.mask.length()) {
            int i = position;
            while (i >= 0) {
                if (this.mask.charAt(i) != '!' && this.mask.charAt(i) != '#' && this.mask.charAt(i) != 'A' && this.mask.charAt(i) != '9') {
                    ++nb;
                } else if (justBefore) break;
                --i;
            }
        }
        return nb;
    }

    private void modifLinux(ModifyEvent e) {
        if (!this.fromMe && !this.forLastChar) {
            this.setFromMe(true);
            int selection = this.myText.getSelection().x;
            if (this.caseType == 1) {
                this.myText.setText(this.myText.getText().toUpperCase());
            } else if (this.caseType == 4) {
                this.myText.setText(this.myText.getText().toLowerCase());
            } else if (this.caseType == 3) {
                this.myText.setText(this.deletePunctuation(this.myText.getText()));
            } else if (this.caseType == 0) {
                this.myText.setText(this.myText.getText());
            }
            this.myText.setSelection(selection);
            this.setFromMe(false);
        }
    }

    private String removeMaskCharTo(String text) {
        for (String next : this.listCharMask) {
            if (text.indexOf(next) == -1) continue;
            text = text.replace(next.charAt(0), '~');
            text = text.replaceAll("~", "");
        }
        return text;
    }

    private String setMaskToThis(String text) {
        StringBuilder newText = new StringBuilder(text);
        int i = 0;
        while (i < this.mask.length()) {
            if (i >= newText.length()) break;
            switch (this.mask.charAt(i)) {
                case '!': 
                case '#': 
                case '9': 
                case 'A': {
                    break;
                }
                default: {
                    newText.insert(i, this.mask.charAt(i));
                }
            }
            ++i;
        }
        return newText.toString();
    }

    private boolean validThisTextWithMask(String text) {
        if (this.mask.length() == 0) {
            return true;
        }
        boolean valid = true;
        if (text.length() > this.mask.length()) {
            valid = false;
        }
        int i = 0;
        while (i < text.length() && valid) {
            switch (this.mask.charAt(i)) {
                case 'A': {
                    valid = this.alphaKeyPressed(text.charAt(i));
                    break;
                }
                case '9': {
                    valid = this.numKeyPressed(text.charAt(i));
                    break;
                }
                case '!': {
                    valid = this.allKeyPressed(text.charAt(i));
                    break;
                }
                case '#': {
                    valid = this.alphaNumKeyPressed(text.charAt(i));
                    break;
                }
                default: {
                    valid = text.charAt(i) == this.mask.charAt(i);
                }
            }
            ++i;
        }
        return valid;
    }

    private void verifLinux(VerifyEvent e) {
        if (!this.fromMe && !this.forLastChar && e.text != null) {
            String newText = new StringBuilder(this.myText.getText()).replace(this.myText.getSelection().x, this.myText.getSelection().y, e.text).toString();
            e.doit = this.validThisTextWithMask(newText.toLowerCase());
        }
    }

    protected boolean allKeyPressed(char eventchar) {
        boolean ret = true;
        if (this.listCharMask.contains(String.valueOf(eventchar))) {
            ret = false;
        }
        return ret;
    }

    protected boolean alphaKeyPressed(char eventchar) {
        boolean ret = true;
        if (eventchar < 'a' || eventchar > 'z') {
            ret = false;
        }
        return ret;
    }

    protected boolean alphaNumKeyPressed(char eventchar) {
        boolean ret = true;
        return ret;
    }

    protected void focusOutEvent() {
        boolean valid_not;
        boolean bl = valid_not = this.validationType != VALID_NOT || this.mask.length() == 0;
        if (!valid_not) {
            boolean valide;
            boolean valid_with_color;
            this.validationStatus = 3;
            String binary = StringUtils.padLeft((String)Integer.toString(this.validationType, 2), (int)8, (char)'0');
            boolean valid_field_must_be_complete = binary.charAt(4) == '1';
            boolean valid_not_field_empty = binary.charAt(5) == '1';
            boolean bl2 = valid_with_color = binary.charAt(7) == '1';
            if (valid_not_field_empty && this.myText.getText().length() == 0) {
                valide = true;
                System.out.println("valid_not_field_empty");
            } else if (valid_field_must_be_complete && this.myText.getText().length() != this.mask.length()) {
                valide = false;
                System.out.println("valid_field_must_be_complete");
            } else {
                valide = this.isValid();
            }
            if (valide) {
                if (valid_with_color) {
                    this.myText.setForeground(null);
                }
            } else if (valid_with_color) {
                this.myText.setForeground(this.red);
            }
            this.validationStatus = valide ? 1 : 2;
        }
        this.myText.setSelection(0, 0);
    }

    protected final ArrayList<String> getListCharMask() {
        return this.listCharMask;
    }

    protected boolean isDataValid() {
        return true;
    }

    protected boolean isValid() {
        String text = this.myText.getText();
        String lowerText = text.toLowerCase();
        int length = text.length();
        boolean valide = true;
        int i = 0;
        while (i < length) {
            switch (this.mask.charAt(i)) {
                case 'A': {
                    char currentChar = lowerText.charAt(i);
                    if (currentChar >= 'a' && currentChar <= 'z') break;
                    valide = false;
                    i = length;
                    break;
                }
                case '9': {
                    if (text.charAt(i) >= '0' && text.charAt(i) <= '9') break;
                    valide = false;
                    i = length;
                    break;
                }
                case '!': {
                    if (!this.listCharMask.contains(String.valueOf(text.charAt(i)))) break;
                    valide = false;
                    i = length;
                    break;
                }
            }
            ++i;
        }
        if (valide) {
            valide = this.isDataValid();
        }
        if (valide) {
            this.textValue = text;
            this.validationStatus = 1;
        } else {
            this.textValue = "";
            this.validationStatus = 2;
        }
        return valide;
    }

    protected void modifieEvent() {
        if (this.caseType == 1) {
            this.setText(this.myText.getText().toUpperCase());
        } else if (this.caseType == 4) {
            this.setText(this.myText.getText().toLowerCase());
        } else if (this.caseType == 3) {
            this.setText(this.deletePunctuation(this.myText.getText()));
        } else if (this.caseType == 0) {
            this.setText(this.myText.getText());
        }
        if (this.mask.length() != 0) {
            int nbMove = 0;
            if (this.positionToAdd == -1) {
                nbMove = 0 - this.getNbBeforeChar(this.oldposition, true);
                this.myText.setSelection(this.oldposition + nbMove + this.positionToAdd);
            } else if (this.positionToAdd == 1) {
                nbMove = this.getNbBeforeChar(this.oldposition + this.positionToAdd, false);
                this.myText.setSelection(this.tempposition + (nbMove += this.getNbAfterChar(this.oldposition + this.positionToAdd)) + this.positionToAdd);
            } else {
                this.myText.setSelection(this.oldposition);
            }
            if (this.myText.getText().trim().length() == this.mask.length() && this.myText.getCaretPosition() == this.mask.length()) {
                this.myText.traverse(16);
            }
        }
    }

    protected boolean numKeyPressed(char eventchar) {
        boolean ret = true;
        if (eventchar < '0' || eventchar > '9') {
            ret = false;
        }
        return ret;
    }

    protected void verifieEvent(Event event) {
        if (event.character == '\u0000') {
            int selectionBase = this.myText.getSelection().x;
            String newText = new StringBuilder(this.myText.getText()).replace(this.myText.getSelection().x, this.myText.getSelection().y, event.text).toString();
            if (this.validThisTextWithMask(newText.toLowerCase())) {
                this.setFromMe(true);
                if (this.caseType == 1) {
                    this.myText.setText(newText.toUpperCase());
                } else if (this.caseType == 4) {
                    this.myText.setText(newText.toLowerCase());
                } else if (this.caseType == 3) {
                    this.myText.setText(this.deletePunctuation(newText));
                } else if (this.caseType == 0) {
                    this.myText.setText(newText);
                }
                this.myText.setSelection(selectionBase + event.text.length());
                this.setFromMe(false);
            } else {
                newText = this.removeMaskCharTo(newText);
                if (this.validThisTextWithMask((newText = this.setMaskToThis(newText)).toLowerCase())) {
                    this.setFromMe(true);
                    int selectionToPut = this.setMaskToThis(this.removeMaskCharTo(String.valueOf(this.myText.getText().substring(0, this.myText.getSelection().x)) + event.text)).length();
                    if (this.caseType == 1) {
                        this.myText.setText(newText.toUpperCase());
                    } else if (this.caseType == 4) {
                        this.myText.setText(newText.toLowerCase());
                    } else if (this.caseType == 3) {
                        this.myText.setText(this.deletePunctuation(newText));
                    } else if (this.caseType == 0) {
                        this.myText.setText(newText);
                    }
                    this.myText.setSelection(selectionToPut);
                    this.setFromMe(false);
                }
            }
            event.doit = false;
        } else {
            if (this.mask.length() == 0) {
                return;
            }
            if (event.character == '\b') {
                this.positionToAdd = this.myText.getSelection().x == this.myText.getSelection().y ? -1 : 0;
            } else if (event.character == '\u007f') {
                this.positionToAdd = 0;
            } else if (this.myText.getText().length() != this.mask.length() || this.myText.getSelection().x != this.myText.getSelection().y) {
                int i = this.myText.getSelection().x;
                while (i < this.mask.length()) {
                    char eventchar = String.valueOf(event.character).toLowerCase().charAt(0);
                    switch (this.mask.charAt(i)) {
                        case 'A': {
                            if (!this.alphaKeyPressed(eventchar)) {
                                event.doit = false;
                                break;
                            }
                            i = this.mask.length();
                            this.positionToAdd = 1;
                            break;
                        }
                        case '9': {
                            if (!this.numKeyPressed(eventchar)) {
                                event.doit = false;
                                break;
                            }
                            i = this.mask.length();
                            this.positionToAdd = 1;
                            break;
                        }
                        case '!': {
                            if (!this.allKeyPressed(eventchar)) {
                                event.doit = false;
                                break;
                            }
                            i = this.mask.length();
                            this.positionToAdd = 1;
                            break;
                        }
                        case '#': {
                            if (!this.alphaNumKeyPressed(eventchar)) {
                                event.doit = false;
                                break;
                            }
                            i = this.mask.length();
                            this.positionToAdd = 1;
                        }
                    }
                    ++i;
                }
            } else {
                event.doit = false;
            }
            if (event.doit) {
                event.doit = this.validate(this.getText());
            }
            if (event.doit) {
                this.oldposition = this.myText.getSelection().x;
                int oldpositionY = this.myText.getSelection().y;
                this.tempposition = this.oldposition - this.getNbBeforeChar(this.oldposition, false);
                this.setFromMe(true);
                this.myText.setText(this.getText());
                this.setFromMe(false);
                this.myText.setSelection(this.tempposition, oldpositionY - this.getNbBeforeChar(oldpositionY, false));
            }
        }
    }

    public void addKeyListener(KeyListener kl) {
        this.myText.addKeyListener(kl);
    }

    public void addListeners() {
        this.myText.addListener(24, (Listener)this.listener);
        this.myText.addListener(25, (Listener)this.listener);
        this.myText.addListener(16, (Listener)this.listener);
        this.myText.addListener(15, (Listener)this.listener);
        this.addMyKeyListener();
    }

    public void addModifyListener(ModifyListener ml) {
        this.myText.addModifyListener(ml);
    }

    public void addMyKeyListener() {
        this.myText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent ke) {
                int pos;
                if (MaskedText.this.mask.length() == 0) {
                    return;
                }
                int n = pos = MaskedText.this.myText.getSelection().x < MaskedText.this.mask.length() ? MaskedText.this.myText.getSelection().x : MaskedText.this.mask.length() - 1;
                if (MaskedText.this.mask.charAt(pos) == '9') {
                    if (ke.character == '+') {
                        ke.doit = false;
                        ((Text)ke.getSource()).traverse(16);
                    } else if (ke.character == '-') {
                        ke.doit = false;
                        ((Text)ke.getSource()).traverse(8);
                    }
                }
            }
        });
    }

    private boolean validate(String text) {
        return this.predicate == null || this.predicate.evaluate((Object)text);
    }

    public void addMyTraverseListener() {
        this.myText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 32) {
                    event.doit = false;
                } else if (event.detail == 64) {
                    event.detail = 64;
                    event.doit = false;
                }
            }
        });
    }

    public void addVerifyListener(VerifyListener vl) {
        this.myText.addVerifyListener(vl);
    }

    public Control getControl() {
        return this.myText;
    }

    public final String getErrorValidationMsg() {
        return this.errorValidationMsg;
    }

    public boolean getFromMe() {
        return this.fromMe;
    }

    public String getMask() {
        return this.mask;
    }

    public String getText() {
        Iterator<String> i = this.listCharMask.iterator();
        String tempText = this.myText.getText();
        while (i.hasNext()) {
            String next = i.next();
            if (tempText.indexOf(next) == -1) continue;
            tempText = tempText.replace(next.charAt(0), '~');
            tempText = tempText.replaceAll("~", "");
        }
        return tempText;
    }

    public boolean getVisible() {
        return this.myText.getVisible();
    }

    public boolean isKeyField() {
        return this.keyField;
    }

    public void removeListeners() {
        this.myText.removeListener(24, (Listener)this.listener);
        this.myText.removeListener(25, (Listener)this.listener);
        this.myText.removeListener(16, (Listener)this.listener);
        this.myText.removeListener(15, (Listener)this.listener);
    }

    public void setEnabled(boolean value) {
        if (value) {
            this.myText.setBackground(null);
        } else {
            this.myText.setBackground(this.ennabledColor);
        }
        this.myText.setEnabled(value);
        super.setEnabled(value);
    }

    public final void setErrorValidationMsg(String errorValidation) {
        this.errorValidationMsg = errorValidation;
    }

    public void setFont(Font font) {
        this.myText.setFont(font);
    }

    public void setFromMe(boolean value) {
        this.fromMe = value;
        this.myText.setData("fromMe", (Object)value);
    }

    public void setKeyField(boolean b) {
        this.keyField = b;
    }

    public void setMask(String mask) {
        if (mask == null) {
            throw new NullPointerException("mask");
        }
        this.mask = mask;
        this.listCharMask = new ArrayList();
        this.listPositionMask = new ArrayList();
        int i = 0;
        while (i < mask.length()) {
            if (mask.charAt(i) != '!' && mask.charAt(i) != '#' && mask.charAt(i) != 'A' && mask.charAt(i) != '9') {
                if (!this.listCharMask.contains(String.valueOf(mask.charAt(i)))) {
                    this.listCharMask.add(String.valueOf(mask.charAt(i)));
                }
                this.listPositionMask.add(String.valueOf(i));
            }
            ++i;
        }
    }

    public void setText(String bdText) {
        if (bdText == null) {
            bdText = "";
        }
        if (!this.validate(bdText)) {
            return;
        }
        this.myText.setForeground(null);
        String tempText = "";
        int j = 0;
        int i = 0;
        while (i < this.mask.length() && j < bdText.length()) {
            if (this.listPositionMask.contains(String.valueOf(i)) && this.mask.charAt(i) != bdText.charAt(j)) {
                tempText = String.valueOf(tempText) + this.mask.charAt(i);
            } else {
                tempText = String.valueOf(tempText) + bdText.charAt(j);
                ++j;
            }
            ++i;
        }
        this.setFromMe(true);
        int caretOffset = this.myText.getCaretPosition();
        this.myText.setText(tempText);
        caretOffset = tempText == null ? 0 : (tempText.length() < caretOffset ? tempText.length() : caretOffset);
        this.myText.setSelection(caretOffset);
        this.setFromMe(false);
        if (tempText.length() == this.mask.length()) {
            Event event = new Event();
            event.widget = this.myText;
            this.forLastChar = true;
            this.myText.notifyListeners(24, event);
            this.forLastChar = false;
        }
        if (!tempText.equals(this.textValue)) {
            this.textValue = "";
            this.validationStatus = 0;
        }
    }

    public void setTextLimit(int limit) {
        this.myText.setTextLimit(limit);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.myText.setVisible(visible);
    }

    public PredicateA<String> getPredicate() {
        return this.predicate;
    }

    public void setPredicate(PredicateA<String> predicate) {
        this.predicate = predicate;
    }

    private class TextChangeListener
    implements Listener {
        private boolean isSingleChar = true;

        private TextChangeListener() {
        }

        public void handleEvent(Event event) {
            if (!MaskedText.this.fromMe && !MaskedText.this.forLastChar) {
                if (event.type == 25) {
                    this.isSingleChar = event.text.length() < 2;
                    MaskedText.this.verifieEvent(event);
                } else if (event.type == 24) {
                    if (this.isSingleChar) {
                        MaskedText.this.modifieEvent();
                    }
                } else if (event.type == 16) {
                    if (MaskedText.this.validationStatus == 3) {
                        return;
                    }
                    MaskedText.this.focusOutEvent();
                    MaskedText.this.myText.setBackground(null);
                } else if (event.type == 15) {
                    MaskedText.this.myText.selectAll();
                }
            }
        }
    }
}

