/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class LoadingDialog {
    private static final String ANNULER = Messages.getString((String)"LoadingDialog.ANNULER", (String[])new String[0]);
    private static final String CHARGEMENT = Messages.getString((String)"LoadingDialog.CHARGEMENT", (String[])new String[0]);
    private static final String READING_DATA = Messages.getString((String)"LoadingDialog.READING_DATA", (String[])new String[0]);
    protected Shell shell;
    protected Color white;
    protected static Timer time;
    protected static TimerTask task;
    protected static Label lblNote;
    protected static ProgressBar bar;
    protected static int progression;
    private static boolean flashIt;
    static boolean cancelled;
    private String titre = "";
    protected Display display = Display.getDefault();
    private boolean showCancelButton;
    static boolean mustRestartAtZero;

    static {
        progression = 0;
        flashIt = false;
        cancelled = false;
        mustRestartAtZero = true;
    }

    public LoadingDialog(String titre) {
        this(titre, false);
    }

    public LoadingDialog(String titre, boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
        cancelled = false;
        progression = 0;
        this.titre = titre;
    }

    public LoadingDialog(final Shell parent) {
        cancelled = false;
        progression = 0;
        if (parent != null && !parent.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoadingDialog.this.start(parent, 2);
                }
            });
        }
    }

    public LoadingDialog(String titre, final Shell parent, final int progressBarStyle) {
        this.titre = titre;
        cancelled = false;
        mustRestartAtZero = true;
        progression = 0;
        if (parent != null && !parent.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoadingDialog.this.start(parent, progressBarStyle);
                }
            });
        }
    }

    public LoadingDialog(final Shell parent, final int progressBarStyle) {
        cancelled = false;
        progression = 0;
        if (parent != null && !parent.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoadingDialog.this.start(parent, progressBarStyle);
                }
            });
        }
    }

    public void start(Shell parent, int progressBarStyle) {
        this.shell = new Shell(parent, 65536);
        this.shell.setText(this.titre.length() == 0 ? CHARGEMENT : this.titre);
        this.shell.setLayout((Layout)new FormLayout());
        bar = new ProgressBar((Composite)this.shell, progressBarStyle);
        lblNote = new Label((Composite)this.shell, 0);
        this.white = new Color((Device)this.display, 255, 255, 255);
        bar.setBackground(this.white);
        lblNote.setText(this.titre.length() == 0 ? READING_DATA : this.titre);
        lblNote.setBackground(this.white);
        Button btnCancel = null;
        if (this.showCancelButton) {
            btnCancel = new Button((Composite)this.shell, 8);
            btnCancel.setText(ANNULER);
            btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    cancelled = true;
                }
            });
        }
        this.shell.setBackground(this.white);
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawRectangle(0, 0, LoadingDialog.this.shell.getSize().x, LoadingDialog.this.shell.getSize().y);
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoadingDialog.this.white.dispose();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 50);
        data.right = !this.showCancelButton ? new FormAttachment(100, -50) : new FormAttachment((Control)btnCancel, -5);
        data.top = new FormAttachment(0, 17);
        bar.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 50);
        data.right = !this.showCancelButton ? new FormAttachment(100, -50) : new FormAttachment((Control)btnCancel, -5);
        data.top = new FormAttachment((Control)bar, 3);
        lblNote.setLayoutData((Object)data);
        if (this.showCancelButton && btnCancel != null) {
            data = new FormData();
            data.right = new FormAttachment(100, -50);
            data.top = new FormAttachment(0, 17);
            btnCancel.setLayoutData((Object)data);
        }
        this.shell.pack();
        this.shell.setSize(400, 60);
        this.shell.setLocation(parent.getLocation().x + (parent.getSize().x - this.shell.getSize().x) / 2, parent.getLocation().y + (parent.getSize().y - this.shell.getSize().y) / 2);
        this.shell.open();
    }

    public void start(Shell parent) {
        this.start(parent, 2);
    }

    public static void flashNote() {
        LoadingDialog.setFlashIt(true);
        task = new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (lblNote != null && !lblNote.isDisposed()) {
                            if (LoadingDialog.isFlashIt()) {
                                lblNote.setVisible(!lblNote.getVisible());
                            } else {
                                time.cancel();
                                lblNote.setVisible(true);
                            }
                        }
                    }
                });
            }
        };
        time = new Timer();
        time.scheduleAtFixedRate(task, 210L, 200L);
    }

    public static void setNote(final String note) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (lblNote != null && !lblNote.isDisposed()) {
                    lblNote.setText(note);
                }
            }
        });
    }

    public static void setNoteProgression() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (lblNote != null && !lblNote.isDisposed()) {
                    String s = lblNote.getText();
                    if (s.length() > 50) {
                        s = "";
                    }
                    lblNote.setText(String.valueOf(s) + ".");
                }
            }
        });
    }

    public static void setBarMaxMin(int max, int min) {
        bar.setMaximum(max);
        bar.setMinimum(min);
    }

    public static final void setMustRestartAtZero(boolean mustRestartAtZero) {
        LoadingDialog.mustRestartAtZero = mustRestartAtZero;
    }

    public static void addProgression(int percent) {
        if ((progression += percent) > 99 && mustRestartAtZero) {
            progression = 1;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (bar != null && !bar.isDisposed()) {
                    bar.setSelection(progression);
                }
            }
        });
    }

    public static void setProgression(final int percent) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (bar != null && !bar.isDisposed()) {
                    bar.setSelection(percent);
                }
            }
        });
    }

    public void stop() {
        if (time != null) {
            time.cancel();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            bar = null;
            lblNote = null;
            this.shell.dispose();
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public static ProgressBar getBar() {
        return bar;
    }

    public static boolean isFlashIt() {
        return flashIt;
    }

    public static void setFlashIt(boolean flashIt) {
        LoadingDialog.flashIt = flashIt;
    }

    public static boolean isCancelled() {
        return cancelled;
    }
}

