/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FontAwareTable
extends Table
implements IRefreshFont {
    private int fontSizeIncrement = 0;
    private int fontStyle = 0;
    private int minWidth;
    private int minHeight;

    public FontAwareTable(Composite parent, int style, FormToolkit toolkit) {
        this(parent, style);
        this.setBackground(toolkit.getColors().getBackground());
    }

    public FontAwareTable(Composite parent, int style) {
        super(parent, style);
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }

    public void setFont(int fontSizeIncrement, int fontStyle) {
        this.fontSizeIncrement = fontSizeIncrement;
        this.fontStyle = fontStyle;
        this.setFont(ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle));
    }

    public void refreshFont() {
        this.setFont(this.fontSizeIncrement, this.fontStyle);
        FontAwareComposite.refreshFont(this.getChildren());
    }

    protected void checkSubclass() {
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = super.computeSize(wHint, hHint, changed);
        return new Point(Math.max(p.x, this.minWidth), Math.max(p.y, this.minHeight));
    }

    public Point computeSize(int wHint, int hHint) {
        Point p = super.computeSize(wHint, hHint);
        return new Point(Math.max(p.x, this.minWidth), Math.max(p.y, this.minHeight));
    }
}

