/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.SearchElementGroup;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.ISearchElement;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComboSelectedList
extends Composite {
    private MyCombo<ISearchElement> combo;
    private List<ISearchElement> elements = new ArrayList<ISearchElement>();
    private String name;
    private MyLabel label;

    public ComboSelectedList(Composite parent, FormToolkit toolkit, String name) {
        super(parent, 0);
        this.name = name;
        if (toolkit == null) {
            toolkit = UI.createToolKit((Widget)parent);
        }
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 4;
        this.setLayout((Layout)layout);
        toolkit.adapt((Composite)this);
        this.createPart(this, toolkit);
    }

    private void createPart(Composite parent, FormToolkit formToolkit) {
        System.out.println("NAME :: " + this.name);
        this.label = new MyLabel(parent, this.name, 0, formToolkit);
        this.combo = new MyCombo(parent, 0, formToolkit);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.label.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.label.getControl(), 3);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.combo.setLayoutData(data);
        this.combo.setLabelProvider(new ProviderAR<ISearchElement, String>(){

            public String get(ISearchElement object) {
                return object.getSearchName();
            }
        });
        this.combo.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                System.out.println("selection event");
                ISearchElement ise = (ISearchElement)ComboSelectedList.this.combo.getSelection();
                if (ise != null) {
                    ComboSelectedList.this.removeSearchElement(ise);
                }
            }
        });
    }

    private void removeSearchElement(ISearchElement ise) {
        this.elements.remove(ise);
        this.combo.removeAll();
        this.combo.setItems(this.elements);
        this.setLabelText();
    }

    public void addSearchElement(ISearchElement ise) {
        this.elements.add(ise);
        this.combo.removeAll();
        this.combo.setItems(this.elements);
        this.setLabelText();
    }

    private void setLabelText() {
        this.label.setText(String.valueOf(this.name) + (this.elements.size() > 0 ? " (" + this.elements.size() + ")" : ""));
        this.getParent().layout(true, true);
    }

    public SearchElementGroup getElements() {
        return new SearchElementGroup(this.elements);
    }
}

