/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator2;
import ca.infodata.ofys.ui.controls.BaseSwitchTable;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class BaseSectionSwitchTable<E extends EditableDataObject>
extends FontAwareComposite {
    private FontAwareSection section;
    private BaseSwitchTable<E> switchTable;
    private boolean switchTableDirty;
    private IBaseEditor2 parentEditor;
    protected FormToolkit toolkit;
    private String internalSectionTitle = "";
    private int styleList;

    protected int getInternalSectionStyle() {
        return 2;
    }

    protected String getInternalSectionTitle() {
        return this.internalSectionTitle;
    }

    public void setInternalSectionTitle(String internalSectionTitle) {
        this.internalSectionTitle = internalSectionTitle;
    }

    public BaseSectionSwitchTable(Composite parent, IBaseEditor2 parentEditor, int styleList, FormToolkit toolkit) {
        this(parent, parentEditor, styleList, toolkit, false);
    }

    public BaseSectionSwitchTable(Composite parent, IBaseEditor2 parentEditor, int styleList, FormToolkit toolkit, boolean manualInit) {
        super(parent, 0);
        this.parentEditor = parentEditor;
        this.styleList = styleList;
        this.toolkit = toolkit;
        this.toolkit.adapt((Composite)this);
        if (!manualInit) {
            this.init();
        }
    }

    protected void init() {
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        this.setLayout((Layout)fillLayout);
        this.section = new FontAwareSection(this, this.getInternalSectionStyle(), this.toolkit);
        this.setInternalSectionTitle(this.getTitle());
        this.section.setText(this.getInternalSectionTitle());
        this.toolkit.createCompositeSeparator((Composite)this.section);
        final BaseSectionSwitchTable sectionSwitch = this;
        this.switchTable = new BaseSwitchTable<E>((Composite)this.section, this.parentEditor, this.styleList, this.toolkit, true){

            @Override
            protected void createEditionControl(Composite parent) {
                sectionSwitch.createEditionControl(parent);
            }

            @Override
            protected E initializeNewDataObject() {
                return sectionSwitch.initializeNewDataObject();
            }

            @Override
            protected void showDataObject(E selection) {
                sectionSwitch.showDataObject(selection);
            }

            @Override
            protected void leaveEditionMode() {
                BaseSectionSwitchTable.this.switchTableDirty = false;
            }

            @Override
            protected IPreValidator getPreValidatorNewInstance() {
                return sectionSwitch.getPreValidatorNewInstance();
            }

            @Override
            protected IPreValidator2<E> getPreValidatorNewInstance2() {
                return sectionSwitch.getPreValidatorNewInstance2();
            }

            @Override
            protected void switched() {
                BaseSectionSwitchTable.this.section.setExpanded(!BaseSectionSwitchTable.this.section.isExpanded());
                BaseSectionSwitchTable.this.section.setExpanded(!BaseSectionSwitchTable.this.section.isExpanded());
            }

            @Override
            protected boolean saving(E dataObject) {
                return sectionSwitch.saving(dataObject);
            }

            @Override
            protected boolean deleting(E dataObject) {
                return sectionSwitch.deleting(dataObject);
            }
        };
        this.switchTable.createControls();
        this.switchTable.addToolTipListener(new ListTable.IToolTipChanged(){

            @Override
            public void toolTipChanged(String toolTip) {
                BaseSectionSwitchTable.this.section.setToolTipText(toolTip);
            }
        });
        this.switchTable.addRowListener(new ListTable.IRowCountListener(){

            @Override
            public void rowCountChanged(int nbRow) {
                BaseSectionSwitchTable.this.setInternalSectionTitle(String.valueOf(BaseSectionSwitchTable.this.getTitle()) + " (" + nbRow + ")");
                BaseSectionSwitchTable.this.section.setText(BaseSectionSwitchTable.this.getInternalSectionTitle());
            }
        });
        this.section.setClient((Control)this.switchTable);
        this.section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                BaseSectionSwitchTable.this.setFirstFocus();
                if (e.getState()) {
                    if (Application.get().getGlobalInstances().getSession().getUser().getUserPreferences().getIsAdvancedUser() == 1 && BaseSectionSwitchTable.this.switchTable.getItemCount() == 0) {
                        BaseSectionSwitchTable.this.switchTable.getListTableSwitch().editNewItem();
                    }
                } else if (BaseSectionSwitchTable.this.switchTable.isInEdition()) {
                    if (BaseSectionSwitchTable.this.switchTableDirty) {
                        if (!BaseSectionSwitchTable.this.switchTable.getListTableSwitch().save()) {
                            BaseSectionSwitchTable.this.section.setExpanded(true);
                        }
                    } else {
                        BaseSectionSwitchTable.this.switchTable.getListTableSwitch().cancel();
                    }
                }
            }
        });
    }

    protected abstract void showDataObject(E var1);

    protected abstract E initializeNewDataObject();

    protected abstract void createEditionControl(Composite var1);

    protected abstract String getTitle();

    protected abstract void setFirstFocus();

    protected IPreValidator getPreValidatorNewInstance() {
        return null;
    }

    protected IPreValidator2<E> getPreValidatorNewInstance2() {
        return null;
    }

    public Table getTable() {
        return this.switchTable.getListTableSwitch().getTable();
    }

    public void setStatusList(IEditableDataObjectList<E> statusList) {
        if (statusList == null) {
            statusList = new EditableDataObjectList();
        }
        this.switchTable.setStatusList((IEditableDataObjectList<E>)statusList);
    }

    public void addTableModificationListener(ListTable.IListTableModificationListener<E> listener) {
        this.switchTable.getListTableSwitch().addTableModificationListener(listener);
    }

    public IBaseEditor2 getParentEditor() {
        return this.parentEditor;
    }

    public void setSectionExpanded(boolean status) {
        this.section.setExpanded(status);
    }

    public BaseSwitchTable<E> getSwitchTable() {
        return this.switchTable;
    }

    public IEditableDataObjectList<E> getStatusList() {
        return this.switchTable.getStatusList();
    }

    public void addColumn(int width) {
        this.switchTable.addColumn(width);
    }

    public void addColumn(int width, String title) {
        this.switchTable.addColumn(width, title);
    }

    public void refresh() {
        this.switchTable.refresh();
        this.parentEditor.checkDirty();
    }

    public void select(int index) {
        this.switchTable.select(index);
    }

    public boolean delete() {
        return this.switchTable.delete();
    }

    public ProviderAR<E, String[]> getLabelProvider() {
        return this.switchTable.getLabelProvider();
    }

    public void setLabelProvider(ProviderAR<E, String[]> labelProvider) {
        this.switchTable.setLabelProvider(labelProvider);
    }

    public Section getSection() {
        return this.section;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.switchTable.setEnabled(enabled);
        this.getSection().setEnabled(enabled);
    }

    public void setBtnDeleteEnabled(boolean enabled) {
        this.switchTable.setBtnDeleteEnabled(enabled);
    }

    public void addListSelectionChangeListener(SelectionListener listener) {
        this.switchTable.addListSelectionChangeListener(listener);
    }

    public E getFirstSelectedItem() {
        return this.switchTable.getFirstSelectedItem();
    }

    public PredicateA<E> getDisplayPredicate() {
        return this.switchTable.getDisplayPredicate();
    }

    public void setDisplayPredicate(PredicateA<E> displayPredicate) {
        this.switchTable.setDisplayPredicate(displayPredicate);
    }

    protected boolean saving(E dataObject) {
        return true;
    }

    protected boolean deleting(E dataObject) {
        return true;
    }

    public abstract class SwitchTableModifyListener
    extends EditorModifyListener {
        public SwitchTableModifyListener() {
            super(BaseSectionSwitchTable.this.parentEditor);
        }

        @Override
        public final void edited(Event e) {
            BaseSectionSwitchTable.this.switchTableDirty = true;
            this.sectionEdited(e);
        }

        public abstract void sectionEdited(Event var1);
    }
}

