/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.IWebController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.ui.browser.sonar.ActionResultComponentWrapper;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.IRenderEngine;
import ca.infodata.ofys.ui.browser.sonar.SonarRequest;
import ca.infodata.ofys.ui.browser.util.PlainRenderEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.PathMap;

public class SonarDispatcher {
    private static final Logger logger = Logger.getLogger(SonarDispatcher.class.getName());
    public static final String INSERTPARAM = "insert";
    public static final String CALLBACKPARAM = "cb";
    private static IRenderEngine renderer;
    private static SonarDispatcher sonar;
    private PathMap<Object> pathMap;

    private SonarDispatcher() {
    }

    public IRenderEngine getRenderer() {
        if (renderer == null) {
            renderer = new PlainRenderEngine();
        }
        return renderer;
    }

    public static synchronized void startSonar() {
        SonarDispatcher.getInstance();
    }

    public static SonarDispatcher getInstance() {
        if (sonar == null) {
            sonar = new SonarDispatcher();
        }
        return sonar;
    }

    public static IWebController getController(String target) {
        return SonarDispatcher.getInstance().getMatch((String)target).cloader.getCtrl();
    }

    public ViewConfig getMatch(String target) {
        if (this.pathMap == null) {
            return null;
        }
        PathMap.MappedEntry match = this.pathMap.getMatch(target);
        if (match == null) {
            return null;
        }
        ViewConfig config = new ViewConfig();
        config.cloader = (ComponentLoader)match.getValue();
        return config;
    }

    public String callback(IComponent elem, ViewConfig config) {
        String skin = elem.getSkin();
        if (skin != null && !skin.isEmpty()) {
            elem.getResponse().put("view", skin);
        }
        if (config.callback == null || config.callback.equals("")) {
            String string = config.callback = config.req.params.containsKey(CALLBACKPARAM) ? config.req.params.get(CALLBACKPARAM) : "";
        }
        if (config.req.params.containsKey(INSERTPARAM)) {
            String updateElement = config.req.params.get(INSERTPARAM);
            elem.getResponse().put("updateElement", updateElement);
        }
        String data = elem.getResponse().size() == 1 && elem.getResponse().containsKey("data") ? Application.get().getGsonProcessor().toJson(elem.getResponse().get("data")) : Application.get().getGsonProcessor().toJson(elem.getResponse());
        return data;
    }

    public void registerComponent(ComponentLoader c) {
        this.addComponent(c.getPattern(), c);
    }

    public void unregisterComponent(ComponentLoader c) {
        if (this.pathMap != null && this.pathMap.containsKey((Object)c.getPattern())) {
            this.pathMap.remove((Object)c.getPattern());
        }
    }

    private void addComponent(String pattern, ComponentLoader cloader) {
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        if (this.pathMap.containsKey((Object)pattern)) {
            throw new IllegalArgumentException("The Path " + pattern + "is already mapped");
        }
        if (cloader.getCtrl() == null) {
            throw new NullPointerException("Controller");
        }
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        this.pathMap.put(pattern, (Object)cloader);
    }

    public ViewConfig processQuery(ViewConfig config) {
        if (config.query == null || config.query.equals("")) {
            return config;
        }
        HashMap<String, String> tempParams = new HashMap<String, String>();
        if (config.query.contains("?")) {
            String[] temp = config.query.split("\\?");
            config.req.path = temp[0];
            String[] params = temp[1].split("&");
            int i = 0;
            while (i < params.length) {
                temp = params[i].split("=");
                if (temp.length > 1) {
                    tempParams.put(temp[0], temp[1]);
                }
                ++i;
            }
            config.req.params = tempParams;
        } else {
            config.req.path = config.query.trim();
            config.req.params = new HashMap<String, String>();
        }
        return config;
    }

    public String renderComponent(IComponent view, ViewConfig config) {
        try {
            this.getRenderer().setRoot(config.cloader);
            String res = config.partial != false ? this.getRenderer().getViewContent(view) : this.getRenderer().getViewPartialContent(view);
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SonarDispacter view resolve error", e);
            String errorPage = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><title>500</title></head><body><h1>Erreur 500</h1><p>Nous somme desol\u00e9, une erreur s'est produit. Essayer de redemarer le logiciel. Si le probl\u00e8me persistent contactez INFO-DATA.</p></body></html>";
            return errorPage;
        }
    }

    public String getView(ViewConfig config) {
        IComponent comp = this.getComponent(config);
        String res = this.renderComponent(comp, config);
        return res;
    }

    @Deprecated
    public String getViewPath(ViewConfig config) {
        return this.getRenderer().getView(this.getComponent(config));
    }

    @Deprecated
    public String getPartialPath(ViewConfig config) {
        IComponent component = this.getComponent(config);
        String res = this.getRenderer().getPartialView(component);
        return res;
    }

    public IComponent getComponent(ViewConfig config) {
        if (config.req.path == null) {
            this.processQuery(config);
        }
        try {
            ActionResult actionResult = config.cloader.getCtrl().getAction((IServerRequest)config.req);
            ActionResultComponentWrapper res = actionResult != null ? new ActionResultComponentWrapper(actionResult) : null;
            boolean commit = config.req.resolved;
            if (res == null) {
                if (config.req.response != null && !commit) {
                    config.req.response.sendError(400, "Ressource non trouv\u00e9e " + config.req.path);
                }
                return this.NotFound(config.req.path);
            }
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Request error 500 " + config.cloader.getComponentPath() + ": ", e);
            try {
                if (config.req.response != null) {
                    config.req.response.sendError(500, "Request error 500 " + config.req.path + ": " + e.getMessage());
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Request error 500 " + config.cloader.getComponentPath() + ": ", e);
            }
            return this.ErrorOccured(config.req.path);
        }
    }

    private IComponent NotFound(String uri) {
        ActionResultComponentWrapper res = new ActionResultComponentWrapper(new ActionResult("notFound400"));
        res.setSkin("<h1>Impossible de trouver les ressources demand\u00e9es.</h1><p>La requ\u00eate \"" + uri + "\" a produit une erreur</p>");
        return res;
    }

    private IComponent ErrorOccured(String uri) {
        ActionResultComponentWrapper res = new ActionResultComponentWrapper(new ActionResult("error500"));
        res.setSkin("<h1>Erreur lors du traitement de la requ\u00eate.</h1><p>La requ\u00eate \"" + uri + "\" a produit une erreur</p>");
        return res;
    }

    public void stopSonar() {
        this.getRenderer().dispose();
    }

    public class ViewConfig {
        public Boolean partial;
        public ComponentLoader cloader;
        public String callback;
        public String query;
        public Boolean async;
        public SonarRequest req = new SonarRequest();
    }
}

