/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.ui.browser.FileResource2;
import ca.infodata.ofys.ui.browser.InMemoryResource;
import ca.infodata.ofys.ui.browser.resource.BadResource;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.h2cache.BigDataEncryptedFileSystem;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class InMemoryResourceHandler
extends ResourceHandler {
    private static final Logger logger = Logger.getLogger(InMemoryResourceHandler.class.getName());
    private PathMap<Object> pathMap;
    private int maxCacheSize = 5;
    private final CopyOnWriteArrayList<String> cacheStack;
    private final ConcurrentHashMap<String, SoftReference<Object>> cache;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public InMemoryResourceHandler() {
        this.cache = new ConcurrentHashMap();
        this.cacheStack = new CopyOnWriteArrayList();
    }

    public void addResource(String pattern, Object data, boolean withH2Put) {
        if (data == null) {
            throw new NullPointerException("html");
        }
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        this.pathMap.put(pattern, null);
        if (data instanceof String || data instanceof byte[]) {
            this.cacheStack.add(pattern);
            this.cache.put(pattern, new SoftReference<Object>(data));
            if (this.cacheStack.size() >= this.maxCacheSize) {
                String pattern0 = this.cacheStack.get(0);
                this.cache.remove(pattern0);
                this.cacheStack.remove(0);
            }
            if (withH2Put) {
                LibPlugin.getDefault().getEncryptedFS().put(pattern, data);
            }
        }
    }

    public void remove(String pattern) {
        this.pathMap.remove((Object)pattern);
        this.cacheStack.remove(pattern);
        this.cache.remove(pattern);
        this.executor.execute(new RemoveTask(pattern));
    }

    public boolean hasResource(String path) {
        PathMap.MappedEntry match;
        if (this.pathMap != null && (match = this.pathMap.getMatch(path)) != null) {
            String pattern = match.getKey();
            if (this.getFromCache(pattern) != null) {
                return true;
            }
            if (LibPlugin.getDefault().getEncryptedFS().exists(pattern)) {
                return true;
            }
        }
        return false;
    }

    public Resource getResource(String path) throws MalformedURLException {
        PathMap.MappedEntry match;
        if (this.pathMap != null && (match = this.pathMap.getMatch(path)) != null) {
            String pattern = match.getKey();
            Object data = this.getFromCache(pattern);
            if (data == null) {
                data = LibPlugin.getDefault().getEncryptedFS().get(pattern);
            }
            URL url = null;
            if (data instanceof String) {
                return new InMemoryResource(pattern, ((String)data).getBytes(StandardCharsets.UTF_8));
            }
            if (data instanceof byte[]) {
                return new InMemoryResource(pattern, (byte[])data);
            }
            if (data instanceof InputStream) {
                return new InMemoryResource(pattern, (InputStream)data);
            }
            if (data instanceof File) {
                try {
                    FileResource2 fileResource = new FileResource2((File)data);
                    return fileResource;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error loading resource with url " + url, e);
                    return new BadResource(url, e.toString());
                }
            }
            return new BadResource(url, pattern);
        }
        return null;
    }

    private Object getFromCache(String pattern) {
        if (this.cache.containsKey(pattern)) {
            SoftReference<Object> ref = this.cache.get(pattern);
            Object data = ref.get();
            if (data == null) {
                this.cache.remove(pattern);
            }
            return data;
        }
        return null;
    }

    public void dispose() {
        this.cache.clear();
        this.executor.shutdown();
    }

    private class RemoveTask
    implements Runnable {
        private String pattern;

        public RemoveTask(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public void run() {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Exception exception) {}
            BigDataEncryptedFileSystem fs = LibPlugin.getDefault().getEncryptedFS();
            if (fs.isAlive()) {
                fs.remove(this.pattern);
            }
        }
    }
}

