/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.appointment.editor.multiprof.AppointmentMultiProfEditor;
import ca.infodata.ofys.ui.appointment.editor.multiprof.MultiProfInput;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.IPair;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class OpenAppointmentAction
extends Action
implements IMenuCreator {
    private static final Logger logger = Logger.getLogger(OpenAppointmentAction.class.getName());
    private static final String OUVRE_LA_VUE_DE_RENDEZVOUS = Messages.getString((String)"AppointmentPerspective.OUVRE_LA_VUE_DE_RENDEZVOUS", (String[])new String[0]);
    private static final String OPEN_MULTI_PROF_RV = Messages.getString((String)"AppointmentPerspective.OPEN_MULTI_PROF_RV", (String[])new String[0]);
    private Image icon;
    private final List<XBaseProfessionnal> allProfessionnals;
    private final List<IPair<XBaseProfessionnal, XSite>> appointmentProfessionnals;
    private Menu menu;

    public OpenAppointmentAction(List<XBaseProfessionnal> professionnals) {
        super(OUVRE_LA_VUE_DE_RENDEZVOUS, 4);
        this.allProfessionnals = professionnals == null ? Collections.EMPTY_LIST : professionnals;
        ArrayList<XBaseProfessionnal> list = new ArrayList<XBaseProfessionnal>();
        for (XBaseProfessionnal prof : this.allProfessionnals) {
            if (!prof.isUseAppointment() || !prof.isActive()) continue;
            list.add(prof);
        }
        this.appointmentProfessionnals = ProfessionalBySiteCombo.toProfessionnalBySiteList(list);
        List workSites = SitePlugin.getDefault().getWorkSites();
        if (workSites.size() > 1) {
            ProfessionalBySiteCombo.sortBySiteAndProf(this.appointmentProfessionnals);
        } else {
            ProfessionalBySiteCombo.sortByProf(this.appointmentProfessionnals);
        }
        this.icon = ResourceGetter.getImage((String)"images/clock-icon32.png");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.icon));
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.icon != null) {
            ResourceGetter.dispose((Object)this.icon);
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }

    public void run() {
        if (this.allProfessionnals.isEmpty()) {
            MessageUtil.warningMsg((Shell)UI.getWorkbenchShell(), (String)"Il n'y aucun professionnel pour ce client");
            return;
        }
        if (this.appointmentProfessionnals.isEmpty()) {
            MessageUtil.warningMsg((Shell)UI.getWorkbenchShell(), (String)"Il n'y aucun professionnel avec l'option 'rendez-vous' d'activ\u00e9e");
            return;
        }
        XBaseProfessionnal sessionProfessionnal = PersonUiPlugin.getDefault().getSessionProfessionnal();
        if (sessionProfessionnal != null && sessionProfessionnal.isUseAppointment()) {
            OpenAppointmentAction.openAppointmentEditor(sessionProfessionnal);
        } else {
            HashSet<XBaseProfessionnal> profs = new HashSet<XBaseProfessionnal>();
            String lastOpenedEditorType = PreferencesSettings.getInstance().get("appointment/last-opened-editor-type");
            if (lastOpenedEditorType == null || "single-prof".equals(lastOpenedEditorType)) {
                Set<XBaseProfessionnal> set = this.getPreferedAppointmentProfessionnal("appointment/single-prof-input");
                if (set.isEmpty()) {
                    profs.add((XBaseProfessionnal)this.appointmentProfessionnals.get(0).getFirst());
                } else {
                    profs.add(set.iterator().next());
                }
                if (profs.size() == 1) {
                    OpenAppointmentAction.openAppointmentEditor((XBaseProfessionnal)profs.iterator().next());
                } else {
                    OpenAppointmentAction.openAppointmentMultiProfEditor(profs);
                }
                return;
            }
            if (lastOpenedEditorType == null && profs.isEmpty() || "multi-prof".equals(lastOpenedEditorType)) {
                Set<XBaseProfessionnal> set = this.getPreferedAppointmentProfessionnal("appointment/multi-prof-input");
                profs.addAll(set);
                OpenAppointmentAction.openAppointmentMultiProfEditor(profs);
                return;
            }
        }
    }

    private Set<XBaseProfessionnal> getPreferedAppointmentProfessionnal(String key) {
        HashSet<XBaseProfessionnal> list = new HashSet<XBaseProfessionnal>();
        String profStr = PreferencesSettings.getInstance().get(key);
        if (StringUtils.isNotBlank((String)profStr)) {
            String[] profsIdsStr = profStr.split(";");
            ArrayList<Integer> profsIds = new ArrayList<Integer>();
            int i = 0;
            while (i < profsIdsStr.length) {
                try {
                    profsIds.add(Integer.parseInt(profsIdsStr[i]));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Coudn't load well the ids of appointment professionnal preferences : " + profStr, e);
                    break;
                }
                ++i;
            }
            for (IPair<XBaseProfessionnal, XSite> xbp : this.appointmentProfessionnals) {
                if (!profsIds.contains(((XBaseProfessionnal)xbp.getFirst()).getId())) continue;
                list.add((XBaseProfessionnal)xbp.getFirst());
            }
        }
        return list;
    }

    public static void openAppointmentEditor(XBaseProfessionnal professionnal) {
        AppointmentMainEditorInput input = null;
        try {
            Log.logOperation((String)"OpenAppointmentAction.openAppointmentEditor", (Object[])new Object[]{professionnal});
            input = new AppointmentMainEditorInput("AppointmentMainEditor");
            input.setProfessional(professionnal);
            input.setMode(IAppointmentMode.Mode.APPOINTMENT);
            input.setDate(LocalDate.today());
            BaseEditor.openEditor((IEditorInput)input, (String)AppointmentMainEditor.class.getName());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open appointment editor with input " + input, e);
        }
    }

    public static void openAppointmentMultiProfEditor(Set<XBaseProfessionnal> professionnals) {
        MultiProfInput input = new MultiProfInput();
        try {
            Log.logOperation((String)"OpenAppointmentAction.openAppointmentMultiProfEditor", (Object[])new Object[0]);
            input.setDate(LocalDate.today());
            if (professionnals != null) {
                input.addProf(professionnals);
            }
            BaseEditor.openEditor((IEditorInput)input, (String)AppointmentMultiProfEditor.class.getName());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open appointment multi prof editor with input " + input, e);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            MenuItem menuItem = new MenuItem(this.menu, 8);
            menuItem.setText(OPEN_MULTI_PROF_RV);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenAppointmentAction.openAppointmentMultiProfEditor(OpenAppointmentAction.this.getPreferedAppointmentProfessionnal("appointment/multi-prof-input"));
                }
            });
            List workSites = SitePlugin.getDefault().getWorkSites();
            for (final IPair<XBaseProfessionnal, XSite> e : this.appointmentProfessionnals) {
                menuItem = new MenuItem(this.menu, 8);
                String text = e.getSecond() == null || workSites.size() <= 1 ? ((XBaseProfessionnal)e.getFirst()).getName() : String.valueOf(((XSite)e.getSecond()).getNameCommon()) + " - " + ((XBaseProfessionnal)e.getFirst()).getName();
                menuItem.setText(text);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e2) {
                        OpenAppointmentAction.openAppointmentEditor((XBaseProfessionnal)e.getFirst());
                    }
                });
            }
            this.menu.setVisible(true);
        }
        return this.menu;
    }

    public Menu getMenu(Menu menu) {
        return null;
    }
}

