/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.recall;

import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallListContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.appointment.editor.recall.PatientRecallSearchView;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.report2.PrintDialog2;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;

public class PatientRecallListEditor
extends BaseEditor
implements IEditorPart,
IPrintable,
IReferenceControl {
    private static final Logger logger = Logger.getLogger(PatientRecallListEditor.class.getName());
    private MyButton cmdSearchPatient;
    private MyButton cmdClearList;
    private Table tblPatients;

    public void createMyControl(Composite parent) {
        MyLabel lblSelection = new MyLabel(parent, Messages.getString((String)"UTILISEZ_LA_FONCTION_RECHERCHE", (String[])new String[0]), 0, this.toolkit);
        this.cmdSearchPatient = new MyButton(parent, Messages.getString((String)"AJOUTER", (String[])new String[0]), 8, this.toolkit);
        this.cmdClearList = new MyButton(parent, Messages.getString((String)"EFFACER_TOUS", (String[])new String[0]), 8, this.toolkit);
        this.tblPatients = this.toolkit.createTable(parent, 67616);
        this.tblPatients.setHeaderVisible(true);
        String[] colTitre = new String[]{Messages.getString((String)"PATIENT", (String[])new String[0]), Messages.getString((String)"DDN", (String[])new String[0]), Messages.getString((String)"DOSSIER", (String[])new String[0]), Messages.getString((String)"TELEPHONE", (String[])new String[0]), Messages.getString((String)"MEDECIN", (String[])new String[0]), Messages.getString((String)"PRIORITE", (String[])new String[0]), Messages.getString((String)"DATE", (String[])new String[0]), Messages.getString((String)"PREFERENCE", (String[])new String[0]), Messages.getString((String)"ETAT", (String[])new String[0]), Messages.getString((String)"NOTE", (String[])new String[0])};
        int[] colWidth = new int[]{150, 90, 60, 100, 150, 90, 80, 80, 80, 200};
        int i = 0;
        while (i < colTitre.length) {
            TableColumn col = new TableColumn(this.tblPatients, 2048);
            col.setText(colTitre[i]);
            col.setWidth(colWidth[i]);
            ++i;
        }
        this.cmdSearchPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientRecallListEditor.this.btnSearchPatientRecallSelected();
            }
        });
        this.cmdClearList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientRecallListEditor.this.btnClearListSelected();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        lblSelection.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSelection.getControl(), 0);
        data.left = new FormAttachment(0, 0);
        this.cmdSearchPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblSelection.getControl(), 0);
        data.left = new FormAttachment(this.cmdSearchPatient.getControl(), UI.getAjustedPositionHorizontal());
        this.cmdClearList.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmdSearchPatient.getControl(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.tblPatients.setLayoutData((Object)data);
    }

    public XPatientRecallListContainer getContainer() {
        return (XPatientRecallListContainer)((EditorInput)this.getEditorInput()).getCompleteDataObject();
    }

    private void btnSearchPatientRecallSelected() {
        IViewPart view = BaseSearchView.openView(PatientRecallSearchView.class);
        if (view != null) {
            ((PatientRecallSearchView)view).setContainerReferenceControl(this);
        }
    }

    private void btnClearListSelected() {
        this.getContainer().setPatientList(new ArrayList());
        this.tblPatients.removeAll();
    }

    public void setToolBarStatus() {
    }

    public boolean isDataDirty() {
        return false;
    }

    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XPatientRecallListContainer) {
            this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject());
        }
    }

    public void showDataObject() {
        this.tblPatients.removeAll();
        for (XPatientRecall recall : this.getContainer().getPatientRecallList()) {
            this.addPatientRecall(recall);
        }
    }

    public void print() {
        XPatientRecallListContainer container = this.getNewContainer();
        PrintDialog2 dialog = new PrintDialog2(this.getSite().getShell(), (Serializable)container);
        UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
        dialog.open();
    }

    private XPatientRecallListContainer getNewContainer() {
        XPatientRecallListContainer container = new XPatientRecallListContainer();
        TableItem[] tableItemArray = this.tblPatients.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                container.addPatientRecall((XPatientRecall)item.getData());
            }
            ++n2;
        }
        return container;
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return AppointmentAccessorClient.getInstance();
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/alarmclock32.png");
    }

    public void callback(Object o) {
        if (this.isDisposed()) {
            return;
        }
        if (o instanceof XPatientRecall[]) {
            XPatientRecall[] xPatientRecallArray = (XPatientRecall[])o;
            int n = xPatientRecallArray.length;
            int n2 = 0;
            while (n2 < n) {
                XPatientRecall recall = xPatientRecallArray[n2];
                this.addPatientRecall(recall);
                ++n2;
            }
        } else if (o instanceof XPatientRecall) {
            this.addPatientRecall((XPatientRecall)o);
        } else if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            if (objects.length > 0) {
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] instanceof XPatientRecall) {
                        this.addPatientRecall((XPatientRecall)objects[i]);
                    } else if (objects[i] instanceof SearchItem) {
                        this.callback(((SearchItem)objects[i]).getData());
                    }
                    ++i;
                }
            }
        } else {
            logger.warning("Trying to add object " + o + " to PatientRecallListEditor failed. Object is not an instance of XPatientRecall[]");
        }
    }

    public void addPatientRecall(XPatientRecall recall) {
        List recalls = this.getContainer().getPatientRecallList();
        if (!recalls.contains(recall)) {
            IPatient patient = recall.getPatient();
            String name = patient.getName();
            String birthdate = patient.getBirthDate() == null ? "" : LocalDateFormat.format((LocalDate)patient.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
            String recordNumber = patient.getPatientRecordNumber() == null ? "" : patient.getPatientRecordNumber();
            String phoneNumber = this.getFirstPhoneNumber(recall);
            phoneNumber = phoneNumber == null ? "" : phoneNumber;
            XBaseProfessionnal professionnal = PersonUiPlugin.getDefault().getBaseProfessionnal(recall.getProfessionnal());
            String professionnalName = professionnal == null ? "" : professionnal.getName();
            String priority = recall.getPriority() == null ? "" : recall.getPriority().toString();
            String dateRecall = recall.getDateRecall() == null ? "" : LocalDateFormat.format((LocalDate)recall.getDateRecall(), (String)FormatDateProvider.getFormatDate().toString());
            String preferredTime = recall.getPreferredTime() == null ? "" : recall.getPreferredTime().toString();
            String status = recall.getStatus() == null ? "" : recall.getStatus().toString();
            String reason = recall.getReason() == null ? "" : recall.getReason();
            String[] row = new String[]{name, birthdate, recordNumber, phoneNumber, professionnalName, priority, dateRecall, preferredTime, status, reason};
            TableItem tableItem = new TableItem(this.tblPatients, 0);
            tableItem.setText(row);
            tableItem.setData((Object)recall);
            tableItem.setChecked(true);
            recalls.add(recall);
        }
    }

    private String getFirstPhoneNumber(XPatientRecall recall) {
        IPatient patient = recall.getPatient();
        String phoneNumber = null;
        XContactInformation contact = patient.getFirstContactInformation();
        if (contact != null && contact.getContact() != null && contact.getTypeContact() != null && XContactInformation.CONTACT_PHONE_TYPES.contains(contact.getTypeContact())) {
            phoneNumber = contact.getFormatedTelephone();
        } else {
            contact = patient.getSecondContactInformation();
            if (contact != null && contact.getContact() != null && contact.getTypeContact() != null && XContactInformation.CONTACT_PHONE_TYPES.contains(contact.getTypeContact())) {
                phoneNumber = contact.getFormatedTelephone();
            }
        }
        return phoneNumber;
    }

    public boolean isPrintAllowed() {
        return true;
    }
}

