/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.ui.appointment.editor.model2.IXAppointmentDateMapListener;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.mb.listeners.GenListenerManager;

public class XBaseAppointmentDateMap {
    private final GenListenerManager<IXAppointmentDateMapListener<XBaseAppointmentDate>> manager;
    private final MultiValueMap mapBaseAppointmentDateByDate;
    private final MultiKeyMap mapBaseAppointmentDateByDateProfessional;
    private final MultiValueMap mapBaseAppointmentDateByProfessional;
    private final IXAppointmentDateMapListener<XBaseAppointmentDate> proxy;
    private final PredicateA<Object> predicate;

    public XBaseAppointmentDateMap(PredicateA<Object> predicate) {
        this.predicate = predicate;
        this.mapBaseAppointmentDateByDate = new MultiValueMap();
        this.mapBaseAppointmentDateByProfessional = new MultiValueMap();
        this.mapBaseAppointmentDateByDateProfessional = new MultiKeyMap();
        this.manager = new GenListenerManager(IXAppointmentDateMapListener.class);
        this.proxy = (IXAppointmentDateMapListener)this.manager.getProxy();
    }

    private boolean isValid(Object object) {
        return this.predicate == null || this.predicate.evaluate(object);
    }

    private XBaseAppointmentDate internal_add(XAppointmentDate date) {
        XBaseAppointmentDate base = null;
        if (this.isValid(date) && !this.contains(date)) {
            base = new XBaseAppointmentDate(date);
            this.mapBaseAppointmentDateByDate.put((Object)date.getDate(), (Object)base);
            this.mapBaseAppointmentDateByProfessional.put((Object)base.getProfessional(), (Object)base);
            this.mapBaseAppointmentDateByDateProfessional.put((Object)base.getDate(), (Object)base.getProfessional(), (Object)base);
        }
        return base;
    }

    private boolean internal_add(XBaseAppointmentDate base) {
        boolean added;
        boolean bl = added = this.isValid(base) && (!this.contains(base) || base.getStatistic() != null);
        if (added) {
            this.mapBaseAppointmentDateByDate.put((Object)base.getDate(), (Object)base);
            this.mapBaseAppointmentDateByProfessional.put((Object)base.getProfessional(), (Object)base);
            this.mapBaseAppointmentDateByDateProfessional.put((Object)base.getDate(), (Object)base.getProfessional(), (Object)base);
        }
        return added;
    }

    private XBaseAppointmentDate internal_remove(XAppointmentDate date) {
        XBaseAppointmentDate base = new XBaseAppointmentDate(date);
        boolean removed = this.internal_remove(base);
        if (removed) {
            return base;
        }
        return null;
    }

    private boolean internal_remove(XBaseAppointmentDate date) {
        boolean removed = this.contains(date);
        if (removed) {
            this.mapBaseAppointmentDateByDate.remove((Object)date.getDate(), (Object)date);
            this.mapBaseAppointmentDateByProfessional.remove((Object)date.getProfessional(), (Object)date);
            this.mapBaseAppointmentDateByDateProfessional.remove((Object)new MultiKey((Object)date.getDate(), (Object)date.getProfessional()));
        }
        return removed;
    }

    public synchronized boolean add(XAppointmentDate date) {
        XBaseAppointmentDate base = this.internal_add(date);
        if (base != null) {
            this.proxy.add(base);
        }
        return base != null;
    }

    public synchronized boolean add(XBaseAppointmentDate base) {
        boolean added = this.internal_add(base);
        if (added) {
            this.proxy.add(base);
        }
        return added;
    }

    public synchronized boolean addAll(Collection<XBaseAppointmentDate> lstDate) {
        boolean added = false;
        for (XBaseAppointmentDate base : lstDate) {
            boolean bl = added = this.internal_add(base) || added;
        }
        if (added) {
            this.proxy.addAll(lstDate);
        }
        return added;
    }

    public synchronized boolean addAll2(Collection<? extends XAppointmentDate> lstDate) {
        boolean bl;
        ArrayList<XBaseAppointmentDate> list = new ArrayList<XBaseAppointmentDate>();
        for (XAppointmentDate xAppointmentDate : lstDate) {
            XBaseAppointmentDate base = this.internal_add(xAppointmentDate);
            if (base == null) continue;
            list.add(base);
        }
        boolean bl2 = bl = list.size() > 0;
        if (bl) {
            this.proxy.addAll(list);
        }
        return bl;
    }

    public synchronized void clear() {
        this.mapBaseAppointmentDateByDate.clear();
        this.mapBaseAppointmentDateByProfessional.clear();
        this.mapBaseAppointmentDateByDateProfessional.clear();
        this.proxy.clear();
    }

    public synchronized boolean contains(XAppointmentDate date) {
        return this.get(date.getDate(), date.getProfessional()) != null;
    }

    public synchronized boolean contains(XBaseAppointmentDate date) {
        return this.get(date.getDate(), date.getProfessional()) != null;
    }

    public synchronized Collection<XBaseAppointmentDate> get(LocalDate date) {
        return (Collection)this.mapBaseAppointmentDateByDate.get((Object)date);
    }

    public synchronized XBaseAppointmentDate get(LocalDate date, Integer professional) {
        return (XBaseAppointmentDate)this.mapBaseAppointmentDateByDateProfessional.get((Object)new MultiKey((Object)date, (Object)professional));
    }

    public synchronized Collection<XBaseAppointmentDate> get(Integer professional) {
        return (Collection)this.mapBaseAppointmentDateByProfessional.get((Object)professional);
    }

    public synchronized boolean remove(XAppointmentDate date) {
        boolean removed;
        XBaseAppointmentDate base = this.internal_remove(date);
        boolean bl = removed = base != null;
        if (removed) {
            this.proxy.remove(base);
        }
        return removed;
    }

    public synchronized boolean remove(XBaseAppointmentDate date) {
        boolean removed = this.internal_remove(date);
        if (removed) {
            this.proxy.remove(date);
        }
        return removed;
    }

    public synchronized boolean removeAll(Collection<XBaseAppointmentDate> lstDate) {
        boolean removed = false;
        for (XBaseAppointmentDate base : lstDate) {
            boolean bl = removed = this.internal_remove(base) || removed;
        }
        if (removed) {
            this.proxy.removeAll(lstDate);
        }
        return removed;
    }

    public synchronized boolean removeAll2(Collection<? extends XAppointmentDate> lstDate) {
        boolean bl;
        ArrayList<XBaseAppointmentDate> list = new ArrayList<XBaseAppointmentDate>();
        for (XAppointmentDate xAppointmentDate : lstDate) {
            XBaseAppointmentDate base = this.internal_remove(xAppointmentDate);
            if (base == null) continue;
            list.add(base);
        }
        boolean bl2 = bl = list.size() > 0;
        if (bl) {
            this.proxy.removeAll(list);
        }
        return bl;
    }

    public synchronized List<XBaseAppointmentDate> values() {
        return new ArrayList<XBaseAppointmentDate>(this.mapBaseAppointmentDateByDateProfessional.values());
    }

    public void addListener(IXAppointmentDateMapListener<XBaseAppointmentDate> listener) {
        this.manager.addListener(listener);
    }

    public void removeListener(IXAppointmentDateMapListener<XBaseAppointmentDate> listener) {
        this.manager.removeListener(listener);
    }

    public synchronized String toString() {
        StringBuilder b = new StringBuilder(1000);
        b.append("XBaseAppointmentDateMap");
        MapIterator mapIterator = this.mapBaseAppointmentDateByDateProfessional.mapIterator();
        while (mapIterator.hasNext()) {
            b.append("\n");
            b.append(mapIterator.next().toString());
        }
        return b.toString();
    }

    public synchronized int size() {
        return this.mapBaseAppointmentDateByDateProfessional.size();
    }
}

