/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.controller;

import ca.infodata.util1.ClosureA;
import ca.infodata.util1.ClosureAR;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentList<T>
implements List<T> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final List<T> list;

    public ConcurrentList(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.remove(o);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public boolean add(T t) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.add(t);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public void clear() {
        this.readWriteLock.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public T get(int index) {
        this.readWriteLock.readLock().lock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        throw new RuntimeException("unsupported feature");
    }

    public T find(ClosureAR<T, Boolean> next) {
        this.readWriteLock.readLock().lock();
        try {
            int size = this.list.size();
            int i = 0;
            while (i < size) {
                T t = this.list.get(i);
                Boolean doNext = (Boolean)next.execute(t);
                if (Boolean.TRUE.equals(doNext)) {
                    T t2 = t;
                    return t2;
                }
                try {
                    ++i;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return null;
    }

    public void iterator(ClosureA<T> next) {
        this.readWriteLock.readLock().lock();
        try {
            try {
                int size = this.list.size();
                int i = 0;
                while (i < size) {
                    next.execute(this.list.get(i));
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.readWriteLock.readLock().unlock();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.readWriteLock.readLock().lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readWriteLock.readLock().lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.addAll(c);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.addAll(index, c);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.removeAll(c);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public T set(int index, T element) {
        this.readWriteLock.readLock().lock();
        try {
            T t = this.list.set(index, element);
            return t;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void add(int index, T element) {
        this.readWriteLock.writeLock().lock();
        try {
            this.list.add(index, element);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public T remove(int index) {
        T ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.remove(index);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public int indexOf(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new RuntimeException("unsupported feature");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new RuntimeException("unsupported feature");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new RuntimeException("unsupported feature");
    }
}

