// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('Entrée dans ScriptClient.js');

window.onerror = function (message, source, noLigne)
{
    loguerErrorAuServeur(message, source, noLigne);
};

$(document).ready(function ()
{
    $formulaireArchive = $('.formulaire.archive');
    $formulaireArchive.find(':input').addClass('readonly');
    $formulaireArchive.find('.bouttonAction').hide();
    
	$("input.TimePicker").timepicker(
	{
		timeOnly: true,
		currentText: "Maintenant",
		closeText: "Ok",
		timeOnlyTitle: "Choisir le temps",
		timeText: "Temps",
		hourText: "Heures",
		minuteText: "Minutes"
	});
					
	//Code pour le format de la date
	$(".datePicker").datepicker(
	{
	    dateFormat : "yy-mm-dd",
	    monthNames: [ "Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre" ],			
	    dayNamesMin: [ "Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa" ]
	});
	
	//Widget Onglet
	$( ".tabs" ).tabs();
	
    //Widget Accordion#
    $(".accordion").accordion({ collapsible: true , active: false});
		
    $(".formulaire div.historique").accordion(
    {
        collapsible: true,
        active: false,
        animate: false
    });
		
    //Code pour le dialog
    $(".dialogue").dialog(
    {
	    autoOpen : false,
	    draggable : true,
        resizable : false,
        height : 'auto',
        width : 'auto',
        modal: true
    });
		
    $(document.getElementById("opener")).click(function() 
    {
        $(document.getElementById("dialog")).dialog("open");
    });

    $(document.getElementById("closer")).click(function() 
    {
        $(document.getElementById("dialog")).dialog("close");
    });

    $(".formulaire :input.readonly").not(":button.bouttonAction").each(function ()
    {
        this.disabled = true;
    });

	$("input[type=file],select,textarea").each(function()
	{
		setHiddenPrintDiv(this);
		
		$(this).change(function()
    	{
    		setHiddenPrintDiv(this);
    	});
	});
	
    $("input[type=Radio].imprimeQueValeurSelectionnee").change(function()
    {
        $("input[name="+ $(this).attr("name") +"]").each(function()
        {
            $("#" + $(this).attr("id") + "lbl").addClass("NoPrint");
            $("#" + $(this).attr("id") + "lbl").parent().addClass("NoPrint");
        });
        $("#" + $(this).attr("id") + "lbl").removeClass("NoPrint");
        $("#" + $(this).attr("id") + "lbl").parent().removeClass("NoPrint");
    });

    $("input[type=CheckBox].imprimeQueValeurSelectionnee").change(function()
    {
        if($("#" + $(this).attr("id") + "lbl").hasClass( "NoPrint"))
        {
            $("#" + $(this).attr("id") + "lbl").removeClass("NoPrint");
            $("#" + $(this).attr("id") + "lbl").parent().removeClass("NoPrint");
        }
        else
        {
            $("#" + $(this).attr("id") + "lbl").addClass("NoPrint");	
            $("#" + $(this).attr("id") + "lbl").parent().addClass("NoPrint");
        }
    });
    
    // TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
    $('.bouttonAction').click(function ()
    {
    	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("Clic sur bouton d'actions #" + this.id);
    });
});

/**
 * Retourne la valeur d'un champ pour être utilisée dans un calcul. La valeur peut être convertie en nombre avant d'être retournée, ce qui
 * permet des opérations arithmétiques dans les calculs.
 * 
 * @param nomChamp le nom du champ.
 * @param convertirEnNombre si la valeur doit être convertie en nombre. Si ce paramètre n'est pas spécifié, la valeur doit correspondre à
 *                          l'expression régulière "-?^\d+(\.\d+)?$" pour être convertie en nombre.
 * @returns la valeur du champ.
 */
function getValeurChampCalcul(nomChamp, convertirEnNombre)
{
	var valeurs = getValeursChamp(nomChamp);
	
	if (convertirEnNombre || (typeof(convertirEnNombre) == 'undefined' && /^-?\d+(\.\d+)?$/.test(valeurs)))
    {
    	valeurs = Number(valeurs);
    }
    
	return valeurs;
}

/** Calcul l'age d'une personne en fonction de sa date de naissance.
 * 
 * @param nomChampDateNaissance le nom du champ repr�sentant la date de naissance.
 * @returns l'age de la personne.
 */
function calculAge(nomChampDateNaissance)
{
	var age = "";
	var dateNaissance = Date.parse(getValeursChamp(nomChampDateNaissance)[0]);
	
	if (dateNaissance != null)
	{
		var todayDate = new Date();
		
		age = todayDate.getFullYear() - dateNaissance.getFullYear(); 

		if (todayDate.getMonth() < dateNaissance.getMonth() || 
		    (dateNaissance.getMonth() == todayDate.getMonth() && todayDate.getDate() < dateNaissance.getDate()))
		{
		  age--;
		}
	}
	
	return age;
}

/** Calcule le jour de la semaine en fonction de la date donnée.
 * 
 * @param nomChampDate le nom du champ représentant la date.
 * @returns le jour de la semaine.
 */
function calculJourSemaine(nomChampDate)
{
	var jour = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
	var date = Date.parse(getValeursChamp(nomChampDate)[0]);
	return date == null ? '' : jour[date.getDay()];
}

/**
 * Calcule la longueur du champ avec le nom spécifié. Si le champ comporte plusieurs valeurs, la somme des longueurs est retournée.
 * 
 * @param nomChamp le nom du champ dont la longueur est à calculer.
 * @returns la longueur du champ avec le nom spécifié.
 */
function calculLongueur(nomChamp)
{
	return getValeursChamp(nomChamp).join('').length;
}

/**
 * Convertit en nombre la valeur du champ avec le nom spécifié.
 * 
 * @param nomChamp le nom du champ dont la valeur est à convertir.
 * @returns la valeur convertie en nombre.
 */
function calculNombre(nomChamp)
{
    return Number(getValeursChamp(nomChamp));	
}

/**
 * Assigne au champ la valeur du calcul (assignation) et appel .change si nÃ©cessaire.
 * 
 * @param nom le nom du champ dans lequel assignÃ© la valeur.
 * @param assignation l'assignation (la valeur)
 */
function assignationValeurCalcul(nom, assignation)
{
    var $controlesCibles = $(document.getElementsByName(nom)).filter(':input[name="' + nom + '"]').not(':button');
    var ancienneValeur = getValeursChamp(nom);
    
    // Arrondir à 2 chiffres décimales si nécessaire.
    if (!isNaN(assignation) && assignation % 1 > 0)
    {
    	assignation = Number(assignation).toFixed(2);
    }

    // Le reste du traitement peut assumer que 'assignation' est un array.
    if (!$.isArray(assignation))
    {
        assignation = [assignation];
    }
    
    if ($controlesCibles.is(':text, textarea'))
    {
        $controlesCibles.val(assignation.join(", "));
    }
    else
    {
        $controlesCibles.val(assignation);
    }

    if(!comparerArray(getValeursChamp(nom), ancienneValeur))
    {
        $controlesCibles.change();
    }
}

/**
 * Méthode de comparaison d'array copié sur stackoverflow.
 * 
 * @param array1 le premier array
 * @param array2 le deuxième array
 * @returns {Boolean} si les deux array sont identique.
 */
function comparerArray(array1, array2)
{
    if (!array2)
    {
    	return false;
    }  

    if (array1.length != array2.length)
    {
        return false;
    }

    for (var i = 0, l=array1.length; i < l; i++)
    {
        if (array1[i] instanceof Array && array2[i] instanceof Array)
        {
            if (!array1[i].compare(array2[i]))
            {
                return false;
            }
        }
        else if (array1[i] != array2[i])
        {
            return false;
        }
    }
    return true;
}

function setHiddenPrintDiv(ObjectCourant)
{
	var tempContain = $(ObjectCourant).val();
	var idDiv = "#" + $(ObjectCourant).attr("id") + "div";
	
	if(tempContain != null)
	{
		// Il faut changer les saut de lignes aisni que les < et >.
		tempContain = tempContain.replace(/&/gi,'&amp;');
		tempContain = tempContain.replace(/>/gi,'&gt;');
		tempContain = tempContain.replace(/</gi,'&lt;');
		tempContain = tempContain.replace(/\n/gi,'<br>');
		
		$(idDiv).html(tempContain);
	}
	else
	{
		$(idDiv).html("");
	}
}



/**
 * RÃ©initialise les éléments de type DatePicker du à un problême avec JQuery.
 * 
 * @param idTr id du tr contenant les DatePicker.
 */
function reinitialiserDatePicker(idTr)
{
	$("#" + idTr).find("input.datePicker").each(function()
	{;
		$(this).removeClass("hasDatepicker").datepicker(
		{
			dateFormat : "yy-mm-dd",
			monthNames: ["Janvier", "FÃ©vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "AoÃ»t", "Septembre", "Octobre", "Novembre", "Decembre"],
			dayNamesMin: ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"]
		});
	});
}

/**
 * Réinitialise les éléments de type TimePicker du à un problême avec JQuery.
 * 
 * @param idTr id du tr contenant les TimePicker.
 */
function reinitialiserTimePicker(idTr)
{
	$(document.getElementById(idTr)).find("input.TimePicker").each(function ()
	{
		$(this).removeClass("hasDatepicker").timepicker(
		{
			timeOnly: true,
			currentText: "Maintenant",
			closeText: "Ok",
			timeOnlyTitle: "Choisir le temps",
			timeText: "Temps",
			hourText: "Heures",
			minuteText: "Minutes"
		});
	});
}


	
function verification()
{
    var idRequete = $('input.idRequete').attr('value') || 'nouvelle';
    var $errorLog = $(document.getElementById('Requete_' + idRequete + '_errorLog'));
    var FlagPasse = true;
    var nomInputPrecedent = "qqqqqqq";
	var estInvisible = function()
	{
		var invisible = false
		
		if (!$(this).hasClass("ui-tabs-panel"))
		{
		    invisible = $(this).css('display') == 'none' || $(this).css('visibility') == 'hidden' || $(this).css('visibility') == 'collapse';
		}
		
		return invisible;
	}
	
	$errorLog.html('');
	var array = new Array();
    $('input.nonValide, select.nonValide, textarea.nonValide').each(function()
    {
   	    if(!$(this).is(estInvisible) && !$(this).parents().is(estInvisible))
   	    {
   	    	if (this.name != nomInputPrecedent)
   	    	{
              	if($('#' + this.getAttribute('name') + 'MessageVerif').length)
               	{
              		$errorLog.html($errorLog.html() + $('#' + this.getAttribute('name') + 'MessageVerif').html() + '<br/>');
              		array.push($('#' + this.getAttribute('name') + 'MessageVerif').text());
               	}
               	else
               	{
               		$errorLog.html($errorLog.html() + 'Le champ «&nbsp;' + $("#" +this.getAttribute('name')+ "lbl").html() + '&nbsp;» est requis et ne peut pas être vide.' + '<br/>');
               		array.push('Le champ «\u00A0' + $("#" + this.getAttribute('name') + "lbl").text() + '\u00A0» est requis et ne peut pas être vide.');
               	}
              	
                FlagPasse = false;
   	    		nomInputPrecedent = this.name;
   	    	}	
   	    }
    });
    
    if(array.length >= 1) {
    	$(window).scrollTop(0);
    	 alert(array.length > 1 ? "Plusieurs erreurs de validation ont été détectées.": array[0]);
    			}
    
    
    if(FlagPasse == false)
    {
    	$errorLog.addClass("ui-state-error");
    }
    else
    {
    	$errorLog.removeClass("ui-state-error");
    }
    
    return FlagPasse;
}

function getValeursChamp(nomChamp)
{
	var valeurs = [];
	
	var query = document.getElementsByName(nomChamp);
	var len = query.length;
	for (var i=0;i<len;i++)
	{
		obj = query[i];
		if (obj!=undefined && obj.name==nomChamp)
		{
			switch (obj.nodeName)
			{
				case 'INPUT':
				{
					switch (obj.type)
					{
						case 'text':
						case 'file':
						case 'hidden':
						{
							valeurs.push(obj.value);
							break;
						}
						case 'radio':
						case 'checkbox':
						{
							if (obj.checked)
							{
								valeurs.push(obj.value);
							}
							break;
						}
					}
					break;
				}
				
				case 'TEXTAREA':
				{
					valeurs.push(obj.value);
					break;
				}
				
				case 'SELECT':
				{
					$(obj).find(':selected').each(function()
					{
						valeurs.push(obj.value);
					});
					break;
				}
			}
		}
	}

	return valeurs;
}

function ChangementFiltre(verification, newTypeChange)
{
	if (verification == "true")   
	{
		$(newTypeChange).removeClass("desactive");
		$(newTypeChange).addClass("active");
		$(newTypeChange).removeClass("desactive");
		$(newTypeChange + "lbl").addClass("active");
		$(newTypeChange + "lbl").removeClass("desactive");
		$(newTypeChange + "lbl").addClass("active");
		$(newTypeChange + "td").addClass("active");
		$(newTypeChange + "td").removeClass("desactive");
		$(newTypeChange + "td").addClass("active");
	}
	else
	{
		$(newTypeChange).removeClass("active");
		$(newTypeChange).addClass("desactive");
		$(newTypeChange + "lbl").removeClass("active");
		$(newTypeChange + "lbl").addClass("desactive");
		$(newTypeChange + "td").removeClass("active");
		$(newTypeChange + "td").addClass("desactive");
	}
}
	
//Code pour le retour de la valeur d'un groupe de radio
function getCheckedValue(radioObj)
{
	if (!radioObj)
	{
		return "";
	}
	
	var radioLength = radioObj.length;
	if (radioLength == undefined)
	{
		if (radioObj.checked)
		{
			return radioObj.value;
		}
		else
		{
			return "";
		}
	}
	
	for ( var i = 0; i < radioLength; i++)
	{
		if (radioObj[i].checked)
		{
			return radioObj[i].value;
		}
	}
	return "";
}
	
/**
 * Méthode permettant de copier la valeur d'un champ dans un autre. Cette méthode est utilisée par l'élément SIGNATURE.
 * 
 * @param idElementReferencant id de l'élément dans lequel copier la valeur.
 * @param nomChampReference nom de l'élément Ã  partir du quel copier la valeur.
 */
function copierValeurChamp(idElementReferencant, nomChampReference)
{
	$(document.getElementById(idElementReferencant)).html($(document.getElementsByName(nomChampReference)).val());
}

/**
 * Méthode permettant d'affecter une ou des valeurs dans un champ.
 * 
 * @param nomChamp le nom du champ dans lequel on veut affecter une ou des valeurs.
 * @param paramValeurs la ou les données à affecter au champ 'nomChamp'. Peut être une chaîne ou un tableau de chaînes.
 */
function setValeursChamp(nomChamp, paramValeurs)
{
    var anciennesValeurs = getValeursChamp(nomChamp);
    var nouvellesValeurs = $.isArray(paramValeurs) ? paramValeurs : [paramValeurs];
    var $champ = $(document.getElementsByName(nomChamp)).filter('[name="' + nomChamp.replace(/"|\\/g, '\\$&') + '"]');
    
    $champ.val(nouvellesValeurs);
    
    if (!comparerArray(anciennesValeurs, nouvellesValeurs))
    {
        $champ.change();
    }
}

/**
 * Retourne un booléen indiquant si le tableau spécifié contient au moins un objet avec la valeur spécifiée pour la
 * propriété spécifiée.
 * 
 * @param tableau le tableau dans lequel chercher l'objet.
 * @param nomProp le nom de la propriété à rechercher.
 * @param valeur la valeur à rechercher.
 * @returns {Boolean} si le tableau contient un objet correspondant.
 */
function tableauContientObjetAvecPropriete(tableau, nomProp, valeur)
{    
    for (var i = 0; i < tableau.length; ++i)
    {
        if (tableau[i][nomProp] === valeur)
        {
            return true;
        }
    }
    return false;
}

function initMenuPrincipal()
{
    $(document.getElementById("ulMenuPrinc_liCreer")).click(function(event)
    {
        event.stopPropagation();          
        $(document.getElementById("ulMenuPrinc_liCreer_ulFormulaires")).removeClass("desactive").addClass("active");      
     });
      
	$(document).click(function()
	{
	  $(document.getElementById("ulMenuPrinc_liCreer_ulFormulaires")).removeClass("active").addClass("desactive");
	});
}

function initListeVues()
{
    if (getCookies()['masquerListeVues'] == 'true')
    {
        $('body').addClass('listeVuesMasquee');
    }
    
    $divMenuTypesReq = $(document.getElementById('divMenuTypesReq'));
    $divMenuTypesReq.before('<a id="aAfficherListeVues" href="#">&#9660; Afficher la liste des vues</a>');
    $divMenuTypesReq.prepend('<a id="aMasquerListeVues" href="#">&#9650;</a>');
    
    $([document.getElementById('aMasquerListeVues'), document.getElementById('aAfficherListeVues')]).click(function()
    {
        $('body').toggleClass('listeVuesMasquee');
        setCookie('masquerListeVues', $('body').hasClass('listeVuesMasquee'));
        return false;
    });
}

// Plug-in API pour DataTable - http://datatables.net/plug-ins/api
jQuery.fn.dataTableExt.oApi.fnProcessingIndicator = function ( oSettings, onoff )
{
  if( typeof(onoff) == 'undefined' )
  {
      onoff=true;
  }
  this.oApi._fnProcessingDisplay( oSettings, onoff );
};

function getValeurListeFiltrante(nomChamp)
{
	return $(document.getElementsByName(nomChamp)).filter('[name=' + nomChamp + ']').val();
}

function configurerListesFiltrantes(dataTables, listesFiltrantes)
{
	// Déplacer les listes filtrantes et leur label à l'intérieur du DataTable et actualiser le DataTable lorsque la valeur d'une liste change
    $.each(listesFiltrantes, function (i, lstFiltrante)
    {
        var idSelectFiltre = lstFiltrante.idSelect;
        var lblFiltre = $('label[for="' + idSelectFiltre + '"]').detach()[0];
        var selFiltre = $(document.getElementById(idSelectFiltre)).detach()[0];
        var spnFiltre = document.createElement('span');
        
        spnFiltre.className = 'filtre';
        $(spnFiltre).append(lblFiltre).append(selFiltre);
        $('.divisionFiltres').append(spnFiltre);
        
        $(selFiltre).change(function ()
        {
            dataTables.fnDraw();
        });
    });
    
	// Filtrer les options des listes filtrantes enfants selon les valeurs de leurs parents
	$.each(listesFiltrantes, function (i, lstFiltrante)
	{
		var select = document.getElementById(lstFiltrante.idSelect);
		var selectsParents = [];
		var actualiserSelonValeursParents;
		
		$.each(lstFiltrante.nomsParents, function (j, nomPar)
		{
			selectsParents.push($(document.getElementsByName(nomPar)).filter('[name=' + nomPar + ']')[0]);
		});
		
		if (selectsParents.size != 0)
		{
			actualiserSelonValeursParents = function ()
			{
			    var indiceInitial = select.selectedIndex;
			    var valeurInitiale = select[indiceInitial].text;
			    var tousLesParentsFiltrent = true;
			    var optionTous;
			    
			    $(select).empty();
			    
			    $.each(selectsParents, function (j, selParent)
			    {
			    	if (selParent.selectedIndex == 0)
		    		{
			    		tousLesParentsFiltrent = false;
		    		}
			    });
			    
			    if (!tousLesParentsFiltrent)
			    {
			    	$.each(lstFiltrante.valeurs, function (j, val)
			    	{
			    		var option = document.createElement('option');
			    		option.appendChild(document.createTextNode(val));
			    		select.appendChild(option);
			    	});
			    }
			    else
		    	{
			    	optionTous = document.createElement('option');
				    optionTous.appendChild(document.createTextNode('Tous'));
				    select.appendChild(optionTous);
				    
			    	if (lstFiltrante.mapValeursEnfants[lstFiltrante.fonctionParent()] != undefined)
			    	{
				    	$.each(lstFiltrante.mapValeursEnfants[lstFiltrante.fonctionParent()], function (j, valEnfant)
		    			{
				    		var option = document.createElement('option');
				    		option.appendChild(document.createTextNode(valEnfant));
				    		select.appendChild(option);
		    			});
			    	}
		    	}
			    
		    	// Resélectionner la valeur si c'est une valeur qui filtre et elle est encore présente
		    	if (indiceInitial != 0)
		    	{
		    		for (var i = 1; i < select.options.length; ++i)
	    			{
		    			if (select.options[i].text == valeurInitiale)
	    				{
		    				select.options[i].selected = true;
		    				break;
	    				}
	    			}
		    	}
			};
			
			$.each(selectsParents, function (j, selParent)
			{
				$(selParent).change(actualiserSelonValeursParents);
				actualiserSelonValeursParents();
			});
		}
	});
}

/**
 * Affecte la valeur sp�cifi�e au champ de recherche du portail et fait en sorte qu'un texte "placeholder" soit affich� lorsque la
 * recherche est vide.
 * 
 * @param valeur la valeur � affecter au champ de recherche.
 */
function configurerChampRechercher(valeur)
{
    var $champRechercher = $('div.dataTables_filter input');
    var textePlaceholder = 'Rechercher...';
    var classePlaceholder = 'placeholder';
    
    if (valeur != null && valeur != '')
    {
    	$champRechercher[0].value = valeur;
    	$champRechercher.removeClass(classePlaceholder);
    }
    else
    {
    	$champRechercher[0].value = textePlaceholder;
    	$champRechercher.addClass(classePlaceholder);
    }
    
    $champRechercher
    .focus(function ()
    {
        if ($champRechercher.hasClass(classePlaceholder))
        {
            $champRechercher.removeClass(classePlaceholder);
           	this.value = '';
        }
    })
    .blur(function ()
    {
        if (this.value == '')
        {
            $champRechercher.addClass(classePlaceholder);
            this.value = textePlaceholder;
        }
    });
}

function genererDefinitionsColonnesDataTableRequetes(idTypeRequete, 
													 colonnesDonnees, 
													 nomChampId, 
													 nomChampIdFormulaire, 
													 urlBaseApp)
{

    var iColonneDonnees = 0;
    var widthColonneCocher = '25px';
    var pourcentWidthColonnesDonnees = 100;
    var convertirLargeurObjetColonneEnSWidth = function(largeurCol)
    {        
        if (!largeurCol || largeurCol < 0 || largeurCol > 1)
        {
            return null;
        }
        else
        {
            return colonnesDonnees[iColonneDonnees].largeur * pourcentWidthColonnesDonnees + '%';
        }
    }
    
    var definitionsColonnes = 
    [
	    {
	        "aTargets": [0],
	        "mData": null,
	        "sDefaultContent": '<input type="checkbox">',
	        "sClass": 'tableauReqCellCocher',
	        "sWidth": widthColonneCocher,
	        "bSortable": false
	    },
	    {
	        "aTargets": [1],
	        "mData": colonnesDonnees[iColonneDonnees].nom,
	        "sWidth": convertirLargeurObjetColonneEnSWidth(colonnesDonnees[iColonneDonnees].largeur),
	        
	        "mRender":
	        function(data, type, row)
	        {
	            var paramRef = idTypeRequete == null ? '' : '&ref=' + idTypeRequete;
	            
	            return '<a href="' + urlBaseApp + '/requetes/formulaire.html?idRequete=' + row[nomChampId] +
	            paramRef + '">' + data + '</a>';;
	        }
	    }
    ];
    
    var iColonne = 2;
    ++iColonneDonnees;
    
    for (iColonneDonnees; iColonneDonnees < colonnesDonnees.length; ++iColonneDonnees)
    {
        definitionsColonnes.push(
        {
            "aTargets": [iColonne],
            "mData": colonnesDonnees[iColonneDonnees].nom,
            "sWidth": convertirLargeurObjetColonneEnSWidth(colonnesDonnees[iColonneDonnees].largeur)
        });
        ++iColonne;
    }
    
    if (!tableauContientObjetAvecPropriete(colonnesDonnees, 'nom', nomChampId))
    {
        definitionsColonnes.push(
        {
        	"aTargets":[iColonne], 
        	"mData":nomChampId, 
        	"bVisible":false
        });
        ++iColonne;
    }
    
    if (!tableauContientObjetAvecPropriete(colonnesDonnees, 'nom', nomChampIdFormulaire))
    {
        definitionsColonnes.push(
        {
        	"aTargets":[iColonne], 
        	"mData":nomChampIdFormulaire, 
        	"bVisible":false
        });
        ++iColonne;
    }
    
    definitionsColonnes.push(
    {
    	"aTargets":["_all"], 
    	"mData":null
    });

    return definitionsColonnes;
}

/**
 * Initialise la fonction callback qui met un délai sur la recherche de datatable
 */
function initFonctionFiltreDelaiRechercheDatatable()
{
	if (jQuery.fn.dataTableExt.oApi.fnSetFilteringDelay === undefined)
	{
		//JQuery plugin
		//https://datatables.net/plug-ins/api
		//Enables filtration delay for keeping the browser more responsive while searching for a longer keyword.
		//Author : Zygimantas Berziunas http://www.zygimantas.com/, 
		//         Allan Jardine http://www.sprymedia.co.uk/
		//         and vex
	    jQuery.fn.dataTableExt.oApi.fnSetFilteringDelay = function ( oSettings, iDelay ) {
	        var _that = this;
	     
	        if ( iDelay === undefined ) {
	            iDelay = 1000;
	        }
	          
	        this.each( function ( i ) {
	            $.fn.dataTableExt.iApiIndex = i;
	            var
	                $this = this,
	                oTimerId = null,
	                sPreviousSearch = null,
	                anControl = $( 'input', _that.fnSettings().aanFeatures.f );
	              
	                anControl.unbind( 'keyup' ).bind( 'keyup', function() {
	                var $$this = $this;
	      
	                if (sPreviousSearch === null || sPreviousSearch != anControl.val()) {
	                    window.clearTimeout(oTimerId);
	                    sPreviousSearch = anControl.val(); 
	                    oTimerId = window.setTimeout(function() {
	                        $.fn.dataTableExt.iApiIndex = i;
	                        _that.fnFilter( anControl.val() );
	                    }, iDelay);
	                }
	            });
	              
	            return this;
	        } );
	        return this;
	    };
	}
}

function genererOrdreDeTriAvecCookie(cookies, idTypeRequete)
{
    var ordreDeTriCookie = [];
    for (var clef in cookies)
    {
    	var testCourrant = new RegExp("^iSortCol_[0-9]+_"+idTypeRequete);
    	if (testCourrant.test(clef))
    	{
    		var colnum = Number(cookies[clef]);
    		var index = clef.replace(/^iSortCol_/,'').replace(/_.*$/,'');
    		var ordre = cookies['sSortDir_'+index+'_'+idTypeRequete];
    		ordreDeTriCookie.push([colnum,ordre]);
    	}
    }
    return ordreDeTriCookie;
}

function initDataTableRequetes(idTable,
                               listesFiltrantes,
                               idTypeRequete,
                               idSousTypeRequete,
                               colonnesDonnees,
                               nomChampId,
                               nomChampIdFormulaire,
                               urlBaseApp,
                               msgTraitement,
                               modeJournal,
                               modeArchives)
{
	initFonctionFiltreDelaiRechercheDatatable();
	
    var dataTable;
    var cookies = getCookies();
    
    if (!("iDisplayLength" in cookies))
    {
    	setCookie("iDisplayLength", 25);
    }
    
    for (var i in listesFiltrantes)
    {
    	var nomChampFiltre = listesFiltrantes[i].nomChamp;
  	    var cookie_key = "filtre_" + idTypeRequete + "_" + nomChampFiltre;
        if (cookie_key in cookies)
        {
    	    $(document.getElementById(listesFiltrantes[i].idSelect)).val(cookies[cookie_key]);
    	    setCookie(cookie_key, cookies[cookie_key]);
        }
  	}
    
    var gererErreurAjax = function(xhr, texteStatut, erreur)
    {
       alert("Une erreur s'est produite sur le serveur. Veuillez réessayer plus tard.");
       dataTable.fnProcessingIndicator(false);
    };
    
    var preparerEtEnvoyerRequeteAjax = function(sSource, aoData, fnCallback)
    {
    	//preparation
    	var nouveauCookies = {};
    	var nombreColonne = 0;
    	for (var i in aoData)
    	{
    		var data = aoData[i];
    		if (data['name']=="iDisplayLength")
    		{
    			nouveauCookies["iDisplayLength"] = data["value"];
    		}
    		else if (/^sSortDir_/.test(data['name']))
    		{
    			nouveauCookies[data['name']+"_"+idTypeRequete] = data['value'];
    		}
    		else if (/^iSortCol_/.test(data['name']))
    		{
    			nouveauCookies[data['name']+"_"+idTypeRequete] = data['value'];
    		}
    		else if(/^sSearch$/.test(data['name']))
    		{
    			// La présence de la classe 'placeholder' sur le champ de recherche indique que sa valeur n'est qu'un "placeholder" et qu'elle doit être ignorée
    	    	if ($("div.dataTables_filter input").hasClass('placeholder'))
    	    	{
    	    		data['value'] = "";
    	    	}
    	    	
    			nouveauCookies[data['name']+"_"+idTypeRequete] = data['value'];
    		}
    		else if(/^iColumns$/.test(data['name']))
    		{
    			nombreColonne = data['value'];
    		}
    	}
    	
    	//vider certains cookies
    	for(var i=0;i<nombreColonne;i++)
    	{
    		resetCookie("iSortCol_"+i+"_"+idTypeRequete);
    		resetCookie("sSortDir_"+i+"_"+idTypeRequete);
    	}
    	resetCookie("sSearch_"+idTypeRequete);
    	
    	//mettre à jour les cookies
    	for (var cookie in nouveauCookies)
    	{
    		setCookie(cookie, nouveauCookies[cookie]);
    	}
    	
        for (var i in listesFiltrantes)
        {
        	var nomChampFiltre = listesFiltrantes[i].nomChamp;
            var $selFiltre = $(document.getElementById(listesFiltrantes[i].idSelect));
            var nomCookieFiltre = "filtre_" + idTypeRequete + "_" + nomChampFiltre;
            
            if ($selFiltre.length != 0
             && $selFiltre[0].options.length != 0
             && $selFiltre[0].selectedIndex > 0)
            {
                var nomChampMessage = "filtre_" + nomChampFiltre;
            	var filtreSelectionnee = $selFiltre[0].options[$selFiltre[0].selectedIndex].text;
                aoData.push(
                {
                    "name": nomChampMessage,
                    "value": filtreSelectionnee
                });
                setCookie(nomCookieFiltre,filtreSelectionnee);
            }
            else
            {
            	resetCookie(nomCookieFiltre);
            }
        }
        
        aoData.push(
        {
            "name": "type",
            "value": idTypeRequete
        });
        aoData.push(
        {
            "name": "sousType",
            "value": idSousTypeRequete
        });
        aoData.push(
        {
            "name": "modeJournal",
            "value": modeJournal
        });
        aoData.push(
        {
            "name": "modeArchives",
            "value": modeArchives
        });
    
        $.ajax(
        {
            "dataType": 'json',
            "url": sSource,
            "data": aoData,
            "cache": false,
            "success": fnCallback,
            "error": gererErreurAjax
        });
    };
    
    var decocherSelectionnerTout = function () { $('th input[type=checkbox]').prop('checked', false); };
    
    var definitionsColonnes = [{"mData":null, "bSortable":false, "aTargets":[0]}];
    if (colonnesDonnees.length != 0)
    {
        definitionsColonnes = genererDefinitionsColonnesDataTableRequetes(idTypeRequete,
                                                                          colonnesDonnees,
                                                                          nomChampId,
                                                                          nomChampIdFormulaire,
                                                                          urlBaseApp);
    }

    dataTable = $('#' + idTable).dataTable(
    {
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": urlBaseApp + "/portail/jsonDataTableRequetes.json",
        "fnServerData": preparerEtEnvoyerRequeteAjax,
        "fnDrawCallback": decocherSelectionnerTout,
        "sDom": '<"divisionFiltresEtRecherche"<"divisionFiltres">f>rt<"divisionAffichage"lp>',
        "sPaginationType": "full_numbers",
        "bAutoWidth" : false,
        "aoColumnDefs": definitionsColonnes,
        "iDisplayLength": Number(cookies["iDisplayLength"]) || 25,
        "aaSorting": genererOrdreDeTriAvecCookie(cookies,idTypeRequete),
        "oSearch": {"sSearch":getCookies()["sSearch_"+idTypeRequete] || ""},
        "oLanguage":
        {
            "sEmptyTable": "",
            "sInfo": "_TOTAL_ requête(s)",
            "sInfoEmpty": "0 requête(s)",
            "sInfoFiltered": " (filtrées de _MAX_)",
            "sInfoPostFix": "",
            "sInfoThousands": "&nbsp;",
            "sLengthMenu": "Afficher&nbsp:&nbsp;_MENU_",
            "sLoadingRecords": "Chargement...",
            "sProcessing": msgTraitement,
            "sSearch": "",
            "sUrl": "",
            "sZeroRecords": "Aucune requête à afficher.",            
            
            "oPaginate":
            {
                "sFirst": "<<",
                "sLast": ">>",
                "sPrevious": "<",
                "sNext": ">"
            },
       
            "oAria":
            {
                "sSortAscending": " : activez pour trier par ordre croissant.",
                "sSortDescending": " : activez pour trier par ordre décroissant."
            }
        }
    });
    
    if (listesFiltrantes)
    {
        configurerListesFiltrantes(dataTable, listesFiltrantes)
    }
    
    configurerChampRechercher(cookies["sSearch_"+idTypeRequete]);
    
    dataTable.fnSetFilteringDelay(500);
}

function calculCurrentDate(valeurGauche, valeurDroite)
{
	var retour = "";

	if (valeurGauche && valeurDroite && valeurDroite.length > 2)
	{
		var d = null;
		var type = valeurDroite.substr(valeurDroite.length - 2, 2);
		var addition = Number(valeurDroite.substr(0, valeurDroite.length - 2));
		
		if (!isNaN(addition))
		{
			switch(type)
			{
				case "AA" :
				{
					d = Date.parse(valeurGauche).add(addition).year();
					break;
				}
				case "MM" :
				{
					d = Date.parse(valeurGauche).add(addition).month();
					break;
				}
				case "JJ" :
				{
					d = Date.parse(valeurGauche).add(addition).day();
					break;
				}
				default:
				{
					d = Date.parse(valeurGauche);
				}
			}
			retour = d.toString("yyyy-MM-dd");
		}
	}
		
	return retour;
}

function calculCurrentTime(valeurGauche, valeurDroite)
{
	var retour = "";

	if (valeurGauche && valeurDroite && valeurDroite.length > 2)
	{
		var d = null;
		var type = valeurDroite.substr(valeurDroite.length - 2, 2);
		var addition = Number(valeurDroite.substr(0, valeurDroite.length - 2));
		
		if (!isNaN(addition))
		{
			switch(type)
			{
				case "hh" :
				{
					d = Date.parse(valeurGauche).add(addition).hour();
					break;
				}
				case "mm" :
				{
					d = Date.parse(valeurGauche).add(addition).minute();
					break;
				}
				default:
				{
					d = Date.parse(valeurGauche);
				}
			}
			retour = d.toString("H:mm");
		}
	}
		
	return retour;
}

var rendu = 0;
function ajoutFichiersJoints(nomNoeud, additionnalClass)
{
	var fileIndex = rendu;
    $("#" + nomNoeud + "Table").append("\n" +
        "<tr class=\"" + nomNoeud + fileIndex + "\">" +
        "<td class=\"" + nomNoeud + fileIndex + "\">" + "\n" +
        "<div id=\"" + nomNoeud + fileIndex + "div\"" +
            " class=\"ReqReg_impression " + additionnalClass + "\"></div>" +
        "<input id=\"" + nomNoeud + fileIndex + "Hidden\" type=\"hidden\" name=\"" + nomNoeud + "\" disabled/>" +
        "<input type=\"file\"" +
             " id=\"" + nomNoeud + fileIndex + "File\"" +
             " name=\"" + nomNoeud + "[" + fileIndex + "]\"" +
             " class=\"" + nomNoeud + fileIndex + " NoPrint " + additionnalClass + "\"/>" +
         "<input type=\"text\"" +
             " id=\"" + nomNoeud + fileIndex + "Champ\"" +
             " value=\""+ nomNoeud + "\"" +
             " name=\"" + "nomChamps" + "[" + fileIndex + "]\"" +
             " class=\"" + nomNoeud + fileIndex + " " + additionnalClass + " desactive " + "\"/>" + "\n" +
         "<input id=\"" + nomNoeud + fileIndex + "Enlever\" type=\"button\"" +
             " class=\"NoPrint " + nomNoeud + fileIndex + "\"" +
             " name=\"ac_fichier_remove\"" +
             " value=\"Enlever le fichier\"/>" + "\n" +
        "</td>" +
        "</tr>"
    );
    rendu++;
    
    $(document.getElementById(nomNoeud + fileIndex + 'File')).change(function()
    {
        var nomFichierAvecChemin = $(this).val();
        var nomFichierSansChemin = nomFichierAvecChemin.substring(nomFichierAvecChemin.lastIndexOf('\\') + 1);
        
        $(document.getElementById(nomNoeud + fileIndex + 'Hidden')).val(nomFichierSansChemin);
        $(document.getElementById(nomNoeud + fileIndex + 'div')).text(nomFichierSansChemin);
        $(document.getElementById(nomNoeud + 'fixClassesConditionnellesFichierJoint')).change();
    });
    
    $('#' + nomNoeud + fileIndex + 'Enlever').click(function()
    {
        $('.' + nomNoeud + fileIndex).remove();
        $(document.getElementById(nomNoeud + 'fixClassesConditionnellesFichierJoint')).change();
    });
}

function enleverFichierJoint(test, id)
{
	$("#" + test).remove();
	creerInputHiddenActionServeur('conteneurEnleverFichier' + id, 'Action_EnleverFichier', id.toString(), '');
}

/**
 * Préinitialise l'affichage des choix multiple filtrés selon les données contenu dans l'élément dont l'attribut name est <CODE>nomElementRef</CODE> 
 * et active les choix correspondant dans la table <CODE>tableDeFiltre</CODE>
 * 
 * @param nomElementRef nom de l'élément référencer par le filtre
 * @param tableDeFiltre table des données associer au valeur de l'élément référencer par le filtre
 */
function preparerFiltre(nomElementRef, tableDeFiltre)
{
    filtrerValeurChamp(nomElementRef, tableDeFiltre);
}

/**
 * Actualise l'affichage de choix multiples filtrés, selon les valeurs du champ avec le nom spécifié et la liste associative spécifiée.
 * 
 * @param nomChampFiltrant nom du champ filtrant
 * @param idsParFiltre liste associative avec les valeurs filtrantes comme clés et les IDs des champs à afficher comme valeurs
 */
function filtrerValeurChamp(nomChampFiltrant, idsParFiltre)
{
    var valeursChampFiltrant, filtre, val, i, j;
    
    for (filtre in idsParFiltre)
    {
        for (i = 0; i < idsParFiltre[filtre].length; ++i)
        {
            ChangementFiltre("false", "#" + idsParFiltre[filtre][i]);
        }
    }

    valeursChampFiltrant = getValeursChamp(nomChampFiltrant);
    for (i = 0; i < valeursChampFiltrant.length; ++i)
    {
        val = valeursChampFiltrant[i].replace("'", "\\'");
        
        if (idsParFiltre[val] != undefined)
        {
            for (j = 0; j < idsParFiltre[val].length; ++j)
            {
                ChangementFiltre("true", "#" + idsParFiltre[val][j]);
            }
        }
    }
}

/**
 * Cette fonction permet d'émuler le comportement d'un 'placeholder' html5 
 * pour champ de texte. Utile pour avoir ce comportement avec des fureteurs obsolètes tel IE9.
 * Remarquons également que nous maintenons à jour l'attribut class de l'élément afin de savoir sans équivoques 
 * si la valeur qu'il contient est (ou non) le placeholder.
 *
 * @param htmlElementTexteId : le id html unique de l'élément de type texte pour lequel on veut émuler le comportement de 'placeholder'.
 */
function preparerPlaceholderElementTexte(htmlElementTexteId)
{	
	$(document).ready(function()
	{	
		var classePlaceholder = "placeholder";
		var elementTexte = $("#" + htmlElementTexteId);
		var longueurMax = elementTexte.attr("maxlength");
		var utiliserLongueurMax = false;
		var valeurParDefaut = elementTexte.attr("placeholder") == "" ? "" : elementTexte.attr("placeholder");
		
		if (typeof longueurMax !== 'undefined')
		{
		    utiliserLongueurMax = true;
		}
		
		if (elementTexte.val() == "")
		{
			elementTexte.val(valeurParDefaut);
			elementTexte.addClass(classePlaceholder);
		}
		
		elementTexte.focus(function() 
		{
			var valeurChamp = elementTexte.val();
			var valeurPlaceholder = elementTexte.attr("placeholder");
			if (utiliserLongueurMax)
			{
				valeurChamp = valeurChamp.substring(0, longueurMax);
				valeurPlaceholder = valeurPlaceholder.substring(0, longueurMax);
			}		
			
			if (elementTexte.hasClass(classePlaceholder))
		    {
				elementTexte.val("");
				elementTexte.removeClass(classePlaceholder);
		    }
		});
		
		elementTexte.blur(function() 
		{
			var valeurChamp = elementTexte.val();
			var valeurPlaceholder = elementTexte.attr("placeholder");
			if (utiliserLongueurMax)
			{
				valeurChamp = valeurChamp.substring(0, longueurMax);
				valeurPlaceholder = valeurPlaceholder.substring(0, longueurMax);
			}
			
			if (valeurChamp == "")
		    {
		        elementTexte.val(elementTexte.attr("placeholder"));
		        elementTexte.addClass(classePlaceholder);
		    }
		});
	});
}

/**
 * Diffère la configuration du filtrage d'un champ liste jusqu'à ce que l'initialisation du document soit complétée. La configuration du
 * filtrage inclut un premier filtrage selon la valeur initiale du champ filtrant, de même que l'ajout des gestionnaires d'événements
 * nécessaires pour effectuer un refiltrage à chaque 'change' du champ filtrant.
 * 
 * @param nomChampFiltrant le nom du champ filtrant
 * @param idSelect l'ID de l'élément 'select' représentant le champ liste dont les valeurs sont à filtrer
 * @param paramFiltrage un paramètre spécifiant comment filtrer. Peut être une liste associative faisant correspondre chaque valeur
 *                      filtrante à un tableau de valeurs filtrées (dans le cas d'un filtrage entièrement fait côté client) ou le nom d'une
 *                      liste disponible sur le serveur (dans le cas d'un filtrage AJAX, fait à l'aide d'une requête vers le serveur à
 *                      chaque fois que le champ filtrant change de valeur).
 * @param placeholder On peut le voir comme un texte substitue à la valeur vide d'un select.
 *                    Quand il est non nul, il doit apparaitre comme texte de la premiere option du select qui le contient.
 *                    Il doit également avoir une valeur vide (l'option) pour que le texte ne soit pas sauvegardé.                    
 * @param modeApi booléen spécifiant si l'API a été utilisé pour effectuer la requête.
 */
function preparerFiltrageChampListe(nomChampFiltrant, idSelect, paramFiltrage, placeholder, modeApi)
{
	$(document).ready(function ()
	{
		var select = document.getElementById(idSelect);
		var valeurInitialeSelect = select.value;
		var doGetValeursFiltrees;
		var filtrerValeursChampListe;
		
		if (typeof(paramFiltrage) == 'object')
		{
			doGetValeursFiltrees = function (valeurFiltrante)
			{
				return paramFiltrage[valeurFiltrante.replace("'", "\\'")] || [];
			};
		}
		else
		{
			doGetValeursFiltrees = function (valeurFiltrante)
			{
				var valeursFiltrees = [];
				
				$.ajax({
					url: (modeApi ? '/Requetes/api/web/v1/' : '/Requetes/requetes/') + 'donnees/' + encodeURIComponent(paramFiltrage) + '.json',
					data: { filtre: valeurFiltrante },
					method: 'GET',
					dataType: 'json',
					cache: false,
					async: false,
					success: function (data)
					{
						valeursFiltrees = data["valeurs"];
					},
					error: function ()
					{
						var lblSelect = $("#" + select.name + "lbl").html();
						alert('Impossible de récupérer du serveur les options pour le champ «\u00A0' + lblSelect + '\u00A0».');
					}
				});
				
				return valeursFiltrees;
			}
		}
		
		filtrerValeursChampListe = function ()
		{
			var valeursChampFiltrant = getValeursChamp(nomChampFiltrant);
			$(select).empty();
			
			var optionVide = document.createElement('option');
            optionVide.appendChild(document.createTextNode(placeholder));
            optionVide.value = '';
            select.appendChild(optionVide);
			$.each(valeursChampFiltrant, function (i, valChampFiltrant)
			{
				var valeursFiltrees;
			
				if (valChampFiltrant != '')
				{
					valeursFiltrees = doGetValeursFiltrees(valChampFiltrant);
					
					if (valeursFiltrees.length > 0)
					{
						$.each(valeursFiltrees, function (j, valFiltree)
						{
							var option = document.createElement('option');
							option.appendChild(document.createTextNode(valFiltree));
							option.value = valFiltree;
							select.appendChild(option);
						});
					}
				}
			});
		};

        filtrerValeursChampListe();
		select.value = valeurInitialeSelect;
		
		$(document.getElementsByName(nomChampFiltrant)).filter('[name=' + nomChampFiltrant + ']').change(function ()
		{
			var selectAvaitValeur = select.value != '';
			
			filtrerValeursChampListe();
			if (selectAvaitValeur)
			{
				$(select).change();
			}
		});
	});
}

/**
 * Change les donnée de l'élément que JQuery trouvera avec <CODE>rechercheElement</CODE> 
 * selon les donnée contenu dans l'élément dont l'attribut <CODE>name=</CODE> 
 * nomElementRef avec les données contenue dans <CODE>tableDeFiltre</CODE>
 *  
 * @param nomElementRef nom de l'élément référencer par le filtre
 * @param rechercheElement critère de recherche JQuery de l'élément destination
 * @param tableDeFiltre table des données associer au valeur de l'élément référencer par le filtre
 */
function filtreChampTexte(nomElementRef, rechercheElement ,tableDeFiltre)
{
	var valeursChampLie = getValeursChamp(nomElementRef);
	var element = $(rechercheElement);
	element.val("").change();
	for(var filtre in tableDeFiltre)
	{
		if($.inArray(filtre,valeursChampLie)!=-1)
		{
			element.val(tableDeFiltre[filtre]);
			element.change();
		}
	}
}

/**
 * Cherche si la donnée recherchée est présente dans les sous arrays
 * 
 * @param indexRecherche index d'une rangée contenant seulement des valeurs uniques.
 * @param arrayDarray Un array deux dimension contenant les lignes selectionnées.
 * @param valeurRecherchee Valeur recherchée dans les sous Arrays.
 * @returns {Boolean} si la valeur est présente ou non.
 */
function siPresentDansArray(indexRecherche, arrayDarray, valeurRecherchee)
{
	var present = false;
	
	for (var i = 0; i < arrayDarray.length; i++)
	{
		if (arrayDarray[i][indexRecherche] == valeurRecherchee)
			present = true;
	}

	return present;
}

/**
 * Cherche si la donnée recherchée est présente dans les sous arrays d'un array deux dimensions et retourne l'index de l'array la contenant.
 * 
 * @param indexRecherche index d'une rangée contenant seulement des valeurs uniques.
 * @param arrayDarray Un array deux dimension contenant les lignes selectionnées.
 * @param valeurRecherchee Valeur recherchée dans les sous Arrays.
 * @returns {Number} index de l'array contenant la valeur recherchée ou null si l'index n'est pas trouvé.
 */
function indexCorrespondant(indexRecherche, arrayDarray, valeurRecherchee)
{
	for(var i = 0; i < arrayDarray.length; i++)
	{
		if(arrayDarray[i][indexRecherche] == valeurRecherchee)
		{
			return i;
		}
	}
	return null;
}

/*******************************************************************************
 PICKLIST
 ******************************************************************************/
/**
 * picklistJSON
 * {
        'donneeSelectionne' : [ listes des éléments déjà selectionné, vide par défaut ],
        'definitionsColonnes' : [{},{},{}] definition de colonne pour le datatable ,
        'champCible' : [ liste de nom de champ qui recevron le resultat de selection du picklist ] ,
        'selectionMultiple' : boolean si la selection est multiple ,
        'nomTable' : id du dialogue (popup), 
        'nomNoeud : id du champ,
        'index' : indice servant à la selection multiple,
        'nomVue' : nom de la vue pour l'accès BD,
        'nomColonneFiltre' : nom de la colonne filtre pour l'accès BD,
        'nomChampFiltre' : nom du champ dont la valeur sert de filtre pour l'accès BD,
        'selecteurBoutonOuvrire' : "#boutonOuvrirePicklist" + nomNoeud,
        'selecteurBoutonFermer' : "#boutonFermerPicklist" + nomNoeud,
        'selecteurDialogue' : "#dialog" + nomNoeud,
        'dejaInitialise' : false simple variable à initialiser à false et qui empeche le picklist d'être initialiser deux fois
 * }
 */

/**
 * Assigne les valeures Selectionné du picklist et le ferme.
 * 
 * @param picklistJSON structure de données du picklist concerné
 */
function fermePopulPicklist(picklistJSON)
{
	var champRendu = 0;
	
	for(var numValeur = 0; numValeur < picklistJSON['champCible'].length; numValeur ++)
	{
		var valeursRetournee = new Array();
		for(var donneesChamp = 0; donneesChamp < picklistJSON['donneeSelectionne'].length; donneesChamp ++)
		{
			valeursRetournee[donneesChamp] = picklistJSON['donneeSelectionne'][donneesChamp][numValeur];
		}
		var element = document.getElementsByName(picklistJSON['champCible'][numValeur]);
		$(element).val(valeursRetournee);
		$(element).change();
	}	

	$(picklistJSON['selecteurDialogue'] ).dialog('close');
}

/**
 * Convertit en un array de chaînes l'élément <code>tr</code> spécifié. Le premier élément de l'array retourné est le contenu textuel du premier
 * <code>td</code>, le second élément est le contenu textuel du second <code>td</code>, et ainsi de suite.
 * 
 * @param tr l'élément <code>tr</code> à convertir en array.
 * @returns l'array de chaînes résultant de la conversion du <code>tr</code> spécifié.
 */
function convertirTrEnArray(tr)
{
	var array = [];
	$(tr).find("td").each(function ()
	{
		array.push($(this).text());
	});
	
	return array;
}

/**
 * Selectionne une rangée et l'ajoute à la selection courante.
 * 
 * @param ranger Rangée courament sélectionnée.
 * @param picklistJSON structure de données du picklist concerné
 * @returns Array 2D des rangées sélectionnées.
 */
function selectMulti(ranger, picklistJSON) 
{
	var index = picklistJSON['index'];
	var arrayTr = convertirTrEnArray(ranger);
	var jsonArrayTr = JSON.stringify(convertirTrEnArray(ranger));
	
	if (picklistJSON['index'] != null)
	{
		if ($(ranger).is('.row_selected'))
		{
			picklistJSON['donneeSelectionne'].push(arrayTr);
		}
		else
		{
			picklistJSON['donneeSelectionne'].splice(indexCorrespondant(index, picklistJSON['donneeSelectionne'], $(ranger).find('td:eq(' + index + ')').text()), 1);
		}
	}
	else
	{
		// Si aucun 'index' n'est spécifié, on considère que tous les 'tr's avec exactement le même contenu représente le même élément
		
		if ($(ranger).is('.row_selected'))
		{
			$(ranger).siblings('tr').each(function ()
			{
			    if (JSON.stringify(convertirTrEnArray(this)) == jsonArrayTr)
		    	{
			    	$(this).addClass('row_selected');
		    	}
			});
			
			picklistJSON['donneeSelectionne'].push(arrayTr);
		}
		else
		{
			$(ranger).siblings('tr').each(function ()
			{
			    if (JSON.stringify(convertirTrEnArray(this)) == jsonArrayTr)
		    	{
			    	$(this).removeClass('row_selected');
		    	}
			});
			
			for (var i = 0; i < picklistJSON['donneeSelectionne'].length; ++i)
			{
				if (JSON.stringify(picklistJSON['donneeSelectionne'][i]) == jsonArrayTr)
				{
					picklistJSON['donneeSelectionne'].splice(i--, 1)
				}
			}
		} 
	}
	
	return picklistJSON['donneeSelectionne'];
}

/**
 * Selectionne une rangée dans le picklist et retourne l'object avec les collonnes sélectionnées.
 * 
 * @param ranger Rangée courament sélectionnée
 * @param picklistJSON structure de données du picklist concerné
 * @returns Array 2D des rangées sélectionnées.
 */
function selectSolo(ranger, picklistJSON) 
{
	var nomTable = picklistJSON['nomTable'];
	var nomNoeud = picklistJSON['nomNoeud'];
	var nomChamp = picklistJSON['champCible'];
	picklistJSON['donneeSelectionne'] = new Array();

	$('#' + nomTable + " tr").removeClass('row_selected');
	$(ranger).addClass('row_selected');
	var CurrentSelection = convertirTrEnArray(ranger);
	picklistJSON['donneeSelectionne'].push(CurrentSelection);
	fermePopulPicklist(picklistJSON);
		
	return picklistJSON['donneeSelectionne'];
}

/**
 * Ajoute les éléments déjà selectionné dans l'object.
 * 
 * @param picklistJSON structure de données du picklist concerné
 * @returns Object des rangées selectionnées.
 */
function preSelection(picklistJSON) 
{
	var selecteur = document.getElementsByName(picklistJSON['champCible'][0]);
	var contenuChampText = $(selecteur).val();
	
	if (contenuChampText == null)
	{
		var contenuChamp = [];
	}
	else
	{
		var contenuChamp = contenuChampText.split(",");
	}
	
	for (var i = 0; i < contenuChamp.length; i++)
	{
		var colonneSelectionnee = [];
		var contientValeursNonVides = false;
		
		for (var j = 0; j < picklistJSON['champCible'].length; j++)
		{
			var colonne = picklistJSON['champCible'][j];
			var valeursChampCible = colonne != undefined && colonne != '' ? getValeursChamp(colonne) : [];
			
			if (valeursChampCible.length != 0 && valeursChampCible[0] != '')
			{
				colonneSelectionnee.push(valeursChampCible[0].split(",")[i]);
				contientValeursNonVides = true;
			}
			else
			{
				colonneSelectionnee.push('');
			}
		}
		
		if (colonneSelectionnee.length != 0 && contientValeursNonVides)
		{
			picklistJSON['donneeSelectionne'].push(colonneSelectionnee);
		}
	}
	
	return picklistJSON['donneeSelectionne'];
}

/**
 * Initialisation du picklist a partir du JSON donnée.
 * 
 * @param picklistJSON structure de données du picklist concerné
 */
function generePickListAvecJSON(picklistJSON, url)
{
	$(picklistJSON['selecteurBoutonOuvrire']).click(function ()
	{
	    if (!picklistJSON['dejaInitialise'])
	    {
		    picklistJSON['dejaInitialise'] = true;
	    	picklistJSON['donneeSelectionne'] = preSelection(picklistJSON);
	    	
            initFonctionFiltreDelaiRechercheDatatable();
	    	var dataTable = $('#' + picklistJSON['nomTable']).dataTable(genereDatatablePourPickList(picklistJSON, url));
            dataTable.fnSetFilteringDelay(500);
	    }
	    else
	    {
	    	$(picklistJSON['selecteurDialogue']).dialog('open');
	    }
    });
    
    $(picklistJSON['selecteurBoutonFermer']).click(function ()
    {
        fermePopulPicklist(picklistJSON);
    });
	
	$(document.getElementsByName(picklistJSON['nomChampFiltre'])).filter('[name=' + picklistJSON['nomChampFiltre'] + ']').change(function ()
	{
		$.each(picklistJSON['champCible'], function (i, nomChampCible)
		{
			$(document.getElementsByName(nomChampCible)).filter('[name=' + nomChampCible + ']').val(['']).change();
		});
		
		if (!$(picklistJSON['selecteurBoutonOuvrire']).hasClass('readonly'))
		{
			$(picklistJSON['selecteurBoutonOuvrire']).prop('disabled', champEstVide(this.name));
		}

		picklistJSON['donneeSelectionne'] = [];
		picklistJSON['dejaInitialise'] = false;
	});
	
	if (picklistJSON['nomChampFiltre'] != '' && !$(picklistJSON['selecteurBoutonOuvrire']).hasClass('readonly'))
	{
		$(picklistJSON['selecteurBoutonOuvrire']).prop('disabled', champEstVide(picklistJSON['nomChampFiltre']));
	}
}

/**
 * Genere le popup du picklist
 * 
 * @param picklistJSON structure de données du picklist concerné
 */
function genereDatatablePourPickList(picklistJSON, url)
{
	var datatableStruct = 
	{
		"bDestroy": true,
		"bProcessing": true,
		"bServerSide": true,
		"sAjaxSource": url,
		"sDom": '<"divisionRecherche"f>rt<"divisionAffichage"lp>',
		"sPaginationType": "full_numbers",
		"aoColumnDefs": picklistJSON['definitionsColonnes'],
		"iDisplayLength": Number(getCookies()["iDisplayLength_" + picklistJSON["nomVue"]]) || 50,
		"fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull)
		{
			if (picklistJSON['index'] != null)
            {
				var searchedValue = $('td:eq(' + picklistJSON['index'] + ')', nRow).html();
				
				if (searchedValue != '' && siPresentDansArray(picklistJSON['index'], picklistJSON['donneeSelectionne'], searchedValue))
				{
					$(nRow).addClass('row_selected');
				}
			}
			else
			{
				// Si aucun 'index' n'est spécifié, tout le contenu du 'tr' doit correspondre à un élément précédemment sélectionné pour être resélectionné
				
				var jsonArrayTr = JSON.stringify(convertirTrEnArray(nRow));

				$.each(picklistJSON['donneeSelectionne'], function (i, rangee)
				{
					if (JSON.stringify(rangee) == jsonArrayTr)
					{
						$(nRow).addClass('row_selected');
					}
				});
			}
			 
			return nRow;
		},
		"fnInitComplete": function(oSettings, json)
		{
		    $(picklistJSON['selecteurDialogue'] + ' div.dataTables_length select').change(function()
		    {
		        setCookie("iDisplayLength_" + picklistJSON["nomVue"], this.value);
		    });
		    
		    // Doit être exécuté une fois l'initialisation du DataTable complétée pour que position/height/width soient calculées correctement
		    // https://bugs.jqueryui.com/ticket/4053
		    $(picklistJSON['selecteurDialogue']).dialog(
			{
			    autoOpen : true,
			    draggable : true,
		        resizable : false,
		        height : 'auto',
		        width : '80%',
		        modal: true
			});
		},
		"fnDrawCallback": function (oSettings)
		{
	        $("#" + picklistJSON['nomTable'] + " tr:not([role=row])").click(function ()
    		{
	        	if (picklistJSON['selectionMultiple']!=true)
	        	{
		        	picklistJSON['donneeSelectionne'] = selectSolo(this, picklistJSON);
	        	}
	        	else
	    		{
		        	$(this).toggleClass('row_selected');
		        	picklistJSON['donneeSelectionne'] = selectMulti(this, picklistJSON);
	    		}
	        });
		},
		"oLanguage":
		{
			"sEmptyTable": "",
			"sInfo": "_TOTAL_ donnée(s)",
			"sInfoEmpty": "0 donnée(s)",
			"sInfoFiltered": " (filtrées de _MAX_)",
			"sInfoPostFix": "",
			"sInfoThousands": "&nbsp;",
			"sLengthMenu": "Afficher&nbsp;:&nbsp;_MENU_",
			"sLoadingRecords": "Chargement...",
			"sProcessing": "En traitement",
			"sUrl": "",
			"sZeroRecords": "Aucune donnée à afficher.",
			"sSearch": "Rechercher :",
			"oPaginate":
			{
				"sFirst": "◀◀",
				"sLast": "▶▶",
				"sPrevious": "◀",
				"sNext": "▶"
			},
			"oAria":
			{
				"sSortAscending": " : activez pour trier par ordre croissant.",
				"sSortDescending": " : activez pour trier par ordre décroissant."
			}
		},
		"fnServerParams": function (aoData) 
		{
			var valeurFiltre = getValeursChamp(picklistJSON['nomChampFiltre'])[0];
			
			aoData.push(
			{
				"name": "vue_SQL", 
				"value": picklistJSON['nomVue']
			});
			
			if (valeurFiltre != '')
			{
				aoData.push(
				{
					"name": "nomColonneFiltre", 
					"value": picklistJSON['nomColonneFiltre']
				});
				
				aoData.push(
				{
					"name": "valeurFiltre", 
					"value": valeurFiltre
				});
			}
			
			for (var i in picklistJSON['definitionsColonnes'])
			{
				var colonne = picklistJSON['definitionsColonnes'][i];
				aoData.push(
				{
					"name" : "mRechercheProp_"+colonne['aTargets'][0],
					"value" : ("desactive"!=colonne['sClass'])
				});
			}
		}
	};
	
	return datatableStruct;
}

/*******************************************************************************
 * COOKIE
*******************************************************************************/
/**
 * Obtenire une liste associative à l'image des cookies stocké.
 * 
 * @returns liste assocative de cookie;
 */
function getCookies()
{
	var cookieStrLst = document.cookie.split(';');
	var cookieJson = {};
	for(var i in cookieStrLst) 
	{
		var cookieStr = cookieStrLst[i];
		var key = cookieStr.replace(/=.*$/g,"").replace(/^\s+|\s+$/g, '');
		var value = cookieStr.replace(/^.*=/g,"").replace(/^\s+|\s+$/g, '');
		cookieJson[decodeURIComponent(key)] = decodeURIComponent(value);
	}
	return cookieJson;
}

/**
 * Ajoute ou modifie un cookie. Ces dernier expire dans une années.
 * 
 * @param key étant la clé qui permet de trouver les données
 * @param value étant la valeurs associé à la clé.
 */
function setCookie(key, value)
{
	if (value!=null && value!="")
	{
		var expire = new Date();
		expire.setYear(expire.getYear ()+1);
		document.cookie=encodeURIComponent(key)+"="+encodeURIComponent(value)+";expires=" + expire.toGMTString();
	}
	else
	{
		//IE8 si l'on set null dans un cookie, le cookie s'ajoute avec son propre nom comme valeur
		resetCookie(key);
	}
}

/**
 * detruit un cookie.
 * 
 * @param key Ã©tant la clÃ© qui permet de trouver les donnÃ©es
 */
function resetCookie(key)
{
	var expire = new Date();
	expire.setYear(expire.getYear ()-1);
	document.cookie=encodeURIComponent(key)+"=expiree;expires=Thu, 01 Jan 1970 00:00:00 GMT";
}

/*******************************************************************************
 *CONDITION 
 ******************************************************************************/

/*
 * listeControleJSON 
 * [
	{
		'verifControleLie' : "",
		'controlesAffectees' : [],
	},
 * ]
 * */
/**
 * Initialise la vérification des condition.
 * @param listeControleJSON structure de donne en JSON qui contient toute l'information sur la condition et les id affecté.
 * @param verifFunctor      fonction annonyme qui effectu la vérification et retourne un booleen sur echec
 * @param classeAffectee    classe à affecter au id en cas d'echec de validation
 */
function verifcontrolInit(listeControleJSON,verifFunctor,classeAffectee)
{
	for (var j in listeControleJSON)
	{
		var controleJSON = listeControleJSON[j];
		var controlesAffectees = controleJSON['controlesAffectees'];
		var nomControleLie = controleJSON['verifControleLie'];
		var functor = function()
		{
			var condition = verifFunctor();
			for (var i in controlesAffectees)
				if(condition)
					$(controlesAffectees[i]).addClass(classeAffectee);
				else
					$(controlesAffectees[i]).removeClass(classeAffectee);
		}
		
		functor();
		$(document.getElementsByName(nomControleLie)).filter('[name="' + nomControleLie + '"]').change(function()
        {
	        functor();
        });
	}
}

/*******************************************************************************
 *CONTENEUR DYNAMIQUE 
 ******************************************************************************/

/**
 * JSON attendu
 * {
 * 	"rendu" : [0-9]+,
 * 	"nomIdAdd" : "",
 * 	"nouveauContenu" : "<html...",
 * 	"nomChamp" : "",
 * 	"suffix" : "trid",
 * 	"type" : "RANGEE",
 * 	"nomIdLength" : "",
 * }
 */

/**
 * initialise la r�p�tition du conteneur dynamique
 * @param JSON structure de donn�e d�crivant le conteneur dynamique � r�p�ter
 */
function initialiseRepetitionConteneurDynamique(JSON)
{
	$('#' + JSON['nomIdAdd']).click(function() 
	{  
		JSON['rendu']++; 
		var nouveaucontenu = JSON['nouveauContenu']; 
		ajouterRangeeRepetee(JSON);
	}); 
	
	$('#' + JSON['nomIdDelete']).click(function() 
	{ 
		if(JSON['rendu'] > 0) 
		{ 
			$('#'+JSON['nomChamp']+JSON['rendu']+JSON['suffix']).remove(); 
			JSON['rendu']--; 
			$('#' + JSON['nomIdLength']).val(JSON['rendu']);
		} 
	}); 
}

/**
 * Ajoute une rangée répétée à l'index spécifié et en respectant le HTML de base fourni en paramêtre.
 * 
 * @param JSON structure de donn�e d�crivant le conteneur dynamique � r�p�ter
 */
function ajouterRangeeRepetee(JSON)
{
	var html = batirHtmlRangee(JSON);
	var idTr = JSON['nomChamp'] + JSON['rendu'];
	ajouterTr(JSON, html, idTr);
	reinitialiserDatePicker(idTr);
	reinitialiserTimePicker(idTr);
	
	$('#' + JSON['nomIdLength']).val(JSON['rendu']);
}

/**
 * Bâtit le HTML de la nouvelle rangée à partir du HTML de base.
 * 
 * @param JSON structure de donn�e d�crivant le conteneur dynamique � r�p�ter
 * 
 * @returns le HTML de la nouvelle rangée.
 */
function batirHtmlRangee(JSON)
{
	var html = JSON['nouveauContenu'];
	
	$("#" + JSON['nomChamp'] + "trid").children().find('input, select, textarea, p').each(function()
	{
	    if($(this).is('input, select, textarea'))
	    {
	    	var nomCourant = $(this).attr("name");
	    	var nouveauNom = JSON['nomChamp'] + JSON['rendu'] + nomCourant;
	    	html = remplacerNomDansHtml(nomCourant, nouveauNom, html);
	    }
	    else
	    {
	    	var currentId = $(this).attr("id");
	    	html = html.replace(new RegExp(currentId, "g"), JSON['nomChamp'] + JSON['rendu'] + currentId);
	    }
	});
	
	return html;
}

/**
 * Ajoute un nouveau tr à la page avec le contenu spécifié en paramêtre.
 * 
 * @param JSON structure de donn�e d�crivant le conteneur dynamique � r�p�ter
 * @param html le HTML représentant la rangée.
 * @param idTr l'id du tr à créer.
 */
function ajouterTr(JSON, html, idTr)
{
	if(JSON['rendu'] == 1)
	{
		$("#" + JSON['nomChamp'] + "trid").after("<tr id=\"" + idTr + "trid\">" + html + "</tr>");
	}
	else
	{
		$("#" + JSON['nomChamp'] + (JSON['rendu'] - 1) + "trid").after("<tr id=\"" + idTr + "trid\">" + html + "</tr>");
	}
}


/**
 * Remplace le nom de l'élément courant avec son nouveau nom. À noter que la string du nom est remplacée et non pas l'attribut nom lui-même.
 * 
 * @param nomCourant le nom courant.
 * @param nouveauNom le nouveau nom.
 * @param html le HTML à modifier.
 * 
 * @returns le HTML modifié.
 */
function remplacerNomDansHtml(nomCourant, nouveauNom, html)
{
	html = html.replace(new RegExp('"' + nomCourant, "g"), "\"" + nouveauNom);
	html = html.replace(new RegExp('#' + nomCourant, "g"), "#" + nouveauNom);
	html = html.replace(new RegExp("'" + nomCourant, "g"), "'" + nouveauNom);
	html = html.replace(new RegExp('=' + nomCourant, "g"), "=" + nouveauNom);
	html = html.replace(new RegExp('=' + nomCourant, "g"), "=" + nouveauNom);
	html = html.replace(new RegExp("'." + nomCourant, "g"), "'." + nouveauNom);
	
	return html;
}

/*******************************************************************************
 *Portail imprimable
 ******************************************************************************/

function initialiserBoutonVersionImprimablePortail(cheminContextuel)
{
	$(document).ready(function ()
	{
		var nomFenetre = 'VersionImprimable_' + new Date().getTime();
			
		$('#portailVersionImprimable').click(function ()
		{
			var requetes = $('td [type=checkbox]:checked').parent()  //obtenir le td
			                                              .parent()  //obtenir le tr
			                                              .find('a') //trouver le lien
			                                              .map(function () { return $(this).attr('href').match(/idRequete=[0-9]+/); })
			                                              .get()     //transformer le resultat en list
			                                              .join('&');//concatener avec des s�parateur '&'
			
			if (requetes != null && requetes.replace(/^\s+|\s+$/g, '') != "")
			{
				var lien = cheminContextuel + requetes;
				window.open('about:blank', nomFenetre, 'resizable=yes').focus();
				window.open(lien + '&_=' + new Date().getTime(), nomFenetre);
			}
		});
	});
}

/**
 * Initialise l'evenement bouton impression du portail.
 * 
 * @param cheminContextuel est le lien vers le bon type de formulaire
 */
function initialiserBoutonImpressionPortail(cheminContextuel)
{
	$(document).ready(function(){
		$('#portailImprimable').click(function(){
			var requetes = $('td [type=checkbox]:checked').parent()  //obtenir le td
			                                              .parent()  //obtenir le tr
			                                              .find('a') //trouver le lien
			                                              .map(function(){return $(this).attr('href').match(/idRequete=[0-9]+/)})
			                                              .get()     //transformer le resultat en list
			                                              .join('&');//concatener avec des s�parateur '&'
			if (requetes != null && requetes.replace(/^\s+|\s+$/g, '') != "")
			{
				var lien = cheminContextuel + requetes;
				window.location.href = lien;
			}
		});
	});
}


/*******************************************************************************
 *WORKAROUNDS POUR BUGS IE
 ******************************************************************************/

/**
 * Fix pour un bug spécifique à Internet Explorer 8. Lors de l'impression d'éléments 'input' de type 'checkbox' ou
 * 'radio', IE8 semble tenir compte de l'attribut 'checked' plutôt que de la propriété. Voir
 * http://www.sitepoint.com/forums/showthread.php?663679-Working-around-a-serious-IE8-bug
 */
function ie8FixImpressionCheckboxEtRadio()
{
    $(document).ready(function()
    {
        $('input[type="checkbox"]').change(function()
        {
            if (this.checked)
            {
                this.setAttribute('checked', 'checked');
            }
            else
            {
                this.removeAttribute('checked');
            }
        });

        // Tient compte du fait que change ne sera appelé que sur le bouton coché dans le cas d'un change "organique"
        // mais que change peut également être appelé "programmatiquement" sur des boutons décochés.
        $('input[type="radio"]').change(function()
        {
            if (this.checked)
            {
                $('input[type="radio"][name="' + this.name + '"]').not(this).each(function()
                 {
                    this.removeAttribute('checked');
                 });
                
                this.setAttribute('checked', 'checked');
            }
            else
            {
                this.removeAttribute('checked');
            }
        });
   });
}

/*******************************************************************************
 *ACTION
 ******************************************************************************/
function imprimerControl(currentDialog, prefixeId)
{
	$("input[type=file],select,textarea").each(function()
	{				
		setHiddenPrintDiv(this);
	});

	var noeudDialog = document.getElementById(prefixeId + currentDialog + "_dialog");
	$(noeudDialog).dialog("close");
	
    var contenuDialogue = noeudDialog.innerHTML;
	
    var nouvelleFenetre = window.open('', 'printwin', 'left=100,top=100,width=400,height=400');

    var contenuImpression = '<HTML>\n' +
    							'<HEAD>\n' +
    								'<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">' +
    								'<meta http-equiv="X-UA-Compatible" content="IE=edge">' +
    								document.getElementById("appliedStyle").outerHTML +
    								document.getElementById("printStyle").outerHTML +
    								'<TITLE>Contenu Imprime</TITLE>\n' +
    								'<script>\n' +
    									'function fermeFenetreLorsqueComplete()' + 
    									'{\n' + 
    										'if(document.readyState=="complete")' +
    										'{\n' +
    											'window.close()\n' +
											'}\n' +
											'else' + 
											'{\n' +
												'setTimeout("fermeFenetreLorsqueComplete()",2000)\n' +
											'}\n' +
										'}\n' +
										'function print_win()' + 
										'{\n' +
											'window.print();\n' +
											'fermeFenetreLorsqueComplete();\n' +
										'}\n' +
    								'<\/script>\n' +
								'</HEAD>\n' +
								'<BODY onload="print_win()">\n' +
									contenuDialogue +
								'</BODY>\n' +
							'</HTML>\n';
    
    nouvelleFenetre.document.write(contenuImpression);
    nouvelleFenetre.document.close();
}

function imprimerForm()
{
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('imprimerForm : entrée');
	
	window.print();
	
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('imprimerForm : sortie');
}

/**
 * Charge ou recharge la version imprimable du formulaire dans une fenêtre "pop-up". La fonction ouvre une nouvelle fenêtre au premier appel
 * et réutilise cette fenêtre lors des appels subséquents. La version imprimable est un document PDF.
 */
function popUpFenetreVersionImprimable(modeApi)
{
    var formTemp = document.createElement('form');
    var idFormulaire = $('input.idFormulaire').val();
    var fenetre;

    $('form, div.dialogue').find('input, select, textarea').each(function ()
    {
    	if ((this.type != 'radio' && this.type != 'checkbox') || this.checked)
        {
	    	formTemp.appendChild(creerInputHidden(this.name, this.value));
        }
    });
    
    formTemp.appendChild(creerInputHidden('ReqReg_IdType', idFormulaire));
    
	// Avoir plusieurs fenêtres qui partagent toutes la même fenêtre pour afficher différents PDFs semble être problématique avec IE. On 
	// fait donc en sorte que chaque page ait sa propre fenêtre de version imprimable, en générant un nom de fenêtre pseudo-unique à la
	// premi�re exécution de la fonction.
	if (typeof popUpFenetreVersionImprimable.nomFenetre == 'undefined')
	{
		popUpFenetreVersionImprimable.nomFenetre = 'VersionImprimable_' + new Date().getTime();
	}
	
	// Aussi, avec IE, il semble nécessaire de spécifier 'about:blank' plutôt que '' comme premier paramètre à 'window.open' avant d'appeler
	// 'focus' sur la fenêtre. Voir :
	// http://stackoverflow.com/questions/987572/opening-a-popup-in-ie-member-not-found
	fenetre = window.open('about:blank', popUpFenetreVersionImprimable.nomFenetre, 'resizable=yes');
	fenetre.focus();

	formTemp.target = popUpFenetreVersionImprimable.nomFenetre;
	if (modeApi)
	{
		formTemp.action = '/Requetes/api/web/v1/versionImprimable.pdf?idTypeRequete=' + idFormulaire;
	}
	else
	{
		formTemp.action = '/Requetes/requetes/versionImprimable.pdf?idTypeRequete=' + idFormulaire;
	}

	formTemp.method = 'post';

	document.body.appendChild(formTemp);
	formTemp.submit();
	document.body.removeChild(formTemp);
}

/**
 * Assigne au champ avec le nom spécifié la valeur spécifiée, à l'aide du préfixe spécifié.
 * 
 * @param nomChamp le nom du champ auquel assigner une valeur.
 * @param valeur la valeur à assigner. Il est possible de référer à la valeur d'un autre champ en spécifiant son nom entre crochets (p. ex. '[autreChamp]').
 * @param prefixeIds la chaîne avec laquelle préfixer les noms de champs pour obtenir leur nom complet dans le document HTML.
 */
function assignerValeur(nomChamp, valeur, prefixeIds)
{
	var nomCompletChamp = prefixeIds + nomChamp;
	var $champCible = $(document.getElementsByName(nomCompletChamp)).filter(':input[name="' + nomCompletChamp + '"]').not(':button');
	var anciennesValeurs = getValeursChamp(nomCompletChamp);
	var nouvellesValeurs = [valeur];
	
	if (/^\[.+\]$/.test(valeur))
	{
		nouvellesValeurs = getValeursChamp(prefixeIds + valeur.slice(1, -1));
	}
	
	$champCible.val(nouvellesValeurs);
    if (!comparerArray(anciennesValeurs, nouvellesValeurs))
    {
        $champCible.change();
    }
}

function openLinkedDialog(currentDialog, prefixeId)
{
    $(document.getElementById(prefixeId + currentDialog + "_dialog")).dialog("open");
}

function submitForm()
{
	// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('submitForm : entrée');
	
	var classePlaceholder = "placeholder";
    var $formulaire = $('form');

	// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("submitForm : $('form').length == " + $formulaire.length);
    
    // Fait en sorte que soient inclus dans la soumission m�me les champs avec la classe 'readonly' (qui sont 'disabled')
    // et les champs dans les dialogues (qui sont � l'ext�rieur du formulaire).
    $('form :input.readonly, div.dialogue :input').not(':button').each(function ()
    {
        if (this.type == 'radio' || this.type == 'checkbox')
        {
            if (this.checked == true)
            {
                $formulaire.append(creerInputHidden(this.name, this.value));
            }
        }
        else
        {
            $formulaire.append(creerInputHidden(this.name, this.value));
        }
    });
	
    //Vide la valeur des elements contenant la valeur 'placeholder'.
    //Si un élément a la 'class' placeholder définie, alors il contient la valeur du placeholder.
    //Cette mécanique est dans les fonctions implanterPlaceholderElementListe et implanterPlaceholderElementTexte.
    //On ne veut pas persister de telles valeurs (une valeur égale au placeholder).
    $("." + classePlaceholder).val("");
    
	// Désactive les boutons pour éviter les doubles soumissions et soumet le formulaire.
    $('.boutton').prop('disabled', true);
    
    $formulaire.submit();
    
    // TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('submitForm : sortie');
}

// TODO Doc
function creerInputHidden(nom, valeur)
{
	var inputHidden = document.createElement('input');
	inputHidden.type = 'hidden';
	inputHidden.name = nom;
	inputHidden.value = valeur;
	
	return inputHidden;
}

function creerInputHiddenActionServeur(id,actionNom,valeur1, valeur2, prefixeId)
{
	jQuery.fn.exists = function(){return this.length>0;}
	
	var mainForm = $("form");

	var $conteneur = $(document.getElementById(id));
	if($conteneur.exists())
	{
		var newButton = $conteneur;
	}
	else
	{
		var newButton=document.createElement('input');
	}
	
	newButton.type='hidden';
	newButton.value="valeur1=\"" +valeur1.replace(new RegExp("\"","g"), "\\\"") + "\"; " +
	   				"valeur2=\"" + valeur2.replace(new RegExp("\"","g"), "\\\"") +"\";";
	newButton.id=id;
	newButton.name=actionNom;
	mainForm.append(newButton);
}

function executeAction(listeActions, modeApi)
{
	// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation(('executeAction : entrée'));
	
	var soumission = false;
	var i;

	// Les actions qui peuvent influencer le résultat de l'action 'verification' sont prioritaires
	for (i = 0; i < listeActions.length; ++i)
	{
		if (listeActions[i][0] == "assignationValeurClient" && listeActions[i][4])
		{
			// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
			loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("Action 'assignationValeurClient' (valeur:" + listeActions[i][1] + "; valeur2:" + listeActions[i][2] + ")");
			
			assignerValeur(listeActions[i][1], listeActions[i][2], listeActions[i][3]);
		}
	}
	
	// Si présente, l'action 'verification' peut court-circuiter la séquence des actions
	for (i = 0; i < listeActions.length; ++i)
	{
		if (listeActions[i][0] == "verification" && listeActions[i][4])
		{
			// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
			loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("Action 'verification' (valeur:" + listeActions[i][1] + "; valeur2:" + listeActions[i][2] + ")");
			
			if (!verification())
			{
				// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
				loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("Action 'verification' a retourné 'false' - fin de la séquence d'actions");
				return;
			}
		}
	}
	
	// Les autres actions sont traitées dans l'ordre spécifié
	for (i = 0; i < listeActions.length; ++i)
	{
	    var type = listeActions[i][0];
	    var valeur = listeActions[i][1];
	    var valeur2 = listeActions[i][2];
	    var prefixeIds = listeActions[i][3];
	    var appliquer = listeActions[i][4];
	    
		if (appliquer && type != "verification" && type != "assignationValeurClient")
		{
			// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
			loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation("Action '" + type + "' (valeur:" + listeActions[i][1] + "; valeur2:" + listeActions[i][2] + ")");
			
			switch (type)
			{
			    case "imprime":
			    {
				    imprimerForm();
				    break;
			    }
			    case "versionImprimable":
			    {
			    	popUpFenetreVersionImprimable(modeApi);
			    	break;
			    }
			    case "imprimeContent":
			    {
			    	imprimerControl(valeur, prefixeIds);
			    	break;
			    }
				case "dialogOpener":
			    {
					openLinkedDialog(valeur, prefixeIds);
					break;
			    }
				case "submit":
				{
					soumission = true;
					break;
				}
				case "courriel":
				{
					creerInputHiddenActionServeur('conteneur'+ valeur +'Courriel',
												  'Action_Courriel',
												  valeur, valeur2, prefixeIds);
					soumission = true;
					break;
				}
				case "assignationValeur":
				{
					creerInputHiddenActionServeur('conteneurAssignationValeur' + valeur,
												  'Action_AssignationValeur',
												  valeur, valeur2, prefixeIds);
					soumission = true;
					break;
				}
				case "creationExtraRequete":
				{
					creerInputHiddenActionServeur('conteneurCreationExtraRequete'+ valeur + valeur2,
		                      					  'Action_CreationExtraRequete',
												  valeur, valeur2, prefixeIds);
					soumission = true;
					break;
				}
				case "assignationValeurComplexe":
				{
					creerInputHiddenActionServeur('conteneurAssignationValeurComplexe' + valeur,
							  'Action_AssignationValeurComplexe',
							  valeur, valeur2, prefixeIds);
					soumission = true;
					break;
				}
				case "envoiHTTP":
				{
					creerInputHiddenActionServeur('conteneur' + valeur + 'EnvoiHTTP',
        					                      'Action_EnvoiHTTP',
							                       valeur, valeur2, prefixeIds);
					soumission = true;
					break;
				}
				default:
				{
					// Première lettre en majuscule
					var nomType = type.charAt(0).toUpperCase() + type.slice(1);
					var idConteneur = 'conteneur'+nomType;
					var action = 'Action_' + nomType;
					creerInputHiddenActionServeur(idConteneur,
												  action,
												  valeur,
												  valeur2, 
												  prefixeIds);
					soumission = true;
					break;
				}
			}
		}
	}
	
	// Si au moins une action est une action serveur, soumettre
	if (soumission == true)
	{
		// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
		loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('Soumission du formulaire');
		
		submitForm();
	}
	
	// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
	loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('executeAction : sortie');
}

function genereAction(listeActions, modeApi)
{
	executeAction(listeActions, modeApi);
}

/**
 * Ajoute une entrée de niveau DEBUG au journal de l'application côté serveur.
 * 
 * @param message le message de l'entrée à ajouter.
 */
function loguerDebugAuServeur(message)
{
	$.ajax({
		url: '/Requetes/logging/debug.json',
		method: 'POST',
		data:
		{
			temps: new Date().getTime(),
			message: message
		}
	});
}

/**
 * Ajoute une entrée de niveau ERROR au journal de l'application côté serveur.
 * 
 * @param message le message d'erreur.
 * @param source l'URL de la source de l'erreur.
 * @param noLigne le numéro de la ligne où l'erreur a été rencontrée.
 */
function loguerErrorAuServeur(message, source, noLigne)
{
	$.ajax({
		url: '/Requetes/logging/error.json',
		method: 'POST',
		data:
		{
			temps: new Date().getTime(), 
			message: message,
			source: source,
			noLigne: noLigne
		}
	});
}

//TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
function loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation(message)
{
	if (/idTypeRequete=(52|107|161|217|225|231|235|242|248|249|272)/.test(window.location.href) && !/idRequete=/.test(window.location.href))
	{
		loguerDebugAuServeur(message);
	}
}

// TODO Enlever après avoir réglé le bogue des requêtes qui ne sont pas créées
loguerDebugAuServeurSiFormulaireImprime2XEtEnCreation('Sortie de ScriptClient.js');