/*!
 *
 * jQuery TE 1.4.0 , http://jqueryte.com/
 * Copyright (C) 2013, Fatih Koca (fattih@fattih.com), (http://jqueryte.com/about)

 * jQuery TE is provided under the MIT LICENSE.
 *
*/

/**
		//EXEMPLE OF USE FOR BAR BUTTON ORDER AND
		//ADDING ONE BUTTON

		t.jqte( {
			toolbar: "format fsize color bcolor | b i u strike | ol ul sup sub outdent indent | left center right | link unlink | rule remove source",
			buttons: function() {
				buttons.push(
				{
					name:"bcolor", cls:"bcolor", command:'BackColor', key:'', tag:'', 
					emphasis:false, title: "Back color", hotkeyname: null, 
					onSelect: function(data, selectedElem) {
						applySelectedStyle("rgb("+data+")", "background-color")
					}, 
					list: {
						datas: [
							"0,0,0","68,68,68","102,102,102","153,153,153","204,204,204","238,238,238","243,243,243","255,255,255",
							null,
							"255,0,0","255,153,0","255,255,0","0,255,0","0,255,255","0,0,255","153,0,255","255,0,255",
							null,
							"244,204,204","252,229,205","255,242,204","217,234,211","208,224,227","207,226,243","217,210,233","234,209,220",
							"234,153,153","249,203,156","255,229,153","182,215,168","162,196,201","159,197,232","180,167,214","213,166,189",
							"224,102,102","246,178,107","255,217,102","147,196,125","118,165,175","111,168,220","142,124,195","194,123,160",
							"204,0,0","230,145,56","241,194,50","106,168,79","69,129,142","61,133,198","103,78,167","166,77,121",
							"153,0,0","180,95,6","191,144,0","56,118,29","19,79,92","11,83,148","53,28,117","116,27,71",
							"102,0,0","120,63,4","127,96,0","39,78,19","12,52,61","7,55,99","32,18,77","76,17,48"
						],
						listType: ListType.GRID,
						listMaxSize: 8,
						onBuild: function (data) {
							return $("<div>").addClass(vars.css+"_color").css("background-color","rgb("+data+")");
						}
					}
				});
			}
		});
**/



(function($){		
	$.fn.jqte = function(options){
	
		//sub element list type
		var ListType = {
			VLIST: 1,
			HLIST: 2,
			GRID:  3	//In grid, null value is an horizontal blank separator
		};
		// default text formats
		var formats = [
			["p","Normal"],
			["h1","Header 1"],
			["h2","Header 2"],
			["h3","Header 3"],
			["h4","Header 4"],
			["h5","Header 5"],
			["h6","Header 6"],
			["pre","Preformatted"]
		];
		
		// default font sizes
//		var fsizes = ["85%","95%","115%","125%","135%","155%","175%"];
		var fsizes = ["10","12","16","18","20","24","28"];
		
		// default rgb values of colors
		var colors = [
		"0,0,0","68,68,68","102,102,102","153,153,153","204,204,204","238,238,238","243,243,243","255,255,255",
		null,
		"255,0,0","255,153,0","255,255,0","0,255,0","0,255,255","0,0,255","153,0,255","255,0,255",
		null,
		"244,204,204","252,229,205","255,242,204","217,234,211","208,224,227","207,226,243","217,210,233","234,209,220",
		"234,153,153","249,203,156","255,229,153","182,215,168","162,196,201","159,197,232","180,167,214","213,166,189",
		"224,102,102","246,178,107","255,217,102","147,196,125","118,165,175","111,168,220","142,124,195","194,123,160",
		"204,0,0","230,145,56","241,194,50","106,168,79","69,129,142","61,133,198","103,78,167","166,77,121",
		"153,0,0","180,95,6","191,144,0","56,118,29","19,79,92","11,83,148","53,28,117","116,27,71",
		"102,0,0","120,63,4","127,96,0","39,78,19","12,52,61","7,55,99","32,18,77","76,17,48"
		];
		
		// default link-type names
		var linktypes = ["Web Address","E-mail Address","Picture URL"];
		
		var vars = $.extend({
			// options
			'status'		: true,
			'css' 			: "jqte",
			'title'			: true,
			'button'		: "OK",
			'format'		: true,
			'formats'		: formats,
			'fsize' 		: true,
			'fsizes'		: fsizes,
			'funit'			: "px",
			'color'			: true,
			'linktypes'		: linktypes,
			'b' 			: true,
			'i' 			: true,
			'u' 			: true,
			'ol' 			: true,
			'ul' 			: true,
			'sub'			: true,
			'sup'			: true,
			'outdent'		: true,
			'indent'		: true,
			'left'			: true,
			'center'		: true,
			'right'			: true,
			'strike'		: true,
			'link'			: true,
			'unlink'		: true,
			'remove'		: true,
			'rule'			: true,
			'source'		: true,
			'placeholder'	: false,
			'br'			: true,
			'p'				: true,
			'toolbar'		: null,	//To edit order and separator : have preceance on any other setting : 
									//"format fsize color | b i u strike | ol ul sub sup outdent indent | left center right | link unlink | rule remove source"
			'buttons'		: [],	//To add buttons
			// events
			'change'		: "",
			'focus'			: "",
			'blur'			: ""
		}, options);
		
		return this.each(function(){

			
			var defaultListElement = [];
			defaultListElement[ListType.VLIST] = {
				datas: 	[],
				listType: ListType.VLIST,
				listMaxSize: 8,					//Number of visible
				onBuild: function (data) {
					return $("<span class='"+vars.css+"_hover_list'>"+data+"</span>");
				}
			}
			defaultListElement[ListType.HLIST] = {
				datas: [],
				listType: ListType.HLIST,
				listMaxSize: 8,					//Number of visible
				onBuild: function (data) {
					return $("<span class='"+vars.css+"_hover_list'>"+data+"</span>");
				}
			}
			defaultListElement[ListType.GRID] = {
				datas: [],
				listType: ListType.GRID,
				listMaxSize: 8,					//Number horizontal griddata
				onBuild: function (data) {
					return $("<span class='"+vars.css+"_hover_grid'>"+data+"</span>");
				}
			}
			
			//Specific elements onSelect function (use wrapper cause true function are defined later
			function selectColor(data, selectedElem) {
				applySelectedStyle("rgb("+data+")", "color")
			}
			function selectBColor(data, selectedElem) {
				applySelectedStyle("rgb("+data+")", "background-color")
			}
			function selectFSize(data, selectedElem) {
				applySelectedStyle(data + vars.funit, "font-size")
			}
			function selectFormat(data, selectedElem) {
				var butLabel = jQTE.find("."+vars.css+"_tool_"+selectedElem.data("button").cls+" ."+vars.css+"_tool_label ."+vars.css+"_tool_text");
				formatLabelView(selectedElem.text(), butLabel);
				selectionSet("formatBlock","<"+data[0]+">");
			}
			function selectAppliedStyle(data, selectedElem) {
				selectionSet(data,null);
			}
			
			//Specific elements
			var colorsListElement = {
				datas: colors,
				listType: ListType.GRID,
				listMaxSize: 8,
				onBuild: function (data) {
					return $("<div>").addClass(vars.css+"_color").css("background-color","rgb("+data+")");
				}
			}
			var fontsListElement = {
				datas: fsizes,
				listType: ListType.VLIST,
				listMaxSize: 8,
				onBuild: function (data) {
					return $("<a>").addClass(vars.css+"_hover_list").addClass(vars.css+"_fontsize").css("font-size", data+"px").text("Abcdefgh...");
				}
			}
			var formatsListElement = {
				datas: $.isArray(vars.formats)?vars.formats:formats,
				listType: ListType.VLIST,
				listMaxSize: 8,
				onBuild: function (data) {
					var elem = $('<a '+vars.css+'-formatval="'+ data[0] +'" class="'+vars.css+'_format'+' '+vars.css+'_format_'+data[0]+'" role="menuitem" unselectable>'+ data[1] +'</a>');
					return elem;
				}
			}
			
			var linkForm = {
				onOpen: function(mainDiv) {
					var linkinput = mainDiv.find("input");
				//	var linktypes = mainDiv.find("."+vars.css+"_linktypes")
				//	var linktypeview = mainDiv.find("."+vars.css+"_linktypeview")
//					var linkbutton = mainDiv.find("."+vars.css+"_linkbutton")

					var selectedTag = getSelectedNode(); // the selected node
					var thisHrefLink = "http://"; // default the input value of the link-form-field
					var setdatalink = vars.css+"-setlink";

					if(selectedTag)
					{
						var thisTagName  = selectedTag.prop('tagName').toLowerCase();
						
						// if tag name of the selected node is "a" and the selected node have "href" attribute
						if(thisTagName == "a" && selectedTag.is('[href]'))
						{
							thisHrefLink = selectedTag.attr('href');
							selectedTag.attr(setdatalink,"");
						}
						// if it don't have "a" tag name
						else {
							replaceSelection("a",setdatalink,"");
						}
					}
					else {
						linkinput.val(thisHrefLink).focus();
					}
					
//					linkInputSet(thisHrefLink);
					
					// the method of link-input
					linkinput
						// auto focus
						.focus()
						// update to value
						.val(thisHrefLink);
						
								


				},
				onBuild: function(mainDiv, fnOnFinish) {
					// add to some tools in link form area
					var linktypeselect = $('<div class="'+vars.css+'_linktypeselect" unselectable></div>');
					var linkinput = $('<input class="'+vars.css+'_linkinput" type="text/css" value="">');
					var linkbutton = $('<div class="'+vars.css+'_linkbutton" unselectable>'+vars.button+'</div> <div style="height:1px;float:none;clear:both"></div>');
					mainDiv.append(linktypeselect).append(linkinput).append(linkbutton);
					
					// add to the link-type-selector sub tool parts
					var linktypes = $('<div class="'+vars.css+'_linktypes" role="menu" unselectable></div>');
					var linktypeview = $('<div class="'+vars.css+'_linktypeview" unselectable></div>');
					var setdatalink = vars.css+"-setlink";
					linktypeselect.append(linktypeview).append(linktypes);

					var thisHrefLink = "http://"; // default the input value of the link-form-field
					
					// the default value of the link-type
					linktypes.data("linktype","0");
					
					// add link types to link-type-selector
					for(var n = 0; n < 3; n++)
					{
						linktypes.append('<a '+vars.css+'-linktype="'+n+'" unselectable>'+vars.linktypes[n]+'</a>');
						linktypeview.html('<div class="'+vars.css+'_linktypearrow" unselectable></div><div class="'+vars.css+'_linktypetext">'+linktypes.find('a:eq('+linktypes.data("linktype")+')').text()+'</div>');
					}
					// the event of click link-button
					linkbutton.click(function()
					{
						linkRecord(jQTE.find("["+setdatalink+"]"));
						fnOnFinish();
					});	
					
					linkinput
						// the event of key to enter in link-input
						.bind("keypress keyup",function(e)
						{
							if(e.keyCode==13)
							{
								linkbutton.trigger("click");
								return false;
							}
						});
						
					// the method of displaying-hiding to link-types
					linktypeselect.click(function(e)
					{
						if($(e.target).hasClass(vars.css+"_linktypetext") || $(e.target).hasClass(vars.css+"_linktypearrow"))
							linktypeSwitch(true);
					});
					
					// the method of selecting to link-types
					linktypes.find("a").click(function()
					{
						var thisLinkType = $(this).attr(vars.css+"-linktype");
						
						linktypes.data("linktype",thisLinkType)
						
						linktypeview.find("."+vars.css+"_linktypetext").html(linktypes.find('a:eq('+linktypes.data("linktype")+')').text());
						
						linkInputSet(thisHrefLink);
						
						linktypeSwitch();
					});

					function linktypeSwitch(status)
					{
						if(status)
							linktypes.show();
						else
							linktypes.hide();
					}
					
					// the function of updating the link-input according to the link-type
					function linkInputSet(thisHrefLink)
					{
						var currentType = linktypes.data("linktype");
						
						// if selected type of e-mail
						if(currentType=="1" && (linkinput.val()=="http://" || linkinput.is("[value^=http://]") || !linkinput.is("[value^=mailto]"))) 
							linkinput.val("mailto:");
						else if(currentType!="1" && !linkinput.is("[value^=http://]"))
								linkinput.val("http://");
						else
							linkinput.val(thisHrefLink);
					}
					
					// the function of updating editor
					function linkRecord(thisSelection)
					{
						// focus to link-input
						linkinput.focus();
						
						// select to the selected node
						selectText(thisSelection);
						
						// remove pre-link attribute (mark as "link will be added") of the selected node
						thisSelection.removeAttr(setdatalink);
						
						// if not selected to link-type of picture
						if(linktypes.data("linktype")!="2")
							selectionSet("createlink",linkinput.val()); // insert link url of link-input to the selected node
						// if selected to link-type of picture
						else
						{
							selectionSet("insertImage",linkinput.val()); // insert image url of link-input to the selected node

							// the method of all pictures in the editor
							editor.find("img").each(function(){
								var emptyPrevLinks = $(this).prev("a");
								var emptyNextLinks = $(this).next("a");
								
								// if "a" tags of the front and rear of the picture is empty, remove
								if(emptyPrevLinks.length>0 && emptyPrevLinks.html()=="")
									emptyPrevLinks.remove();
								else if(emptyNextLinks.length>0 && emptyNextLinks.html()=="")
									emptyNextLinks.remove();
							});
						}

						// export contents of the text to the sources
						editor.trigger("change");
					}
				}
			}

			
			// methods
			$.fn.jqteVal = function(value){
				$(this).closest("."+vars.css).find("."+vars.css+"_editor").html(value);
			}
			
			// browser information is received
			var thisBrowser = navigator.userAgent.toLowerCase();
			
			// if browser is ie and it version is 7 or even older, close title property
			if(/msie [1-7]./.test(thisBrowser))
				vars.title = false;
			
			var buttons = [];
			
			// insertion function for parameters to toolbar
			function addParams(name,command,key,tag,emphasis, cssNo, title, hotkeyname, onSelect, subListElement, label, form)
			{
				return buttons.push({name:name, cls:cssNo, command:command, key:key, tag:tag, emphasis:emphasis, title: title, hotkeyname: hotkeyname, onSelect: onSelect, list: subListElement, label: label, form: form});
			};
			
			// add parameters for toolbar 
			//			name	command					key		tag				emphasis	cssNo/cls	title			hotkeyname			onSelect				subListElement		label
			addParams('format'	,'formats'				,''		,''				,false, "format"		,"Text Format"		,null			,selectFormat			,formatsListElement	,vars.formats[0][1].length>0 && vars.formats[0][1]!="undefined" ? vars.formats[0][1] : ""); // text format button  --> no hotkey
			addParams('fsize'	,'fSize'				,''		,''				,false, "fsize"			,"Font Size"		,null			,selectFSize			,fontsListElement); // font size button --> no hotkey
			addParams('color'	,'colors'				,''		,''				,false, "fcolor"		,"Color"			,null			,selectColor 			,colorsListElement); // text color button  --> no hotkey
			addParams('bcolor'	,'BackColor'			,''		,''				,false, "bcolor"		,"Highlight color"	,null			,selectBColor 			,colorsListElement); // text background color button  --> no hotkey
			addParams('b'		,'Bold'					,'B'	,["b","strong"]	,true,  "bold"			,"Bold"				,"B"			,selectAppliedStyle); // bold --> ctrl + b
			addParams('i'		,'Italic'				,'I'	,["i","em"]		,true,  "italic"		,"Italic"			,"I"			,selectAppliedStyle); // italic --> ctrl + i
			addParams('u'		,'Underline'			,'U'	,["u"]			,true,  "underline"		,"Underline"		,"I"			,selectAppliedStyle); // underline --> ctrl + u
			addParams('ol'		,'insertorderedlist'	,'¾'	,["ol"]			,true,  "point_list"	,"Ordered List"		,"."			,selectAppliedStyle); // ordered list --> ctrl + .(dot)
			addParams('ul'		,'insertunorderedlist'	,'¼'	,["ul"]			,true,  "number_list"	,"Unordered List"	,","			,selectAppliedStyle); // unordered list --> ctrl + ,(comma)
			addParams('sub'		,'subscript'			,'('	,["sub"]		,true,  "subscript"		,"Subscript"		,"down arrow"	,selectAppliedStyle); // sub script --> ctrl + down arrow
			addParams('sup'		,'superscript'			,'&'	,["sup"]		,true,  "superscript"	,"Superscript"		,"up arrow"		,selectAppliedStyle); // super script --> ctrl + up arrow
			addParams('outdent'	,'outdent'				,'%'	,["blockquote"]	,false, "left_indent"	,"Outdent"			,"left arrow"	,selectAppliedStyle); // outdent --> ctrl + left arrow
			addParams('indent'	,'indent'				,'\''	,["blockquote"]	,true,  "right_indent"	,"Indent"			,"right arrow"	,selectAppliedStyle); // indent --> ctrl + right arrow
			addParams('left'	,'justifyLeft'			,''		,''				,false, "ha_left"		,"Justify Left"		,null			,selectAppliedStyle); // justify Left --> no hotkey
			addParams('center'	,'justifyCenter'		,''		,''				,false, "ha_center"		,"Justify Center"	,null 			,selectAppliedStyle); // justify center --> no hotkey
			addParams('right'	,'justifyRight'			,''		,''				,false, "ha_right"		,"Justify Right"	,null			,selectAppliedStyle); // justify right --> no hotkey
			addParams('strike'	,'strikeThrough'		,'K'	,["strike"]		,true,  "strike"		,"Strike Through"	,"K"			,selectAppliedStyle); // strike through --> ctrl + K
			addParams('link'	,'linkcreator'			,'L'	,["a"]			,true,  "link"			,"Add Link"			,"L"			,function() {}			,null				,null,	linkForm); // insertion link  --> ctrl + L
			addParams('unlink'	,'unlink'				,''		,["a"]			,false, "unlink"		,"Remove Link"		,null			,selectAppliedStyle); // remove link --> ctrl + N 
			addParams('remove'	,'removeformat'			,'.'	,''				,false, "cleanstyle"	,"Cleaner Style"	,"Delete"		,selectAppliedStyle); // remove all styles --> ctrl + delete
			addParams('rule'	,'inserthorizontalrule'	,'H'	,["hr"]			,false, "hr"			,"Horizontal Rule"	,"H"			,selectAppliedStyle); // insertion horizontal rule --> ctrl + H
			addParams('source'	,'displaysource'		,''		,''				,false, "displaysource"	,"Source" 			,''				,function() {}); // feature of displaying source

			//The only way I found to repport the environtment context here.  If we cant have the context, we must change a little
			//the api to pass it en params to let the buttons to be fully context independant
			if ( $.isFunction(vars.buttons) ) {
				var fnS = vars.buttons+"";
				fnS = fnS.substring(13,fnS.length-1);
				eval(fnS);
/*			if ( $.isArray(vars.buttons) ) {
				for (var i = 0; i < vars.buttons.length; i++) {
					buttons.push(vars.buttons[i]);
				}*/
			}
			if(!$(this).data("jqte") || $(this).data("jqte")==null || $(this).data("jqte")=="undefined")
				$(this).data("jqte",true);
			else 
				$(this).data("jqte",false);
			
			// is the status false of the editor
			if(!vars.status || !$(this).data("jqte"))
			{
				// if wanting the false status later
				if($(this).closest("."+vars.css).length>0)
				{
					var editorValue	= $(this).closest("."+vars.css).find("."+vars.css+"_editor").html();
					
					// add all attributes of element
					var thisElementAttrs = "";
					
					$($(this)[0].attributes).each(function()
					{
						if(this.nodeName!="style")
							thisElementAttrs = thisElementAttrs+" "+this.nodeName+'="'+this.nodeValue+'"';
					});
					
					var thisElementTag = $(this).is("[data-origin]") && $(this).attr("data-origin")!="" ? $(this).attr("data-origin") : "textarea";
					
					// the contents of this element
					var createValue	= '>'+editorValue;
					
					// if this element is input or option
					if(thisElementTag=="input" || thisElementTag=="option")
					{
						// encode special html characters
						editorValue = editorValue.replace(/"/g,'&#34;').replace(/'/g,'&#39;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
						
						// the value of this element
						createValue	= 'value="'+editorValue+'">';
					}
					
					var thisClone = $(this).clone();
					
					$(this).data("jqte",false).closest("."+vars.css).before(thisClone).remove();
					thisClone.replaceWith('<'+ thisElementTag + thisElementAttrs + createValue + '</'+thisElementTag+'>');
				}
				return;
			}
			
			// element will converted to the jqte editor
			var thisElement = $(this);
			
			// tag name of the element
			var thisElementTag = $(this).prop('tagName').toLowerCase();
			
			// tag name of origin
			$(this).attr("data-origin",thisElementTag);
			
			// contents of the element
			var thisElementVal = $(this).is("[value]") || thisElementTag == "textarea" ? $(this).val() : $(this).html();
			
			// decode special html characters
			thisElementVal = thisElementVal.replace(/&#34;/g,'"').replace(/&#39;/g,"'").replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&amp;/g,'&');
			
			// start jqte editor to after the element
			$(this).after('<div class="'+vars.css+'"></div>');
			
			// jqte
			var jQTE = $(this).next('.'+vars.css);
			
			// insert toolbar in jqte editor
			jQTE.html('<div class="'+vars.css+"_toolbar"+'" role="toolbar" unselectable></div><div class="'+vars.css+'_form-list"></div><div class="'+vars.css+"_editor"+'"></div>');
			
			var toolbar			= jQTE.find('.'+vars.css+"_toolbar"); // the toolbar variable
			var editor			= jQTE.find('.'+vars.css+"_editor"); // the text-field of jqte editor
			var emphasize		= vars.css+"_tool_depressed"; // highlight style of the toolbar buttons

			// create to the source-area
			editor.after('<div class="'+vars.css+'_source '+vars.css+'_hiddenField"></div>');
			
			var sourceField = jQTE.find("."+vars.css+"_source"); // the source-area variable
			
			// move the element to the source-area
			thisElement.appendTo(sourceField);
			
			// if the element isn't a textarea, convert this to textarea
			if(thisElementTag!="textarea")
			{
				// add all attributes of element to new textarea (type and value except)
				var thisElementAttrs = "";
				
				$(thisElement[0].attributes).each(function(){
					if(this.nodeName!="type" && this.nodeName!="value")
						thisElementAttrs = thisElementAttrs+" "+this.nodeName+'="'+this.nodeValue+'"';
				});
				
				// convert the element to textarea
				thisElement.replaceWith('<textarea '+thisElementAttrs+'>'+thisElementVal+'</textarea>');
				
				// update to variable of thisElement
				thisElement = sourceField.find("textarea");
			}

			// add feature editable to the text-field ve copy from the element's value to text-field
			editor.attr("contenteditable","true").html(thisElementVal);

			// if we have a toolbar setting, we gonna order buttons list
			var fromToolBarSetting = false;
			if ( typeof(vars['toolbar'] ) != 'undefined' && vars['toolbar'] != null && vars['toolbar'].length > 0 ) {
				var blocs = vars['toolbar'].split("|");
				if (blocs.length > 0) {
					var nlistButton = [];
					
					var haveAddButton = false;
					for (var i = 0; i < blocs.length; i++) {
						var subList = blocs[i].split(" ");
						if (subList.length > 0) {
							if (haveAddButton && nlistButton.length > 0) {
								nlistButton.push(null);	//Separator
							}
							haveAddButton = false;
							for (var j = 0; j < subList.length; j++) {
								if (subList[j].trim().length > 0 ) {
									//Will find the button
									var buName = subList[j].trim();
									for (var k = 0; k < buttons.length; k++) {
										if (buttons[k].name == buName) {
											nlistButton.push(buttons[k]);
											haveAddButton = true;
											break;
										}
									}
								}
							}
						}
					}
					//If we finally have a list of button, we put it as the list of button
					if (nlistButton.length > 0 ) {
						fromToolBarSetting = true;
						buttons = nlistButton;
					}
				}
			}
			
			// insertion the toolbar button
			for(var n = 0; n < buttons.length; n++)
			{
				var buttonInBuild = buttons[n];
				// if from toolbar setting and we got a seperator
				if (fromToolBarSetting && buttonInBuild == null) {
					//add separator
					toolbar.append("<div class='"+vars.css+"_tool_separator'></div>");
				}
				// if from toolbar or by standard setting of this button is activated (is it true?)
				else if(fromToolBarSetting || vars[buttonInBuild.name])
				{
					// if it have a title, add to this button
					var buttonHotkey = buttonInBuild.key.length>0 ?  buttonInBuild.hotkeyname!=null && buttonInBuild.hotkeyname!="undefined" && buttonInBuild.hotkeyname!="" ? ' (Ctrl+'+buttonInBuild.hotkeyname+')' : '' : '';
					var buttonTitle = buttonInBuild.title!=null && buttonInBuild.title!="undefined" && buttonInBuild.title!="" ? buttonInBuild.title+buttonHotkey : '';
					var buttonLabel = buttonInBuild.label!=null && buttonInBuild.label!="undefined" ? buttonInBuild.label : '';
					
					// add this button to the toolbar
					var buDiv = $('<div class="'+vars.css+'_tool '+vars.css+'_tool_'+buttonInBuild.cls+'" role="button" data-tool="'+n+'" unselectable></div>')
					var buAnchor = $('<a class="'+vars.css+'_tool_icon" unselectable></a>').unbind("click");
					if (buttonLabel.length > 0) {
						buAnchor = $('<a class="'+vars.css+'_tool_label" unselectable><span class="'+vars.css+'_tool_text" unselectable>'+buttonLabel+'</span></a>')
					}
					
					buDiv.append(buAnchor);
					toolbar.append(buDiv);
					
					// add the parameters to this button
					buDiv.data({tag : buttonInBuild.tag, command : buttonInBuild.command, emphasis : buttonInBuild.emphasis, title : buttonTitle});
					
					//If we have a button with list : 
					if ( 
						typeof(buttonInBuild.list) != 'undefined' 
						&& buttonInBuild.list != null
						&& $.isArray(buttonInBuild.list.datas)
					) {
						var ltype = buttonInBuild.list.listType || ListType.VLIST;
						$.extend(defaultListElement[ltype],buttonInBuild.list);
						
						//Build the main box and bind some event
						var listBox = $('<div class="'+vars.css+'_'+buttonInBuild.cls+'" unselectable></div>')
						listBox.addClass(vars.css+"_list").addClass(vars.css+"_list_uid_"+buttonInBuild.cls);
						buDiv.append(listBox);
						buDiv.children("a").prop("linkedList","."+vars.css+"_list_uid_"+buttonInBuild.cls).click(function(e) {
							openButtonsList($(this).prop("linkedList"));
							e.preventDefault();
							e.stopPropagation();
						})
						
						//if we are in grid mode
						if (ltype == ListType.GRID) {
							var t = $("<table>").addClass(vars.css+"_list_table");
							var tr = $("<tr>");
							var nullLine = 0;
							for (var i = 0; i < buttonInBuild.list.datas.length; i++) {
								if ( (i-nullLine) % buttonInBuild.list.listMaxSize == 0) {
									t.append(tr);
									tr = $("<tr>");
								}
								var td = $("<td>");
								var iData = buttonInBuild.list.datas[i];
								if (iData == null) {
									t.append(tr).append("<tr><td class='"+vars.css+"_list_table_hsep' colspan="+buttonInBuild.list.listMaxSize+"></td></tr>");
									tr = $("<tr>");
									
									nullLine++;
								} else {
									td.append(buttonInBuild.list.onBuild(iData));
									td.data("button",buttonInBuild);
									td.data("buttonValue",iData);
									//Bind the on select
									td.click(function(e) {
										$(this).data("button").onSelect($(this).data("buttonValue"), $(this));
										closeButtonsList();
										e.stopPropagation();
										e.preventDefault();
									});
									tr.append(td);
								}
							}
							
							if (tr.children().size() > 0) {
								t.append(tr);
							}
							listBox.append(t);
						} 
						//if we are in vertical list
						else if (ltype == ListType.VLIST) {
							for (var i = 0; i < buttonInBuild.list.datas.length; i++) {
								var div = $("<div>");
								var iData = buttonInBuild.list.datas[i];

								div.append(buttonInBuild.list.onBuild(iData));
								div.data("button",buttonInBuild);
								div.data("buttonValue",iData);
								//Bind the on select
								div.click(function(e) {
									$(this).data("button").onSelect($(this).data("buttonValue"),$(this));
									closeButtonsList();
									e.stopPropagation();
									e.preventDefault();
								});
								listBox.append(div);
							}
						}
					//For button with forms : build a bar
					} if ( 
						typeof(buttonInBuild.form) != 'undefined' 
						&& buttonInBuild.form != null 
					) {
						var formBox = $("<div class='"+vars.css+"_form "+vars.css+"_form_"+buttonInBuild.cls+"' role='dialog'>");
						jQTE.find("."+vars.css+"_form-list").append(formBox);
						buttonInBuild.form.onBuild(formBox,closeButtonsList);
						formBox.prop("form",buttonInBuild.form);
						formBox.bind("onOpen",function(){
							$(this).prop("form").onOpen($(this))
						});
						
						//prevent closing when working in the form unlike buttons
						formBox.click(function(e) {
							e.stopPropagation();
							e.preventDefault();
						});
						buDiv.children("a").prop("linkedList","."+vars.css+"_form_"+buttonInBuild.cls)
						buDiv.click(function(e) {
							var fnSlideDownFinish = function() {
								$(this).trigger("onOpen");
							}
							openButtonsList($(this).children("a").prop("linkedList"),fnSlideDownFinish);
							
							e.stopPropagation();
							e.preventDefault();
						});
					//For button with no list and no form
					} else {
						buDiv.data("button",buttonInBuild);
						buDiv.data("buttonValue",buttonInBuild.command);
						buDiv.click(function(e) {
							if(editor.not(":focus"))
								editor.focus();
							$(this).data("button").onSelect($(this).data("buttonValue"),$(this));
							closeButtonsList();
							e.stopPropagation();
							e.preventDefault();
							
							// to highlight the toolbar buttons according to the cursor position in jqte editor
							$(this).data('emphasis')==true && !$(this).hasClass(emphasize) ? $(this).addClass(emphasize) : $(this).removeClass(emphasize);
						});
					}

				}
			}
			
			// add the prefix of css according to browser
			var prefixCss = "";

			if(/msie/.test(thisBrowser)) // ie
				prefixCss = '-ms-';
			else if(/chrome/.test(thisBrowser) || /safari/.test(thisBrowser) || /yandex/.test(thisBrowser)) // webkit group (safari, chrome, yandex)
				prefixCss = '-webkit-';
			else if(/mozilla/.test(thisBrowser)) // firefox
				prefixCss = '-moz-';
			else if(/opera/.test(thisBrowser)) // opera
				prefixCss = '-o-';
			else if(/konqueror/.test(thisBrowser)) // konqueror
				prefixCss = '-khtml-';
			else 
				prefixCss = '';
				
			// the feature of placeholder
			if(vars.placeholder && vars.placeholder!="")
			{
				jQTE.find("."+vars.css+"_editor").before('<div class="'+vars.css+'_placeholder" unselectable><div class="'+vars.css+'_placeholder_text">'+vars.placeholder+'</div></div>');
				
				var placeHolder = jQTE.find("."+vars.css+"_placeholder");
				
				placeHolder.click(function(){
					editor.focus();
				});
			}
			
			// make unselectable to unselectable attribute ones
			jQTE.find("[unselectable]")
				.css(prefixCss+"user-select","none")
				.addClass("unselectable")
				.attr("unselectable","on")
				.on("selectstart mousedown",false);
			
			// each button of the toolbar
			var toolbutton = toolbar.find("."+vars.css+"_tool");
			
			// format menu
			var formatbar = toolbar.find("."+vars.css+"_formats");
			
			// font-size filed
			var fsizebar = toolbar.find("."+vars.css+"_fontsizes");
			
			// color palette
			var cpalette = toolbar.find("."+vars.css+"_cpalette");
			
			// get the selected text as plain format
			function selectionGet()
			{
				// for webkit, mozilla, opera
				if (window.getSelection)
					return window.getSelection();
				// for ie
				else if (document.selection && document.selection.createRange && document.selection.type != "None")
					return document.selection.createRange();
			}
			
			// the function of changing to the selected text with "execCommand" method
			function selectionSet(addCommand,thirdParam)
			{
				console.log(addCommand);
				console.log(thirdParam);
				var	range,
					sel = selectionGet();

				console.log(sel);
				console.log("#####");
				// for webkit, mozilla, opera
				if (window.getSelection)
				{
					if (sel.anchorNode && sel.getRangeAt)
						range = sel.getRangeAt(0);
						
					if(range)
					{
						sel.removeAllRanges();
						sel.addRange(range);
					}
					
					if(!thisBrowser.match(/msie/))
						document.execCommand('StyleWithCSS', false, false);
					
					document.execCommand(addCommand, false, thirdParam);
				}
				
				// for ie
				else if (document.selection && document.selection.createRange && document.selection.type != "None")
				{
					range = document.selection.createRange();
					range.execCommand(addCommand, false, thirdParam);
				}
				
				// change styles to around tags
				affectStyleAround(false,false);
			}
			
			// the function of changing to the selected text with tags and tags's attributes
			function replaceSelection(tTag,tAttr,tVal) {
				
				// first, prevent to conflict of different jqte editors
				if(editor.not(":focus"))
					editor.focus();
				
				// for webkit, mozilla, opera			
				if (window.getSelection)
				{
					var selObj = selectionGet(), selRange, newElement, documentFragment;
					
					if (selObj.anchorNode && selObj.getRangeAt)
					{
						selRange = selObj.getRangeAt(0);
						
						// create to new element
						newElement = document.createElement(tTag);
						
						// add the attribute to the new element
						$(newElement).attr(tAttr,tVal);
						
						// extract to the selected text
						documentFragment = selRange.extractContents();
						
						// add the contents to the new element
						newElement.appendChild(documentFragment);
						
						selRange.insertNode(newElement);
						selObj.removeAllRanges();
						
						// if the attribute is "style", change styles to around tags
						if(tAttr=="style")
							affectStyleAround($(newElement),tVal);
						// for other attributes
						else
							affectStyleAround($(newElement),false);
					}
				}
				// for ie
				else if (document.selection && document.selection.createRange && document.selection.type != "None")
				{
					var range = document.selection.createRange();
					var selectedText = range.htmlText;
					
					var newText = '<'+tTag+' '+tAttr+'="'+tVal+'">'+selectedText+'</'+tTag+'>';
					
					document.selection.createRange().pasteHTML(newText);
				}
			}
			
			// the function of getting to the parent tag
			var getSelectedNode = function() {
				var node,selection;
				if(window.getSelection) {
					selection = getSelection();
					node = selection.anchorNode;
				}
				if(!node && document.selection && document.selection.createRange && document.selection.type != "None")
				{
					selection = document.selection;
					var range = selection.getRangeAt ? selection.getRangeAt(0) : selection.createRange();
					node = range.commonAncestorContainer ? range.commonAncestorContainer :
						   range.parentElement ? range.parentElement() : range.item(0);
				}
				if(node) {
					return (node.nodeName == "#text" ? $(node.parentNode) : $(node));
				}
				else 
					return false;
			};
			
			// the function of replacement styles to the around tags (parent and child)
			function affectStyleAround(element,style)
			{
				var selectedTag = getSelectedNode(); // the selected node
				
				selectedTag = selectedTag ? selectedTag : element;
				
				// (for replacement with execCommand) affect to child tags with parent tag's styles
				if(selectedTag && style==false)
				{
					// apply to the selected node with parent tag's styles
					if(selectedTag.parent().is("[style]"))
						selectedTag.attr("style",selectedTag.parent().attr("style"));
						
					// apply to child tags with parent tag's styles
					if(selectedTag.is("[style]"))
						selectedTag.find("*").attr("style",selectedTag.attr("style"));
				}
				// (for replacement with html changing method)
				else if(element && style && element.is("[style]"))
				{
					var styleKey = style.split(";"); // split the styles
					
					styleKey = styleKey[0].split(":") // get the key of first style feature
					
					// apply to child tags with parent tag's styles
					if(element.is("[style*="+styleKey[0]+"]"))
						element.find("*").css(styleKey[0],styleKey[1]);
						
					// select to the selected node again
					selectText(element);
				}
			}

			// the function of making selected to a element
			function selectText(element)
			{
				if(element)
				{
					var element = element[0];
					
					if (document.body.createTextRange)
					{
						var range = document.body.createTextRange();
						range.moveToElementText(element);
						range.select();
					}
					else if (window.getSelection)
					{
						var selection = window.getSelection();  
						var range = document.createRange();
						
						if(element != "undefined" && element != null)
						{
							range.selectNodeContents(element);
							
							selection.removeAllRanges();
							selection.addRange(range);
							
							if($(element).is(":empty"))
							{
								$(element).append("&nbsp;");
									selectText($(element));
							}
						}
					}
				}
			}
			
			//generic function to toggle list of buttons 
			function openButtonsList(selector, fnFinishSlideDown) {
				var isVisible = jQTE.find(selector).is(":visible");
				//If was visible : gonna close here
				closeButtonsList();
				
				//if wasn't visible : gonna open
				if (!isVisible) {
					jQTE.find(selector).slideDown(100,fnFinishSlideDown);
					if(editor.not(":focus"))
						editor.focus();
				}
			}

			//generic close all list
			function closeButtonsList() {
				jQTE.find("."+vars.css+"_list:visible, ."+vars.css+"_form").each(function() {
					$(this).slideUp(100);
				});
			}
			
			//if we click outside : close list (each button list and list 
			//stop propagation on click to have a smooth way to do things
			$(document).click(function() {
				closeButtonsList();
			});
			
			function applySelectedStyle(styleValue, styleType)
			{
				var prevStyles = refuseStyle(styleType); // affect styles to child tags (and extract to the new style attributes)
				
				// change to selected text
				replaceSelection("span","style",styleType+":"+styleValue+";"+prevStyles);
				
				// remove title bubbles
				$('.'+vars.css+'_title').remove();
				
				// export contents of the text to the sources
				editor.trigger("change");
			}
			
			// the function of removing all pre-link attribute (mark as "link will be added")
			function clearSetElement(elem)
			{
				jQTE.find(elem).each(function(){
					$(this).before($(this).html()).remove();
				});
			}
			
			// the function of refusing some styles
			function refuseStyle(refStyle)
			{
				var selectedTag = getSelectedNode(); // the selected node
				
				// if the selected node have attribute of "style" and it have unwanted style
				if(selectedTag && selectedTag.is("[style]") && selectedTag.css(refStyle)!="")
				{
					var refValue = selectedTag.css(refStyle); // first get key of unwanted style
					
					selectedTag.css(refStyle,""); // clear unwanted style
					
					var cleanStyle = selectedTag.attr("style"); // cleaned style
					
					selectedTag.css(refStyle,refValue); // add unwanted style to the selected node again
					
					return cleanStyle; // print cleaned style
				}
				else
					return "";
			}
			
			// change format label
			function formatLabelView(str, elem)
			{
				var formatLabel = typeof elem == 'undfined' || elem == null || $(elem).size() == 0?formatbar.closest("."+vars.css+"_tool").find("."+vars.css+"_tool_label").find("."+vars.css+"_tool_text"): $(elem);
				
				if(str.length > 10)
						str = str.substr(0,7) + "...";
				
				// change format label of button
				formatLabel.html(str);
			}

			// the function of insertion a specific form to texts
			function extractToText(strings)
			{
				var $htmlContent, $htmlPattern, $htmlReplace;

				// first remove to unnecessary gaps
				$htmlContent = strings.replace(/\n/gim,'').replace(/\r/gim,'').replace(/\t/gim,'').replace(/&nbsp;/gim,' ');

				$htmlPattern =  [
					/\<span(|\s+.*?)><span(|\s+.*?)>(.*?)<\/span><\/span>/gim, // trim nested spans
					/<(\w*[^p])\s*[^\/>]*>\s*<\/\1>/gim, // remove empty or white-spaces tags (ignore paragraphs (<p>) and breaks (<br>))
					/\<div(|\s+.*?)>(.*?)\<\/div>/gim, // convert div to p
					/\<strong(|\s+.*?)>(.*?)\<\/strong>/gim, // convert strong to b
					/\<em(|\s+.*?)>(.*?)\<\/em>/gim // convert em to i
				];

				$htmlReplace = [
					'<span$2>$3</span>',
					'',
					'<p$1>$2</p>',
					'<b$1>$2</b>',
					'<i$1>$2</i>'
				];
				
				// repeat the cleaning process 5 times
				for(c=0; c<5; c++)
				{
					// create loop as the number of pattern
					for(var i = 0; i < $htmlPattern.length; i++)
					{
						$htmlContent = $htmlContent.replace($htmlPattern[i], $htmlReplace[i]);
					}
				}

				// if paragraph is false (<p>), convert <p> to <br>
				if(!vars.p)
					$htmlContent = $htmlContent.replace(/\<p(|\s+.*?)>(.*?)\<\/p>/ig, '<br/>$2');

				// if break is false (<br>), convert <br> to <p>
				if(!vars.br)
				{
					$htmlPattern =  [
						/\<br>(.*?)/ig,
						/\<br\/>(.*?)/ig
					];

					$htmlReplace = [
						'<p>$1</p>',
						'<p>$1</p>'
					];

					// create loop as the number of pattern (for breaks)
					for (var i = 0; i < $htmlPattern.length; i++) {
						$htmlContent = $htmlContent.replace($htmlPattern[i], $htmlReplace[i]);
					}
				}

				// if paragraph and break is false (<p> && <br>), convert <p> to <div>
				if(!vars.p && !vars.br)
					$htmlContent = $htmlContent.replace(/\<p>(.*?)\<\/p>/ig, '<div>$1</div>');

				return $htmlContent;
			}

			// the function of exporting contents of the text field to the source field (to be the standard in all browsers)
			function postToSource()
			{
				// clear unnecessary tags when editor view empty
				var sourceStrings = editor.text()=="" && editor.html().length<12 ? "" : editor.html();
				
				thisElement.val(extractToText(sourceStrings));
			}

			// the function of exporting contents of the source field to the text field (to be the standard in all browsers)
			function postToEditor()
			{
				editor.html(extractToText(thisElement.val()));
			}

			// the function of getting parent (or super parent) tag name of the selected node
			function detectElement(tags){
			
				var resultdetect=false, $node = getSelectedNode(), parentsTag;
				
				if($node)
				{
					$.each(tags, function(i, val){
						parentsTag = $node.prop('tagName').toLowerCase();

						if (parentsTag == val)
							resultdetect = true;
						else
						{
							$node.parents().each(function(){
								parentsTag = $(this).prop('tagName').toLowerCase();
								if (parentsTag == val)
									resultdetect = true;
							});
						}
					});
					
					return resultdetect;
				}
				else 
					return false;
			};

			// the function of highlighting the toolbar buttons according to the cursor position in jqte editor
			function buttonEmphasize(e)
			{
				for(var n = 0; n < buttons.length; n++)
				{				
					if(buttons[n] != null && (fromToolBarSetting || vars[buttons[n].name]) && buttons[n].emphasis && buttons[n].tag!='')
						detectElement(buttons[n].tag) ? toolbar.find('.'+vars.css+'_tool_'+buttons[n].cls).addClass(emphasize) : $('.'+vars.css+'_tool_'+buttons[n].cls).removeClass(emphasize);
				}
				// showing text format
				if(vars.format && $.isArray(vars.formats))
				{
					var isFoundFormat = false;
					
					for(var f = 0; f < vars.formats.length; f++)
					{
						var thisFormat = [];
						thisFormat[0] = vars.formats[f][0];
						
						if(vars.formats[f][0].length>0 && detectElement(thisFormat))
						{
							formatLabelView(vars.formats[f][1]);
							
							isFoundFormat = true;
							break;
						}
					}
					
					if(!isFoundFormat)
						formatLabelView(vars.formats[0][1]);
				}
			}

			// the event of click to the toolbar buttons
			toolbutton
				//.unbind("click")
				.click(function(e){	
					// if source button is clicked
					if($(this).data('command')=='displaysource' && !toolbar.data("sourceOpened"))
					{
						// hide all the toolbar buttons (except the source button)
						toolbar.find("."+vars.css+"_tool").addClass(vars.css+"_hiddenField");
						toolbar.find("."+vars.css+"_tool_separator").addClass(vars.css+"_hiddenField");
						$(this).removeClass(vars.css+"_hiddenField");
						
						// update to data of source displaying
						toolbar.data("sourceOpened",true);
						
						// equalize height of the text field with height of the source field
						thisElement.css("height",editor.outerHeight());
						
						sourceField.removeClass(vars.css+"_hiddenField");
						editor.addClass(vars.css+"_hiddenField");
						thisElement.focus();
						
						// hide placeholder
						if(vars.placeholder && vars.placeholder!="")
							placeHolder.hide();
					}
					// if other buttons is clicked
					else
					{
						// update to data of source hiding
						toolbar.data("sourceOpened",false);

						// display all the toolbar buttons
						toolbar.find("."+vars.css+"_tool").removeClass(vars.css+"_hiddenField");
						toolbar.find("."+vars.css+"_tool_separator").removeClass(vars.css+"_hiddenField");

						sourceField.addClass(vars.css+"_hiddenField");
						editor.removeClass(vars.css+"_hiddenField");
						
						if(vars.placeholder && vars.placeholder!="")
							editor.html()!="" ? placeHolder.hide() : placeHolder.show();
					}
					
					// export contents of the text to the sources
					editor.trigger("change");
				})
				// the event of showing to the title bubble when mouse over of the toolbar buttons
				.hover(function(e){
					if(vars.title && $(this).data("title")!="" && ( $(e.target).hasClass(vars.css+"_tool") || $(e.target).hasClass(vars.css+"_tool_icon") ))
					{
						$('.'+vars.css+'_title').remove();

						// create the title bubble
						jQTE.append('<div class="'+vars.css+'_title"><div class="'+vars.css+'_titleArrow"><div class="'+vars.css+'_titleArrowIcon"></div></div><div class="'+vars.css+'_titleText">'+$(this).data("title")+'</div></div>');
						
						var thisTitle = $('.'+vars.css+'_title:first');
						var thisArrow = thisTitle.find('.'+vars.css+'_titleArrowIcon');
						var thisPosition = $(this).position();
						var thisAlignX = thisPosition.left + $(this).outerWidth() - (thisTitle.outerWidth()/2) - ($(this).outerWidth()/2);
						var thisAlignY = (thisPosition.top + $(this).outerHeight() + 5);

						// show the title bubble and set to its position
						thisTitle.delay(400).css({'top':thisAlignY, 'left':thisAlignX}).fadeIn(200);
					}
				},function(){
					$('.'+vars.css+'_title').remove();
				});

			// prevent multiple calling postToSource()
			var editorChangeTimer = null;

			// the methods of the text fields
			editor

				// trigger change method of the text field when the text field modified
				.bind("keypress keyup keydown drop cut copy paste DOMCharacterDataModified DOMSubtreeModified",function()
				{
					// export contents of the text to the sources
					if(!toolbar.data("sourceOpened"))
						$(this).trigger("change");
						
					// if the change method is added run the change method   
					if($.isFunction(vars.change))
						vars.change();
						
					// the feature of placeholder
					if(vars.placeholder && vars.placeholder!="")
						$(this).text()!="" ? placeHolder.hide() : placeHolder.show();
				})
				.bind("change",function()
				{
					if(!toolbar.data("sourceOpened"))
					{
						clearTimeout(editorChangeTimer);
						editorChangeTimer = setTimeout(postToSource,10);
					}
				})

				// run to keyboard shortcuts
				.keydown(function(e)
				{
					// if ctrl key is clicked
					if(e.ctrlKey)
					{
						// check all toolbar buttons
						for(var n = 0; n < buttons.length; n++)
						{
							// if this settings of this button is activated (is it true)
							// if the keyed button with ctrl is same of hotkey of this button
							if(buttons[n] != null && (fromToolBarSetting || vars[buttons[n].name]) && e.keyCode == buttons[n].key.charCodeAt(0))
							{
								jQTE.find("."+vars.css+'_tool.'+vars.css+'_tool_'+buttons[n].cls).trigger("click");
								return false;
							}
						}
					}
				})

				// method of triggering to the highlight button
				.bind("mouseup keyup",buttonEmphasize)

				// the event of focus to the text field
				.focus(function()
				{
					// if the focus method is added run the focus method   
					if($.isFunction(vars.focus))
						vars.focus();
					
					// add onfocus class
					jQTE.addClass(vars.css+"_focused");
					
					// prevent focus problem on opera
					if(/opera/.test(thisBrowser))
					{
						var range = document.createRange();
						range.selectNodeContents(editor[0]);
						range.collapse(false);
						var selection = window.getSelection();
						selection.removeAllRanges();
						selection.addRange(range);
					}
				})

				// the event of focus out from the text field
				.focusout(function()
				{
					// remove to highlights of all toolbar buttons
					toolbutton.removeClass(emphasize);
					
					// if the blur method is added run the blur method   
					if($.isFunction(vars.blur))
						vars.blur();
					
					// remove onfocus class	
					jQTE.removeClass(vars.css+"_focused");
					
					// show default text format
					if($.isArray(vars.formats))
						formatLabelView(vars.formats[0][1]);
				});

			// the event of key in the source field
			thisElement
				.bind("keydown keyup",function()
				{
					// export contents of the source to the text field
					setTimeout(postToEditor,0);
					
					// auto extension for the source field
					$(this).height($(this)[0].scrollHeight);
					
					// if the source field is empty, shorten to the source field
					if($(this).val()=="")
						$(this).height(0);
				})
				.focus(function()
				{
					// add onfocus class
					jQTE.addClass(vars.css+"_focused");
				})
				.focusout(function()
				{
					// remove onfocus class	
					jQTE.removeClass(vars.css+"_focused");
				});
				
			setTimeout(function() {
				console.log("focus");
				editor.focus();
			}, 100);
		});

	};
})(jQuery);