/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.kryoserializers;

import ca.infodata.dsq.signature.XmlSignature;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XmlSignatureSerializer
extends Serializer<XmlSignature> {
    private static final Logger logger = Logger.getLogger(XmlSignatureSerializer.class.getName());
    private final Constructor _constructor;

    public XmlSignatureSerializer(Class<XmlSignature> clazz) {
        try {
            this._constructor = clazz.getConstructor(String.class, String.class, String.class, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XmlSignature read(Kryo kryo, Input input, Class<? extends XmlSignature> type) {
        XmlSignature obj = null;
        String token = input.readString();
        String actor = null;
        byte actorNull = input.readByte();
        if (actorNull == 1) {
            actor = input.readString();
        }
        String xmlSign = null;
        byte xmlSignNull = input.readByte();
        if (xmlSignNull == 1) {
            xmlSign = input.readString();
        }
        try {
            obj = (XmlSignature)this._constructor.newInstance(token, null, actor, xmlSign);
            return obj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return obj;
        }
    }

    public void write(Kryo kryo, Output output, XmlSignature sign) {
        output.writeString(sign.getToken());
        if (sign.getActor() == null) {
            output.writeByte((byte)0);
        } else {
            output.writeByte((byte)1);
            output.writeString(sign.getActor());
        }
        String xml = null;
        try {
            xml = sign.getXmlSignature();
        }
        catch (KryoException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (xml == null) {
            output.writeByte((byte)0);
        } else {
            output.writeByte((byte)1);
            output.writeString(xml);
        }
    }
}

