/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.service;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.service.IEditableDataObjectDeleted;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceDefData;
import ca.infodata.ofys.data.middle.dataobjects.service.XServiceType;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeDef;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.EnumSet;

public final class XRessourceDef
extends EditableDataObject
implements IEditableDataObjectDeleted {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public String nameFr;
    public String nameEn;
    public Boolean isDeleted;
    public Long createdDatetime;
    public String tarifDebut;
    public String tarifFin;
    public EnumSet<XServiceType> serviceType = EnumSet.noneOf(XServiceType.class);
    public IEditableDataObjectList<XRessourceDefData> lstRessourceDefData = new EditableDataObjectList<XRessourceDefData>();
    public XTaxeDef taxeDef;
    public XRessource ressource;

    @Override
    public void initialize() {
        this.setNew();
        this.nameFr = "";
        this.nameEn = "";
        this.tarifDebut = LocalDateFormat.format((LocalDate)LocalDate.today(), (String)"yyyyMMdd");
        this.tarifFin = "99999999";
        this.isDeleted = Boolean.FALSE;
        this.createdDatetime = DateUtil.now();
        this.lstRessourceDefData = new EditableDataObjectList<XRessourceDefData>();
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.lstRessourceDefData.isDirty();
        return dirty;
    }

    @Override
    public XRessourceDef clone() {
        XRessourceDef c = (XRessourceDef)super.clone();
        c.id = this.id;
        c.nameFr = this.nameFr;
        c.nameEn = this.nameEn;
        c.tarifDebut = this.tarifDebut;
        c.tarifFin = this.tarifFin;
        if (this.serviceType != null) {
            c.serviceType = this.serviceType.clone();
        }
        if (this.lstRessourceDefData != null) {
            c.lstRessourceDefData = this.lstRessourceDefData.deepClone();
        }
        if (this.taxeDef != null) {
            c.taxeDef = this.taxeDef.clone();
        }
        if (this.ressource != null) {
            c.ressource = this.ressource;
        }
        c.isDeleted = this.isDeleted;
        c.createdDatetime = this.createdDatetime;
        return c;
    }

    @Override
    public XRessourceDef cloneSetIdNull() {
        XRessourceDef c = this.clone();
        c.id = null;
        c.setNew();
        for (XRessourceDefData rDefData : c.lstRessourceDefData) {
            rDefData.id = null;
            rDefData.setNew();
            rDefData.ressourceDef = c;
        }
        return c;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public final String getNameFr() {
        return this.nameFr;
    }

    public final void setNameFr(String aname) {
        this.nameFr = aname;
        this.setUpdated();
    }

    public final String getName(String langue) {
        if ("fr".equals(langue)) {
            return this.nameFr;
        }
        return this.nameEn;
    }

    public final String getNameEn() {
        return this.nameEn;
    }

    public final void setNameEn(String aname) {
        this.nameEn = aname;
        this.setUpdated();
    }

    @Override
    public final Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @Override
    public final void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    public final Long getCreatedDatetime() {
        return this.createdDatetime;
    }

    public final void setCreatedDatetime(Long createdDatetime) {
        this.createdDatetime = createdDatetime;
        this.setUpdated();
    }

    public final String getTarifDebut() {
        return this.tarifDebut;
    }

    public final void setTarifDebut(String tarifDebut) {
        this.tarifDebut = tarifDebut;
        this.setUpdated();
    }

    public final String getTarifFin() {
        return this.tarifFin;
    }

    public final void setTarifFin(String tarifFin) {
        this.tarifFin = tarifFin;
        this.setUpdated();
    }

    public final EnumSet<XServiceType> getServiceType() {
        return this.serviceType;
    }

    public final void setServiceType(EnumSet<XServiceType> serviceType) {
        this.serviceType = serviceType;
        this.setUpdated();
    }

    public final IEditableDataObjectList<XRessourceDefData> getRessourceDefData() {
        return this.lstRessourceDefData;
    }

    public final void setRessourceDefData(IEditableDataObjectList<XRessourceDefData> lstRessourceDefData) {
        this.lstRessourceDefData = lstRessourceDefData;
        this.setUpdated();
    }

    public final XTaxeDef getTaxeDef() {
        return this.taxeDef;
    }

    public final void setTaxeDef(XTaxeDef taxe) {
        this.taxeDef = taxe;
        this.setUpdated();
    }

    public final XRessource getRessource() {
        return this.ressource;
    }

    public final void setRessource(XRessource ressource) {
        this.ressource = ressource;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XRessourceDef [id=%s, name=%s, debut=%s, fin=%s]", this.id, this.nameFr, this.tarifDebut, this.tarifFin);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XRessourceDef" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    public final void addRessourceDef(XRessourceDefData x) {
        this.lstRessourceDefData.add(x);
        x.setRessourceDef(this);
        x.setUpdated();
    }

    public final void removeRessourceDef(XRessourceDefData x) {
        this.lstRessourceDefData.remove(x);
        x.setRessourceDef(null);
        x.setUpdated();
    }

    @Override
    public void setNew() {
        super.setNew();
        this.id = null;
        this.setModificationStatus(ModificationStatus.STATUS_NEW);
        if (this.lstRessourceDefData != null) {
            for (XRessourceDefData x : this.lstRessourceDefData) {
                x.id = null;
                x.setNew();
            }
        }
    }
}

