/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.pdf;

import ca.infodata.ofys.data.middle.dataobjects.pdf.TablePdfNumeration;
import ca.infodata.util1.StringUtils;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.LineSeparator;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class TablePdf {
    private String printedBy;
    private String title;
    private List<Paragraph> comments;
    private List<String> headers = new ArrayList<String>();
    private List<List<String>> rows = new ArrayList<List<String>>();

    public TablePdf() {
        this.comments = new ArrayList<Paragraph>();
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public void setPrintedBy(String printedBy) {
        this.printedBy = printedBy;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public void setRows(List<List<String>> rows) {
        this.rows = rows;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Paragraph> getComments() {
        return this.comments;
    }

    public void setComments(List<Paragraph> comments) {
        this.comments = comments;
    }

    public void generatePdf(OutputStream outputStream) throws DocumentException, IOException {
        Font font = new Font(2, 11.0f, 0, Color.black);
        Font bold = new Font(2, 11.0f, 1, Color.black);
        TablePdfNumerationExtension tablePdfNumeration = new TablePdfNumerationExtension();
        tablePdfNumeration.setFooterText(this.printedBy);
        float width = PageSize.LETTER.getHeight();
        float height = PageSize.LETTER.getWidth();
        Rectangle rect = new Rectangle(width, height);
        Document document = new Document(rect, 36.0f, 36.0f, 36.0f + tablePdfNumeration.totalHeight, 36.0f);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.setCompressionLevel(5);
        writer.setPageEvent((PdfPageEvent)tablePdfNumeration);
        writer.open();
        document.open();
        Paragraph p = new Paragraph();
        p.setAlignment(1);
        p.setFont(font);
        p = new Paragraph();
        p.setAlignment(1);
        p.setFont(font);
        p.add((Element)new LineSeparator());
        p.add((Element)new Chunk("\n"));
        document.add((Element)p);
        PdfPTable table = new PdfPTable(this.headers.size());
        table.setHeaderRows(1);
        table.setWidthPercentage(100.0f);
        float[] columnWidth = new float[this.headers.size()];
        for (int i = 0; i < this.headers.size(); ++i) {
            ArrayList<Float> ws = new ArrayList<Float>();
            ws.add(Float.valueOf(bold.getCalculatedBaseFont(true).getWidthPoint(this.headers.get(i), bold.getCalculatedSize()) + 20.0f));
            for (List<String> list : this.rows) {
                for (int j = 0; j < list.size(); ++j) {
                    if (i != j) continue;
                    String columnValue = StringUtils.defaultString((String)list.get(i));
                    ws.add(Float.valueOf(bold.getCalculatedBaseFont(true).getWidthPoint(columnValue, bold.getCalculatedSize()) + 20.0f));
                }
            }
            float max = 0.0f;
            for (Float w : ws) {
                max = Math.max(w.floatValue(), max);
            }
            columnWidth[i] = max;
        }
        table.setWidths(columnWidth);
        for (String header : this.headers) {
            PdfPCell cell = new PdfPCell(new Phrase(header, bold));
            table.addCell(cell);
        }
        if (this.rows.isEmpty()) {
            PdfPCell cell = new PdfPCell(new Phrase("Aucune donn\u00e9e trouv\u00e9e", font));
            cell.setColspan(this.headers.size());
            table.addCell(cell);
            document.add((Element)table);
        } else {
            for (List<String> row : this.rows) {
                for (String string : row) {
                    String string2 = StringUtils.defaultString((String)string);
                    PdfPCell cell = new PdfPCell(new Phrase(string2, font));
                    table.addCell(cell);
                }
                table.completeRow();
            }
            document.add((Element)table);
        }
        writer.flush();
        document.close();
        writer.close();
    }

    final class TablePdfNumerationExtension
    extends TablePdfNumeration {
        final float totalHeight;
        private PdfPTable table = new PdfPTable(1);

        public TablePdfNumerationExtension() {
            this.table.setTotalWidth(PageSize.LETTER.getHeight() - 36.0f - 36.0f);
            this.table.setLockedWidth(true);
            PdfPCell cell = new PdfPCell(new Phrase(TablePdf.this.title, new Font(2, 16.0f, 0, Color.black)));
            cell.setHorizontalAlignment(1);
            cell.setBorder(0);
            this.table.addCell(cell);
            cell = new PdfPCell();
            cell.setHorizontalAlignment(1);
            cell.setBorder(1);
            this.table.addCell(cell);
            if (TablePdf.this.comments != null && TablePdf.this.comments.size() > 0) {
                for (Paragraph comment : TablePdf.this.comments) {
                    cell = new PdfPCell(new Phrase(comment.getContent(), comment.getFont()));
                    cell.setBorder(0);
                    cell.setHorizontalAlignment(comment.getAlignment());
                    this.table.addCell(cell);
                }
            }
            this.totalHeight = this.table.getTotalHeight();
        }

        @Override
        public void onEndPage(PdfWriter writer, Document document) {
            super.onEndPage(writer, document);
            this.table.writeSelectedRows(0, -1, document.leftMargin(), document.top() + this.totalHeight, writer.getDirectContent());
        }
    }
}

