/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.patient.searchElement;

import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.data.middle.dataobjects.patient.searchElement.ISearchElement;

public class LabTypeSearchElement
implements ISearchElement {
    private static final long serialVersionUID = 4002526883085011323L;
    private final Float min;
    private final Float max;
    private Integer id;
    private String code;

    public LabTypeSearchElement(XLabType labType, Float min, Float max) {
        this.min = min;
        this.max = max;
        if (labType != null) {
            this.id = labType.id;
            this.code = labType.code;
        }
    }

    @Override
    public String getSearchName() {
        return this.code == null ? " - - - " : "LAB - " + this.code;
    }

    @Override
    public String getConditionString() {
        StringBuilder sql = new StringBuilder().append(" labs.id_lab_type = ").append(this.id).append(" ");
        if (this.min != null) {
            sql.append(" AND to_number(labs.lab_val, '9999999999.999999999999') > ").append(this.min).append(" ");
        }
        if (this.max != null) {
            sql.append(" AND to_number(labs.lab_val, '9999999999.999999999999') < ").append(this.max).append(" ");
        }
        return sql.toString();
    }

    @Override
    public ISearchElement.SearchElementType getSearchType() {
        return ISearchElement.SearchElementType.LAB;
    }
}

