/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.AbstractSerializableGenericListDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Listenable;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ListenableList<E>
extends AbstractSerializableGenericListDecorator<E>
implements Listenable,
Cloneable {
    private static final Logger logger = Logger.getLogger(MyChildrenListener.class.getName());
    private static final long serialVersionUID = 8037113904755669339L;
    private IObjectListener<Object> childrenListener = new MyChildrenListener();
    private final boolean listenToChildren;
    private boolean isListenerEnabled;

    public static <T> List<T> decorate(List<T> list, boolean listenToChildren) {
        return new ListenableList<T>(list, listenToChildren);
    }

    protected ListenableList(List<E> list, boolean listenToChildren) {
        super(list);
        this.listenToChildren = listenToChildren;
        this.setListenerEnabled(true);
    }

    public ListenableList(boolean listenToChildren) {
        this(new ArrayList(), listenToChildren);
    }

    void deregisterChild(Object child) {
        if (this.listenToChildren && child instanceof Listenable) {
            ObjectListenerManager.removeListener(child, this.childrenListener);
            ((Listenable)child).setListenerEnabled(false);
        }
    }

    void deregisterChildren(Collection<?> children) {
        if (this.listenToChildren) {
            for (Object e : children) {
                this.deregisterChild(e);
            }
        }
    }

    void meModified() {
        if (this.isListenerEnabled) {
            ObjectListenerManager.fireObjectModified(this);
        }
    }

    void registerChild(Object child) {
        if (this.listenToChildren && child instanceof Listenable) {
            ObjectListenerManager.addListener(child, this.childrenListener);
            ((Listenable)child).setListenerEnabled(true);
        }
    }

    void registerChildren(Collection<?> children) {
        if (this.listenToChildren) {
            for (Object e : children) {
                this.registerChild(e);
            }
        }
    }

    @Override
    public boolean add(E e) {
        boolean add = super.add(e);
        if (add) {
            this.registerChild(e);
            this.meModified();
        }
        return add;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.registerChild(element);
        this.meModified();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.registerChildren(c);
            this.meModified();
        }
        return addAll;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean addAll = super.addAll(index, c);
        if (addAll) {
            this.registerChildren(c);
            this.meModified();
        }
        return addAll;
    }

    @Override
    public void clear() {
        this.deregisterChildren(this);
        super.clear();
        this.meModified();
    }

    @Override
    public E remove(int index) {
        Object remove = super.remove(index);
        this.deregisterChild(remove);
        this.meModified();
        return remove;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.deregisterChild(o);
            this.meModified();
        }
        return remove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.deregisterChildren(c);
            this.meModified();
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retainAll;
        ArrayList copy = null;
        if (this.listenToChildren) {
            copy = new ArrayList(this);
        }
        if (retainAll = super.retainAll(c)) {
            this.deregisterChildren(copy);
            this.registerChildren(c);
            this.meModified();
        }
        return retainAll;
    }

    @Override
    public E set(int index, E element) {
        E set = super.set(index, element);
        this.registerChild(element);
        this.deregisterChild(set);
        this.meModified();
        return set;
    }

    @Override
    public boolean isListenerEnabled() {
        return this.isListenerEnabled;
    }

    @Override
    public void setListenerEnabled(boolean enable) {
        if (this.isListenerEnabled != enable) {
            this.isListenerEnabled = enable;
            if (this.listenToChildren) {
                if (this.isListenerEnabled) {
                    this.registerChildren(super.getList());
                } else {
                    this.deregisterChildren(super.getList());
                }
            }
        }
    }

    public ListenableList<E> clone() {
        try {
            ListenableList c = (ListenableList)super.clone();
            if (this.collection instanceof Cloneable) {
                Cloneable value = (Cloneable)((Object)this.collection);
                try {
                    Method m_clone = value.getClass().getMethod("clone", new Class[0]);
                    m_clone.setAccessible(true);
                    c.collection = (Collection)((Object)((Cloneable)m_clone.invoke((Object)value, new Object[0])));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                logger.log(Level.SEVERE, "ListenableList underlying list is not clonable. will use new ArrayList.");
                c.collection = new ArrayList(this.collection);
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ListenableIterator(super.iterator());
    }

    private class ListenableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> original;

        private ListenableIterator(Iterator<T> iterator) {
            this.original = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public T next() {
            return this.original.next();
        }

        @Override
        public void remove() {
            try {
                this.original.remove();
                ListenableList.this.meModified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MyChildrenListener
    implements IObjectListener<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MyChildrenListener() {
        }

        @Override
        public void objectModified(Object object) {
            ListenableList.this.meModified();
        }
    }
}

