/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.inspq.immunization;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XNormalizedDateTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String year;
    private String month;
    private String day;
    private String hour;
    private String minute;
    private String second;

    public XNormalizedDateTime(String source) {
        this.from(source);
    }

    public String get() {
        StringBuilder b = new StringBuilder(19);
        b.append(this.year);
        b.append('-');
        b.append(this.month);
        b.append('-');
        b.append(this.day);
        b.append('T');
        b.append(this.hour);
        b.append(':');
        b.append(this.minute);
        b.append(':');
        b.append(this.second);
        return b.toString();
    }

    public Date toDate() {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", LocaleProvider.getLocale());
            format.setTimeZone(TimeZoneProvider.getTimeZone());
            Date date = format.parse(this.get());
            return date;
        }
        catch (ParseException e) {
            throw new IllegalStateException("inner date is not formated as yyyy-MM-ddTHH:mm:ss " + this.get(), e);
        }
    }

    public void set(String source) {
        this.from(source);
    }

    private void from(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new IllegalArgumentException("blank source does not represent a valid date");
        }
        if (source.length() == 19) {
            this.from19(source);
        } else {
            this.throwInvalidFormat(source);
        }
    }

    private void from19(String source) {
        String partSeparator = source.indexOf(84) > 0 ? "T" : " ";
        String[] parts = source.split(partSeparator);
        if (parts.length != 2) {
            this.throwInvalidFormat(source);
        }
        String datePart = parts[0];
        String timePart = parts[1];
        String yearS = null;
        String monthS = null;
        String dayS = null;
        String dateSeparator = null;
        if (datePart.indexOf(45) >= 0) {
            dateSeparator = "-";
        } else if (datePart.indexOf(47) >= 0) {
            dateSeparator = "/";
        } else {
            this.throwInvalidFormat(source);
        }
        String[] split = datePart.split(dateSeparator);
        if (split.length == 3) {
            yearS = split[0];
            monthS = split[1];
            dayS = split[2];
            if (yearS.length() != 4 || monthS.length() != 2 || dayS.length() != 2) {
                this.throwInvalidFormat(source);
            }
            try {
                Integer day;
                Integer.valueOf(yearS);
                Integer month = Integer.valueOf(monthS);
                if (month < 1 || month > 12) {
                    this.throwInvalidDateTime(source);
                }
                if ((day = Integer.valueOf(dayS)) < 1 || day > 31) {
                    this.throwInvalidDateTime(source);
                }
            }
            catch (Exception e) {
                this.throwInvalidDateTime(source);
            }
        } else {
            this.throwInvalidFormat(source);
        }
        String hourS = null;
        String minuteS = null;
        String secondS = null;
        String timeSeparator = null;
        if (timePart.indexOf(58) >= 0) {
            timeSeparator = ":";
        } else {
            this.throwInvalidFormat(source);
        }
        split = timePart.split(timeSeparator);
        if (split.length == 3) {
            hourS = split[0];
            minuteS = split[1];
            secondS = split[2];
            if (hourS.length() != 2 || minuteS.length() != 2 || secondS.length() != 2) {
                this.throwInvalidFormat(source);
            }
            try {
                int second;
                int minute;
                int hour = Integer.valueOf(hourS);
                if (hour < 1 || hour > 23) {
                    this.throwInvalidDateTime(source);
                }
                if ((minute = Integer.valueOf(minuteS).intValue()) < 1 || minute > 59) {
                    this.throwInvalidDateTime(source);
                }
                if ((second = Integer.valueOf(secondS).intValue()) < 1 || second > 59) {
                    this.throwInvalidDateTime(source);
                }
            }
            catch (Exception e) {
                this.throwInvalidDateTime(source);
            }
        } else {
            this.throwInvalidFormat(source);
        }
        this.year = yearS;
        this.month = monthS;
        this.day = dayS;
        this.hour = hourS;
        this.minute = minuteS;
        this.second = secondS;
    }

    private void throwInvalidFormat(String source) {
        throw new IllegalArgumentException("source is not in a supported format. " + source);
    }

    private void throwInvalidDateTime(String source) {
        throw new IllegalArgumentException("source does not represent a valid date time. " + source);
    }

    public String toString() {
        return this.get();
    }
}

