/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Age;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.GrowChartPdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.SEX_N_LANGUAGE;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HC_WFL024 {
    private String fullname;
    private LocalDate birthdate;
    private String recordnumber;
    private String gestionalAgeAtBirth;
    private int nbJrsPremature = 0;
    private Sex sex;
    private Language language;
    private boolean blackAndWhite;
    private List<DATA> datas;

    public byte[] render() throws Exception {
        boolean skipFirstLine;
        if (this.datas == null) {
            throw new NullPointerException("datas");
        }
        Collections.sort(this.datas, new Comparator<DATA>(){

            @Override
            public int compare(DATA o1, DATA o2) {
                return o1.date.compareTo((IPartialDate)o2.date);
            }
        });
        byte[] pdf = GrowChartPdfUtil.readFile("HC-WFL_Birth-24", this.getSex(), this.getLanguage(), this.isBlackAndWhite());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfReader reader = new PdfReader(pdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
        boolean page = true;
        PdfContentByte overContent = stamper.getOverContent(1);
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        overContent.setFontAndSize(font, 10.0f);
        overContent.beginText();
        SEX_N_LANGUAGE sexLang = this.getSexLang();
        float x = 400.0f;
        float y = 730.0f;
        overContent.showTextAligned(0, this.getFullname(), x, y, 0.0f);
        if (this.birthdate != null) {
            x = 395.0f;
            y = 716.0f;
            overContent.showTextAligned(0, this.birthdate.formatSlash(), x, y, 0.0f);
        }
        if (this.recordnumber != null) {
            x = 526.0f;
            y = 716.0f;
            overContent.showTextAligned(0, this.recordnumber, x, y, 0.0f);
        }
        if (this.getSex() == Sex.BOYS && this.getLanguage() == Language.EN) {
            x = 360.0f;
            y = 138.0f;
        } else if (this.getSex() == Sex.BOYS && this.getLanguage() == Language.FR) {
            x = 385.0f;
            y = 138.0f;
        } else if (this.getSex() == Sex.GIRLS && this.getLanguage() == Language.EN) {
            x = 360.0f;
            y = 135.0f;
        } else if (this.getSex() == Sex.GIRLS && this.getLanguage() == Language.FR) {
            x = 385.0f;
            y = 135.0f;
        }
        if (this.gestionalAgeAtBirth != null) {
            overContent.setFontAndSize(font, 7.0f);
            overContent.showTextAligned(0, this.gestionalAgeAtBirth, x, y, 0.0f);
        }
        float xStart = 262.0f;
        float xEnd = 517.0f;
        float yEnd = 126.25f;
        float dateXSize = 55.0f;
        float ageXSize = 52.0f;
        float lengthXSize = 50.0f;
        float weightXSize = 50.0f;
        float imcXSize = 50.0f;
        if (this.getSex() == Sex.GIRLS) {
            yEnd -= 3.0f;
        }
        if (this.getLanguage() == Language.FR) {
            dateXSize = 45.0f;
            ageXSize = 45.0f;
            lengthXSize = 55.0f;
            weightXSize = 55.0f;
            imcXSize = 55.0f;
        }
        overContent.setFontAndSize(font, 6.0f);
        int reportTextLinesNumber = 8;
        int datasOffset = Math.max(0, this.datas.size() - reportTextLinesNumber);
        boolean bl = skipFirstLine = this.datas.size() > 0 && this.datas.get((int)(0 + datasOffset)).date != this.birthdate;
        if (skipFirstLine) {
            reportTextLinesNumber = 7;
            datasOffset = Math.max(0, this.datas.size() - reportTextLinesNumber);
        }
        int i = 0;
        while (i + datasOffset < this.datas.size()) {
            DATA data = this.datas.get(i + datasOffset);
            y = skipFirstLine ? yEnd - 6.0f - (float)(i + 1) * 7.65f : yEnd - 6.0f - (float)i * 7.65f;
            x = xStart + 5.0f;
            overContent.showTextAligned(0, data.date.formatSlash(), x, y, 0.0f);
            if (data.date != this.birthdate) {
                x = xStart + dateXSize + 4.0f;
                overContent.showTextAligned(0, Age.formatMonthDay(this.getBirthdate(), data.date), x, y, 0.0f);
            }
            if (data.length != null) {
                x = xStart + dateXSize + ageXSize + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.length) + " cm", x, y, 0.0f);
            }
            if (data.weight != null) {
                x = xStart + dateXSize + ageXSize + lengthXSize + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.weight.floatValue() / 1000.0f) + " kg", x, y, 0.0f);
            }
            x = i == 0 && this.getLanguage() == Language.FR ? xStart + dateXSize + ageXSize + lengthXSize + weightXSize + 5.0f + 28.0f : xStart + dateXSize + ageXSize + lengthXSize + weightXSize + 5.0f;
            if (data.headCirc != null) {
                overContent.showTextAligned(0, String.valueOf(data.headCirc) + " cm", x, y, 0.0f);
            }
            if (data.comments != null) {
                x = xStart + dateXSize + ageXSize + lengthXSize + weightXSize + imcXSize + 5.0f;
                overContent.showTextAligned(0, data.comments, x, y, 0.0f);
            }
            ++i;
        }
        xStart = 125.0f;
        xEnd = xStart + 393.0f;
        float yStart = 424.0f;
        yEnd = 686.0f;
        switch (sexLang) {
            case BOYS_EN: {
                xStart = 125.0f;
                xEnd = 518.1f;
                yStart = 424.0f;
                yEnd = 686.0f;
                break;
            }
            case BOYS_FR: {
                xStart = 125.0f;
                xEnd = 518.1f;
                yStart = 424.0f;
                yEnd = 686.0f;
                break;
            }
            case GIRLS_EN: {
                xStart = 125.0f;
                xEnd = 518.1f;
                yStart = 428.4f;
                yEnd = 690.3f;
                break;
            }
            case GIRLS_FR: {
                xStart = 125.0f;
                xEnd = 518.1f;
                yStart = 428.4f;
                yEnd = 690.3f;
                break;
            }
        }
        float minYValue = this.getSex() == Sex.BOYS ? 28.4f : 26.4f;
        float maxYValue = this.getSex() == Sex.BOYS ? 56.8f : 54.8f;
        float minXValue = 0.0f;
        float maxXValue = 730.0f;
        ArrayList<Point> dots = new ArrayList<Point>();
        for (DATA data : this.datas) {
            if (data.headCirc == null) continue;
            float dayStart = (float)(data.date.dayFrom1970 - this.birthdate.dayFrom1970 - this.getNbJrsPremature()) - minXValue;
            dayStart = dayStart < 0.0f ? 0.0f : dayStart;
            x = xStart + (xEnd - xStart) * dayStart / (maxXValue - minXValue);
            y = yStart + (yEnd - yStart) * ((data.headCirc.floatValue() - minYValue) / (maxYValue - minYValue));
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i2 = dots.size() - 1; i2 >= 0; --i2) {
            overContent.lineTo(((Point)dots.get((int)i2)).x, ((Point)dots.get((int)i2)).y);
        }
        switch (sexLang) {
            case BOYS_EN: {
                xStart = 125.0f;
                xEnd = xStart + 393.0f;
                yStart = 94.2f;
                yEnd = 543.8f;
                break;
            }
            case BOYS_FR: {
                xStart = 125.0f;
                xEnd = xStart + 393.0f;
                yStart = 91.5f;
                yEnd = 554.75f;
                break;
            }
            case GIRLS_EN: {
                xStart = 125.0f;
                xEnd = xStart + 393.0f;
                yStart = 91.5f;
                yEnd = 554.75f;
                break;
            }
            case GIRLS_FR: {
                xStart = 125.0f;
                xEnd = xStart + 393.0f;
                yStart = 91.5f;
                yEnd = 554.75f;
                break;
            }
        }
        minYValue = this.getSex() == Sex.BOYS ? 1400.0f : 1400.0f;
        maxYValue = this.getSex() == Sex.BOYS ? 24600.0f : 25300.0f;
        minXValue = 45.0f;
        maxXValue = 110.0f;
        dots = new ArrayList();
        for (DATA data : this.datas) {
            if (data.weight == null || data.length == null) continue;
            float ry = (data.weight.floatValue() - minYValue) / (maxYValue - minYValue);
            float rx = (data.length.floatValue() - minXValue) / (maxXValue - minXValue);
            y = yStart + (yEnd - yStart) * ry;
            x = xStart + (xEnd - xStart) * rx;
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i3 = dots.size() - 1; i3 >= 0; --i3) {
            overContent.lineTo(((Point)dots.get((int)i3)).x, ((Point)dots.get((int)i3)).y);
        }
        overContent.stroke();
        overContent.endText();
        stamper.close();
        return output.toByteArray();
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getRecordnumber() {
        return this.recordnumber;
    }

    public void setRecordnumber(String recordnumber) {
        this.recordnumber = recordnumber;
    }

    public String getGestionalAgeAtBirth() {
        return this.gestionalAgeAtBirth;
    }

    public void setGestionalAgeAtBirth(String gestionalAgeAtBirth) {
        this.gestionalAgeAtBirth = gestionalAgeAtBirth;
    }

    public final int getNbJrsPremature() {
        return this.nbJrsPremature;
    }

    public final void setNbJrsPremature(int nbJrsPremature) {
        this.nbJrsPremature = nbJrsPremature;
    }

    public List<DATA> getDatas() {
        return this.datas;
    }

    public void setDatas(List<DATA> datas) {
        this.datas = datas;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public boolean isBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackAndWhite = blackAndWhite;
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    private SEX_N_LANGUAGE getSexLang() throws Exception {
        if (this.getLanguage() == Language.EN) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_EN;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_EN;
            }
        }
        if (this.getLanguage() == Language.FR) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_FR;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_FR;
            }
        }
        throw new Exception("unsupported combinaison of sex and language " + (Object)((Object)this.getSex()) + ", " + (Object)((Object)this.getLanguage()));
    }

    public static void main(String[] args) throws Exception {
        String name = "Steeve St-Laurent";
        LocalDate birthdate = Age.parse("2000/08/14");
        String recordnumber = "00015";
        String gestionalAgeAtBirth = "40";
        ArrayList<DATA> datas = new ArrayList<DATA>();
        datas.add(new DATA(Age.parse("2000/08/14"), Float.valueOf(29.0f), Float.valueOf(1000.0f), Float.valueOf(50.0f), "ich"));
        datas.add(new DATA(Age.parse("2000/08/31"), Float.valueOf(32.0f), Float.valueOf(2000.0f), Float.valueOf(50.0f), "bebe"));
        datas.add(new DATA(Age.parse("2000/09/05"), Float.valueOf(33.0f), Float.valueOf(3000.0f), Float.valueOf(55.0f), "mignon"));
        datas.add(new DATA(Age.parse("2000/10/11"), Float.valueOf(34.0f), Float.valueOf(4000.0f), Float.valueOf(55.0f), "joue"));
        datas.add(new DATA(Age.parse("2001/01/01"), Float.valueOf(35.0f), Float.valueOf(6000.0f), Float.valueOf(56.0f), "dort"));
        datas.add(new DATA(Age.parse("2001/02/08"), Float.valueOf(40.0f), Float.valueOf(7000.0f), Float.valueOf(58.0f), "rie"));
        datas.add(new DATA(Age.parse("2001/03/11"), Float.valueOf(44.0f), Float.valueOf(8000.0f), Float.valueOf(62.0f), "pleure"));
        datas.add(new DATA(Age.parse("2001/06/04"), Float.valueOf(45.0f), Float.valueOf(12000.0f), Float.valueOf(66.0f), "boie"));
        datas.add(new DATA(Age.parse("2001/10/01"), Float.valueOf(46.0f), Float.valueOf(15000.0f), Float.valueOf(68.0f), "crie"));
        HC_WFL024 report = new HC_WFL024();
        report.setBirthdate(birthdate);
        report.setGestionalAgeAtBirth("40");
        report.setRecordnumber("00015");
        report.setFullname("Steeve St-Laurent");
        report.setDatas(datas);
        report.setSex(Sex.BOYS);
        report.setLanguage(Language.FR);
        report.setBlackAndWhite(false);
        byte[] pdf = report.render();
        GrowChartPdfUtil.showWithExternalViewer(pdf);
    }

    public static class DATA {
        public LocalDate date;
        public Float headCirc;
        public Float weight;
        public Float length;
        public String comments;

        public DATA(LocalDate date, Float headCircInCm, Float weightInGrams, Float lengthInCm, String comments) {
            this.date = date;
            this.headCirc = headCircInCm;
            this.weight = weightInGrams;
            this.length = lengthInCm;
            this.comments = comments;
        }
    }

    private static class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

