/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.XClient;
import ca.infodata.ofys.data.middle.dataobjects.XRxVigilanceToken;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignatures;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.EnumSet;
import java.util.Locale;

public final class XSession
extends EditableDataObject
implements KryoSerializable {
    private static final long serialVersionUID = -56361219344719913L;
    public Integer id;
    public XUser user;
    public XClient client;
    public XClientPreferences clientPreferences;
    public Locale locale;
    public Integer site;
    public boolean isLocked;
    public EnumSet<XUserRole> role;
    public CUserSignatures signatures;
    public transient XRxVigilanceToken rxVigToken;
    public boolean mustLoadAllLabVersion = false;
    public String apiKeyOrToken = null;
    public String factHttp = null;
    public String factDomain = null;
    public String fmpDomain = null;
    public boolean hasSignature = false;

    @Override
    public void write(Kryo k, Output out) {
        k.writeObjectOrNull(out, (Object)this.user, XUser.class);
        k.writeObjectOrNull(out, (Object)this.client, XClient.class);
        k.writeObjectOrNull(out, (Object)this.clientPreferences, XClientPreferences.class);
        out.writeInt(this.id.intValue(), true);
        if (Locale.FRENCH.getLanguage().equals(this.locale.getLanguage())) {
            out.writeByte((byte)1);
        } else {
            out.writeByte((byte)2);
        }
        out.writeInt(MiscUtil.fromInt(this.site), true);
        out.writeBoolean(this.isLocked);
        if (this.role == null) {
            out.writeShort(0);
        } else {
            out.writeShort(EnumWithValueFactory.to(this.role).intValue());
        }
        k.writeObjectOrNull(out, (Object)this.signatures, CUserSignatures.class);
        out.writeBoolean(this.mustLoadAllLabVersion);
        out.writeString(MiscUtil.fromString(this.apiKeyOrToken));
        out.writeString(MiscUtil.fromString(this.factHttp));
        out.writeString(MiscUtil.fromString(this.factDomain));
        out.writeString(MiscUtil.fromString(this.fmpDomain));
        out.writeBoolean(this.hasSignature);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.user = (XUser)k.readObjectOrNull(in, XUser.class);
        this.client = (XClient)k.readObjectOrNull(in, XClient.class);
        this.clientPreferences = (XClientPreferences)k.readObjectOrNull(in, XClientPreferences.class);
        this.id = in.readInt(true);
        byte lang = in.readByte();
        this.locale = lang == 1 ? Locale.FRENCH : Locale.ENGLISH;
        this.site = MiscUtil.toInt(in.readInt(true));
        this.isLocked = in.readBoolean();
        short role = in.readShort();
        this.role = EnumWithValueFactory.fromSet(XUserRole.class, Integer.valueOf(role));
        this.signatures = (CUserSignatures)k.readObjectOrNull(in, CUserSignatures.class);
        this.mustLoadAllLabVersion = in.readBoolean();
        this.apiKeyOrToken = MiscUtil.toString(in.readString());
        this.factHttp = MiscUtil.toString(in.readString());
        this.factDomain = MiscUtil.toString(in.readString());
        this.fmpDomain = MiscUtil.toString(in.readString());
        this.hasSignature = in.readBoolean();
    }

    @Override
    public void initialize() {
        this.setNew();
        this.role = EnumSet.noneOf(XUserRole.class);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.user != null && this.user.isDirty();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public XUser getUser() {
        return this.user;
    }

    public void setUser(XUser user) {
        this.user = user;
        this.setUpdated();
    }

    public XClient getClient() {
        return this.client;
    }

    public void setClient(XClient client) {
        this.client = client;
        this.setUpdated();
    }

    public XClientPreferences getClientPreferences() {
        return this.clientPreferences;
    }

    public void setClientPreferences(XClientPreferences clientPreferences) {
        this.clientPreferences = clientPreferences;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XSession) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XSession" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XSession clone() {
        XSession c = (XSession)super.clone();
        c.id = this.id;
        if (this.user != null) {
            c.user = this.user.clone();
        }
        if (this.client != null) {
            c.client = this.client.clone();
        }
        c.site = this.site;
        c.locale = this.locale;
        c.signatures = this.signatures;
        c.mustLoadAllLabVersion = this.mustLoadAllLabVersion;
        return c;
    }

    @Override
    public String toString() {
        return String.format("XSession {id=%s,user=%s,client=%s,clientPreferences=%s}", this.id, this.user, this.client, this.clientPreferences);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUpdated();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Integer getSite() {
        return this.site;
    }

    public void setSite(Integer site) {
        this.site = site;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }

    public EnumSet<XUserRole> getRole() {
        return this.role;
    }

    public void setRole(EnumSet<XUserRole> role) {
        this.role = role;
    }

    public CUserSignatures getSignatures() {
        return this.signatures;
    }

    public void setSignatures(CUserSignatures signatures) {
        this.signatures = signatures;
    }
}

