/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.util.List;

public class XBasePerson
implements IPerson {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public Integer idPerson;
    public String str;
    @FieldSerializer.NotNull
    public String lastName;
    public String midInitial;
    @FieldSerializer.NotNull
    public String firstName;
    public String gender;
    public LocalDate birthDate;
    public Short age;
    public Short race;
    public String title;
    public XImageDecorator decorators;
    public boolean isDeleted;
    public EditableDataObjectList<XPersonSite> sites;

    public XBasePerson() {
    }

    public XBasePerson(IPerson person) {
        this.idPerson = person.getIdPerson();
        this.age = person.getAge();
        this.title = person.getTitle();
        this.birthDate = person.getBirthDate();
        this.gender = person.getGender();
        this.firstName = person.getFirstName();
        this.lastName = person.getLastName();
        this.midInitial = person.getMidInitial();
        this.str = person.getName();
        this.decorators = person.getDecorators();
        this.race = person.getRace();
        this.isDeleted = Boolean.TRUE.equals(person.getIsDeleted());
    }

    @Override
    public void initialize() {
        this.birthDate = null;
        this.age = null;
        this.firstName = "";
        this.lastName = "";
        this.gender = "I";
        this.midInitial = "";
        this.title = "";
        this.str = "";
        this.decorators = XImageDecorator.NULL_DECORATORS;
    }

    @Override
    public String getFirstAndLastName() {
        String first = this.getFirstName();
        String last = this.getLastName();
        JoinList list = new JoinList(" ", 2);
        list.setAllowBlank(false);
        list.setTrim(true);
        list.add((CharSequence)first);
        list.add((CharSequence)last);
        return list.toString();
    }

    @Override
    public Integer getIdPerson() {
        return this.idPerson;
    }

    public void setIdPerson(Integer idPerson) {
        this.idPerson = idPerson;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getMidInitial() {
        return this.midInitial;
    }

    public void setMidInitial(String midInitial) {
        this.midInitial = midInitial;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @Override
    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return this.str;
    }

    public void setText(String text) {
        this.str = text;
    }

    @Override
    public String getName() {
        String last = this.getLastName();
        String first = this.getFirstName();
        JoinList list = new JoinList(", ", 2);
        list.setAllowBlank(false);
        list.setTrim(true);
        list.add((CharSequence)last);
        list.add((CharSequence)first);
        return list.toString();
    }

    @Override
    public String getNameBirthdateSex() {
        String sex;
        StringBuilder b = new StringBuilder(30);
        b.append(this.getName());
        LocalDate dob = this.getBirthDate();
        if (dob != null) {
            b.append(' ');
            b.append(LocalDateFormat.format((LocalDate)dob, (String)FormatDateProvider.getFormatDate().toString()));
        }
        if (!StringUtils.isBlank((CharSequence)(sex = this.getGender())) && !"I".equals(sex)) {
            b.append(' ').append('(').append(sex).append(')');
        }
        return b.toString();
    }

    @Override
    public XImageDecorator getDecorators() {
        return this.decorators;
    }

    public void setDecorators(XImageDecorator decorators) {
        this.decorators = decorators;
    }

    @Override
    public Short getAge() {
        return this.age;
    }

    public void setAge(Short age) {
        this.age = age;
    }

    @Override
    public XBasePerson clone() {
        try {
            XBasePerson c = (XBasePerson)super.clone();
            c.decorators = this.decorators == null ? null : this.decorators.clone();
            c.sites = this.sites == null ? null : this.sites.deepClone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Deprecated
    public void copyTo(XBasePerson c) {
        c.idPerson = this.idPerson;
        c.str = this.str;
        c.lastName = this.lastName;
        c.midInitial = this.midInitial;
        c.firstName = this.firstName;
        c.gender = this.gender;
        c.birthDate = this.birthDate;
        c.title = this.title;
        c.decorators = this.decorators;
        c.age = this.age;
        c.sites = this.sites == null ? null : this.sites.deepClone();
        c.isDeleted = this.isDeleted;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XBasePerson) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPerson" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public Short getRace() {
        return this.race;
    }

    public void setRace(Short race) {
        this.race = race;
    }

    public List<XPersonSite> getSites() {
        return this.sites;
    }

    public boolean isAssociatedWithSite(XSite site) {
        if (site == null || site.getId() == null || this.sites == null || this.sites.isEmpty()) {
            return false;
        }
        for (XPersonSite ps : this.sites) {
            if (ps == null || ps.getAddedAs() != SiteAddedAs.WORK_SITE || ps.getIdSite() == null || !ps.getIdSite().equals(site.getId())) continue;
            return true;
        }
        return false;
    }

    public void setSites(EditableDataObjectList<XPersonSite> sites) {
        this.sites = sites;
    }

    @Override
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public IEditableDataObjectList<XPersonSite> getLstSites() {
        return this.sites;
    }
}

