/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.callback;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class JobCallback
extends Callback {
    private static volatile boolean killNextJob;
    private static final List<Job> jobs;
    private static final String VALIDATION;
    private CallbackJob job;
    private IProgressMonitor jobProgressMonitor;

    static {
        jobs = Collections.synchronizedList(new ArrayList());
        VALIDATION = Messages.getString((String)"VALIDATION", (String[])new String[0]);
    }

    @Deprecated
    public static final JobCallback getNullCallback() {
        return new JobCallback(VALIDATION, JustLogStatusHandler.getInstance()){

            @Override
            public void responseReceived(ReturnObject response) {
            }
        };
    }

    public static void killJobs() {
        for (Job job : jobs) {
            job.done(Status.CANCEL_STATUS);
        }
        jobs.clear();
    }

    public static void killNextJob() {
        killNextJob = true;
    }

    public JobCallback() {
        this(BaseAccessorClient.defaultStatusHandler);
    }

    public JobCallback(IStatusHandler statusHandler) {
        this("", statusHandler);
    }

    public JobCallback(String title) {
        this(title, BaseAccessorClient.defaultStatusHandler);
    }

    public JobCallback(String title, IStatusHandler statusHandler) {
        super(statusHandler);
        if (killNextJob) {
            killNextJob = false;
        } else {
            this.job = new CallbackJob(title);
            jobs.add(this.job);
            this.job.schedule();
            this.jobProgressMonitor = this.job.progressMonitor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        super.kill();
        if (this.job != null) {
            this.job.done(Status.OK_STATUS);
        }
        List<Job> list = jobs;
        synchronized (list) {
            jobs.remove((Object)this.job);
        }
    }

    public Job getJob() {
        return this.job;
    }

    public IProgressMonitor getJobProgressMonitor() {
        return this.jobProgressMonitor;
    }

    private static class CallbackJob
    extends Job {
        private IProgressMonitor progressMonitor;

        private static String getJobName(String source) {
            return String.valueOf(source) + "...";
        }

        public CallbackJob(String name) {
            super(CallbackJob.getJobName(name));
        }

        protected IStatus run(IProgressMonitor arg0) {
            this.progressMonitor = arg0;
            return Job.ASYNC_FINISH;
        }
    }
}

