/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IBillingNBAccessor;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.DefaultJobCallback;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XBilling;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XBillingSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XCommunicationLog;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BillingNBAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(BillingNBAccessorClient.class.getName());
    private static BillingNBAccessorClient instance;
    private final IBillingNBAccessor accessor;

    public static BillingNBAccessorClient getInstance() throws CannotConnectToServerException {
        return BillingNBAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static BillingNBAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new BillingNBAccessorClient(serverConnectionInfo);
        }
        return instance;
    }

    private BillingNBAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getBillingNBAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public IPair<? extends IStatus, XBilling> getNewDefaultBilling(XBaseProfessionnal professionnal, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.getNewDefaultBilling(professionnal.getId().intValue());
            callback.response(r);
            IPair iPair = (IPair)r.getObj();
            return iPair;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
            Pair pair = Pair.newPair((Object)new Status(IStatus.Severity.BUG, (Throwable)e), null);
            return pair;
        }
        finally {
            ((Callback)callback).kill();
        }
    }

    public List<XBilling> findBillingNotSentByProfessionnal(XBaseProfessionnal professionnal, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.findBillingNotSentByProfessionnal(professionnal.getId().intValue());
            callback.response(r);
            List list = (List)r.getObj();
            return list;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public void loadBilling(int uniqueKey, XSession session, final ICallback callback, final Collection<Integer> ids) {
        final String key = "PatientAccessorClient.loadBilling" + uniqueKey;
        if (this.isOkToCallFunction(key, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = BillingNBAccessorClient.this.accessor.loadBilling(ids);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            BillingNBAccessorClient.this.functionCallEnded(key, callback);
                        }
                    }
                    finally {
                        BillingNBAccessorClient.this.functionCallEnded(key, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findBilling(int uniqueKey, XSession session, final ICallback callback, final XBillingSearchCriteria criteria) {
        final String key = "PatientAccessorClient.findBilling" + uniqueKey;
        if (this.isOkToCallFunction(key, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = BillingNBAccessorClient.this.accessor.findBilling(criteria);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            BillingNBAccessorClient.this.functionCallEnded(key, callback);
                        }
                    }
                    finally {
                        BillingNBAccessorClient.this.functionCallEnded(key, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<Integer> findBilling(XBillingSearchCriteria criteria, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.findBilling(criteria);
            callback.response(r);
            List list = (List)r.getObj();
            return list;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public void findImmunization(final ICallback callback, final String serviceCode, XSession session) {
        final String key = "PatientAccessorClient.findImmunization" + serviceCode;
        if (this.isOkToCallFunction(key, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = BillingNBAccessorClient.this.accessor.findImmunization(serviceCode);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            BillingNBAccessorClient.this.functionCallEnded(key, callback);
                        }
                    }
                    finally {
                        BillingNBAccessorClient.this.functionCallEnded(key, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XBilling> findAllBillingNotSent(XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.findAllBillingNotSent();
            callback.response(r);
            List list = (List)r.getObj();
            return list;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public List<XCommunicationLog> getAllCommunicationLog(LocalDate start, LocalDate end, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.getAllCommunicationLog(start, end);
            callback.response(r);
            List list = (List)r.getObj();
            return list;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public XCommunicationLog getCommunicationLog(int idCommunicationLog, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.getCommunicationLog(idCommunicationLog);
            callback.response(r);
            XCommunicationLog xCommunicationLog = (XCommunicationLog)r.getObj();
            return xCommunicationLog;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public List<Integer> findAppointmentForBilling(int idProfessionnal, LocalDate date, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.findAppointmentForBilling(idProfessionnal, date);
            callback.response(r);
            List list = (List)r.getObj();
            return list;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public void doNotBillThisAppointment(int idAppointment, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            try {
                ReturnObject r = BillingNBAccessorClient.instance.accessor.doNotBillThisAppointment(idAppointment);
                callback.response(r);
            }
            catch (Exception e) {
                callback.exception(e);
                logger.log(Level.SEVERE, "Erreur", e);
                ((Callback)callback).kill();
            }
        }
        finally {
            ((Callback)callback).kill();
        }
    }

    public XBilling createNewBillingFromAppointment(int idBilling, int idAppointment, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.createNewBillingFromAppointment(idBilling, idAppointment);
            callback.response(r);
            XBilling xBilling = (XBilling)r.getObj();
            return xBilling;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public XBilling createNewBillingSamePatient(int idBilling, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.createNewBillingSamePatient(idBilling);
            callback.response(r);
            XBilling xBilling = (XBilling)r.getObj();
            return xBilling;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    public XBilling createNewBillingSameService(int idBilling, XSession session) {
        DefaultJobCallback callback = new DefaultJobCallback();
        try {
            ReturnObject r = BillingNBAccessorClient.instance.accessor.createNewBillingSameService(idBilling);
            callback.response(r);
            XBilling xBilling = (XBilling)r.getObj();
            return xBilling;
        }
        catch (Exception e) {
            callback.exception(e);
            logger.log(Level.SEVERE, "Erreur", e);
        }
        finally {
            ((Callback)callback).kill();
        }
        return null;
    }

    protected IBillingNBAccessor getAccessor() {
        return this.accessor;
    }
}

