/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain.sommhosp.pdf;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetail;
import ca.infodata.dsq.service.sommhosp.get.PatientDischargeCareDetailDocument;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class PatientDischargeReportPdf {
    private final Candidate candidate;
    private final PatientDischargeCareDetail detail;
    private VIEW_MODE viewMode;
    private String printedBy;

    public PatientDischargeReportPdf(Candidate candidate, PatientDischargeCareDetail detail) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (detail == null) {
            throw new NullPointerException("detail");
        }
        this.detail = detail;
        this.candidate = candidate;
        this.viewMode = VIEW_MODE.VIEW;
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public void setPrintedBy(String printedBy) {
        this.printedBy = printedBy;
    }

    public VIEW_MODE getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(VIEW_MODE viewMode) {
        this.viewMode = viewMode;
    }

    public void getErrorPicture(OutputStream outputStream) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        String title = StringUtils.isBlank((CharSequence)this.detail.title) ? "Sommaire d'hospitalisation" : this.detail.title;
        String text = new JoinList("\n").add((CharSequence)"Erreur lors de la g\u00e9n\u00e9ration du document").add((CharSequence)this.detail.id.value()).add((CharSequence)this.detail.version).toString();
        boolean landscape = false;
        byte[] part = PatientDischargeReportPdf.newPdfFromText(title, text, landscape);
        outputStream.write(part);
        outputStream.flush();
    }

    public void getPicture(OutputStream outputStream) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        ArrayList<byte[]> parts = new ArrayList<byte[]>(3);
        parts.add(this.getDocumentPart(this.detail.document));
        int pageCount = PatientDischargeReportPdf.computePageCount(parts) + 1;
        if (this.viewMode == VIEW_MODE.PRINT) {
            parts.add(0, this.getCoverPageForPrint(pageCount));
        } else {
            parts.add(0, this.getCoverPageForViewer());
        }
        if (parts.size() > 0) {
            byte[] picture = this.joinPdfs((byte[][])parts.toArray((T[])new byte[0][]), pageCount);
            if (this.viewMode != VIEW_MODE.PRINT) {
                PdfReader reader = new PdfReader(picture);
                PdfStamper stamper = new PdfStamper(reader, outputStream);
                stamper.setEncryption(null, null, 0, 1);
                outputStream.flush();
                stamper.close();
                reader.close();
            } else {
                outputStream.write(picture);
                outputStream.flush();
            }
        }
    }

    private byte[] getDocumentPart(PatientDischargeCareDetailDocument document) throws Exception {
        if ("application/PDF".equalsIgnoreCase(document.mediaType)) {
            byte[] pdf = DatatypeConverter.parseBase64Binary((String)document.text);
            return pdf;
        }
        if ("image/png".equalsIgnoreCase(document.mediaType) || "image/gif".equalsIgnoreCase(document.mediaType) || "image/jpeg".equalsIgnoreCase(document.mediaType) || "image/tiff".equalsIgnoreCase(document.mediaType) || "image/png".equalsIgnoreCase(document.mediaType)) {
            byte[] image = DatatypeConverter.parseBase64Binary((String)document.text);
            byte[] pdf = PatientDischargeReportPdf.newPdfFromImage(image);
            return pdf;
        }
        if ("text/rtf".equalsIgnoreCase(document.mediaType)) {
            String text = document.text;
            return PatientDischargeReportPdf.newPdfFromText("", text, true);
        }
        if ("text/plain".equalsIgnoreCase(document.mediaType)) {
            String decodedText = document.text;
            return PatientDischargeReportPdf.newPdfFromText("", decodedText, true);
        }
        return PatientDischargeReportPdf.newPdfFromText(null, "Unsupported mediaType " + document.mediaType, false);
    }

    private static int computePageCount(List<byte[]> parts) throws IOException {
        int pageCount = 0;
        for (byte[] pdf : parts) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            pageCount += pdfReader.getNumberOfPages();
            pdfReader.close();
        }
        return pageCount;
    }

    private static byte[] newPdfFromImage(byte[] data) throws Exception {
        Image image = Image.getInstance((byte[])data);
        boolean landscape = image.getWidth() > image.getHeight();
        Rectangle pageSize = landscape ? PageSize.LETTER.rotate() : PageSize.LETTER;
        int margin = 40;
        float width = pageSize.getRight((float)margin) - pageSize.getLeft((float)margin);
        float height = pageSize.getTop((float)margin) - pageSize.getBottom((float)margin);
        image.scaleToFit(width, height);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        document.add((Element)image);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] getCoverPageForViewer() throws Exception {
        PdfPCell cell;
        Font bold12 = new Font(0, 12.0f, 1);
        Rectangle rect = new Rectangle(PageSize.LETTER);
        rect.setBottom(450.0f);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        String title = StringUtils.isBlank((CharSequence)this.detail.title) ? "Sommaire d'hospitalisation" : this.detail.title;
        document.addTitle(title);
        Paragraph paragraph = new Paragraph(new JoinList("\n", new Object[]{title, this.detail.version}) + "\n\n", bold12);
        paragraph.setAlignment(1);
        document.add((Element)paragraph);
        PdfPTable table = new PdfPTable(new float[]{30.0f, 70.0f});
        table.setWidthPercentage(100.0f);
        table.getDefaultCell().setPadding(5.0f);
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName();
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        table.addCell("Usager");
        table.addCell(StringUtils.join((String)", ", (Object[])new Object[]{name, nam}));
        String status = this.detail.code == null ? "" : ("completed".equalsIgnoreCase(this.detail.code.code) ? "" : ("active".equalsIgnoreCase(this.detail.code.code) ? "Rectifi\u00e9" : ("new".equalsIgnoreCase(this.detail.code.code) ? "Amend\u00e9" : "")));
        if (StringUtils.isNotBlank((String)status)) {
            cell = new PdfPCell(new Phrase(status, bold12));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setPaddingBottom(10.0f);
            table.addCell(cell);
        }
        if (this.detail.fixEffectiveTime != null) {
            table.addCell("Date de la demande de rectification");
            table.addCell(this.detail.fixEffectiveTime.formatTextual());
        }
        if (this.detail.fixReasonCode != null) {
            table.addCell("Raison de la rectification");
            table.addCell(this.format(this.detail.fixReasonCode));
        }
        if (this.detail.effectiveTimeStart != null) {
            table.addCell("Date d'admission");
            table.addCell(this.detail.effectiveTimeStart.formatTextual());
        }
        if (this.detail.effectiveTimeEnd != null) {
            table.addCell("Date de d\u00e9part");
            table.addCell(this.detail.effectiveTimeEnd.formatTextual());
        }
        if (this.detail.lengthOfStayQuantity != null) {
            table.addCell("Dur\u00e9 du s\u00e9jour");
            table.addCell(String.format("%s jour(s)", this.detail.lengthOfStayQuantity.value));
        }
        table.addCell("Intervenant responsable");
        if (this.detail.author != null) {
            table.addCell(String.format("%s, %s (%s)", this.detail.author.getLastName(), this.detail.author.getFirstName(), this.detail.author.getNIU_COLLEGE().value()));
        } else {
            table.addCell("Non sp\u00e9cifi\u00e9");
        }
        table.addCell("Nom du lieu de service");
        if (this.detail.location != null) {
            table.addCell(this.detail.location.getName());
        } else {
            table.addCell("Non sp\u00e9cifi\u00e9");
        }
        cell = new PdfPCell(new Phrase("Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)"));
        cell.setColspan(2);
        cell.setBorder(0);
        cell.setPaddingBottom(10.0f);
        table.addCell(cell);
        if (this.printedBy != null) {
            cell = new PdfPCell(new Phrase(this.printedBy));
            cell.setColspan(2);
            cell.setBorder(0);
            cell.setPaddingBottom(10.0f);
            table.addCell(cell);
        }
        document.add((Element)table);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private String format(Code code) {
        if (code == null) {
            return null;
        }
        if (StringUtils.isNotBlank((String)code.code) && StringUtils.isNotBlank((String)code.text)) {
            return code.text + " (" + code.code + ")";
        }
        if (StringUtils.isNotBlank((String)code.code)) {
            return code.code;
        }
        if (StringUtils.isNotBlank((String)code.text)) {
            return code.text;
        }
        return "";
    }

    private byte[] getCoverPageForPrint(int pageCount) throws Exception {
        return this.getCoverPageForViewer();
    }

    private byte[] joinPdfs(byte[][] pdfs, int pageCount) throws Exception {
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        String patientInformation = StringUtils.join((String)", ", (Object[])new Object[]{name, nam});
        Font font = new Font(2, 12.0f, 0, Color.black);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)outputStream);
        document.open();
        int pageNumber = 1;
        for (byte[] pdf : pdfs) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            int n = pdfReader.getNumberOfPages();
            for (int page = 1; page <= n; ++page) {
                PdfImportedPage importedPage = pdfCopy.getImportedPage(pdfReader, page);
                Rectangle boundingBox = pdfReader.getPageSizeWithRotation(page);
                PdfCopy.PageStamp pageStamp = pdfCopy.createPageStamp(importedPage);
                PdfContentByte overContent = pageStamp.getOverContent();
                if (this.viewMode == VIEW_MODE.PRINT && pageNumber > 1) {
                    float footerBottom;
                    float headerRight;
                    float headerLeft;
                    float headerTop;
                    String pageInfo = String.format("Page %d de %d", pageNumber, pageCount);
                    String disclaimer = "Ces donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)";
                    if (pdfReader.getPageRotation(page) == PdfPage.PORTRAIT.intValue()) {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    } else {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    }
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(patientInformation, font), (float)headerLeft, (float)headerTop, (float)0.0f);
                    overContent.moveTo(headerLeft, headerTop - 5.0f);
                    overContent.lineTo(headerRight, headerTop - 5.0f);
                    overContent.stroke();
                    overContent.moveTo(headerLeft, footerBottom + 15.0f);
                    overContent.lineTo(headerRight, footerBottom + 15.0f);
                    overContent.stroke();
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)2, (Phrase)new Phrase(pageInfo, font), (float)headerRight, (float)footerBottom, (float)0.0f);
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(disclaimer, font), (float)headerLeft, (float)footerBottom, (float)0.0f);
                    pageStamp.alterContents();
                }
                pdfCopy.addPage(importedPage);
                ++pageNumber;
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
        }
        document.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static byte[] newPdfFromText(String title, String text, boolean landscape) throws Exception {
        return PatientDischargeReportPdf.newPdfFromText(title, text, landscape ? PageSize.LETTER.rotate() : PageSize.LETTER);
    }

    private static byte[] newPdfFromText(String title, String text, Rectangle pageSize) throws Exception {
        Paragraph paragraph;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        if (title != null && title.trim().length() > 0) {
            document.addTitle(title);
            paragraph = new Paragraph(title + "\n\n", new Font(0, 12.0f, 1));
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
        }
        paragraph = new Paragraph(text, new Font(0, 12.0f, 0));
        paragraph.setKeepTogether(true);
        document.add((Element)paragraph);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }
}

