/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.text.NumberFormat;

public class ValueWithUnit2
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Object value;
    public final String unit;

    public ValueWithUnit2(Object value, String unit) {
        this.value = value;
        this.unit = unit;
    }

    public String toString() {
        Object svalue = this.value;
        String sunit = this.unit;
        if (this.value instanceof Number) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(5);
            svalue = nf.format(this.value);
            if ("1".equals(this.unit)) {
                sunit = "u";
            }
        }
        if (Helper.isNotBlank(sunit)) {
            return String.format("%s (%s)", svalue, sunit);
        }
        return String.format("%s", svalue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueWithUnit2 other = (ValueWithUnit2)obj;
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.toString().equals(other.value.toString()));
    }
}

