/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.HistoryStatusChange;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IPrescriptionDetails;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.MedicationDispense;
import ca.infodata.dsq.domain.QuantityObservation;
import ca.infodata.dsq.domain.ReferenceProtocol;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.SupplyEventSummary;
import ca.infodata.dsq.domain.SupplyRequestItem;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.tools.Helper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public final class PrescriptionDrugDetails
implements Serializable,
IPrescriptionDetails {
    private static final long serialVersionUID = 1L;
    public String id;
    public String version;
    public Code status;
    public Code code;
    public Long datetime;
    public ILocation location;
    public IProvider prescriber;
    public Medication medication;
    public List<ReferenceProtocol> referenceProtocols;
    public String previousPrescriptionId;
    public String previousPrescriptionVersion;
    public Code previousPrescriptionCode;
    public ArrayList<TherapeuticIntent> reasons;
    public Boolean electronicVersionHasAuthority;
    public String derivedFromCode;
    public ArrayList<QuantityObservation> patientMesures;
    public ArrayList<DosageInstruction> dosageInstructions;
    public Boolean notEligibleForTrial;
    public Code trialSupplyPermissionCode;
    public String supplyRequestStatusCode;
    public Long supplyRequestAllowedPeriodLowDate;
    public Long supplyRequestAllowedPeriodHighDate;
    public Duration supplyRequestAllowedPeriodDuration;
    public ILocation supplyRequestLocation;
    public Long supplyRequestLocationPickupDate;
    public Code supplyRequestLocationSubstitutionConditionCode;
    public ArrayList<SupplyRequestItem> supplyRequestItems;
    public Code substitutionPermissionCode;
    public Boolean substitutionNotAllowedIndicator;
    public Code substitutionNotAllowedReasonCode;
    public ArrayList<Refusal> refusalsToFill;
    public ArrayList<Annotation> annotations;
    public ArrayList<DetectedIssueEvent> detectedIssueEvents;
    public Code treatmentTypeCode;
    public SupplyEventSummary supplyEventSummary;
    public MedicationDispense medicationDispense;
    public ArrayList<HistoryStatusChange> historyStatusChanges;

    public String toString() {
        try {
            return this.normalToString();
        }
        catch (Exception e) {
            return this.failedToString(e);
        }
    }

    private String normalToString() {
        int i;
        String format = "PrescriptionDrugDetails [id=%s, version=%s, status=%s, code=%s, date=%s(%s), \n%s,\n%s\n%s,\n%s,\nPrevious prescription id=%s, version=%s, code=%s,\nPrescribed because of %s\nElectronic Version Has Authority %s\nDerivedFrom code=%s\nPatient mesures{patientMesures}\nDosage instructions (posology){posology}\nNotEligibleForTrial?  %s, %s,\nSubstitutionPermission?  indicator=%s, code=%s, notAllowedReasonCode=%s\nTreatment type %s\nSupply Request\n  statusCode=%s, \n  allowedPeriodLowDate=%s(%s), allowedPeriodHighDate=%s(%s), allowedPeriodDuration=%s\n  location=%s, pickupDate=%s(%s), substitutionConditionCode=%s{items},\nRefusals To Fill{refusals}\nSupplyEventSummary\n%s\nMedicationDispense\n%s\nDetected Issue Events{events}\nHistory Status Change{history}\nAnnotations{annotations}";
        String result = String.format("PrescriptionDrugDetails [id=%s, version=%s, status=%s, code=%s, date=%s(%s), \n%s,\n%s\n%s,\n%s,\nPrevious prescription id=%s, version=%s, code=%s,\nPrescribed because of %s\nElectronic Version Has Authority %s\nDerivedFrom code=%s\nPatient mesures{patientMesures}\nDosage instructions (posology){posology}\nNotEligibleForTrial?  %s, %s,\nSubstitutionPermission?  indicator=%s, code=%s, notAllowedReasonCode=%s\nTreatment type %s\nSupply Request\n  statusCode=%s, \n  allowedPeriodLowDate=%s(%s), allowedPeriodHighDate=%s(%s), allowedPeriodDuration=%s\n  location=%s, pickupDate=%s(%s), substitutionConditionCode=%s{items},\nRefusals To Fill{refusals}\nSupplyEventSummary\n%s\nMedicationDispense\n%s\nDetected Issue Events{events}\nHistory Status Change{history}\nAnnotations{annotations}", this.id, this.version, this.status, this.code, this.datetime, Helper.formatFULLDATETIME(this.datetime), this.prescriber, this.location, this.medication, this.referenceProtocols, this.previousPrescriptionId, this.previousPrescriptionVersion, this.previousPrescriptionCode, this.reasons, this.electronicVersionHasAuthority, this.derivedFromCode, this.notEligibleForTrial, this.trialSupplyPermissionCode, this.substitutionNotAllowedIndicator, this.substitutionPermissionCode, this.substitutionNotAllowedReasonCode, this.treatmentTypeCode, this.supplyRequestStatusCode, this.supplyRequestAllowedPeriodLowDate, Helper.formatFULLDATE(this.supplyRequestAllowedPeriodLowDate), this.supplyRequestAllowedPeriodHighDate, Helper.formatFULLDATE(this.supplyRequestAllowedPeriodHighDate), this.supplyRequestAllowedPeriodDuration, this.supplyRequestLocation, this.supplyRequestLocationPickupDate, Helper.formatFULLDATE(this.supplyRequestLocationPickupDate), this.supplyRequestLocationSubstitutionConditionCode, this.supplyEventSummary, this.medicationDispense);
        String format2 = "";
        if (this.patientMesures != null) {
            for (i = 0; i < this.patientMesures.size(); ++i) {
                format2 = format2 + "\n" + this.patientMesures.get(i);
            }
        }
        result = result.replace("{patientMesures}", format2);
        format2 = "";
        if (this.dosageInstructions != null) {
            for (i = 0; i < this.dosageInstructions.size(); ++i) {
                format2 = format2 + "\n" + this.dosageInstructions.get(i);
            }
        }
        result = result.replace("{posology}", format2);
        format2 = "";
        if (this.supplyRequestItems != null) {
            for (i = 0; i < this.supplyRequestItems.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nitems=";
                }
                format2 = format2 + "\n" + this.supplyRequestItems.get(i);
            }
        }
        result = result.replace("{items}", format2);
        format2 = "";
        if (this.refusalsToFill != null) {
            for (i = 0; i < this.refusalsToFill.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nrefusals=";
                }
                format2 = format2 + "\n" + this.refusalsToFill.get(i);
            }
        }
        result = result.replace("{refusals}", format2);
        format2 = "";
        if (this.detectedIssueEvents != null) {
            for (i = 0; i < this.detectedIssueEvents.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nEvent=";
                }
                format2 = format2 + "\n" + this.detectedIssueEvents.get(i);
            }
        }
        result = result.replace("{events}", format2);
        format2 = "";
        if (this.historyStatusChanges != null) {
            for (i = 0; i < this.historyStatusChanges.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nHistoryStatusChanges=";
                }
                format2 = format2 + "\n" + this.historyStatusChanges.get(i);
            }
        }
        result = result.replace("{history}", format2);
        format2 = "";
        if (this.annotations != null) {
            for (i = 0; i < this.annotations.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nAnnotation=";
                }
                format2 = format2 + "\n" + this.annotations.get(i);
            }
        }
        result = result.replace("{annotations}", format2);
        return result;
    }

    private String failedToString(Exception e) {
        StringBuilder b = new StringBuilder(2000);
        b.append("normal toString failed with \n");
        b.append(e.toString());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        b.append(stringWriter.getBuffer());
        b.append("\n\n");
        b.append("PrescriptionDrugDetails [");
        b.append("id=");
        b.append(this.id);
        b.append(", version=");
        b.append(this.version);
        b.append(", status=");
        b.append(this.status);
        b.append(", code=");
        b.append(this.code);
        b.append(", date=");
        b.append(this.datetime);
        b.append("\n" + this.prescriber + ", ");
        b.append("\n" + this.location + ", ");
        b.append("\n" + this.medication + ", ");
        b.append("\n" + this.referenceProtocols + ", ");
        b.append("\nPrevious prescription ");
        b.append("id=");
        b.append(this.id);
        b.append(", version=");
        b.append(this.version);
        b.append(", code=");
        b.append(this.code);
        b.append("\nPrescribed because of  ");
        b.append(this.reasons);
        b.append("\nElectronic Version Has Authority ");
        b.append(this.electronicVersionHasAuthority);
        b.append("\nDerivedFrom code=");
        b.append(this.derivedFromCode);
        b.append("\nPatient mesures");
        b.append(this.patientMesures);
        b.append("\nDosage instructions (posology)");
        b.append(this.dosageInstructions);
        b.append("\nNotEligibleForTrial? " + this.notEligibleForTrial + ", " + this.trialSupplyPermissionCode);
        b.append("\nSubstitutionPermission?  indicator=" + this.substitutionNotAllowedIndicator);
        b.append(", code=" + this.substitutionPermissionCode);
        b.append(", notAllowedReasonCode=" + this.substitutionNotAllowedReasonCode);
        b.append("\nTreatment type " + this.treatmentTypeCode);
        b.append("\nSupply Request ");
        b.append("\n statusCode=" + this.supplyRequestStatusCode);
        b.append("\n allowedPeriodLowDate=" + this.supplyRequestAllowedPeriodLowDate);
        b.append(" allowedPeriodHighDate=" + this.supplyRequestAllowedPeriodHighDate);
        b.append(" allowedPeriodDuration=" + this.supplyRequestAllowedPeriodDuration);
        b.append("\n location= " + this.supplyRequestLocation);
        b.append(" pickupDate=" + this.supplyRequestLocationPickupDate);
        b.append(" substitutionConditionCode= " + this.supplyRequestLocationSubstitutionConditionCode);
        b.append("\nSupply Request Items= " + this.supplyRequestItems);
        b.append("\nRefusals To Fill= " + this.refusalsToFill);
        b.append("\n=SupplyEventSummary " + this.supplyEventSummary);
        b.append("\nDetected Issue Events= " + this.detectedIssueEvents);
        b.append("\nAnnotations= " + this.annotations);
        return b.toString();
    }

    @Override
    public Long getDatetime() {
        return this.datetime;
    }

    @Override
    public Boolean getElectronicVersionHasAuthority() {
        return this.electronicVersionHasAuthority;
    }

    @Override
    public Boolean getHasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public Boolean getHasIssues() {
        return this.detectedIssueEvents != null && !this.detectedIssueEvents.isEmpty();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IProvider getPrescriber() {
        return this.prescriber;
    }

    @Override
    public ArrayList<TherapeuticIntent> getReasons() {
        return this.reasons;
    }

    @Override
    public ArrayList<Refusal> getRefusalsToFill() {
        return this.refusalsToFill;
    }

    @Override
    public Code getStatus() {
        return this.status;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ArrayList<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ArrayList<DetectedIssueEvent> getDetectedIssueEvents() {
        return this.detectedIssueEvents;
    }

    @Override
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public String getPreviousPrescriptionId() {
        return this.previousPrescriptionId;
    }

    @Override
    public String getPreviousPrescriptionVersion() {
        return this.previousPrescriptionVersion;
    }

    @Override
    public ILocation getSupplyRequestLocation() {
        return this.supplyRequestLocation;
    }

    @Override
    public IPrescriptionDetails getDetail() {
        return this;
    }

    @Override
    public void setDetail(IPrescriptionDetails detail) {
    }
}

