/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;

public class AssignKMeans_F64
implements AssignCluster<double[]> {
    List<double[]> clusters;

    public AssignKMeans_F64(List<double[]> clusters) {
        this.clusters = clusters;
    }

    public AssignKMeans_F64(AssignKMeans_F64 original) {
        this.clusters = new ArrayList<double[]>();
        for (int i = 0; i < original.clusters.size(); ++i) {
            this.clusters.add((double[])original.clusters.get(i).clone());
        }
    }

    @Override
    public int assign(double[] point) {
        int best = -1;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < this.clusters.size(); ++i) {
            double score = StandardKMeans_F64.distanceSq(point, this.clusters.get(i));
            if (!(score < bestScore)) continue;
            bestScore = score;
            best = i;
        }
        return best;
    }

    @Override
    public void assign(double[] point, double[] fit) {
        int i;
        Arrays.fill(fit, 0.0);
        double max = 0.0;
        for (int i2 = 0; i2 < this.clusters.size(); ++i2) {
            double d;
            fit[i2] = d = StandardKMeans_F64.distanceSq(point, this.clusters.get(i2));
            if (!(d > max)) continue;
            max = d;
        }
        double total = 0.0;
        int i3 = 0;
        while (i3 < this.clusters.size()) {
            int n = i3++;
            double d = fit[n] / max;
            fit[n] = d;
            total += d;
        }
        double total2 = 0.0;
        for (i = 0; i < this.clusters.size(); ++i) {
            fit[i] = total - fit[i];
            total2 += fit[i];
        }
        i = 0;
        while (i < this.clusters.size()) {
            int n = i++;
            fit[n] = fit[n] / total2;
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.clusters.size();
    }

    @Override
    public AssignCluster<double[]> copy() {
        return new AssignKMeans_F64(this);
    }

    public List<double[]> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<double[]> clusters) {
        this.clusters = clusters;
    }
}

