/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class VisOdomPixelDepthPnP<T extends ImageBase<T>> {
    private int thresholdAdd;
    private int thresholdRetire;
    private boolean doublePass;
    private PointTrackerTwoPass<T> tracker;
    private ImagePixelTo3D pixelTo3D;
    private Point2Transform2_F64 pixelToNorm;
    private Point2Transform2_F64 normToPixel;
    private RefinePnP refine;
    private ModelMatcher<Se3_F64, Point2D3D> motionEstimator;
    private List<Point2D3DTrack> inlierTracks = new ArrayList<Point2D3DTrack>();
    private Se3_F64 keyToWorld = new Se3_F64();
    private Se3_F64 currToKey = new Se3_F64();
    private Se3_F64 currToWorld = new Se3_F64();
    private boolean first = true;
    private long tick;
    private Se3_F64 temp = new Se3_F64();

    public VisOdomPixelDepthPnP(int thresholdAdd, int thresholdRetire, boolean doublePass, ModelMatcher<Se3_F64, Point2D3D> motionEstimator, ImagePixelTo3D pixelTo3D, RefinePnP refine, PointTrackerTwoPass<T> tracker, Point2Transform2_F64 pixelToNorm, Point2Transform2_F64 normToPixel) {
        this.thresholdAdd = thresholdAdd;
        this.thresholdRetire = thresholdRetire;
        this.doublePass = doublePass;
        this.motionEstimator = motionEstimator;
        this.pixelTo3D = pixelTo3D;
        this.refine = refine;
        this.tracker = tracker;
        this.pixelToNorm = pixelToNorm;
        this.normToPixel = normToPixel;
    }

    public void reset() {
        this.tracker.reset();
        this.keyToWorld.reset();
        this.currToKey.reset();
        this.first = true;
        this.tick = 0L;
    }

    public boolean process(T image) {
        this.tracker.process(image);
        ++this.tick;
        this.inlierTracks.clear();
        if (this.first) {
            this.addNewTracks();
            this.first = false;
        } else {
            if (!this.estimateMotion()) {
                return false;
            }
            this.dropUnusedTracks();
            int N = this.motionEstimator.getMatchSet().size();
            if (this.thresholdAdd <= 0 || N < this.thresholdAdd) {
                this.changePoseToReference();
                this.addNewTracks();
            }
        }
        return true;
    }

    private void changePoseToReference() {
        Se3_F64 keyToCurr = this.currToKey.invert((Se3_F64)null);
        List<PointTrack> all = this.tracker.getAllTracks(null);
        for (PointTrack t : all) {
            Point2D3DTrack p = (Point2D3DTrack)t.getCookie();
            SePointOps_F64.transform(keyToCurr, p.location, p.location);
        }
        this.concatMotion();
    }

    private int dropUnusedTracks() {
        List<PointTrack> all = this.tracker.getAllTracks(null);
        int num = 0;
        for (PointTrack t : all) {
            Point2D3DTrack p = (Point2D3DTrack)t.getCookie();
            if (this.tick - p.lastInlier <= (long)this.thresholdRetire) continue;
            this.tracker.dropTrack(t);
            ++num;
        }
        return num;
    }

    private void addNewTracks() {
        this.tracker.spawnTracks();
        List<PointTrack> spawned = this.tracker.getNewTracks(null);
        for (PointTrack t : spawned) {
            Point2D3DTrack p = (Point2D3DTrack)t.getCookie();
            if (p == null) {
                p = new Point2D3DTrack();
                t.cookie = p;
            }
            if (!this.pixelTo3D.process(t.x, t.y) || this.pixelTo3D.getW() == 0.0) {
                this.tracker.dropTrack(t);
                continue;
            }
            Point3D_F64 X2 = p.getLocation();
            double w = this.pixelTo3D.getW();
            X2.set(this.pixelTo3D.getX() / w, this.pixelTo3D.getY() / w, this.pixelTo3D.getZ() / w);
            p.lastInlier = this.tick;
            this.pixelToNorm.compute(t.x, t.y, p.observation);
        }
    }

    private boolean estimateMotion() {
        Se3_F64 keyToCurr;
        List<PointTrack> active = this.tracker.getActiveTracks(null);
        ArrayList<Point2D3D> obs = new ArrayList<Point2D3D>();
        for (PointTrack t : active) {
            Point2D3D p = (Point2D3D)t.getCookie();
            this.pixelToNorm.compute(t.x, t.y, p.observation);
            obs.add(p);
        }
        if (!this.motionEstimator.process(obs)) {
            return false;
        }
        if (this.doublePass && !this.performSecondPass(active, obs)) {
            return false;
        }
        this.tracker.finishTracking();
        if (this.refine != null) {
            keyToCurr = new Se3_F64();
            this.refine.fitModel(this.motionEstimator.getMatchSet(), this.motionEstimator.getModelParameters(), keyToCurr);
        } else {
            keyToCurr = this.motionEstimator.getModelParameters();
        }
        keyToCurr.invert(this.currToKey);
        int N = this.motionEstimator.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            int index = this.motionEstimator.getInputIndex(i);
            Point2D3DTrack t = (Point2D3DTrack)active.get(index).getCookie();
            t.lastInlier = this.tick;
            this.inlierTracks.add(t);
        }
        return true;
    }

    private boolean performSecondPass(List<PointTrack> active, List<Point2D3D> obs) {
        Point2D3D p;
        Se3_F64 keyToCurr = this.motionEstimator.getModelParameters();
        Point3D_F64 cameraPt = new Point3D_F64();
        Point2D_F64 predicted = new Point2D_F64();
        List<PointTrack> all = this.tracker.getAllTracks(null);
        for (PointTrack t : all) {
            p = (Point2D3D)t.getCookie();
            SePointOps_F64.transform(keyToCurr, p.location, cameraPt);
            this.normToPixel.compute(cameraPt.x / cameraPt.z, cameraPt.y / cameraPt.z, predicted);
            this.tracker.setHint(predicted.x, predicted.y, t);
        }
        this.tracker.performSecondPass();
        active.clear();
        obs.clear();
        this.tracker.getActiveTracks(active);
        for (PointTrack t : active) {
            p = (Point2D3D)t.getCookie();
            this.pixelToNorm.compute(t.x, t.y, p.observation);
            obs.add(p);
        }
        return this.motionEstimator.process(obs);
    }

    private void concatMotion() {
        this.currToKey.concat(this.keyToWorld, this.temp);
        this.keyToWorld.set(this.temp);
        this.currToKey.reset();
    }

    public Se3_F64 getCurrToWorld() {
        this.currToKey.concat(this.keyToWorld, this.currToWorld);
        return this.currToWorld;
    }

    public PointTracker<T> getTracker() {
        return this.tracker;
    }

    public ModelMatcher<Se3_F64, Point2D3D> getMotionEstimator() {
        return this.motionEstimator;
    }

    public List<Point2D3DTrack> getInlierTracks() {
        return this.inlierTracks;
    }

    public void setPixelToNorm(Point2Transform2_F64 pixelToNorm) {
        this.pixelToNorm = pixelToNorm;
    }

    public void setNormToPixel(Point2Transform2_F64 normToPixel) {
        this.normToPixel = normToPixel;
    }

    public long getTick() {
        return this.tick;
    }
}

