/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene;

import boofcv.alg.scene.FeatureToWordHistogram;
import boofcv.struct.feature.TupleDesc_F64;
import java.util.Arrays;
import org.ddogleg.clustering.AssignCluster;

public class FeatureToWordHistogram_F64
implements FeatureToWordHistogram<TupleDesc_F64> {
    private AssignCluster<double[]> assignment;
    private boolean hardAssignment;
    private int total;
    private double[] histogram;
    private double[] temp;
    private boolean processed;

    public FeatureToWordHistogram_F64(AssignCluster<double[]> assignment, boolean hardAssignment) {
        this.assignment = assignment;
        this.hardAssignment = hardAssignment;
        this.histogram = new double[assignment.getNumberOfClusters()];
        if (!hardAssignment) {
            this.temp = new double[assignment.getNumberOfClusters()];
        }
    }

    @Override
    public void reset() {
        this.total = 0;
        this.processed = false;
        Arrays.fill(this.histogram, 0.0);
    }

    @Override
    public void addFeature(TupleDesc_F64 feature) {
        if (this.hardAssignment) {
            int n = this.assignment.assign(feature.getValue());
            this.histogram[n] = this.histogram[n] + 1.0;
        } else {
            this.assignment.assign(feature.getValue(), this.temp);
            for (int i = 0; i < this.histogram.length; ++i) {
                int n = i;
                this.histogram[n] = this.histogram[n] + this.temp[i];
            }
        }
        ++this.total;
    }

    @Override
    public void process() {
        this.processed = true;
        int i = 0;
        while (i < this.histogram.length) {
            int n = i++;
            this.histogram[n] = this.histogram[n] / (double)this.total;
        }
    }

    @Override
    public double[] getHistogram() {
        if (!this.processed) {
            throw new RuntimeException("Must call process first before histogram is valid");
        }
        return this.histogram;
    }

    @Override
    public int getTotalWords() {
        return this.histogram.length;
    }
}

