/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.f.EpipolarMinimizeGeometricError;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import org.ejml.data.DMatrixRMaj;

public class TrifocalTransfer {
    TrifocalTensor tensor;
    TrifocalExtractGeometries extract = new TrifocalExtractGeometries();
    DMatrixRMaj F21 = new DMatrixRMaj(3, 3);
    DMatrixRMaj F31 = new DMatrixRMaj(3, 3);
    EpipolarMinimizeGeometricError adjuster = new EpipolarMinimizeGeometricError();
    Point2D_F64 pa = new Point2D_F64();
    Point2D_F64 pb = new Point2D_F64();
    Point3D_F64 la = new Point3D_F64();
    Vector3D_F64 l = new Vector3D_F64();

    public void setTrifocal(TrifocalTensor tensor) {
        this.tensor = tensor;
        this.extract.setTensor(tensor);
        this.extract.extractFundmental(this.F21, this.F31);
    }

    public void transfer_1_to_3(double x1, double y1, double x2, double y2, Point3D_F64 p3) {
        this.adjuster.process(this.F21, x1, y1, x2, y2, this.pa, this.pb);
        GeometryMath_F64.mult(this.F21, this.pa, (GeoTuple3D_F64)this.la);
        this.l.x = this.la.y;
        this.l.y = -this.la.x;
        this.l.z = -this.pb.x * this.la.y + this.pb.y * this.la.x;
        MultiViewOps.transfer_1_to_3(this.tensor, this.pa, this.l, p3);
    }

    public void transfer_1_to_2(double x1, double y1, double x3, double y3, Point3D_F64 p2) {
        this.adjuster.process(this.F31, x1, y1, x3, y3, this.pa, this.pb);
        GeometryMath_F64.multTran(this.F31, this.pa, this.la);
        this.l.x = this.la.y;
        this.l.y = -this.la.x;
        this.l.z = -this.pb.x * this.la.y + this.pb.y * this.la.x;
        MultiViewOps.transfer_1_to_2(this.tensor, this.pa, this.l, p2);
    }
}

