/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class DecomposeEssential {
    private SingularValueDecomposition<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(3, 3, true, true, false);
    DMatrixRMaj U;
    DMatrixRMaj S;
    DMatrixRMaj V;
    List<Se3_F64> solutions = new ArrayList<Se3_F64>();
    DMatrixRMaj E_copy = new DMatrixRMaj(3, 3);
    DMatrixRMaj temp = new DMatrixRMaj(3, 3);
    DMatrixRMaj temp2 = new DMatrixRMaj(3, 3);
    DMatrixRMaj Rz = new DMatrixRMaj(3, 3);

    public DecomposeEssential() {
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.Rz.set(0, 1, 1.0);
        this.Rz.set(1, 0, -1.0);
        this.Rz.set(2, 2, 1.0);
    }

    public void decompose(DMatrixRMaj E) {
        if (this.svd.inputModified()) {
            this.E_copy.set(E);
            E = this.E_copy;
        }
        if (!this.svd.decompose(E)) {
            throw new RuntimeException("Svd some how failed");
        }
        this.U = this.svd.getU(this.U, false);
        this.V = this.svd.getV(this.V, false);
        this.S = this.svd.getW(this.S);
        SingularOps_DDRM.descendingOrder(this.U, false, this.S, this.V, false);
        this.decompose(this.U, this.S, this.V);
    }

    public void decompose(DMatrixRMaj U, DMatrixRMaj S, DMatrixRMaj V) {
        if (CommonOps_DDRM.det(U) < 0.0) {
            CommonOps_DDRM.scale(-1.0, U);
            CommonOps_DDRM.scale(-1.0, S);
        }
        if (CommonOps_DDRM.det(V) < 0.0) {
            CommonOps_DDRM.scale(-1.0, V);
            CommonOps_DDRM.scale(-1.0, S);
        }
        this.extractTransform(U, V, S, this.solutions.get(0), true, true);
        this.extractTransform(U, V, S, this.solutions.get(1), true, false);
        this.extractTransform(U, V, S, this.solutions.get(2), false, false);
        this.extractTransform(U, V, S, this.solutions.get(3), false, true);
    }

    public List<Se3_F64> getSolutions() {
        return this.solutions;
    }

    private void extractTransform(DMatrixRMaj U, DMatrixRMaj V, DMatrixRMaj S, Se3_F64 se, boolean optionA, boolean optionB) {
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        if (optionA) {
            CommonOps_DDRM.mult(U, this.Rz, this.temp);
        } else {
            CommonOps_DDRM.multTransB(U, this.Rz, this.temp);
        }
        CommonOps_DDRM.multTransB(this.temp, V, R);
        if (optionB) {
            CommonOps_DDRM.multTransB(U, this.Rz, this.temp);
        } else {
            CommonOps_DDRM.mult(U, this.Rz, this.temp);
        }
        CommonOps_DDRM.mult(this.temp, S, this.temp2);
        CommonOps_DDRM.multTransB(this.temp2, U, this.temp);
        T.x = this.temp.get(2, 1);
        T.y = this.temp.get(0, 2);
        T.z = this.temp.get(1, 0);
    }
}

