/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public class ImplEdgeNonMaxSuppressionCrude {
    public static void inner4(GrayF32 intensity, GrayF32 derivX, GrayF32 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        for (int y = 1; y < h; ++y) {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0.0f ? 1 : -1;
                int dy = derivY.data[indexY] > 0.0f ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        }
    }

    public static void inner4(GrayF32 intensity, GrayS16 derivX, GrayS16 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        for (int y = 1; y < h; ++y) {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0 ? 1 : -1;
                int dy = derivY.data[indexY] > 0 ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        }
    }

    public static void inner4(GrayF32 intensity, GrayS32 derivX, GrayS32 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        for (int y = 1; y < h; ++y) {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0 ? 1 : -1;
                int dy = derivY.data[indexY] > 0 ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        }
    }

    public static void border4(GrayF32 _intensity, GrayF32 derivX, GrayF32 derivY, GrayF32 output) {
        float right;
        float middle;
        float left;
        int dy;
        int dx;
        int x;
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        for (x = 0; x < w; ++x) {
            dx = derivX.get(x, 0) > 0.0f ? 1 : -1;
            dy = derivY.get(x, 0) > 0.0f ? 1 : -1;
            left = intensity.get(x - dx, -dy);
            middle = intensity.get(x, 0);
            right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
                continue;
            }
            output.set(x, 0, middle);
        }
        for (x = 0; x < w; ++x) {
            dx = derivX.get(x, h) > 0.0f ? 1 : -1;
            dy = derivY.get(x, h) > 0.0f ? 1 : -1;
            left = intensity.get(x - dx, h - dy);
            middle = intensity.get(x, h);
            right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
                continue;
            }
            output.set(x, h, middle);
        }
        for (int y = 1; y < h; ++y) {
            dx = derivX.get(0, y) > 0.0f ? 1 : -1;
            dy = derivY.get(0, y) > 0.0f ? 1 : -1;
            left = intensity.get(-dx, y - dy);
            middle = intensity.get(0, y);
            right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
                continue;
            }
            output.set(0, y, middle);
        }
        int ww = w - 1;
        for (int y = 1; y < h; ++y) {
            int dx2 = derivX.get(ww, y) > 0.0f ? 1 : -1;
            int dy2 = derivY.get(ww, y) > 0.0f ? 1 : -1;
            float left2 = intensity.get(ww - dx2, y - dy2);
            float middle2 = intensity.get(ww, y);
            float right2 = intensity.get(ww + dx2, y + dy2);
            if (left2 > middle2 || right2 > middle2) {
                output.set(ww, y, 0.0f);
                continue;
            }
            output.set(ww, y, middle2);
        }
    }

    public static void border4(GrayF32 _intensity, GrayI derivX, GrayI derivY, GrayF32 output) {
        float right;
        float middle;
        float left;
        int dy;
        int dx;
        int x;
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        for (x = 0; x < w; ++x) {
            dx = derivX.get(x, 0) > 0 ? 1 : -1;
            dy = derivY.get(x, 0) > 0 ? 1 : -1;
            left = intensity.get(x - dx, -dy);
            middle = intensity.get(x, 0);
            right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
                continue;
            }
            output.set(x, 0, middle);
        }
        for (x = 0; x < w; ++x) {
            dx = derivX.get(x, h) > 0 ? 1 : -1;
            dy = derivY.get(x, h) > 0 ? 1 : -1;
            left = intensity.get(x - dx, h - dy);
            middle = intensity.get(x, h);
            right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
                continue;
            }
            output.set(x, h, middle);
        }
        for (int y = 1; y < h; ++y) {
            dx = derivX.get(0, y) > 0 ? 1 : -1;
            dy = derivY.get(0, y) > 0 ? 1 : -1;
            left = intensity.get(-dx, y - dy);
            middle = intensity.get(0, y);
            right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
                continue;
            }
            output.set(0, y, middle);
        }
        int ww = w - 1;
        for (int y = 1; y < h; ++y) {
            int dx2 = derivX.get(ww, y) > 0 ? 1 : -1;
            int dy2 = derivY.get(ww, y) > 0 ? 1 : -1;
            float left2 = intensity.get(ww - dx2, y - dy2);
            float middle2 = intensity.get(ww, y);
            float right2 = intensity.get(ww + dx2, y + dy2);
            if (left2 > middle2 || right2 > middle2) {
                output.set(ww, y, 0.0f);
                continue;
            }
            output.set(ww, y, middle2);
        }
    }
}

