/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveDown;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericConvolveDown<Input extends ImageBase<Input>, Output extends ImageBase<Output>>
implements ConvolveDown<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    int skip;
    ImageType<Input> inputType;
    ImageType<Output> outputType;

    public GenericConvolveDown(Method m, KernelBase kernel, BorderType type, int skip, ImageType<Input> inputType, ImageType<Output> outputType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.skip = skip;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    @Override
    public int getSkip() {
        return this.skip;
    }

    @Override
    public void setSkip(int skip) {
        this.skip = skip;
    }

    @Override
    public void process(Input input, Output output) {
        try {
            this.m.invoke(null, this.kernel, input, output, this.skip);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return this.getHorizontalBorder();
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public ImageType<Input> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<Output> getOutputType() {
        return this.outputType;
    }
}

