(function () {

    'use strict';
    angular.module("widgets")
    .factory('Markdown', [function () {
      var cnv = new tui.Editor({ el: $('<div></div>')[0] });
       var mdToTxtEditor = new tui.Editor({
         el: $('<div></div>')[0],
         initialEditType: 'wysiwyg',
       });
       var lineParser = {
         copieStr: "",
         ol: function (lines, elem) {
           for (var i = 0; i < elem.childNodes.length; i++) {
             lines.push((i+1) +'. '+ elem.childNodes[i].textContent);
           }
         },
         ul: function (lines, elem) {
           for (var i = 0; i < elem.childNodes.length; i++) {
             if (elem.childNodes[i].className === 'task-list-item' ||
                elem.childNodes[i].className === 'task-list-item checked') { // checkbox list
               lines.push('   '+elem.childNodes[i].textContent);
             }else{
               lines.push('*  ' + elem.childNodes[i].textContent);//bullet list
             }
           }
         },
         table: function (lines, elem) {
           function getrow(e){
             var entries = []
             for (var i = 0; e.childNodes && i < e.childNodes.length; i++) {
               entries.push(e.childNodes[i].textContent);
             }
             return entries.join(' | ')
           }
           function getAllRows(e) {
              for (var i = 0; e.childNodes && i < e.childNodes.length; i++) {
                lines.push(getrow(e.childNodes[i]));
              }
           }
           (function (){
             for (var i = 0; elem.childNodes && i < elem.childNodes.length; i++) {
               var nodeType = elem.childNodes[i].nodeName.toLowerCase();
               if (nodeType === 'thead') { // Table header
                lines.concat(getAllRows(elem.childNodes[i]));
               } else if (nodeType === 'tbody') {// Table body
                 lines = lines.concat(getAllRows(elem.childNodes[i]));
                }else{
                  lines = lines.push(elem.childNodes[i].textContent);
               }
             }
           })();
         },

       }
       function lineToTxt(lines, elem){
         var nodeType = elem.nodeName.toLowerCase();
        if (lineParser[nodeType]) {
          lineParser[nodeType](lines, elem)
        }else{
          lines.push(elem.textContent);
        }
       }
      return {
        MD: '≖',
        toHTML: function (md) {
          if (cnv){
            return cnv.convertor.toHTML(md)
          }
          return "";
        },
        isMD: function(txt) {
          return txt.startsWith(this.MD);
        },
        editorToText: function (editor) {
          var helper = editor.getSquire();
          var txt = helper.get$Body()[0];
          var lines = [];
          for (let i = 0; i < txt.childNodes.length; i++) {
            lineToTxt(lines, txt.childNodes[i]);
          }

          return lines.join('\n');
        },
        escapeMarkdownCharacters(text) {
          return text.replace(/\(/g, '\\(')
            .replace(/\)/g, '\\)')
            .replace(/\[/g, '\\[')
            .replace(/\]/g, '\\]')
            .replace(/</g, '\\<')
            .replace(/>/g, '\\>');
        },
        mdToTxt: function (md) {
          if (md.indexOf(this.MD) === -1) {
            return md;
          }else{
            mdToTxtEditor.setValue(this.getMd(md))
            return this.editorToText(mdToTxtEditor);
          }
        },
        txtToMd: function (txt) {// sanitize text to make sure no markdown specific characters remain unescaped.
          if(txt !== undefined){
            var e = new tui.Editor({
              el: $('<div></div>')[0],
              initialEditType: 'wysiwyg',
            });
            e.wwEditor.getEditor().insertPlainText(txt, !0);
            // return cnv.importManager.escapeMarkdownCharacters(txt)
            return e.getValue();
          }
          return "";
        },
        getMd: function(val) {
          var x = val === undefined ? '' : val;
          if (x.indexOf(this.MD) === 0) {
            x = x.substring(this.MD.length);
          }else{
            x = this.txtToMd(val);
          }
          return x;
        }
      }
    }])
    .directive('toastEditor', ['$filter','DashAPI', 'Markdown', '$compile', function ($filter, DashAPI, Markdown, $compile) {
    'use strict';
    return {
      restrict: 'EA',
      // templateUrl: "/dashboard/resources/ofys/widgets/toasteditor.html",
      controller: ['$scope', '$element', '$attrs', function (scope, element, attr) {
        var firstClick = false;
        this.element = element;
        scope.editor = {txt: ''};
        scope.isMD = false;
        function initEditor() {
          var initialcontent = attr.model ? addMultipleLineBreaks(Markdown.getMd(scope.$eval(attr.model))): '';
          var isViewer = !!(initialcontent);
          var editorContainer;
          if(isViewer){
            editorContainer = $compile('<div class="ofys-tui-editor xxreadOnly" xxresize-toast-to-content-read-only></div>')(scope);
          }else{
            editorContainer = $('<div class="ofys-tui-editor"></div>');
          }
          // scope.switcheditor = function () {
          //   console.log("switched")
          // }
          // element.html()
          // var switchbtn = $(`
          //   <div class="mdSwitch">
          //     <i class="fa" data-ng-class="{'fa-file-text-o': isMD, 'fa-file-word-o': !isMD}" data-ng-click="switcheditor()"aria-hidden="true"></i>
          //   </div>
          // `)
          // $compile(switchbtn.contents())(scope);
          // $(element).append(switchbtn);
          $(element).append(editorContainer);
          var opt = {
            el: editorContainer[0],
            useCommandShortcut: true,
            initialEditType: 'wysiwyg',
            usageStatistics: false,
            initialValue: initialcontent,
            previewStyle: 'vertical',
            height: isViewer ? "20px": '300px',
            exts: ['colorSyntax'],
            language: DashAPI.lang,
            toolbarItems: [
              'heading',
              'bold',
              'italic',
              // 'strike',
              'divider',
              'hr',
              // 'quote',
              // 'divider',
              'ul',
              'ol',
              'task',
              // 'indent',
              // 'outdent',
              // 'divider',
              'table',
              // 'image',
              // 'link',
              // 'divider',
              // 'code',
              // 'codeblock',
              // 'divider',
            ]
          };
          if(isViewer){

        	  var ctrlDown = false,
              ctrlKey = 17,
              cmdKey = 91,
              vKey = 86,
              aKey = 65,
              cKey = 67;
            opt.viewer = isViewer;
           scope.editor.tui = new tui.Editor.factory(opt);
            // scope.editor.tui = new tui.Editor(opt);
            // scope.editor.tui._ui.getModeSwitch().hide();
            // scope.editor.tui._ui._toolbar.$el.remove();

             // To make sure the editor cannot be modified. all keys except the copy command are accepted.
            //  scope.editor.tui.wwEditor.addKeyEventHandler('DEFAULT', function (event) {
            //     if((event.ctrlKey || event.metaKey) && (event.which === cKey || event.which === aKey))return;
            //     event.preventDefault();//Block all keystrokes except ctrl+c and ctrl+a
            // })

          }else{
            scope.editor.tui = new tui.Editor(opt);
            scope.editor.tui._ui.getModeSwitch().hide();
            scope.editor.tui.on('change', updateModel);
            scope.editor.tui.on('blur', updateModel);
            $(".tui-table.tui-toolbar-icons").on('click', function(){
              if(!firstClick){
                firstClick = true;

                new jBox('Notice', {
                  color: 'yellow',
                  content: $filter('translate')("tablePrintWarning"),
                  autoClose: 8000,
                  attributes: {
                    x: 'right',
                  }
                });
              }
            })
            if(attr.maxLengthLock){
              scope.editor.tui.wwEditor.addKeyEventHandler('DEFAULT', function (e) {
                var x = scope.editor.tui.getValue();
                if (x.length > attr.maxLengthLock
                    && e.keyCode !== 46 // keycode for delete
                    && e.keyCode !== 8 // keycode for backspace
                    && !(e.keyCode > 36 && e.keyCode < 41) // keycode for arrow keys left 37 up 38 down 39 right 40
                  ) {
                    e.preventDefault();
                    updateModel()
                }
              });
            }

          }
        }

        function updateModel() {
            setModel(scope.editor.tui.getValue());
        }

        function setModel(data){
            if (scope.editor.input && scope.editor.input.updateModel) {
		        	if(attr.maxLengthLock && data.length > attr.maxLengthLock){
		        		data =  data.substring(0, (attr.maxLengthLock*1)+1 );
		        	}
              scope.editor.input.updateModel(editorToTxt(data));
              if (scope.resizeToastToContentIf) {
                scope.resizeToastToContentIf($(element).find('.ofys-tui-editor'), scope.editor.tui);
              }
            }
        }

        function editorToTxt(editorContent) {
          return Markdown.MD + cleanMultipleLineBreaks(editorContent);
        }

        function cleanMultipleLineBreaks(s) {
        		// return s;
          var a = s.split('\n')
          removeLineBreaks(a)
          // if(s.indexOf("<br>") === 0){
          //   s = s.replace("<br>", "")
          // }
          return a.join("\n")
        }

        /*
          Toast editor adds <br> in text and this causes print issues in some cases this code removes the <br> and replaces it with a \n
          Toast editor only adds the <br> element after every first consecutive line break i.e

          <br>
          <br>
          some text

          if only one line break is the the text no <br> is added.
          A <br> element can be added in table element in mid-phrase. and this
        */
        function addMultipleLineBreaks(s) {
        	// return s;
          var a = s.split('\n')
          var lineBreakBuffer = [];
          for (var i = 0; i < a.length; i++) {
            if(a[i] === ""){
              lineBreakBuffer.push(i);
            }else if(lineBreakBuffer.length > 0){
              if(isBlockStart(a[i])){
                /*
                  Adds line breaks to blocks i.e table, header h1,h2,h3 ordered list, checklist.
                  blocks have a special rule for adding line breaks.
                  for more than 2 line breaks between a block and other text, the block must have
                */
                addLineBreaks(a, lineBreakBuffer, 1, 3 )// 3 because the first element and the last 2 elements dont have a <br> element in blocks
              }else{
                // addMultipleLineBreaksNormal(a, lineBreakBuffer);
                addLineBreaks(a, lineBreakBuffer, 1, 0 )
              }
              lineBreakBuffer = [];// reset buffer because at this point all the line breaks should be taken care of.
            }
          }
          //end of file case.
          if(lineBreakBuffer.length > 0){
            addLineBreaks(a, lineBreakBuffer, 1, 0 )
          }
          return a.join("\n")
        }

        function isBlockStart(s) {
          return (
            s.indexOf("| ") === 0 || // table
            s.indexOf("# ") === 0 ||// header
            s.indexOf("- - -") === 0 ||// Line skip
            s.indexOf("1. ") === 0 ||// ordered list
            s.indexOf("* [") === 0 // checklist
                )
              }

        function addLineBreaks(a, indexes, start, trail) {
          if(indexes.length > start){
            if(indexes[0] === 0){
              start -= 1;
            }
            indexes = indexes.splice(start, indexes.length - trail)

            for (var i = 0; i < indexes.length; i++) {
              a[indexes[i]] = '<br>';
            }
          }
          return a
        }

        function removeLineBreaks(a) {
          for (var i = 0; i < a.length; i++) {
            if(a[i] && a[i] === '<br>'){
              a[i] = "";
            }
          }
        }


        this.getRange = function (md) {
          return {
            s: 0,
            e: 0,
            r: scope.editor.tui.wwEditor.getIMERange()
          }
        }

        this.moveCursorToEndAndOpenAutocomplete = function () {
          scope.editor.tui.focus();
          scope.editor.tui.wwEditor.moveCursorToEnd();
          scope.editor.tui.insertText("\n");
          if(scope.editor.input.openTemplateAssist){
            scope.editor.input.openTemplateAssist();
          }
        }

        function getdiv(d){
          if (d.nodeType === Node.TEXT_NODE) {
            d = d.parentNode;
          }
          return d;
        }

        this.getCursorHeight = function () {
          var d = getdiv(scope.editor.tui.getSquire().getSelection().cloneRange().startContainer);
          var jl = $(d);
          var p = jl.position().top + jl.height() + 35;// line position + height + menu bar height;
          return p
        }

        this.insertText = function (txt, sel) {
          if(sel && sel.r){
            scope.editor.tui.wwEditor.setSelectionByContainerAndOffset(sel.r.startContainer, sel.r.startOffset, sel.r.endContainer, sel.r.endOffset)
          }
          scope.editor.tui.insertText(txt);
        }

        this.insertHTML = function (html, sel) {
          if(sel && sel.r){
            scope.editor.tui.wwEditor.setSelectionByContainerAndOffset(sel.r.startContainer, sel.r.startOffset, sel.r.endContainer, sel.r.endOffset)
          }
          scope.editor.tui.getSquire().insertHTML(html);
        }

        this.setInput = function(input){
          input.show(false);
          scope.editor.input = input;
        }

        //The copy paste function can allow formating that is not supported by jasper print.
        //This function makes sure that the code that is set is only the supported format.
        this.standardizeHtml = function(v){

        }

        this.setValue = function (val) {
          var s = addMultipleLineBreaks(Markdown.getMd(val));
          var editorStr = scope.editor.tui.getValue();

          var cleanS = cleanMultipleLineBreaks(s);
          var cleanEditor = cleanMultipleLineBreaks(editorStr);

          //seems repetitive but the cleaned and uncleaned version have to agree that there is a change.
          // weirdly in some cases they don't agree and cause a false positive editor update which clears the editor (not wanted when typing.)
          //one case in which they dont agree is after a line in bold putting three linebreaks causes this false positive behaviour if only the unclean version is tested.
          if (scope.editor.tui && editorStr !== s && cleanEditor !== cleanS) {
            scope.editor.tui.setValue(s);
          }
        }

        this.focus = function () {
          scope.editor.tui.focus();
        }
        if(attr.toastController){// used by encounter editor for the paste button.
          var bag = scope.$eval(attr.toastController)
          bag.ctrl = this
        }
        initEditor()
      }]
    };
  }]).directive('toastEditorInput', ['Markdown', function (Markdown) {
    'use strict';
    return {
      restrict: 'EA',
      require: ['^^toastEditor', '?ngModel', '^dynaAutocomplete'],
      link: function (scope, element, attr, ctrls) {
        var toastCtrler = ctrls[0];
        var ngModelCtrl = ctrls[1];
        var autocomplete = ctrls[2];

        var input = {el: element, show: function (show) {
            if(show === true){
              $(element).removeClass("hide");
            }else{
              $(element).addClass("hide");
            }
          },
          focus: function () {
            toastCtrler.focus();
          },
          updateModel: function(data){
            if (ngModelCtrl){
              var d = data === Markdown.MD ? "" : data;
              // d = sanitizeHtml(d);	// bogue avec ce sanitize. si faire le parse, le curseur va tjrs à la fin du texte. pas pratique pour écrire un long texte...
              ngModelCtrl.$setViewValue(d);
              $(element).val(d);
            }
          }
        };

        function sanitizeHtml(d){
          var str;
          if(d !== "" && d.indexOf("<") > -1 ){
            var parser = new DOMParser();
            var doc = parser.parseFromString(d, "text/html");
            $(doc.body).find("*").each(function(i, e){
              var curr = $(this);
              // remove all attributes except class, id and style
              getAttributeNames(this.attributes).forEach(function (attr){
                if(attr !== "style" && attr !== "id"){
                  curr.removeAttr(attr);
                }
              });
              // remove all styles except color.
              if(this.hasAttribute("style")){
                curr.css(getStylesClearObj(this.style));
              }
            });

            str = domParserToText(doc);
            return str;
          }
          return d;
        }

        function getStylesClearObj(styles){
          var res = {};
          for (let i = 0; i < styles.length; i++) {
            if(styles[i] !== "color"){
              res[styles[i]] = "";
            }
          }
          return res;
        }

        function getAttributeNames(allAttributes){
          var res = [];
          for (let i = 0; i < allAttributes.length; i++) {
            res.push(allAttributes[i].nodeName);
          }
          return res;
        }

        function domParserToText (doc){
          var s = new XMLSerializer();
          var str = s.serializeToString(doc.body);
          var WRAPPER = '<body xmlns="http://www.w3.org/1999/xhtml">'
          var CLOSE_WRAPPER = '</body>';
          if(str.startsWith(WRAPPER)){
            str = str.substr(WRAPPER.length)
          }
          if(str.endsWith(CLOSE_WRAPPER)){
            str = str.substr(0, str.length - CLOSE_WRAPPER.length)
          }
          return str;
        }

        var unacceptChar = " ;.,:'()$%&*/|!@#<>=+~\\\"\n\r\t≖" + $('<textarea />').html('&nbsp;').text()

        if (autocomplete){
          autocomplete.autocompleteDelegate = {
            openTrigger: function eformFnSetOpenTrigger(baseElement, assistant) {
              input.openTemplateAssist = function(){
                assistant.openAssistant();
              }
              function trigger(e) {
                if (e.ctrlKey && e.which == 32) {
                  e.preventDefault();
                  e.stopPropagation();
                  assistant.openAssistant();
                }
              }

              baseElement.keydown(trigger);
              if (toastCtrler) {
                toastCtrler.element.keydown(trigger);
              }
            },
            searchVal: function(sel){
              if(sel && sel.r){
                //first step, if nothing select, try to get the word before.
                var txt = sel.r.startContainer.data;
                if (sel.r.startOffset == sel.r.endOffset) {
                  while (sel.r.startOffset > 0) {
                    var c = txt.substring(sel.r.startOffset - 1, sel.r.startOffset);
                    if (unacceptChar.indexOf(c) != -1) {
                      break;
                    }
                    sel.r.setStart(sel.r.startContainer, sel.r.startOffset - 1);
                  }
                }
                //second step, if we finaly have something selected, copy it as start value for search
                if (sel.r.startOffset != sel.r.endOffset) {
                  return txt.substring(sel.r.startOffset, sel.r.endOffset);
                }
              }
              return "";

            },
            insertText: function (txt, sel) {
              return toastCtrler.insertText(txt, sel);
            },
            getCursorSelectionObj: function (assistant) {
              return toastCtrler.getRange(scope.$eval(attr.ngModel));
            },
            getHeight: function (assistant) {
                return toastCtrler.getCursorHeight();
            },
            transformTxt: function (txt) {
              return Markdown.txtToMd(txt)
            }
          }
        }

        if (toastCtrler) {
          toastCtrler.setInput(input)
          scope.toastTextAreaInput = input;
        }
        scope.$watch(attr.ngModel, function (model) {
          if (toastCtrler) {
            toastCtrler.setValue(model)
          }
        });
      }
    };
  }]);
})();