(function(){
    var fc = angular.module('fullcalendar', []);

    fc.factory('OfysFCUtils', ['AppointmentAccessor','$filter','model','$translate', 
		 function(AppointmentAccessor, $filter, model, $translate) {


		var apStatusColorMap = {
			"NORMAL":'colorAppointmentStateNormal',
			"MESSAGE_LEAVED":'colorAppointmentStateMessage',
			"CONFIRMED":'colorAppointmentStateConfirmed',
			"WANT_TO_MOVE_AHEAD":'colorAppointmentStateWantAppointmentAhead',
			"CONFIRMATION_MAIL_ENVOI":'colorAppointmentStateConfirmEnvoi',
			"CONFIRMATION_MAIL_RECUE":'colorAppointmentStateConfirmRecue',
			"CONFIRMATION_MAIL_ANNULLE":'colorAppointmentStateCancelRecue',
			"CONFIRMATION_TEXTO_ENVOI":'colorAppointmentStateConfirmEnvoi',
			"CONFIRMATION_TEXTO_RECUE":'colorAppointmentStateConfirmRecue',
			"CONFIRMATION_TEXTO_ANNULLE":'colorAppointmentStateCancelRecue',
			"CONFIRMATION_TELVOCAL_ENVOI":'colorAppointmentStateConfirmEnvoi',
			"CONFIRMATION_TELVOCAL_RECUE":'colorAppointmentStateConfirmRecue',
			"CONFIRMATION_TELVOCAL_ANNULLE":'colorAppointmentStateCancelRecue',
			"TO_MOVE":'colorAppointmentStateMoved',
			"NO_ANSWER":'colorAppointmentStateNoAnswer',
			"LIGNE_OCCUPEE":'colorAppointmentStateLineBusy',
			"BOITE_VOCALE":'colorAppointmentStateVoicemail',
			"PAS_DE_SERVICE":'colorAppointmentStateNoService',
		};
		var apPatientStatusColorMap = {
			"NONE":'colorPatientStateNone',
			"ARRIVED":'colorPatientStateArrived',
			"ARRIVED_LATE":'colorPatientStateArrived',
			"SEEN":'colorPatientStateSeen',
			"SEEN_INF":'colorPatientStateSeenInf',
			"SEEN_RES":'colorPatientStateSeenRes',
			"TRIE":'colorPatientStateTrie',
			"ATTENTE_REV":'colorPatientStateAttenteRev',
			"CANCEL":'colorPatientStateCancelled',
			"NOT_CAME":'colorPatientStateNotCame',
			"LEFT_WITHOUT_BEING_SEEN":'colorPatientStateNotCame',
			"PLACED":'colorPatientStatePlaced',
		};
		function getAppointmentBgColor(e){
            var res = {
                background: "#3788d8",
                text: "#ffffff",
                borderColor: "#3788d8",
            };
			var typeAppointment = model.clientPreferences().appointmentTypes.find(function(x){return x.id == e.typeAppointment});
			if(e && e.ptStatColor && typeAppointment){
				res.statusColor = "8px solid " + "rgb("+ typeAppointment.color.join(",")+")";
			}
            if(e && e.patientStatus && apPatientStatusColorMap[e.patientStatus]){
                var colorMatrix = model.clientPreferences()[apPatientStatusColorMap[e.patientStatus]];
                res.borderColor = "rgb("+ colorMatrix.join(",")+")";
            }
            if(e && e.status && apStatusColorMap[e.status]){
                var colorMatrix = model.clientPreferences()[apStatusColorMap[e.status]];
                res.background = "rgb("+ colorMatrix.join(",")+")";
                res.text = manageContrast(colorMatrix);
            }
            return res;
        }
		function getSiteBorderColor(e){
			var site = model.store.sites.index[e]
			return "6px solid " + "rgb("+ site.color.join(",")+")";
		}
		function getPatientName(p){return p.lastName + " "+ p.firstName}
		function getAppointmentTitle(e, ptStatus, note){
			var patientsNames = "";
			if(e.patients && e.patients.length > 0){
				var patientsNamesArray = e.patients.map(getPatientName);
				if(patientsNamesArray.length > 1){
					patientsNames = patientsNamesArray.length +" "+ $filter('translate')('Patients')+" ["+patientsNamesArray.join("], [")+"]";
				}else if(patientsNamesArray.length == 1){
					patientsNames = patientsNamesArray[0];
				}
			}else if(e.adhocPatient){
				patientsNames = getPatientName(e.adhocPatient);
			}

			return patientsNames + 
				(ptStatus ? " (" + ptStatus + ") " : "") + 
				(e.isConfidential ? " " + $filter('translate')('isConfidential') + " " : "") + 
				(e.isDeleted? " ("+$filter('translate')('isDeleted').toUpperCase()+ ") ":"") +
				(note ? note : '');
		}
		
        function getPeriodColor(e){
            var res = {
                background: "blue",
                text: "#ffffff",
                // borderColor: "#3788d8"
            };
			var type = AppointmentAccessor.periodTypesById()[e.appointmentPeriodType];
            if(e && e.appointmentPeriodType &&
                type && type.color &&
                Array.isArray(type.color)){
                if (e.isClosed===true) {
                    res.background = "rgb(75, 75, 75)";
                } else {
                    var colorMatrix = type.color
                    res.background = "rgb("+colorMatrix.join(",")+")"
                    res.text = manageContrast(colorMatrix);
                }
            }
            return res;
        }


        var periodTypes = OfysUtils.mapArrayToObject(function(e){return e.id},model.clientPreferences().appointmentPeriodTypes);
        

        function manageContrast(colorMatrix){
            var brightnessrating = [299,587,114];
            var brightnessIndex = colorMatrix.map(
                                    function(c,i,){return c*brightnessrating[i]}
                                    ).reduce(function(a,c){return a+c})/1000; //(299*R + 587*G + 114*B) / 1000
            return brightnessIndex > 160?"#000000":"#ffffff";
        }

		function getPeriodActivationText(period,d){
			if(period.visibleNbMinBefore != undefined && period.visibleNbMinBefore > 0){
				var mm = moment(d).startOf("day").add(period.startTime, "minutes").subtract(period.visibleNbMinBefore, "minutes").format(OfysUtils.DATETIMEFORMAT);
				return ",V " + mm;
			}
			return ""
		}
		
		function safeShowAppTime(sValue){
			if(sValue != undefined && typeof sValue === "boolean"){
				return sValue;
			}
			return true;
		}

        function getPeriodTitle(e, d, isBackground){
            if(e && e.appointmentPeriodType &&
                    periodTypes[e.appointmentPeriodType]){
                var lang = 'french';
                if ($translate.use()=='en') {
                    lang = 'english';
                }
				var timeStr = "";
				var showPeriodTime = isBackground && safeShowAppTime(model.prefSettings('schedule_settings_showAppTime'));
				if(showPeriodTime){
					timeStr = OfysUtils.ofysTimeToString(e.startTime, true) + " - " +OfysUtils.ofysTimeToString(e.endTime, true)+' ';
				}
                var nom = periodTypes[e.appointmentPeriodType][lang];
                var nomPeriod = e.nomPeriod;
                return timeStr + (nom ? nom: "") + (nomPeriod && nomPeriod.length>0 ? ", " + nomPeriod : "") + 
				(e.isSofyEnabled===true ? ", Sofy" :"") + 
				getPeriodActivationText(e, d) +
				(e.isClosed===true ? $filter('translate')('periodClosed') :"") +
				(periodTypes[e.appointmentPeriodType].canHaveAppointment===false ? $filter('translate')('periodNoAppt') :"");
            }else{
                return "";
            }
        }
		
		var fcutils = {
			findIndexTagOrId:function(lst, id, fn){
				var i = lst.findIndex(function(e){return e.id == id || e.tag == id;});
				if(i > -1){
					fn && fn(i);
				}
			},
			getIdOrTag: function (e){
				if(e.id)return e.id;
				if(e.tag)return e.tag;
			},
			getIdOrUid: function (e){
				if(e.id)return e.id;
				if(e.uid)return e.uid;
			},
			hasUiEvent: function (e){
                return !!(e && e.uiEvent);
            },
            isPeriod : function(fCEvent){
                return (fCEvent && fCEvent.extendedProps && fCEvent.extendedProps.type == "period")
            },
            getOfysFCPeriodObject: function(OfysPeriod){
                return {
                    type: 'period',
                };
            },
			noTimezoneDate: function(d){
				// dates from full calendar are set to the local timezone which causes issues in some cases. e.g
				// user creates a period a 2 am if the date is used with -0500 UTC the date returned would be the previous day.
				// removing the timezone ensures that the dates remain as is.
				return moment(d.toISOString(), OfysUtils.DATETIMEFORMATISO).format(OfysUtils.DATEFORMAT);
			},
            minsToDuration:function(mins){
                return moment().startOf('day').add(mins, "minutes").format("HH:mm:ss");
            },
            eventTimeToOfysTime: function(time){
                var time = moment(time.toLocaleTimeString('en-US', {hour12:false}),'HH:mm:ss');
				return (time.hour()*60)+ time.minutes();
            },
			confidentialAccessDenied: function(e){
				return e.id !== undefined && e.isConfidential && e.patients.length == 0;
			},
			hasStatsBaseAppointmentDate:function(e){
				return (e.statistic && (e.statistic.appointments.length > 0 || e.statistic.periods.length > 0 ))
						|| (e.messageTypes && e.messageTypes.length > 0) || (e.messageTypesAll && e.messageTypesAll.length > 0)
						|| (e.deGardeTypes && e.deGardeTypes.length > 0);
			},
			baseAppointmentDateToFullCalendar: function (e){
				var d = moment(e.date);
				var classNames = [];
				if(e.statistic.appointments.length > 0 || e.statistic.periods.length > 0){
					classNames.push("app-event")
				}
				if((e.message && (e.messageTypes && e.messageTypes.length > 0)) || (e.messageAll && (e.messageTypesAll && e.messageTypesAll.length > 0))){
					classNames.push((e.messageTypes && e.messageTypes.length > 0) ? e.messageTypes[0] : e.messageTypesAll[0])
				}
				if(classNames.length == 0){
					classNames.push("PLAIN");
				}
				if(e.deGardeTypes && e.deGardeTypes.length > 0){
					classNames.push(e.deGardeTypes.length == 3 ? "garde_ALL_DAY" : "garde_" + e.deGardeTypes[0])
				}
				var p = {
					start: d.format(OfysUtils.DATEFORMAT),
					end: d.add(1, "day").format(OfysUtils.DATEFORMAT),
					overlap: false,
					display: 'background',
					classNames: classNames
//					 backgroundColor:"#9d21bf"
				};
				return p;
			},
			baseAppointmentDateStatsToFullCalendar: function (e){
				var d = moment(e.date);
				var mes = "";
				if((e.messageTypes && e.messageTypes.length) || (e.messageTypesAll && e.messageTypesAll.length)){
					mes = (e.messageTypes && e.messageTypes.length > 0 ? "m" : "M");
				}
				if(e.statistic.appointments.length > 0 || e.statistic.periods.length > 0){			
					var p = {
						title: e.statistic.appointments.length + "/" + fcutils.periodSlots(e.statistic.periods) + mes,
						allday: true,
						start: d.startOf("day").format(OfysUtils.DATETIMEFORMATISO)
					};
				} else if(mes){
					var p = {
						title: mes,
						allday: true,
						start: d.startOf("day").format(OfysUtils.DATETIMEFORMATISO),
						classNames: ["pull-right"]
					};
				}
				return p;
			},
			periodSlots: function(periods){
				if(periods && periods.length > 0){
					return periods.reduce(function(slots, period){
						var duration = period.endTime - period.startTime;
						return slots + (Math.ceil(duration / period.defaultAppointmentLength));
					}, 0)
				}else{
					return 0;
				}
			},
            getDuration: function (period, dateTemplate){
                var duration = 15;
                if(model.clientPreferences().appointmentBaseTime !== undefined){
                    duration = model.clientPreferences().appointmentBaseTime
                }
                if(period){
                    duration = period.defaultLength;
                }else if(dateTemplate){
                    duration = dateTemplate.scale;
                }

                return duration;
            },
			updatePeriodEventTitle:function(e, d, isBackground){
				if(this.hasUiEvent(e)){
					e.uiEvent.setProp("title", getPeriodTitle(e, d, isBackground));
				}
			},
			periodToFullCalendar: function (d, isBackground){
				return function(e) {
					var color = getPeriodColor(e);
					var p = {
						id: fcutils.getIdOrTag(e),
						title: getPeriodTitle(e, d, isBackground),
						backgroundColor: color.background,
						textColor: color.text,
						extendedProps: fcutils.getOfysFCPeriodObject(e),
						start: moment(new Date(new Date(d + "T00:00:00").setHours(e.startTime/60, e.startTime%60))).format(OfysUtils.DATETIMEFORMATISO),
						end: moment(new Date(new Date(d + "T00:00:00").setHours(e.endTime/60, e.endTime%60))).format(OfysUtils.DATETIMEFORMATISO),
//						start: moment(d, OfysUtils.DATEFORMAT).startOf('day').add(e.startTime, 'm').format(OfysUtils.DATETIMEFORMATISO),
//						end: moment(d, OfysUtils.DATEFORMAT).startOf('day').add(e.endTime, 'm').format(OfysUtils.DATETIMEFORMATISO),
					};
					if(isBackground){
						p.display = "background";
					}
					p.siteColor = getSiteBorderColor(e.idSite);
					return p;
				}
			},
			appointmentToFullCalendarEvent: function (e){
				var firstPatient = e.patients[0]
				var title;
				var color;
				if(!firstPatient && e.adhocPatient){
					firstPatient = e.adhocPatient;
				}
				if(firstPatient){
					var ptStatus;
					if (e.patientStatus!='NONE') {
						ptStatus = $filter('translate')('AppPatientStatus_' + e.patientStatus);
						if (e.patientStatus==='ARRIVED' || e.patientStatus==='ARRIVED_LATE') {
							var time = $filter('clvtime')(e.arrivedTime);
							ptStatus = time + ": " + ptStatus;
						} else if (e.patientStatus==='SEEN') {
							var time = $filter('clvtime')(e.seenTime);
							ptStatus = time + ": " + ptStatus;
						} else if (e.patientStatus==='SEEN_INF') {
							var time = $filter('clvtime')(e.seenTime);
							ptStatus = time + ": " + ptStatus;
						} else if (e.patientStatus==='SEEN_RES') {
							var time = $filter('clvtime')(e.seenTime);
							ptStatus = time + ": " + ptStatus;
						} else if (e.patientStatus==='ATTENTE_REV') {
							var time = $filter('clvtime')(e.seenTime);
							ptStatus = time + ": " + ptStatus;
						}
					}
					var note;
					if (e.note && e.note!='') {
						note = '\n| ' + e.note;
					}
					if ((e.notePatient && e.notePatient!='') || (e.consultationReason && e.consultationReason!='')) {
						note = (note ? note + ' | @' : '\n| @') + $filter('showNotePatient')(e);
					}
					title = getAppointmentTitle(e, ptStatus, note);
					color = getAppointmentBgColor(e);
				} else if(e.isConfidential){
					title = $filter('translate')('isConfidential');
					color = {
						background: "#787878",
						text: "#ffffff"
					};
				} else {
					title = $filter('translate')('Reservation');
					color = {
						background: "#ff5050",
						text: "#ffffff"
					};
				}
				// if(e.status){
				//     title = scope.allstatusByType[e.status].i18n + " " + title;
				// }
				
				if (e.telmed===1) { 
					title = '\u260F ' + title;
				} else if (e.telmed===2) {
					title = '\u260E ' + title;
				} else if (e.telmed===3) {
					title = '\u2302 ' + title;
				}
				model.store;
				var res = {
					id: fcutils.getIdOrUid(e),
					backgroundColor:color.background,
					textColor: color.text,
					borderColor: color.borderColor,
					extendedProps:{},
					title: title,
					classNames: ['app-border'],
					start: moment(new Date(new Date(e.date + "T00:00:00").setHours(e.startTime/60, e.startTime%60))).format(OfysUtils.DATETIMEFORMATISO),
					end: moment(new Date(new Date(e.date + "T00:00:00").setHours(e.endTime/60, e.endTime%60))).format(OfysUtils.DATETIMEFORMATISO),
				};
				if(getSiteBorderColor(e.idSite)){
					res.siteColor = getSiteBorderColor(e.idSite);
				}
				if(color.statusColor){
					res.statusColor = color.statusColor;
				}
				if(fcutils.confidentialAccessDenied(e)){
					res.editable = false;
				}
				if(e.isDeleted){
					res.classNames.push("app-deleted");
				}
				
				return res;
			}
			
        }

		return fcutils;
	}]);

    fc.directive("fullcal", ['$translate','OfysFCUtils', function($translate, OfysFCUtils){
        return {
			restrict: 'A',
			link: function(scope, element, attrs){
				var calendar ;
				var opt;
				var presets = {
					month:function(){
						return {
							// plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list'],
							// header: '',
							locale: $translate.use(),
							selectable: true,
							initialDate: moment().format('YYYY-MM-DD'),
							displayEventTime: false,
							displayEventEnd: false,
						}
					},
					day:function(opt){
						var parentHeight = element.parent().height() - 5;
						if(element.parent().width() < 600){
							parentHeight = parentHeight - 30;
						}
						const resizeObserver = new ResizeObserver((entries) => {
							requestAnimationFrame(() => {
								$(element[0]).height($(element).parent().height() - 5);
							})
						});
						resizeObserver.observe(element[0])
						return {
							// plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list'],
							headerToolbar: '',
							rerenderDelay:1,
							locale: $translate.use(),
							height: parentHeight,
							slotMinTime: "08:00:00",
							// displayEventTime: false,
							slotMaxTime: "18:00:00",
							// snapDuration: {minute:1},
							allDaySlot: false,
							initialView: 'timeGrid',
							nowIndicator:true,
							initialDate: moment().format('YYYY-MM-DD'),
							slotDuration:'00:05:00',
							slotLabelFormat: {hour: 'numeric', minute: '2-digit', hour12: false},
							// now: false,
							navLinks: false, // can click day/week names to navigate views
							// businessHours: false, // display business hours
							editable: true,
						};
					}
				};
				var api = {
					addEvents: function(e, convert, setUiEvent){
						if(calendar !== undefined){
							var j ;
							for (var i = 0; i < e.length; i++) {
								j = convert(e[i]);
								if(j){
									if(setUiEvent){
										setUiEvent(e[i],calendar.addEvent(j))
									}else{
										e[i].uiEvent = calendar.addEvent(j);
									}
								}
							}
						}
					},
					removeEvents: function(arr){
						var list = arr.filter(OfysFCUtils.hasUiEvent);
						for (var i = 0; i < list.length; i++) {
							var e = list[i];
							e.uiEvent.remove();
							delete e.uiEvent;
						}
					},
					purgeEvents:function(){
						//removes zombie events that might be there even after
						calendar.getEvents().forEach(function(e){
							e.remove();
						})
					},
					updateEventsCalender:function(fn){
						if(fn){
							calendar.batchRendering(function() {
								fn()
							});
						}
					},
					renderCalender: function(id, fn){
						// fn && fn(calendar.getEventById(id))
						calendar.render();
					},
					getDate: function(){
						return OfysFCUtils.noTimezoneDate(calendar.getDate());
					}
				}

				function update(){
					opt = scope.$eval(attrs.fullcal);
					if(opt !== undefined){
						calendar = new FullCalendar.Calendar(element[0], getSettings(opt));
						calendar.render();
						api.cal = calendar;
						if(opt.calendarApi){
							opt.calendarApi(api);
						}
					}
				}

				function getSettings(opt){
					var p;
					if(opt.preset && presets[opt.preset]){
						p = presets[opt.preset]();
					}else {
						p = preset['month'];
					}
					if(opt.options){
						p = $.extend(p, opt.options);
					}
					return p;
				}

				scope.$watch(attrs.fullcal, update);
            }
        }
    }]);
})();

// V